/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.SelectAreaTracker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DragNDropTool
extends AbstractTool
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    protected Tool fChild = null;
    protected DragSource dragSource = DragSource.getDefaultDragSource();
    private ArrayList fDropTargets = new ArrayList();
    private ArrayList fDragGestureRecognizers = new ArrayList();
    private Point origin = null;
    public static DataFlavor VECTORFlavor = new DataFlavor(Vector.class, "Vector");
    public static DataFlavor ASCIIFlavor = new DataFlavor("text/plain; charset=ascii", "ASCII text");

    public DragNDropTool(DrawingEditor editor) {
        super(editor);
    }

    public void viewCreated(DrawingView view) {
        super.viewCreated(view);
        if (Component.class.isInstance(view)) {
            Component c = (Component)((Object)view);
            try {
                DropTarget dt = new DropTarget(c, 3, this);
                this.fDropTargets.add(dt);
            }
            catch (NullPointerException npe) {
                System.err.println("View Failed to initialize to DND.");
                System.err.println("Container likely did not have peer before the DropTarget was added");
                System.err.println(npe);
            }
        }
        if (this.isActive()) {
            this.createDragGestureRecognizer(view, this);
        }
    }

    public void viewDestroying(DrawingView view) {
        if (Component.class.isInstance(view)) {
            Component c = (Component)((Object)view);
            DropTarget dt = c.getDropTarget();
            if (dt != null) {
                dt.setComponent(null);
                dt.removeDropTargetListener(this);
            }
            this.destroyDragGestreRecognizer(view, this);
        }
        super.viewDestroying(view);
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        DrawingView[] dv = this.editor().views();
        for (int x = 0; x < dv.length; ++x) {
            this.createDragGestureRecognizer(dv[x], this);
        }
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        DrawingView[] dv = this.editor().views();
        for (int x = 0; x < dv.length; ++x) {
            this.destroyDragGestreRecognizer(dv[x], this);
        }
        super.deactivate();
    }

    public static void setCursor(int x, int y, DrawingView view) {
        if (view != null) {
            Handle handle = view.findHandle(x, y);
            Figure figure = view.drawing().findFigure(x, y);
            if (handle != null) {
                LocatorHandle lh;
                Locator loc;
                if (LocatorHandle.class.isInstance(handle) && RelativeLocator.class.isInstance(loc = (lh = (LocatorHandle)handle).getLocator())) {
                    RelativeLocator rl = (RelativeLocator)loc;
                    if (rl.equals(RelativeLocator.north())) {
                        view.setCursor(new Cursor(8));
                    } else if (rl.equals(RelativeLocator.northEast())) {
                        view.setCursor(new Cursor(7));
                    } else if (rl.equals(RelativeLocator.east())) {
                        view.setCursor(new Cursor(11));
                    } else if (rl.equals(RelativeLocator.southEast())) {
                        view.setCursor(new Cursor(5));
                    } else if (rl.equals(RelativeLocator.south())) {
                        view.setCursor(new Cursor(9));
                    } else if (rl.equals(RelativeLocator.southWest())) {
                        view.setCursor(new Cursor(4));
                    } else if (rl.equals(RelativeLocator.west())) {
                        view.setCursor(new Cursor(10));
                    } else if (rl.equals(RelativeLocator.northWest())) {
                        view.setCursor(new Cursor(6));
                    }
                }
            } else if (figure != null) {
                view.setCursor(new Cursor(13));
            } else {
                view.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
        DragNDropTool.setCursor(evt.getX(), evt.getY(), this.view());
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.view().unfreezeView();
        if (this.fChild != null) {
            this.fChild.mouseUp(e, x, y);
        }
        this.fChild = null;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(e.getX(), e.getY());
        if (handle != null) {
            this.fChild = this.createHandleTracker(handle);
        } else {
            Figure figure = this.drawing().findFigure(e.getX(), e.getY());
            if (figure != null) {
                if (e.isShiftDown()) {
                    this.view().toggleSelection(figure);
                } else if (!this.view().selection().contains(figure)) {
                    this.view().clearSelection();
                    this.view().addToSelection(figure);
                }
            } else {
                if (!e.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.fChild = this.createAreaTracker();
            }
        }
        if (this.fChild != null) {
            this.fChild.mouseDown(e, x, y);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(e, x, y);
        }
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker(this.editor());
    }

    protected Tool createHandleTracker(Handle handle) {
        return new HandleTracker(this.editor(), handle);
    }

    private void createDragGestureRecognizer(DrawingView dv, DragGestureListener dgl) {
        if (Component.class.isInstance(dv)) {
            Component c = (Component)((Object)dv);
            DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(c, 3, this);
            this.fDragGestureRecognizers.add(dgr);
        }
    }

    private void destroyDragGestreRecognizer(DrawingView dv, DragGestureListener dgl) {
        Iterator i = this.fDragGestureRecognizers.iterator();
        while (i.hasNext()) {
            DragGestureRecognizer dgr = (DragGestureRecognizer)i.next();
            if (dgr.getComponent() != dv) continue;
            dgr.removeDragGestureListener(this);
            dgr.setComponent(null);
            i.remove();
            break;
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Component c = dge.getComponent();
        if (this.fChild != null) {
            return;
        }
        if (DrawingView.class.isInstance(c)) {
            boolean found = false;
            DrawingView dv = (DrawingView)((Object)c);
            Vector selectedElements = dv.selectionZOrdered();
            Iterator itr = selectedElements.iterator();
            if (!itr.hasNext()) {
                return;
            }
            Point p = dge.getDragOrigin();
            while (itr.hasNext()) {
                if (!((Figure)itr.next()).containsPoint(p.x, p.y)) continue;
                found = true;
                break;
            }
            if (found) {
                this.fChild = null;
                this.origin = p;
                MyTransferable trans = new MyTransferable(selectedElements);
                dge.getDragSource().startDrag(dge, DragSource.DefaultMoveDrop, trans, this);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        DragNDropTool.supportDropTargetDragEvent(dtde);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        DragNDropTool.supportDropTargetDragEvent(dtde);
    }

    public void drop(DropTargetDropEvent dtde) {
        if (dtde.isDataFlavorSupported(VECTORFlavor)) {
            if ((dtde.getDropAction() & 3) != 0) {
                if (!dtde.isLocalTransfer()) {
                    System.err.println("Intra-JVM Transfers not implemented for figures yet.");
                    return;
                }
                dtde.acceptDrop(dtde.getDropAction());
                Vector figures = (Vector)DragNDropTool.ProcessReceivedData(VECTORFlavor, dtde.getTransferable());
                if (figures != null) {
                    DrawingView lView = (DrawingView)((Object)dtde.getDropTargetContext().getComponent());
                    lView.clearSelection();
                    Iterator itr = figures.iterator();
                    Point newP = dtde.getLocation();
                    int dx = newP.x - this.origin.x;
                    int dy = newP.y - this.origin.y;
                    while (itr.hasNext()) {
                        Figure f = (Figure)itr.next();
                        f.moveBy(dx, dy);
                        lView.add(f);
                        if (dtde.getDropAction() != 2) continue;
                        lView.addToSelection(f);
                    }
                    lView.checkDamage();
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            System.out.println("String flavor dropped.");
            dtde.acceptDrop(dtde.getDropAction());
            Object o = DragNDropTool.ProcessReceivedData(DataFlavor.stringFlavor, dtde.getTransferable());
            if (o != null) {
                System.out.println("Received string flavored data.");
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        } else if (dtde.isDataFlavorSupported(ASCIIFlavor)) {
            System.out.println("ASCII Flavor dropped.");
            dtde.acceptDrop(1);
            Object o = DragNDropTool.ProcessReceivedData(ASCIIFlavor, dtde.getTransferable());
            if (o != null) {
                System.out.println("Received ASCII Flavored data.");
                dtde.getDropTargetContext().dropComplete(true);
                System.out.println(o);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            System.out.println("Java File List Flavor dropped.");
            int acts = dtde.getDropAction();
            dtde.acceptDrop(1);
            File[] fList = (File[])DragNDropTool.ProcessReceivedData(DataFlavor.javaFileListFlavor, dtde.getTransferable());
            if (fList != null) {
                System.out.println("Got list of files.");
                for (int x = 0; x < fList.length; ++x) {
                    System.out.println(fList[x].getAbsolutePath());
                }
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        DragNDropTool.supportDropTargetDragEvent(dtde);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        DrawingView view = (DrawingView)((Object)dsde.getDragSourceContext().getComponent());
        if (dsde.getDropSuccess()) {
            if (dsde.getDropAction() == 2) {
                Vector figures = (Vector)DragNDropTool.ProcessReceivedData(VECTORFlavor, dsde.getDragSourceContext().getTransferable());
                if (figures != null) {
                    Iterator itr = figures.iterator();
                    while (itr.hasNext()) {
                        view.remove((Figure)itr.next());
                    }
                    view.clearSelection();
                    view.checkDamage();
                }
            } else if (dsde.getDropAction() == 1) {
                // empty if block
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    protected static void supportDropTargetDragEvent(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(VECTORFlavor)) {
            if (dtde.getDropAction() == 1) {
                dtde.acceptDrag(1);
            } else if (dtde.getDropAction() == 2) {
                dtde.acceptDrag(2);
            }
        } else if (dtde.isDataFlavorSupported(ASCIIFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    protected static Object ProcessReceivedData(DataFlavor flavor, Transferable transferable) {
        if (transferable == null) {
            return null;
        }
        try {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                String str = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return str;
            }
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                List aList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                File[] fList = new File[aList.size()];
                aList.toArray(fList);
                return aList;
            }
            if (flavor.equals(ASCIIFlavor)) {
                int length;
                byte[] bytes;
                String txt = null;
                InputStream is = (InputStream)transferable.getTransferData(ASCIIFlavor);
                int n = is.read(bytes = new byte[length = is.available()]);
                if (n > 0) {
                    txt = new String(bytes, 0, n);
                }
                return txt;
            }
            if (flavor.equals(VECTORFlavor)) {
                Vector v = (Vector)transferable.getTransferData(VECTORFlavor);
                return v;
            }
            return null;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            return null;
        }
        catch (UnsupportedFlavorException ufe) {
            System.err.println(ufe);
            return null;
        }
        catch (ClassCastException cce) {
            System.err.println(cce);
            return null;
        }
    }

    protected Object ProcessRemotelyReceivedData(DataFlavor flavor, Transferable transferable) {
        return null;
    }

    class MyTransferable
    implements Transferable,
    Serializable {
        Object o;

        public MyTransferable(Object o) {
            this.o = o;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{VECTORFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(VECTORFlavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.o;
        }
    }
}

