/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Selection;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class View
extends Viewable<AbstractLeafElement> {
    protected List<Selection> selections = new LinkedList<Selection>();
    private boolean propTransient = false;

    @Override
    protected Collection<AbstractLeafElement> createElements() {
        return new AbstractCollection<AbstractLeafElement>(){

            @Override
            public Iterator<AbstractLeafElement> iterator() {
                return new CombiningIterator<AbstractLeafElement>(new Iterator[]{View.this.selections.iterator(), View.this.attributes.iterator(), View.this.constraints.iterator()});
            }

            @Override
            public int size() {
                return View.this.selections.size() + View.this.attributes.size() + View.this.constraints.size();
            }

            @Override
            public boolean add(AbstractLeafElement o) {
                if (o == null) {
                    throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
                }
                if (o instanceof Selection) {
                    return View.this.selections.add((Selection)o);
                }
                if (o instanceof LocalAttribute) {
                    return View.this.attributes.add((LocalAttribute)o);
                }
                if (o instanceof Constraint) {
                    ((Constraint)o).setNameIdx(View.this.constraints.size() + 1);
                    return View.this.constraints.add((Constraint)o);
                }
                throw new ClassCastException();
            }
        };
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        View baseElement = (View)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isAbstract() != baseElement.isAbstract()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), View.formatMessage("err_diff_mismatchInAbstractness", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isFinal() != baseElement.isFinal()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), View.formatMessage("err_diff_mismatchInFinality", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isTransient() != baseElement.isTransient()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), View.formatMessage("err_diff_mismatchInTransientness", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.selections.size() != baseElement.selections.size()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), View.formatMessage("err_diff_expressionMismatch")));
        } else {
            for (int i = 0; i < this.selections.size(); ++i) {
                ExpressionSelection sel = (ExpressionSelection)this.selections.get(i);
                ExpressionSelection baseSel = (ExpressionSelection)baseElement.selections.get(i);
                Ili2cSemanticException err = Evaluable.checkTranslation(sel.getCondition(), baseSel.getCondition(), this.getSourceLine(), "err_diff_expressionMismatch");
                if (err == null) continue;
                errs.add(err);
            }
        }
    }

    public String toString() {
        return "VIEW " + this.getScopedName((Container)null);
    }

    protected void checkForDuplicateNames(ViewableAlias[] aliases) throws IllegalArgumentException {
        for (int i = 0; i < aliases.length; ++i) {
            String curName = aliases[i].getName();
            for (int j = 0; j < i; ++j) {
                if (!curName.equals(aliases[j].getName())) continue;
                throw new IllegalArgumentException(View.formatMessage("err_view_dupAlias", curName, aliases[i].getAliasing().toString(), aliases[j].getAliasing().toString()));
            }
        }
    }

    @Override
    public boolean isDependentOn(Element other) {
        for (Selection sel : this.selections) {
            if (sel == other) {
                return true;
            }
            Viewable selected = sel.getSelected();
            if (selected == null || selected != other && !selected.isDependentOn(other)) continue;
            return true;
        }
        return super.isDependentOn(other);
    }

    public void setTransient(boolean transient1) {
        this.propTransient = transient1;
    }

    public boolean isTransient() {
        return this.propTransient;
    }

    @Override
    public RoleDef findOpposideRole(Container context, String roleName) {
        return this.findOpposideRole(roleName);
    }

    @Override
    public RoleDef findOpposideRole(String roleName) {
        return null;
    }

    @Override
    public RoleDef findRole(String roleName) {
        return null;
    }
}

