/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TranslatedElementNameComparator;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Topic
extends AbstractPatternDef<Element> {
    private boolean viewTopic = false;
    protected String name = "";
    private Domain oid = null;
    private Domain basketOid = null;
    private ArrayList<Domain> deferredGenerics = new ArrayList();
    protected List<Topic> dependsOn = new LinkedList<Topic>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScopedName(Container<?> scope) {
        Model enclosingModel = (Model)this.getContainer(Model.class);
        if (enclosingModel == null) {
            return this.getName();
        }
        Model scopeModel = scope != null ? (Model)scope.getContainerOrSame(Model.class) : null;
        if (enclosingModel == scopeModel) {
            return this.getName();
        }
        return enclosingModel.getName() + "." + this.getName();
    }

    public String toString() {
        return "TOPIC " + this.getScopedName(null);
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Topic.checkNameSanity(name, false);
        this.checkNameUniqueness(newValue, Topic.class, this.getRealExtending(), "err_topic_duplicateName");
        if (newValue.equals(oldValue)) {
            return;
        }
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    @Override
    public void setExtending(Element extending) throws PropertyVetoException {
        super.setExtending(extending);
    }

    public void makeDependentOn(Topic dependee) {
        if (dependee == this) {
            throw new IllegalArgumentException(Topic.formatMessage("err_topic_dependentOnSelf", this.toString()));
        }
        if (dependee == null) {
            throw new IllegalArgumentException();
        }
        this.dependsOn.add(dependee);
    }

    public Iterator<Topic> getDependentOn() {
        return this.dependsOn.iterator();
    }

    @Override
    public boolean isDependentOn(Element other) {
        if (other instanceof Topic && this.dependsOn.contains(other)) {
            return true;
        }
        return super.isDependentOn(other);
    }

    boolean containsConcreteExtensionOfTable(Table abstractTable) {
        for (Element element : this.getViewables()) {
            Table tab;
            if (!(element instanceof Table) || (tab = (Table)element).isAbstract() || !tab.isExtending(abstractTable)) continue;
            return true;
        }
        return false;
    }

    public void setViewTopic(boolean v) {
        this.viewTopic = v;
    }

    public boolean isViewTopic() {
        return this.viewTopic;
    }

    public void setOid(Domain type) {
        this.oid = type;
    }

    public Domain getOid() {
        return this.oid;
    }

    public void setBasketOid(Domain type) {
        this.basketOid = type;
    }

    public Domain getBasketOid() {
        return this.basketOid;
    }

    public void addDeferredGeneric(Domain generic) {
        this.deferredGenerics.add(generic);
    }

    public Domain[] getDefferedGenerics() {
        return this.deferredGenerics.toArray(new Domain[this.deferredGenerics.size()]);
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
        super.checkIntegrity(errs);
        this.checkIntegrityAbstract(errs);
    }

    private void checkIntegrityAbstract(List<Ili2cSemanticException> errs) {
        Domain[] resolved;
        if (this.isAbstract()) {
            return;
        }
        for (Element element : this.getViewables()) {
            Table tab;
            if (!(element instanceof Table) || !(tab = (Table)element).isIdentifiable() || !tab.isAbstract() || this.containsConcreteExtensionOfTable(tab)) continue;
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_topic_abstractElement", this.getScopedName(), tab.getName())));
        }
        Set<Domain> set = this.getUsedGenericDomains(this);
        Model model = (Model)this.getContainer(Model.class);
        for (Domain domain : this.deferredGenerics) {
            resolved = model.resolveGenericDomain(domain);
            if (resolved == null) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_topic_deferredGenericMissingContext", this.getScopedName(), domain.getName())));
            }
            if (set.contains(domain)) continue;
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_topic_deferredGenericUnused", this.getScopedName(), domain.getName())));
        }
        for (Domain domain : set) {
            resolved = model.resolveGenericDomain(domain);
            if (resolved == null) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_topic_genericMissingContext", this.getScopedName(), domain.toString())));
                continue;
            }
            if (resolved.length <= 1 || this.deferredGenerics.contains(domain)) continue;
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_topic_deferredGenericMissing", this.getScopedName(), domain.getName())));
        }
    }

    private Set<Domain> getUsedGenericDomains(Topic topic) {
        HashSet<Element> accu = new HashSet<Element>();
        HashSet<Model> accuScope = new HashSet<Model>();
        this.visitTopic(accu, accuScope, topic);
        for (Model m : accuScope) {
            this.visitModel(accu, accuScope, m);
        }
        HashSet<Domain> ret = new HashSet<Domain>();
        for (Element e : accu) {
            Domain domain;
            if (!(e instanceof AttributeDef)) continue;
            AttributeDef attr = (AttributeDef)e;
            Type type = attr.getDomain();
            if (type instanceof TypeAlias) {
                domain = ((TypeAlias)type).getAliasing();
                if ((type = domain.getType()) instanceof AbstractCoordType && ((AbstractCoordType)type).isGeneric()) {
                    ret.add(domain);
                    continue;
                }
                if (!(type instanceof LineType) || !((type = (domain = ((LineType)type).getControlPointDomain()).getType()) instanceof AbstractCoordType) || !((AbstractCoordType)type).isGeneric()) continue;
                ret.add(domain);
                continue;
            }
            if (type instanceof AbstractCoordType && ((AbstractCoordType)type).isGeneric()) {
                throw new IllegalStateException("unexpected GENERIC CoordType at attr " + attr.getScopedName());
            }
            if (!(type instanceof LineType) || !((type = (domain = ((LineType)type).getControlPointDomain()).getType()) instanceof AbstractCoordType) || !((AbstractCoordType)type).isGeneric()) continue;
            ret.add(domain);
        }
        return ret;
    }

    private void visitModel(HashSet<Element> accu, HashSet<Model> accuScope, Model model) {
        if (model.equals(PredefinedModel.getInstance())) {
            return;
        }
        Iterator topici = model.iterator();
        while (topici.hasNext()) {
            Object tObj = topici.next();
            if (!(tObj instanceof Viewable)) continue;
            this.visitViewable(accu, accuScope, (Viewable)tObj);
        }
    }

    private void visitTopic(HashSet<Element> visitedElements, HashSet<Model> accuScope, Topic def) {
        Model model;
        if (visitedElements.contains(def)) {
            return;
        }
        visitedElements.add(def);
        Iterator classi = def.iterator();
        while (classi.hasNext()) {
            Object classo = classi.next();
            if (!(classo instanceof Viewable)) continue;
            this.visitViewable(visitedElements, accuScope, (Viewable)classo);
        }
        Topic base = (Topic)def.getExtending();
        if (base != null) {
            this.visitTopic(visitedElements, accuScope, base);
        }
        if (!accuScope.contains(model = (Model)def.getContainer(Model.class))) {
            accuScope.add(model);
        }
    }

    private void visitViewable(HashSet<Element> visitedElements, HashSet<Model> accuScope, Viewable def) {
        if (visitedElements.contains(def)) {
            return;
        }
        visitedElements.add(def);
        Iterator attri = def.iterator();
        while (attri.hasNext()) {
            Type type;
            Object attro = attri.next();
            if (!(attro instanceof AttributeDef)) continue;
            AttributeDef attr = (AttributeDef)attro;
            if (!visitedElements.contains(attr)) {
                visitedElements.add(attr);
            }
            if (!((type = attr.getDomain()) instanceof CompositionType)) continue;
            CompositionType compType = (CompositionType)type;
            this.visitViewable(visitedElements, accuScope, compType.getComponentType());
            Iterator<Table> resti = compType.iteratorRestrictedTo();
            while (resti.hasNext()) {
                Viewable rest = resti.next();
                this.visitViewable(visitedElements, accuScope, rest);
            }
        }
        Viewable base = (Viewable)def.getExtending();
        if (base != null) {
            this.visitViewable(visitedElements, accuScope, base);
        }
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        Topic baseElement = (Topic)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isAbstract() != baseElement.isAbstract()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_mismatchInAbstractness", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isFinal() != baseElement.isFinal()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_mismatchInFinality", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isViewTopic() != baseElement.isViewTopic()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_mismatchViewTopic", this.getScopedName(), baseElement.getScopedName())));
        }
        Ili2cSemanticException err = null;
        err = Topic.checkElementRef(this.getBasketOid(), baseElement.getBasketOid(), this.getSourceLine(), "err_diff_bidMismatch");
        if (err != null) {
            errs.add(err);
        }
        if ((err = Topic.checkElementRef(this.getOid(), baseElement.getOid(), this.getSourceLine(), "err_diff_oidMismatch")) != null) {
            errs.add(err);
        }
        if ((err = Topic.checkElementRef(this.getExtending(), baseElement.getExtending(), this.getSourceLine(), "err_diff_baseTopicMismatch")) != null) {
            errs.add(err);
        }
        if (this.dependsOn.size() != baseElement.dependsOn.size()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_dependencyTopicMismatch")));
        }
        ArrayList<Topic> depTopics = new ArrayList<Topic>(this.dependsOn);
        Collections.sort(depTopics, new TranslatedElementNameComparator());
        ArrayList<Topic> baseDepTopics = new ArrayList<Topic>(baseElement.dependsOn);
        Collections.sort(baseDepTopics, new TranslatedElementNameComparator());
        for (int depi = 0; depi < depTopics.size(); ++depi) {
            Topic baseDep;
            Topic dep = depTopics.get(depi);
            err = Topic.checkElementRef(dep, baseDep = baseDepTopics.get(depi), this.getSourceLine(), "err_diff_dependencyTopicMismatch");
            if (err == null) continue;
            errs.add(err);
        }
    }
}

