/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.logging.StdLogEvent;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.StringUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;

public class Tracer
implements LogListener {
    public static final int SILENT = 1;
    public static final int NORMAL = 2;
    public static final int DEBUG = 3;
    public static final int TRACE_BACKEND = 4;
    public static final int ALL = 5;
    private static final int SE_DEVELOPER_ERROR = 100;
    private static final int SE_DEVELOPER_WARNING = 101;
    private static Tracer instance = null;
    private PrintStream outStream = null;
    private int mode = 1;

    private Tracer() {
    }

    public void debug(String message) {
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(1, message, null, Tracer.getOrigin(0)));
    }

    public void developerError(String error) {
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(7, error, null, Tracer.getOrigin(0), 100));
    }

    public void developerWarning(String warning) {
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(3, warning, null, Tracer.getOrigin(0), 101));
    }

    private static OutputStream getConsoleError() {
        return System.err;
    }

    public static Tracer getInstance() {
        if (instance == null) {
            instance = new Tracer();
            instance.setMode(2);
        }
        return instance;
    }

    private void log(String kind, String message, String origin) {
        try {
            this.outStream.println(kind + ": " + message + (StringUtils.isNullOrEmpty(origin) ? "" : " [" + origin + "]"));
        }
        catch (Throwable e) {
            System.err.println("Tracer#log(): " + kind + ": " + message + "=>" + e.getLocalizedMessage());
        }
    }

    public void logBackendCommand(String command) {
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(4, command, null, null));
    }

    public void runtimeError(String error) {
        this.runtimeError(error, null);
    }

    public void runtimeError(String error, Throwable exception) {
        this.runtimeError(error, exception, 1);
    }

    public void runtimeError(String error, Throwable exception, int offsetToStackTrace) {
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(7, error == null ? "Unexpected error" : error, exception, Tracer.getOrigin(offsetToStackTrace)));
    }

    public void runtimeInfo(String info) {
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(5, info, null, Tracer.getOrigin(0)));
    }

    public void runtimeWarning(String warning) {
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(6, warning, null, Tracer.getOrigin(0)));
    }

    public static String[] start(String[] args) {
        int mode = 1;
        if (args != null) {
            ArrayList<String> ret = new ArrayList<String>(Arrays.asList(args));
            Iterator<String> it = ret.iterator();
            while (it.hasNext()) {
                String option = it.next();
                if (option.equalsIgnoreCase("-debug")) {
                    mode = 3;
                    it.remove();
                    break;
                }
                if (option.equalsIgnoreCase("-trace")) {
                    mode = 2;
                    it.remove();
                    break;
                }
                if (option.equalsIgnoreCase("-traceSQL")) {
                    mode = 4;
                    it.remove();
                    break;
                }
                if (!option.equalsIgnoreCase("-all")) continue;
                mode = 5;
                it.remove();
                break;
            }
            Tracer.start((PrintStream)Tracer.getConsoleError(), mode);
            return ret.toArray(new String[0]);
        }
        Tracer.start((PrintStream)Tracer.getConsoleError(), mode);
        return null;
    }

    public static void start(int mode) {
        Tracer.start((PrintStream)Tracer.getConsoleError(), mode);
    }

    public static synchronized void start(PrintStream stream, int mode) {
        if (instance != null) {
            throw new DeveloperException("Default Tracer-instance already initialized!");
        }
        instance = new Tracer();
        Tracer.instance.outStream = stream;
        instance.setMode(mode);
        EhiLogger.getInstance().addListener((LogListener)Tracer.getInstance());
        EhiLogger.getInstance().removeListener((LogListener)StdListener.getInstance());
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(2, "Java Version: " + System.getProperty("java.version"), null, null));
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(2, "Java VM Version: " + System.getProperty("java.vm.version"), null, null));
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(2, "OS Name: " + System.getProperty("os.name"), null, null));
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(2, "OS Architecture: " + System.getProperty("os.arch"), null, null));
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(2, "OS Version: " + System.getProperty("os.version"), null, null));
        EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(2, "OS Locale: " + Locale.getDefault().toString(), null, null));
    }

    public void setMode(int mode) {
        this.mode = mode;
        EhiLogger.getInstance().setTraceFilter(mode == 1 || mode == 2);
    }

    public synchronized void stop() {
        try {
            if (this.outStream != null) {
                this.outStream.close();
            }
            EhiLogger.getInstance().removeListener((LogListener)this);
        }
        catch (Throwable e) {
            System.err.println("Tracer#stop(): " + e.getLocalizedMessage());
        }
        instance = null;
    }

    public void uncaughtException(Throwable exception) {
        try {
            EhiLogger.getInstance().logEvent((LogEvent)new StdLogEvent(7, "Uncaught exception", exception, Tracer.getOrigin(0)));
        }
        catch (Throwable e) {
            System.err.println("Tracer#uncaughtException(): " + e.getLocalizedMessage());
        }
    }

    protected static StackTraceElement getOrigin(int offset) {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (2 + offset < stack.length) {
            StackTraceElement st = stack[2 + offset];
            return st;
        }
        return null;
    }

    public void logEvent(LogEvent event) {
        if (this.mode != 5) {
            if (this.mode == 1) {
                return;
            }
            if (event.getEventKind() == 1 || event.getEventKind() == 2 || event.getEventKind() == 3 || event.getCustomLevel() == 100 || event.getCustomLevel() == 101 ? this.mode != 3 : event.getEventKind() == 4 && this.mode != 4) {
                return;
            }
        }
        String kind = EhiLogger.kindToString((int)event.getEventKind());
        if (event.getCustomLevel() != 0) {
            switch (event.getCustomLevel()) {
                case 0: {
                    break;
                }
                case 100: {
                    kind = kind + "<Developer-Error>";
                    break;
                }
                case 101: {
                    kind = kind + "<Developer-Warning>";
                    break;
                }
                default: {
                    kind = kind + "<CUSTOM-LEVEL[" + event.getCustomLevel() + "]>";
                }
            }
        }
        this.log(kind, event.getEventMsg(), Tracer.formatOrigin(event.getOrigin()));
        if (event.getException() != null) {
            event.getException().printStackTrace(this.outStream);
        }
    }

    protected static String formatOrigin(StackTraceElement st) {
        StringBuffer origin = new StringBuffer();
        if (st != null) {
            if (st.getFileName() != null) {
                origin.append(st.getFileName());
            } else {
                origin.append(st.getClassName());
            }
            origin.append("#");
            origin.append(st.getMethodName());
            origin.append("()");
            int line = st.getLineNumber();
            if (line >= 0) {
                origin.append(":");
                origin.append(line);
            }
        }
        return origin.toString();
    }
}

