/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.logging;

import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.logging.AbstractXtfErrorsLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.interlis2.validator.models.IliVErrors.ErrorLog.Error;
import org.interlis2.validator.models.IliVErrors.ErrorLog.Error_Type;

public class CsvErrorsLogger
extends AbstractXtfErrorsLogger {
    private static int FIELD_MESSAGE = 0;
    private static int FIELD_TYPE = 1;
    private static int FIELD_OBJTAG = 2;
    private static int FIELD_TID = 3;
    private static int FIELD_TECHID = 4;
    private static int FIELD_USERID = 5;
    private static int FIELD_ILIQNAME = 6;
    private static int FIELD_DATASOURCE = 7;
    private static int FIELD_LINE = 8;
    private static int FIELD_GEOMETRY_X = 9;
    private static int FIELD_GEOMETRY_Y = 10;
    private static int FIELD_TECHDETAILS = 11;
    private PrintStream out = null;

    public CsvErrorsLogger(File logFile) {
        try {
            this.out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(logFile)), true, "UTF-8");
            this.writeBOM();
            this.writeHeader();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeBOM() {
        this.out.print("\ufeff");
    }

    protected void writeHeader() {
        String[] values = new String[12];
        values[CsvErrorsLogger.FIELD_MESSAGE] = "Message";
        values[CsvErrorsLogger.FIELD_TYPE] = "Type";
        values[CsvErrorsLogger.FIELD_OBJTAG] = "ObjTag";
        values[CsvErrorsLogger.FIELD_TID] = "Tid";
        values[CsvErrorsLogger.FIELD_TECHID] = "TechId";
        values[CsvErrorsLogger.FIELD_USERID] = "UserId";
        values[CsvErrorsLogger.FIELD_ILIQNAME] = "IliQName";
        values[CsvErrorsLogger.FIELD_DATASOURCE] = "DataSource";
        values[CsvErrorsLogger.FIELD_LINE] = "Line";
        values[CsvErrorsLogger.FIELD_GEOMETRY_X] = "Geometry_x";
        values[CsvErrorsLogger.FIELD_GEOMETRY_Y] = "Geometry_y";
        values[CsvErrorsLogger.FIELD_TECHDETAILS] = "TechDetails";
        try {
            this.writeRecord(values);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeObject(Error iomObj) {
        IomObject geom;
        String[] values = new String[12];
        values[CsvErrorsLogger.FIELD_MESSAGE] = iomObj.getMessage();
        Error_Type type = iomObj.getType();
        if (type != null) {
            values[CsvErrorsLogger.FIELD_TYPE] = Error_Type.toXmlCode(type);
        }
        values[CsvErrorsLogger.FIELD_OBJTAG] = iomObj.getObjTag();
        values[CsvErrorsLogger.FIELD_TID] = iomObj.getTid();
        values[CsvErrorsLogger.FIELD_TECHID] = iomObj.getTechId();
        values[CsvErrorsLogger.FIELD_USERID] = iomObj.getUserId();
        values[CsvErrorsLogger.FIELD_ILIQNAME] = iomObj.getIliQName();
        values[CsvErrorsLogger.FIELD_DATASOURCE] = iomObj.getDataSource();
        Integer line = iomObj.getLine();
        if (line != null) {
            values[CsvErrorsLogger.FIELD_LINE] = line.toString();
        }
        if ((geom = iomObj.getGeometry()) != null) {
            values[CsvErrorsLogger.FIELD_GEOMETRY_X] = geom.getattrvalue("C1");
            values[CsvErrorsLogger.FIELD_GEOMETRY_Y] = geom.getattrvalue("C2");
        }
        values[CsvErrorsLogger.FIELD_TECHDETAILS] = iomObj.getTechDetails();
        try {
            this.writeRecord(values);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    private void writeRecord(String[] values) throws IOException {
        String sep = "";
        for (int i = 0; i < values.length; ++i) {
            this.out.print(sep);
            String value = values[i];
            if (value == null) {
                this.out.print("");
            } else if (value.contains(",") || value.contains("\n") || value.contains("\r") || value.contains("\"")) {
                this.out.print("\"");
                this.out.print(value);
                this.out.print("\"");
            } else {
                this.out.print(value);
            }
            sep = ",";
        }
        this.out.println();
    }
}

