/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.xmiuml.ehi;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.NlsString;
import ch.ehi.uml1_4.implementation.AbstractModelElement;
import ch.ehi.uml1_4.implementation.UmlModel;
import ch.ehi.umleditor.application.LauncherView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MyHandler
implements ContentHandler {
    private Locator currentLocation = null;
    private ErrorHandler eh = null;
    private Map<String, Object> objMap = new HashMap<String, Object>();
    private Set<String> usedObjsTID = new HashSet<String>();
    private Set<String> missingObjsTID = new HashSet<String>();
    private Object actualObject = null;
    private UmlModel umlModel = null;
    private String currentElementTag = null;
    private boolean secondPass = false;
    private boolean inNlsString = false;
    private String nlsStringID = null;
    private HashMap<Class, Map<String, Method>> setValues = new HashMap();
    private HashMap<Class, Map<String, Method>> setObjects = new HashMap();
    private Map<String, Method> currentObjValueSets = null;
    private Map<String, Method> currentObjObjectAdds = null;
    private StringBuffer content = null;
    private int level = 0;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.currentLocation = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        if (this.content != null) {
            this.content.append(text, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.eh = handler;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        Object attsObj = null;
        Object objClass = null;
        ++this.level;
        if (!(this.level != 1 || namespaceURI.equals("") && localName.equals("ch.ehi.umleditor.1") || namespaceURI.equals("http://schemas.umleditor.org/umleditor/1.1") && localName.equals("ch.ehi.umleditor"))) {
            if (localName.startsWith("ch.ehi.umleditor")) {
                EhiLogger.traceUnusualState((String)"file from an unknown umleditor version; will try to read");
            } else {
                throw new SAXException("unexpected xml file");
            }
        }
        this.currentElementTag = localName;
        if (this.level == 3) {
            this.content = new StringBuffer();
        }
        String qualifiedClassName = this.mapTag2Class(localName);
        if (atts.getLength() == 1) {
            String tid = atts.getValue(0);
            try {
                if (!this.objMap.containsKey(tid)) {
                    Class<?> cls = Class.forName(qualifiedClassName);
                    attsObj = cls.newInstance();
                    this.objMap.put(atts.getValue(0), attsObj);
                    this.actualObject = attsObj;
                    if (this.actualObject instanceof UmlModel) {
                        this.umlModel = (UmlModel)this.actualObject;
                    }
                } else {
                    this.actualObject = this.objMap.get(atts.getValue(0));
                }
                if (localName.equals("ch.ehi.basics.types.NlsString")) {
                    this.inNlsString = true;
                    this.nlsStringID = atts.getValue(0);
                }
                this.analyseClass(this.actualObject.getClass());
                this.currentObjValueSets = this.setValues.get(this.actualObject.getClass());
                this.currentObjObjectAdds = this.setObjects.get(this.actualObject.getClass());
            }
            catch (IllegalAccessException ex) {
                LauncherView.getInstance().log("decode", "tid <" + tid + "> tag <" + localName + "> class <" + qualifiedClassName + ">" + ex.getLocalizedMessage());
                EhiLogger.debug((String)("Parsing Error - Line: " + this.currentLocation.getLineNumber() + ", Message: " + ex.getMessage()));
                throw new SAXException(ex);
            }
            catch (InstantiationException ex) {
                LauncherView.getInstance().log("decode", "tid <" + tid + "> tag <" + localName + "> class <" + qualifiedClassName + ">" + ex.getLocalizedMessage());
                EhiLogger.debug((String)("Parsing Error - Line: " + this.currentLocation.getLineNumber() + ", Message: " + ex.getMessage()));
                throw new SAXException(ex);
            }
            catch (ClassNotFoundException ex) {
                LauncherView.getInstance().log("decode", "tid <" + tid + "> tag <" + localName + "> class <" + qualifiedClassName + ">" + ex.getLocalizedMessage());
                EhiLogger.debug((String)("Parsing Error - Line: " + this.currentLocation.getLineNumber() + ", Message: " + ex.getMessage()));
                throw new SAXException(ex);
            }
        } else if (this.inNlsString && atts.getLength() == 3) {
            if (!this.secondPass) {
                NlsString old = (NlsString)this.actualObject;
                NlsString newstr = new NlsString(old, atts.getValue(1), atts.getValue(2));
                this.actualObject = newstr;
                this.objMap.put(this.nlsStringID, newstr);
            }
        } else if (atts.getLength() > 1) {
            this.eh.error(new SAXParseException("You can't have more then 1 Attribute!", this.currentLocation));
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        --this.level;
        if (localName.equals("ch.ehi.basics.types.NlsString")) {
            this.inNlsString = false;
            this.nlsStringID = null;
        } else if (this.level == 2 && !this.inNlsString && this.secondPass) {
            try {
                String value = this.content.toString();
                if (!(this.actualObject instanceof AbstractModelElement) || !this.currentElementTag.equals("DefLangName")) {
                    if (this.currentObjObjectAdds.containsKey(this.currentElementTag)) {
                        if (!this.objMap.containsKey(value)) {
                            if (!this.missingObjsTID.contains(value)) {
                                LauncherView.getInstance().log("decoder", "Object <" + value + "> doestn't exist");
                                this.missingObjsTID.add(value);
                            }
                        } else {
                            Object dest = this.objMap.get(value);
                            this.usedObjsTID.add(value);
                            Method add = this.currentObjObjectAdds.get(this.currentElementTag);
                            add.invoke(this.actualObject, dest);
                        }
                    } else if (this.currentObjValueSets.containsKey(this.currentElementTag)) {
                        Method set = this.currentObjValueSets.get(this.currentElementTag);
                        Class<?> parameterType = set.getParameterTypes()[0];
                        Object valueObject = null;
                        if (parameterType == Boolean.TYPE || parameterType == Boolean.class) {
                            valueObject = Boolean.valueOf(value);
                        } else if (parameterType == Character.TYPE || parameterType == Character.class) {
                            valueObject = new Character(value.charAt(0));
                        } else if (parameterType == Byte.TYPE || parameterType == Byte.class) {
                            valueObject = Byte.valueOf(value);
                        } else if (parameterType == Short.TYPE || parameterType == Short.class) {
                            valueObject = Short.valueOf(value);
                        } else if (parameterType == Integer.TYPE || parameterType == Integer.class) {
                            valueObject = Integer.valueOf(value);
                        } else if (parameterType == Long.TYPE || parameterType == Long.class) {
                            valueObject = Long.valueOf(value);
                        } else if (parameterType == Float.TYPE || parameterType == Float.class) {
                            valueObject = Float.valueOf(value);
                        } else if (parameterType == Double.TYPE || parameterType == Double.class) {
                            valueObject = Double.valueOf(value);
                        } else if (parameterType == String.class) {
                            valueObject = value;
                        }
                        set.invoke(this.actualObject, valueObject);
                    } else {
                        this.eh.error(new SAXParseException("unexpected Element <" + this.currentElementTag + ">", this.currentLocation));
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                EhiLogger.traceUnusualState((String)("Parsing Error - Line: " + this.currentLocation.getLineNumber() + ", Message: " + ex.getMessage() + "; " + this.currentElementTag + " on " + this.actualObject.getClass()));
                throw new SAXException(ex);
            }
            catch (IllegalAccessException ex) {
                EhiLogger.traceUnusualState((String)("Parsing Error - Line: " + this.currentLocation.getLineNumber() + ", Message: " + ex.getMessage() + "; " + this.currentElementTag + " on " + this.actualObject.getClass()));
                throw new SAXException(ex);
            }
            catch (InvocationTargetException ex) {
                EhiLogger.traceUnusualState((String)("Parsing Error - Line: " + this.currentLocation.getLineNumber() + ", Message: " + ex.getMessage() + "; " + this.currentElementTag + " on " + this.actualObject.getClass()));
                throw new SAXException(ex);
            }
        }
        this.content = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private String mapTag2Class(String qualifiedClassName) {
        return qualifiedClassName;
    }

    public Object getUmlModel() {
        return this.umlModel;
    }

    private void analyseClass(Class aclass) {
        if (this.setValues.containsKey(aclass)) {
            return;
        }
        if (this.setObjects.containsKey(aclass)) {
            return;
        }
        Class<?> stringClass = new String().getClass();
        HashMap<String, Method> values = new HashMap<String, Method>();
        HashMap objects = new HashMap();
        HashMap<String, Method> methodSet = new HashMap<String, Method>();
        Method[] methods = aclass.getMethods();
        for (int a = 0; a < methods.length; ++a) {
            Class<?>[] parameterTypes = methods[a].getParameterTypes();
            if (parameterTypes.length != 1) continue;
            methodSet.put(methods[a].getName(), methods[a]);
        }
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            String attrNameWoLink;
            String attrName;
            String methodName = methods[i].getName();
            if (methodName.startsWith("add") && methods[i].getReturnType() == Void.TYPE) {
                attrName = methodName.substring(3);
                if (methodSet.containsKey("add" + attrName + "Link")) continue;
                attrNameWoLink = attrName;
                if (attrName.endsWith("Link")) {
                    attrNameWoLink = attrName.substring(0, attrName.length() - 4);
                }
                if ((parameterTypes = methods[i].getParameterTypes())[0].isPrimitive() || parameterTypes[0] == stringClass || MyHandler.isBuiltinClass(parameterTypes[0])) {
                    values.put(attrName, methods[i]);
                    continue;
                }
                if (methodSet.containsKey("_link" + attrNameWoLink)) {
                    objects.put(attrName, methodSet.get("_link" + attrNameWoLink));
                    continue;
                }
                objects.put(attrName, methods[i]);
                continue;
            }
            if (methodName.startsWith("attach") && methods[i].getReturnType() == Void.TYPE) {
                attrName = methodName.substring(6);
                if (methodSet.containsKey("attach" + attrName + "Link")) continue;
                attrNameWoLink = attrName;
                if (attrName.endsWith("Link")) {
                    attrNameWoLink = attrName.substring(0, attrName.length() - 4);
                }
                if ((parameterTypes = methods[i].getParameterTypes())[0].isPrimitive() || MyHandler.isBuiltinClass(parameterTypes[0]) || parameterTypes[0] == stringClass) {
                    values.put(attrName, methods[i]);
                    continue;
                }
                if (methodSet.containsKey("_link" + attrNameWoLink)) {
                    objects.put(attrName, methodSet.get("_link" + attrNameWoLink));
                    continue;
                }
                objects.put(attrName, methods[i]);
                continue;
            }
            if (!methodName.startsWith("set") || methods[i].getReturnType() != Void.TYPE) continue;
            attrName = methodName.substring(3);
            Class<?>[] parameterTypes2 = methods[i].getParameterTypes();
            if (parameterTypes2[0].isPrimitive() || parameterTypes2[0] == stringClass || MyHandler.isBuiltinClass(parameterTypes2[0])) {
                values.put(attrName, methods[i]);
                continue;
            }
            objects.put(attrName, methods[i]);
        }
        this.setValues.put(aclass, values);
        this.setObjects.put(aclass, objects);
    }

    public void setSecondPass(boolean secondPass) {
        this.secondPass = secondPass;
    }

    public Map<String, Object> getUnreferencedObjects() {
        HashMap<String, Object> ret = new HashMap<String, Object>(this.objMap);
        for (String tid : new HashSet(ret.keySet())) {
            if (!this.usedObjsTID.contains(tid)) continue;
            ret.remove(tid);
        }
        return ret;
    }

    public Set<String> getMissingObjects() {
        return this.missingObjsTID;
    }

    private static boolean isBuiltinClass(Class aclass) {
        String name = aclass.getName();
        return name.equals("java.lang.Boolean") || name.equals("java.lang.Character") || name.equals("java.lang.Byte") || name.equals("java.lang.Short") || name.equals("java.lang.Integer") || name.equals("java.lang.Long") || name.equals("java.lang.Float") || name.equals("java.lang.Double");
    }
}

