/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.translationxml;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.Translation;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.modelmanagement.Model;
import ch.ehi.umleditor.translationxml.ModelElementUtility;
import ch.interlis.ili2c.generator.nls.Ili2TranslationXml;
import ch.interlis.ili2c.generator.nls.ModelElements;
import ch.interlis.ili2c.generator.nls.TranslationElement;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TransferFromXml {
    public void merge(Model model, File xmlfile) throws Exception {
        ModelElements translationElements = Ili2TranslationXml.readModelElementsXml((File)xmlfile);
        ModelElementUtility modelElementUtility = new ModelElementUtility();
        for (TranslationElement translationElement : translationElements) {
            ModelElement modelElement = modelElementUtility.findIliModelElementByScopedName(model, translationElement.getScopedName());
            if (modelElement != null) {
                this.mergeTranslationElementToModelElement(modelElement, translationElement);
                continue;
            }
            EhiLogger.logAdaption((String)("Model element " + translationElement.getScopedName() + " not found"));
        }
    }

    private void mergeTranslationElementToModelElement(ModelElement modelElement, TranslationElement translationElement) {
        HashSet<String> seenLanguages = new HashSet<String>();
        if (modelElement.getName() != null) {
            Map name = modelElement.getName().getAllValues();
            if (translationElement.getName_de() != null && !translationElement.getName_de().isEmpty() && !translationElement.getName_de().equals(name.get("de"))) {
                modelElement.setName(new NlsString(modelElement.getName(), "de", translationElement.getName_de()));
                seenLanguages.add("de");
            }
            if (translationElement.getName_en() != null && !translationElement.getName_en().isEmpty() && !translationElement.getName_en().equals(name.get("en"))) {
                modelElement.setName(new NlsString(modelElement.getName(), "en", translationElement.getName_en()));
                seenLanguages.add("en");
            }
            if (translationElement.getName_fr() != null && !translationElement.getName_fr().isEmpty() && !translationElement.getName_fr().equals(name.get("fr"))) {
                modelElement.setName(new NlsString(modelElement.getName(), "fr", translationElement.getName_fr()));
                seenLanguages.add("fr");
            }
            if (translationElement.getName_it() != null && !translationElement.getName_it().isEmpty() && !translationElement.getName_it().equals(name.get("it"))) {
                modelElement.setName(new NlsString(modelElement.getName(), "it", translationElement.getName_it()));
                seenLanguages.add("it");
            }
            if (modelElement instanceof ModelDef && seenLanguages.size() > 0) {
                ModelDef model = (ModelDef)modelElement;
                String baseLang = model.getBaseLanguage();
                seenLanguages.remove(baseLang);
                Iterator langIt = model.iteratorTranslation();
                while (langIt.hasNext()) {
                    Translation lang = (Translation)langIt.next();
                    seenLanguages.remove(lang.getLanguage());
                }
                for (String lang : seenLanguages) {
                    Translation trans = new Translation();
                    trans.setBaseLanguage(baseLang);
                    trans.setLanguage(lang);
                    model.addTranslation(trans);
                }
            }
        }
        if (modelElement.getDocumentation() != null) {
            Map documentation = modelElement.getDocumentation().getAllValues();
            if (translationElement.getDocumentation_de() != null && !translationElement.getDocumentation_de().isEmpty() && translationElement.getDocumentation_de() != null && translationElement.getDocumentation_de() != "" && !translationElement.getDocumentation_de().equals(documentation.get("de"))) {
                modelElement.setDocumentation(new NlsString(modelElement.getDocumentation(), "de", translationElement.getDocumentation_de()));
            }
            if (translationElement.getDocumentation_en() != null && !translationElement.getDocumentation_en().isEmpty() && translationElement.getDocumentation_en() != null && translationElement.getDocumentation_en() != "" && !translationElement.getDocumentation_en().equals(documentation.get("en"))) {
                modelElement.setDocumentation(new NlsString(modelElement.getDocumentation(), "en", translationElement.getDocumentation_en()));
            }
            if (translationElement.getDocumentation_fr() != null && !translationElement.getDocumentation_fr().isEmpty() && translationElement.getDocumentation_fr() != null && translationElement.getDocumentation_fr() != "" && !translationElement.getDocumentation_fr().equals(documentation.get("fr"))) {
                modelElement.setDocumentation(new NlsString(modelElement.getDocumentation(), "fr", translationElement.getDocumentation_fr()));
            }
            if (translationElement.getDocumentation_it() != null && !translationElement.getDocumentation_it().isEmpty() && translationElement.getDocumentation_it() != null && translationElement.getDocumentation_it() != "" && !translationElement.getDocumentation_it().equals(documentation.get("it"))) {
                modelElement.setDocumentation(new NlsString(modelElement.getDocumentation(), "it", translationElement.getDocumentation_it()));
            }
        } else {
            if (translationElement.getDocumentation_de() != null && !translationElement.getDocumentation_de().isEmpty() && translationElement.getDocumentation_de() != null && translationElement.getDocumentation_de() != "") {
                modelElement.setDocumentation(new NlsString("de", translationElement.getDocumentation_de()));
            }
            if (translationElement.getDocumentation_en() != null && !translationElement.getDocumentation_en().isEmpty() && translationElement.getDocumentation_en() != null && translationElement.getDocumentation_en() != "") {
                modelElement.setDocumentation(new NlsString("en", translationElement.getDocumentation_en()));
            }
            if (translationElement.getDocumentation_fr() != null && !translationElement.getDocumentation_fr().isEmpty() && translationElement.getDocumentation_fr() != null && translationElement.getDocumentation_fr() != "") {
                modelElement.setDocumentation(new NlsString("fr", translationElement.getDocumentation_fr()));
            }
            if (translationElement.getDocumentation_it() != null && !translationElement.getDocumentation_it().isEmpty() && translationElement.getDocumentation_it() != null && translationElement.getDocumentation_it() != "") {
                modelElement.setDocumentation(new NlsString("it", translationElement.getDocumentation_it()));
            }
        }
    }
}

