/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.translationxml;

import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.attributes.DomainAttribute;
import ch.ehi.interlis.constraints.ConstraintDef;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.interlis.metaobjects.ParameterDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.tools.AbstractClassDefUtility;
import ch.ehi.uml1_4.foundation.core.Association;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.Constraint;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.implementation.UmlPackage;
import ch.ehi.uml1_4.modelmanagement.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModelElementUtility {
    private Map<String, ModelElement> scopedName2element = null;

    private void visitEnumerationElement(String scopedNamePrefix, Enumeration enumeration, String baseLanguage) {
        Iterator enumEle = enumeration.iteratorEnumElement();
        while (enumEle.hasNext()) {
            EnumElement enumElement = (EnumElement)enumEle.next();
            String scopedName = scopedNamePrefix + "." + enumElement.getName().getValue(baseLanguage);
            this.scopedName2element.put(scopedName, enumElement);
            if (!enumElement.containsChild()) continue;
            this.visitEnumerationElement(scopedName, enumElement.getChild(), baseLanguage);
        }
    }

    private void visitModelElement(ModelElement modelElement) {
        DomainAttribute attrType;
        AttributeDef def;
        if (modelElement instanceof INTERLIS2Def && ModelElementUtility.isInternal((INTERLIS2Def)modelElement)) {
            return;
        }
        String scopedName = null;
        scopedName = this.getScopedName(modelElement);
        if (scopedName != null) {
            this.scopedName2element.put(scopedName, modelElement);
        }
        if (modelElement instanceof AbstractClassDef) {
            for (Object object : AbstractClassDefUtility.getIliAttributes((AbstractClassDef)modelElement)) {
                if (!(object instanceof AttributeDef)) continue;
                AttributeDef attrDef = (AttributeDef)object;
                this.visitModelElement(attrDef);
            }
            if (modelElement instanceof ClassDef) {
                ClassDef classDef = (ClassDef)modelElement;
                Iterator iterator = classDef.iteratorParameterDef();
                while (iterator.hasNext()) {
                    ParameterDef next = (ParameterDef)iterator.next();
                    this.visitModelElement(next);
                }
            }
            if (modelElement instanceof AssociationDef) {
                Iterator assoDefI = ((AssociationDef)modelElement).iteratorConnection();
                while (assoDefI.hasNext()) {
                    RoleDef roleDef = (RoleDef)assoDefI.next();
                    this.visitModelElement(roleDef);
                }
            }
            Iterator contstraintI = modelElement.iteratorConstraint();
            int idx = 1;
            while (contstraintI.hasNext()) {
                Constraint constraint = (Constraint)contstraintI.next();
                String name = constraint.getDefLangName();
                if (name == null) {
                    constraint.setDefLangName("Constraint" + idx);
                    ++idx;
                }
                this.visitModelElement(constraint);
            }
        } else if (modelElement instanceof Namespace) {
            Type type;
            DomainDef domain;
            for (ModelElement modelDef : ch.ehi.interlis.tools.ModelElementUtility.getChildElements((Namespace)modelElement, null)) {
                this.visitModelElement(modelDef);
            }
            if (modelElement instanceof DomainDef && (domain = (DomainDef)modelElement).containsType() && (type = domain.getType()) instanceof Enumeration) {
                String scopedNamePrefix = this.getScopedName(domain).toString();
                Enumeration enumeration = (Enumeration)type;
                this.visitEnumerationElement(scopedNamePrefix, enumeration, this.getBaseLanguage(domain));
            }
        } else if (modelElement instanceof AttributeDef && (def = (AttributeDef)modelElement).containsAttrType() && (attrType = (DomainAttribute)def.getAttrType()).containsDirect() && attrType.getDirect() instanceof Enumeration) {
            String scopedNamePrefix = this.getScopedName(def).toString();
            Enumeration enumeration = (Enumeration)attrType.getDirect();
            this.visitEnumerationElement(scopedNamePrefix, enumeration, this.getBaseLanguage(def.getOwner()));
        }
    }

    public ModelElement findIliModelElementByScopedName(Model model, String scopedName) {
        if (this.scopedName2element == null) {
            this.scopedName2element = new HashMap<String, ModelElement>();
            this.setupMapping(model);
        }
        return this.scopedName2element.get(scopedName);
    }

    private void setupMapping(Model model) {
        this.visitModelElement(model);
    }

    private String getBaseLanguage(ModelElement modelElement) {
        return this.getModelDef(modelElement).getBaseLanguage();
    }

    private ModelDef getModelDef(ModelElement modelElement) {
        while (!(modelElement instanceof ModelDef)) {
            modelElement = modelElement.getNamespace();
        }
        return (ModelDef)modelElement;
    }

    private String getScopedName(ModelElement modelElement) {
        ArrayList<ModelElement> path = new ArrayList<ModelElement>();
        String baseLanguage = null;
        while (!(modelElement instanceof ModelDef)) {
            path.add(0, modelElement);
            if (modelElement instanceof RoleDef) {
                RoleDef roleDef = (RoleDef)modelElement;
                Association association = roleDef.getAssociation();
                modelElement = association;
                continue;
            }
            if (modelElement instanceof AttributeDef) {
                AttributeDef attrDef = (AttributeDef)modelElement;
                Classifier owner = attrDef.getOwner();
                modelElement = owner;
                continue;
            }
            if (modelElement instanceof ParameterDef) {
                ClassDef classDef = ((ParameterDef)modelElement).getClassDef();
                modelElement = classDef;
                continue;
            }
            if (modelElement instanceof ConstraintDef) {
                if (((ConstraintDef)modelElement).sizeConstrainedElement() != 1) {
                    throw new IllegalStateException("no owner of constraint");
                }
                Iterator constrainedElement = ((ConstraintDef)modelElement).iteratorConstrainedElement();
                modelElement = (ModelElement)constrainedElement.next();
                continue;
            }
            if (!modelElement.containsNamespace()) break;
            modelElement = modelElement.getNamespace();
        }
        if (!(modelElement instanceof ModelDef)) {
            return null;
        }
        baseLanguage = this.getBaseLanguage((ModelDef)modelElement);
        path.add(0, modelElement);
        StringBuilder scopedName = new StringBuilder();
        String sep = "";
        for (ModelElement ele : path) {
            if (ele instanceof UmlPackage) continue;
            scopedName.append(sep);
            scopedName.append(ele.getName().getValue(baseLanguage));
            sep = ".";
        }
        return scopedName.toString();
    }

    public static boolean isInternal(INTERLIS2Def obj) {
        return obj.getDefLangName().startsWith("<");
    }
}

