/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.metaobjects.ParameterDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.tools.ModelElementUtility;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.changepropagation.MetaModelListener;
import ch.ehi.uml1_4.foundation.core.Artifact;
import ch.ehi.uml1_4.foundation.core.Association;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.uml1_4.foundation.core.Class;
import ch.ehi.uml1_4.foundation.core.Constraint;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.Feature;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.implementation.UmlModel;
import ch.ehi.uml1_4.modelmanagement.Package;
import ch.ehi.umleditor.application.NavigationTreeNodeUtility;
import ch.ehi.umleditor.umlpresentation.Diagram;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NavigationTreeModel
implements TreeModel,
MetaModelListener {
    public static final String SORT_BY_KIND_NAME = "SORT_BY_KIND_NAME";
    public static final String SORT_BY_NAME = "SORT_BY_NAME";
    private String currentOrdering = "SORT_BY_KIND_NAME";
    private Vector<TreeModelListener> treeModelListeners = new Vector();
    private Namespace rootElement;
    private boolean showOnlyPackages;

    public NavigationTreeModel(Namespace root, boolean showOnlyPackages) {
        this.rootElement = root;
        this.showOnlyPackages = showOnlyPackages;
    }

    private void fireTreeNodesChanged(Element node) {
        TreePath path = this.getTreePath(node);
        if (path != null) {
            int len = this.treeModelListeners.size();
            TreeModelEvent e = new TreeModelEvent((Object)this, path);
            for (int i = 0; i < len; ++i) {
                this.treeModelListeners.elementAt(i).treeNodesChanged(e);
            }
        }
    }

    private void fireTreeStructureChanged(Element node) {
        TreePath path = this.getTreePath(node);
        if (path != null) {
            int len = this.treeModelListeners.size();
            TreeModelEvent e = new TreeModelEvent((Object)this, path);
            for (int i = 0; i < len; ++i) {
                this.treeModelListeners.elementAt(i).treeStructureChanged(e);
            }
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (!this.treeModelListeners.contains(l)) {
            this.treeModelListeners.addElement(l);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (this.treeModelListeners.contains(l)) {
            this.treeModelListeners.removeElement(l);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        List<Element> children = this.getChildren(parent);
        return children.get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        List<Element> children = this.getChildren(parent);
        return children.size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        List<Element> children = this.getChildren(parent);
        return children.indexOf(child);
    }

    @Override
    public Object getRoot() {
        return this.rootElement;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof Namespace) || node instanceof DomainDef;
    }

    public static boolean isINTERLIS2Def(Object node) {
        return node instanceof INTERLIS2Def;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object node = path.getLastPathComponent();
        if (NavigationTreeModel.isINTERLIS2Def(node)) {
            INTERLIS2Def obj = (INTERLIS2Def)node;
            if (((String)newValue).endsWith(".ili")) {
                NavigationTreeNodeUtility.setName(node, (String)newValue);
            } else {
                NavigationTreeNodeUtility.setName(node, (String)newValue + ".ili");
            }
        } else {
            NavigationTreeNodeUtility.setName(node, (String)newValue);
        }
    }

    private List<Element> getChildren(Object parent) {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (this.showOnlyPackages) {
            if (parent instanceof Namespace) {
                Iterator iterator = ((Namespace)parent).iteratorOwnedElement();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!(next instanceof Package) && !(next instanceof Artifact)) continue;
                    ret.add((Element)next);
                }
                Collections.sort(ret, new Compare(this.currentOrdering));
            }
        } else {
            Iterator iterator;
            if (parent instanceof Class) {
                if (parent instanceof Association) {
                    iterator = ((Association)parent).iteratorConnection();
                    while (iterator.hasNext()) {
                        ret.add((Element)iterator.next());
                    }
                }
                iterator = ((Class)parent).iteratorFeature();
                while (iterator.hasNext()) {
                    ret.add((Element)iterator.next());
                }
                iterator = ((Class)parent).iteratorAssociation();
                while (iterator.hasNext()) {
                    AssociationEnd ownRoleDef = (AssociationEnd)iterator.next();
                    Iterator iteratorRoles = ownRoleDef.getAssociation().iteratorConnection();
                    while (iteratorRoles.hasNext()) {
                        AssociationEnd otherRole = (AssociationEnd)iteratorRoles.next();
                        if (otherRole.equals(ownRoleDef)) continue;
                        ret.add(otherRole);
                    }
                }
                if (parent instanceof ClassDef) {
                    iterator = ((ClassDef)parent).iteratorParameterDef();
                    while (iterator.hasNext()) {
                        ret.add((Element)iterator.next());
                    }
                }
            } else if (parent instanceof Namespace) {
                iterator = ((Namespace)parent).iteratorOwnedElement();
                while (iterator.hasNext()) {
                    ret.add((Element)iterator.next());
                }
                iterator = ((Namespace)parent).iteratorDiagram();
                while (iterator.hasNext()) {
                    ret.add((Element)iterator.next());
                }
                Collections.sort(ret, new Compare(this.currentOrdering));
            }
            if (parent instanceof ModelElement) {
                iterator = ((ModelElement)parent).iteratorConstraint();
                while (iterator.hasNext()) {
                    ret.add((Element)iterator.next());
                }
            }
        }
        return ret;
    }

    @Override
    public void metaModelChanged(MetaModelChange event) {
        AssociationEnd ownRoleDef;
        Object source = event.getSource();
        String ops = event.getOperation();
        if (source instanceof Class) {
            if (source instanceof Association && MetaModelChange.isAttribute(ops, "Connection") && !ops.startsWith("clear")) {
                this.fireTreeStructureChanged((ModelElement)source);
            }
            if (MetaModelChange.isAttribute(ops, "Feature")) {
                this.fireTreeStructureChanged((ModelElement)source);
            }
            if (MetaModelChange.isAttribute(ops, "Association") && !ops.startsWith("clear")) {
                this.fireTreeStructureChanged((ModelElement)source);
            }
            if (source instanceof ClassDef && MetaModelChange.isAttribute(ops, "ParameterDef")) {
                this.fireTreeStructureChanged((ModelElement)source);
            }
        } else if (source instanceof AssociationEnd && MetaModelChange.isAttribute(ops, "Name") && (ownRoleDef = (AssociationEnd)source).containsAssociation()) {
            Iterator iteratorRoles = ownRoleDef.getAssociation().iteratorConnection();
            while (iteratorRoles.hasNext()) {
                AssociationEnd sourceRole = (AssociationEnd)iteratorRoles.next();
                if (sourceRole.equals(ownRoleDef) || !sourceRole.containsParticipant()) continue;
                this.fireTreeStructureChanged(sourceRole.getParticipant());
            }
        }
        if (source instanceof ModelElement && MetaModelChange.isAttribute(ops, "Constraint")) {
            this.fireTreeStructureChanged((ModelElement)source);
        }
        if (source instanceof Namespace) {
            if (MetaModelChange.isAttribute(ops, "OwnedElement")) {
                this.fireTreeStructureChanged((ModelElement)source);
            }
            if (MetaModelChange.isAttribute(ops, "Diagram")) {
                this.fireTreeStructureChanged((ModelElement)source);
            }
        }
        if ((source instanceof ModelElement || source instanceof Diagram) && MetaModelChange.isAttribute(ops, "Name")) {
            if (source instanceof UmlModel) {
                this.fireTreeNodesChanged((UmlModel)source);
            } else {
                Namespace parent = this.getParent((Element)source);
                if (parent != null) {
                    this.fireTreeStructureChanged(parent);
                }
            }
        }
    }

    public Namespace getParent(Element node) {
        Namespace next = null;
        if (node instanceof AssociationEnd) {
            if (((AssociationEnd)node).containsAssociation()) {
                next = (Namespace)((Object)((AssociationEnd)node).getAssociation());
            }
        } else if (node instanceof Feature) {
            if (((Feature)node).containsOwner()) {
                next = ((Feature)node).getOwner();
            }
        } else if (node instanceof Diagram) {
            if (((Diagram)node).containsNamespace()) {
                next = ((Diagram)node).getNamespace();
            }
        } else if (node instanceof ParameterDef) {
            if (((ParameterDef)node).containsClassDef()) {
                next = ((ParameterDef)node).getClassDef();
            }
        } else if (node instanceof Constraint) {
            if (((Constraint)node).iteratorConstrainedElement().hasNext()) {
                next = (Namespace)((Constraint)node).iteratorConstrainedElement().next();
            }
        } else if (node instanceof ModelElement && ((ModelElement)node).containsNamespace()) {
            next = ((ModelElement)node).getNamespace();
        }
        return next;
    }

    public TreePath getTreePath(Element node) {
        ArrayList<Element> path = new ArrayList<Element>();
        path.add(node);
        Namespace next = this.getParent(node);
        if (next != null) {
            path.add(0, next);
            while (next.containsNamespace()) {
                next = next.getNamespace();
                path.add(0, next);
            }
        }
        if (path.get(0) != this.rootElement) {
            return null;
        }
        return new TreePath(path.toArray());
    }

    public String getOrdering() {
        return this.currentOrdering;
    }

    public void setOrdering(String ordering) {
        this.currentOrdering = ordering;
    }

    public void refresh() {
        this.fireTreeStructureChanged(this.rootElement);
    }

    class Compare
    implements Comparator {
        private String ordering;

        public Compare(String ordering) {
            this.ordering = ordering;
        }

        public int compare(Object o1, Object o2) {
            String name2;
            int def;
            if (o1 instanceof Diagram && !(o2 instanceof Diagram)) {
                return -1;
            }
            if (o2 instanceof Diagram && !(o1 instanceof Diagram)) {
                return 1;
            }
            if (this.ordering.equals(NavigationTreeModel.SORT_BY_KIND_NAME) && (def = ModelElementUtility.compareDefinition(o1.getClass(), o2.getClass())) != 0) {
                return def;
            }
            String name1 = NavigationTreeNodeUtility.getName(o1);
            if (name1 == null) {
                name1 = "";
            }
            if ((name2 = NavigationTreeNodeUtility.getName(o2)) == null) {
                name2 = "";
            }
            int compareName = name1.compareToIgnoreCase(name2);
            return compareName;
        }
    }
}

