/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.types.NlsString;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.interlis.metaobjects.MetaObjectFile;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.umleditor.application.DescriptionPanel;
import ch.ehi.umleditor.application.LauncherView;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class MetaObjectFileDialog
extends BaseDialog {
    private static ResourceBundle resMetaObjectFileDialog = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/MetaObjectFileDialog");
    MetaObjectFile metaObjectFile = null;
    private JPanel ivjBaseDialogContentPane = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjBtnCancel = null;
    private JButton ivjBtnOk = null;
    private JTabbedPane ivjTbpGeneral = null;
    private JButton ivjBtnApply = null;
    private DescriptionPanel ivjPnlDescription = null;
    private JButton ivjBtnFileSearch = null;
    private JLabel ivjLblFilename = null;
    private JTextField ivjTxtFilename = null;

    public MetaObjectFileDialog(Frame owner, Element element) {
        super(owner, true);
        this.initialize();
        this.addEscapeKey();
        this.setTitle(resMetaObjectFileDialog.getString("CTSpecification"));
        this.setRelativeLocation(owner);
        this.setElement(element);
        this.show();
    }

    private void addEscapeKey() {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -2972481431614869047L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MetaObjectFileDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private void btnFileSearch() {
        LauncherView.getInstance();
        FileChooser openDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
        openDialog.setDialogTitle(resMetaObjectFileDialog.getString("CTAssignFilename"));
        openDialog.setFileFilter((FileFilter)LauncherView.createXmlFilter());
        if (openDialog.showOpenDialog((Component)this) == 0) {
            try {
                LauncherView.getInstance();
                LauncherView.getSettings().setWorkingDirectory(openDialog.getCurrentDirectory().getAbsolutePath());
                String fileName = openDialog.getSelectedFile().getAbsolutePath();
                this.getTxtFilename().setText(fileName);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.okPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.cancelPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.applyPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.btnFileSearch();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(FocusEvent arg1) {
        try {
            this.getTxtFilename().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLblFilename = new GridBagConstraints();
                constraintsLblFilename.gridx = 1;
                constraintsLblFilename.gridy = 1;
                constraintsLblFilename.gridwidth = 2;
                constraintsLblFilename.ipadx = 74;
                constraintsLblFilename.insets = new Insets(22, 15, 6, 3);
                this.getBaseDialogContentPane().add((Component)this.getLblFilename(), constraintsLblFilename);
                GridBagConstraints constraintsTxtFilename = new GridBagConstraints();
                constraintsTxtFilename.gridx = 3;
                constraintsTxtFilename.gridy = 1;
                constraintsTxtFilename.gridwidth = 2;
                constraintsTxtFilename.fill = 2;
                constraintsTxtFilename.weightx = 1.0;
                constraintsTxtFilename.ipadx = 203;
                constraintsTxtFilename.insets = new Insets(19, 4, 3, 4);
                this.getBaseDialogContentPane().add((Component)this.getTxtFilename(), constraintsTxtFilename);
                GridBagConstraints constraintsBtnOk = new GridBagConstraints();
                constraintsBtnOk.gridx = 1;
                constraintsBtnOk.gridy = 3;
                constraintsBtnOk.ipadx = 64;
                constraintsBtnOk.insets = new Insets(4, 32, 5, 3);
                this.getBaseDialogContentPane().add((Component)this.getBtnOk(), constraintsBtnOk);
                GridBagConstraints constraintsBtnCancel = new GridBagConstraints();
                constraintsBtnCancel.gridx = 2;
                constraintsBtnCancel.gridy = 3;
                constraintsBtnCancel.gridwidth = 2;
                constraintsBtnCancel.ipadx = 18;
                constraintsBtnCancel.insets = new Insets(4, 3, 5, 5);
                this.getBaseDialogContentPane().add((Component)this.getBtnCancel(), constraintsBtnCancel);
                GridBagConstraints constraintsBtnApply = new GridBagConstraints();
                constraintsBtnApply.gridx = 4;
                constraintsBtnApply.gridy = 3;
                constraintsBtnApply.gridwidth = 2;
                constraintsBtnApply.ipadx = 16;
                constraintsBtnApply.insets = new Insets(4, 5, 5, 25);
                this.getBaseDialogContentPane().add((Component)this.getBtnApply(), constraintsBtnApply);
                GridBagConstraints constraintsTbpGeneral = new GridBagConstraints();
                constraintsTbpGeneral.gridx = 1;
                constraintsTbpGeneral.gridy = 2;
                constraintsTbpGeneral.gridwidth = 5;
                constraintsTbpGeneral.fill = 1;
                constraintsTbpGeneral.weightx = 1.0;
                constraintsTbpGeneral.weighty = 1.0;
                constraintsTbpGeneral.ipadx = 376;
                constraintsTbpGeneral.ipady = 99;
                constraintsTbpGeneral.insets = new Insets(0, 10, 3, 9);
                this.getBaseDialogContentPane().add((Component)this.getTbpGeneral(), constraintsTbpGeneral);
                GridBagConstraints constraintsBtnFileSearch = new GridBagConstraints();
                constraintsBtnFileSearch.gridx = 5;
                constraintsBtnFileSearch.gridy = 1;
                constraintsBtnFileSearch.insets = new Insets(17, 4, 0, 6);
                this.getBaseDialogContentPane().add((Component)this.getBtnFileSearch(), constraintsBtnFileSearch);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JButton getBtnApply() {
        if (this.ivjBtnApply == null) {
            try {
                this.ivjBtnApply = new JButton();
                this.ivjBtnApply.setName("BtnApply");
                this.ivjBtnApply.setText(MetaObjectFileDialog.getApplyString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnApply;
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText(MetaObjectFileDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    private JButton getBtnFileSearch() {
        if (this.ivjBtnFileSearch == null) {
            try {
                this.ivjBtnFileSearch = new JButton();
                this.ivjBtnFileSearch.setName("BtnFileSearch");
                this.ivjBtnFileSearch.setText("...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnFileSearch;
    }

    private JButton getBtnOk() {
        if (this.ivjBtnOk == null) {
            try {
                this.ivjBtnOk = new JButton();
                this.ivjBtnOk.setName("BtnOk");
                this.ivjBtnOk.setText(MetaObjectFileDialog.getOKString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnOk;
    }

    private JLabel getLblFilename() {
        if (this.ivjLblFilename == null) {
            try {
                this.ivjLblFilename = new JLabel();
                this.ivjLblFilename.setName("LblFilename");
                this.ivjLblFilename.setToolTipText("");
                this.ivjLblFilename.setText(resMetaObjectFileDialog.getString("LblFilename_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblFilename;
    }

    private DescriptionPanel getPnlDescription() {
        if (this.ivjPnlDescription == null) {
            try {
                this.ivjPnlDescription = new DescriptionPanel();
                this.ivjPnlDescription.setName("PnlDescription");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlDescription;
    }

    private JTabbedPane getTbpGeneral() {
        if (this.ivjTbpGeneral == null) {
            try {
                this.ivjTbpGeneral = new JTabbedPane();
                this.ivjTbpGeneral.setName("TbpGeneral");
                this.ivjTbpGeneral.setToolTipText(resMetaObjectFileDialog.getString("TbpGeneral_toolTipText"));
                this.ivjTbpGeneral.insertTab(this.getDescriptionString(), null, this.getPnlDescription(), null, 0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbpGeneral;
    }

    private JTextField getTxtFilename() {
        if (this.ivjTxtFilename == null) {
            try {
                this.ivjTxtFilename = new JTextField();
                this.ivjTxtFilename.setName("TxtFilename");
                this.ivjTxtFilename.setToolTipText(resMetaObjectFileDialog.getString("TxtFilename_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtFilename;
    }

    @Override
    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getBtnOk().addActionListener(this.ivjEventHandler);
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
        this.getBtnApply().addActionListener(this.ivjEventHandler);
        this.getBtnFileSearch().addActionListener(this.ivjEventHandler);
        this.getTxtFilename().addFocusListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ContractSpecificationDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 230);
            this.setTitle("MetaObjectFile (Spezifikation)");
            this.setContentPane(this.getBaseDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    protected boolean save() {
        this.metaObjectFile.setName(new NlsString(this.metaObjectFile.getName(), "", this.getTxtFilename().getText()));
        this.getPnlDescription().getObject();
        return super.save();
    }

    private void setElement(Element element) {
        this.metaObjectFile = (MetaObjectFile)element;
        this.getTxtFilename().setText(this.metaObjectFile.getName().getValue(""));
        this.getPnlDescription().setObject(this.metaObjectFile);
    }

    class IvjEventHandler
    implements ActionListener,
    FocusListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MetaObjectFileDialog.this.getBtnOk()) {
                MetaObjectFileDialog.this.connEtoC1(e);
            }
            if (e.getSource() == MetaObjectFileDialog.this.getBtnCancel()) {
                MetaObjectFileDialog.this.connEtoC2(e);
            }
            if (e.getSource() == MetaObjectFileDialog.this.getBtnApply()) {
                MetaObjectFileDialog.this.connEtoC3(e);
            }
            if (e.getSource() == MetaObjectFileDialog.this.getBtnFileSearch()) {
                MetaObjectFileDialog.this.connEtoC4(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == MetaObjectFileDialog.this.getTxtFilename()) {
                MetaObjectFileDialog.this.connEtoM1(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

