/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.extensionmechanisms.TaggedValue;
import ch.ehi.umleditor.application.EditorTableModel;
import ch.ehi.umleditor.application.ElementUtils;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.BasePanel;
import ch.softenvironment.view.CommonUserAccess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MetaAttributePanel
extends BasePanel {
    private static final ResourceBundle resClassDefDialog = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/MetaAttributePanel");
    private final Dialog ownerDialog;
    private final List<String> ignoredMetaAttributes;
    private JTable metaAttributeTable;
    private JPopupMenu contextMenu;
    private MetaAttributeDialog metaAttributeEditDialog;

    public MetaAttributePanel(Dialog owner) {
        this(owner, Collections.emptyList());
    }

    public MetaAttributePanel(Dialog owner, List<String> ignoredMetaAttributes) {
        this.ownerDialog = owner;
        this.ignoredMetaAttributes = ignoredMetaAttributes;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(7, 11, 6, 7));
        this.setLayout(new BorderLayout());
        JScrollPane tableScrollPane = new JScrollPane(this.getMetaAttributeTable());
        tableScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            private void handleMouseEvent(MouseEvent e) {
                if (MetaAttributePanel.this.isEnabled()) {
                    MetaAttributePanel.this.genericPopupDisplay(e, MetaAttributePanel.this.getContextMenu());
                }
            }
        });
        this.add((Component)tableScrollPane, "Center");
    }

    private JTable getMetaAttributeTable() {
        if (this.metaAttributeTable == null) {
            EditorTableModel tableModel = new EditorTableModel();
            tableModel.setColumnIdentifiers(new String[]{resClassDefDialog.getString("TbcMetaAttributeName_text"), resClassDefDialog.getString("TbcMetaAttributeValue_text")});
            this.metaAttributeTable = new JTable();
            this.metaAttributeTable.setCellSelectionEnabled(false);
            this.metaAttributeTable.setRowSelectionAllowed(true);
            this.metaAttributeTable.setModel(tableModel);
            this.metaAttributeTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.handleMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.handleMouseEvent(e);
                }

                private void handleMouseEvent(MouseEvent e) {
                    if (MetaAttributePanel.this.isEnabled()) {
                        if (e.getClickCount() == 2) {
                            MetaAttributePanel.this.editMetaAttribute();
                        }
                        MetaAttributePanel.this.genericPopupDisplay(e, MetaAttributePanel.this.getContextMenu());
                    }
                }
            });
        }
        return this.metaAttributeTable;
    }

    private JPopupMenu getContextMenu() {
        if (this.contextMenu == null) {
            final JMenuItem edit = new JMenuItem(CommonUserAccess.getMniEditChangeWindowText());
            edit.setEnabled(false);
            edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaAttributePanel.this.editMetaAttribute();
                }
            });
            JMenuItem newAttribute = new JMenuItem(CommonUserAccess.getMniFileNewText());
            newAttribute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaAttributePanel.this.newMetaAttribute();
                }
            });
            final JMenuItem delete = new JMenuItem(ResourceManager.getResource(BaseDialog.class, "BtnRemove_text"));
            delete.setEnabled(false);
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaAttributePanel.this.deleteSelectedMetaAttribute();
                }
            });
            final JMenuItem moveDown = new JMenuItem(resClassDefDialog.getString("MniMoveDown_text"));
            moveDown.setEnabled(false);
            moveDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaAttributePanel.this.moveDownMetaAttribute();
                }
            });
            this.getMetaAttributeTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DefaultListSelectionModel selectionModel = (DefaultListSelectionModel)e.getSource();
                    boolean somethingSelected = !selectionModel.isSelectionEmpty();
                    edit.setEnabled(somethingSelected);
                    delete.setEnabled(somethingSelected);
                    moveDown.setEnabled(somethingSelected);
                }
            });
            this.contextMenu = new JPopupMenu();
            this.contextMenu.add(edit);
            this.contextMenu.add(new JSeparator());
            this.contextMenu.add(newAttribute);
            this.contextMenu.add(delete);
            this.contextMenu.add(moveDown);
        }
        return this.contextMenu;
    }

    private MetaAttributeDialog getMetaAttributeEditDialog() {
        if (this.metaAttributeEditDialog == null) {
            this.metaAttributeEditDialog = new MetaAttributeDialog(this.ownerDialog);
        }
        return this.metaAttributeEditDialog;
    }

    private void editMetaAttribute() {
        this.getMetaAttributeEditDialog().setCurrentObject(this.getMetaAttributeTable(), this.getMetaAttributeTable().getSelectedRow());
        this.getMetaAttributeEditDialog().setVisible(true);
    }

    private void newMetaAttribute() {
        EditorTableModel tableModel = (EditorTableModel)this.getMetaAttributeTable().getModel();
        tableModel.addRow(new Object[]{resClassDefDialog.getString("TbcMetaAttributeName_text"), resClassDefDialog.getString("TbcMetaAttributeValue_text")});
    }

    private void deleteSelectedMetaAttribute() {
        EditorTableModel tableModel = (EditorTableModel)this.getMetaAttributeTable().getModel();
        int[] selectedRows = this.getMetaAttributeTable().getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            tableModel.removeRow(selectedRows[i]);
        }
    }

    private void moveDownMetaAttribute() {
        EditorTableModel tableModel = (EditorTableModel)this.getMetaAttributeTable().getModel();
        int selectedRow = this.getMetaAttributeTable().getSelectedRow();
        int targetRow = selectedRow + 1;
        if (targetRow < tableModel.getRowCount()) {
            tableModel.moveRow(selectedRow, selectedRow, targetRow);
        }
    }

    public void setCurrentObject(ModelElement element) {
        EditorTableModel tableModel = (EditorTableModel)this.getMetaAttributeTable().getModel();
        tableModel.setRowCount(0);
        if (element != null) {
            Iterator it = element.iteratorTaggedValue();
            while (it.hasNext()) {
                TaggedValue metaAttribute = (TaggedValue)it.next();
                String name = MetaAttributePanel.getMetaAttributeName(metaAttribute);
                String value = metaAttribute.getDataValue();
                if (this.ignoredMetaAttributes.contains(name)) continue;
                tableModel.addRow(new Object[]{name, value});
            }
        }
    }

    public void saveToObject(ModelElement element) {
        Vector<Vector> newMetaAttributes = ((EditorTableModel)this.getMetaAttributeTable().getModel()).getDataVector();
        Iterator it = element.iteratorTaggedValue();
        while (it.hasNext()) {
            TaggedValue metaAttribute = (TaggedValue)it.next();
            String metaAttributeName = MetaAttributePanel.getMetaAttributeName(metaAttribute);
            boolean found = false;
            for (Vector row : newMetaAttributes) {
                if (!row.get(0).equals(metaAttributeName)) continue;
                found = true;
                break;
            }
            if (found || this.ignoredMetaAttributes.contains(metaAttributeName)) continue;
            it.remove();
        }
        Iterator<Vector> iterator = newMetaAttributes.iterator();
        while (iterator.hasNext()) {
            Vector row;
            Vector rowVector = row = iterator.next();
            ElementUtils.setIliTaggedValue(element, (String)rowVector.get(0), (String)rowVector.get(1));
        }
    }

    private static String getMetaAttributeName(TaggedValue metaAttribute) {
        return metaAttribute.getName().getValue().replaceFirst("^" + Pattern.quote("ili:"), "");
    }

    private static class MetaAttributeDialog
    extends BaseDialog {
        private JTable currentTable;
        private int currentRow;
        private JTextField nameTextField;
        private JTextField valueTextField;

        public MetaAttributeDialog(Dialog owner) {
            super(owner, true);
            this.initialize();
        }

        private void initialize() {
            this.setTitle(resClassDefDialog.getString("CTEditDialog"));
            this.setSize(new Dimension(426, 180));
            this.setLayout(new BorderLayout());
            JPanel content = new JPanel();
            content.setLayout(new GridBagLayout());
            content.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
            this.nameTextField = new JTextField();
            this.valueTextField = new JTextField();
            GridBagConstraints nameLabelConstraints = new GridBagConstraints();
            nameLabelConstraints.gridx = 0;
            nameLabelConstraints.gridy = 0;
            nameLabelConstraints.weightx = 0.0;
            nameLabelConstraints.fill = 2;
            nameLabelConstraints.anchor = 256;
            nameLabelConstraints.insets = new Insets(0, 0, 10, 10);
            GridBagConstraints nameTextFieldConstraints = new GridBagConstraints();
            nameTextFieldConstraints.gridx = 1;
            nameTextFieldConstraints.gridy = 0;
            nameTextFieldConstraints.weightx = 2.0;
            nameTextFieldConstraints.fill = 2;
            nameTextFieldConstraints.anchor = 256;
            nameTextFieldConstraints.insets = new Insets(0, 0, 10, 0);
            GridBagConstraints valueLabelConstraints = new GridBagConstraints();
            valueLabelConstraints.gridx = 0;
            valueLabelConstraints.gridy = 1;
            valueLabelConstraints.weightx = 0.0;
            valueLabelConstraints.weighty = 1.0;
            valueLabelConstraints.fill = 2;
            valueLabelConstraints.anchor = 256;
            valueLabelConstraints.insets = new Insets(0, 0, 10, 10);
            GridBagConstraints valueTextFieldConstraints = new GridBagConstraints();
            valueTextFieldConstraints.gridx = 1;
            valueTextFieldConstraints.gridy = 1;
            valueTextFieldConstraints.weightx = 2.0;
            valueTextFieldConstraints.weighty = 1.0;
            valueTextFieldConstraints.fill = 2;
            valueTextFieldConstraints.anchor = 256;
            valueTextFieldConstraints.insets = new Insets(0, 0, 10, 0);
            content.add((Component)new JLabel(resClassDefDialog.getString("TbcMetaAttributeName_text")), nameLabelConstraints);
            content.add((Component)this.nameTextField, nameTextFieldConstraints);
            content.add((Component)new JLabel(resClassDefDialog.getString("TbcMetaAttributeValue_text")), valueLabelConstraints);
            content.add((Component)this.valueTextField, valueTextFieldConstraints);
            this.add((Component)content, "Center");
            JButton okButton = new JButton(MetaAttributeDialog.getOKString());
            okButton.setPreferredSize(new Dimension(100, 25));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaAttributeDialog.this.okPressed();
                }
            });
            JButton cancelButton = new JButton(MetaAttributeDialog.getCancelString());
            cancelButton.setPreferredSize(new Dimension(100, 25));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaAttributeDialog.this.cancelPressed();
                }
            });
            JButton applyButton = new JButton(MetaAttributeDialog.getApplyString());
            applyButton.setPreferredSize(new Dimension(100, 25));
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaAttributeDialog.this.applyPressed();
                }
            });
            Box buttons = Box.createHorizontalBox();
            buttons.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
            buttons.add(Box.createGlue());
            buttons.add(okButton);
            buttons.add(Box.createHorizontalStrut(10));
            buttons.add(cancelButton);
            buttons.add(Box.createHorizontalStrut(10));
            buttons.add(applyButton);
            this.add((Component)buttons, "South");
        }

        public void setCurrentObject(JTable tableModel, int row) {
            this.currentTable = tableModel;
            this.currentRow = row;
            this.nameTextField.setText((String)tableModel.getValueAt(row, 0));
            this.valueTextField.setText((String)tableModel.getValueAt(row, 1));
        }

        @Override
        protected boolean save() {
            this.currentTable.setValueAt(this.nameTextField.getText(), this.currentRow, 0);
            this.currentTable.setValueAt(this.valueTextField.getText(), this.currentRow, 1);
            return super.save();
        }
    }
}

