/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.IliSyntax;
import ch.ehi.interlis.constraints.ConstraintDef;
import ch.ehi.interlis.constraints.ConstraintExpression;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.graphicdescriptions.GraphicDef;
import ch.ehi.interlis.graphicdescriptions.GraphicParameterDef;
import ch.ehi.interlis.metaobjects.ParameterDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.units.UnitDef;
import ch.ehi.interlis.views.ViewDef;
import ch.ehi.uml1_4.foundation.core.Constraint;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.implementation.UmlUsage;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.ReferencableComboBox;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.BasePanel;
import ch.softenvironment.view.DataPanel;
import ch.softenvironment.view.DataSelectorPanel;
import ch.softenvironment.view.DataSelectorPanelListener;
import ch.softenvironment.view.SimpleEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class InterlisSyntaxPanel
extends BasePanel
implements DataPanel,
DataSelectorPanelListener {
    private SimpleEditorPanel ivjPnlEditor = null;
    private ModelElement modelElement = null;
    private IliSyntax iliSyntax = null;
    private Constraint constraint = null;
    private DataSelectorPanel ivjPnlDataSelector = null;
    private ReferencableComboBox ivjCbxUsage = null;
    private JLabel ivjLblUsage = null;
    private JPanel ivjPnlUsage = null;

    public InterlisSyntaxPanel() {
        this.initialize();
    }

    @Override
    public Object createObject() {
        return new NlsString();
    }

    private ReferencableComboBox getCbxUsage() {
        if (this.ivjCbxUsage == null) {
            try {
                this.ivjCbxUsage = new ReferencableComboBox();
                this.ivjCbxUsage.setName("CbxUsage");
                this.ivjCbxUsage.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCbxUsage;
    }

    public NlsString getConstraint() {
        String syntax = this.getPnlEditor().getText();
        if (syntax != null && syntax.length() > 0) {
            if (((ConstraintExpression)this.constraint.getBody()).getSyntax() == null) {
                return new NlsString(syntax);
            }
            return new NlsString(((ConstraintExpression)this.constraint.getBody()).getSyntax(), syntax);
        }
        return null;
    }

    public ModelElement getConstraints() {
        this.modelElement.clearConstraint();
        Iterator iterator = this.getPnlDataSelector().getObjects().iterator();
        try {
            while (iterator.hasNext()) {
                Object eleo = iterator.next();
                ConstraintDef constraintDef = null;
                if (eleo instanceof NlsString) {
                    ConstraintExpression expression = new ConstraintExpression();
                    expression.setSyntax((NlsString)eleo);
                    constraintDef = (ConstraintDef)ElementFactory.createObject(ConstraintDef.class);
                    constraintDef.setBody(expression);
                } else {
                    constraintDef = (ConstraintDef)eleo;
                }
                this.modelElement.addConstraint(constraintDef);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        return this.modelElement;
    }

    private JLabel getLblUsage() {
        if (this.ivjLblUsage == null) {
            try {
                this.ivjLblUsage = new JLabel();
                this.ivjLblUsage.setName("LblUsage");
                this.ivjLblUsage.setText("Abhaengig von:");
                this.ivjLblUsage.setText(this.getResourceString("LblUsage_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblUsage;
    }

    @Override
    public Object getObject() {
        throw new UnsupportedOperationException();
    }

    public ModelElement getParameterDefs() {
        ((ClassDef)this.modelElement).clearParameterDef();
        try {
            Iterator iterator = this.getPnlDataSelector().getObjects().iterator();
            while (iterator.hasNext()) {
                ParameterDef expression = (ParameterDef)ElementFactory.createObject(ParameterDef.class);
                expression.setSyntax((NlsString)iterator.next());
                ((ClassDef)this.modelElement).addParameterDef(expression);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        return this.modelElement;
    }

    private DataSelectorPanel getPnlDataSelector() {
        if (this.ivjPnlDataSelector == null) {
            try {
                this.ivjPnlDataSelector = new DataSelectorPanel();
                this.ivjPnlDataSelector.setName("PnlDataSelector");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlDataSelector;
    }

    private SimpleEditorPanel getPnlEditor() {
        if (this.ivjPnlEditor == null) {
            try {
                this.ivjPnlEditor = new SimpleEditorPanel();
                this.ivjPnlEditor.setName("PnlEditor");
                this.ivjPnlEditor.setLayout(new BoxLayout(this.getPnlEditor(), 0));
                this.ivjPnlEditor.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlEditor;
    }

    private JPanel getPnlUsage() {
        if (this.ivjPnlUsage == null) {
            try {
                this.ivjPnlUsage = new JPanel();
                this.ivjPnlUsage.setName("PnlUsage");
                this.ivjPnlUsage.setPreferredSize(new Dimension(0, 40));
                this.ivjPnlUsage.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLblUsage = new GridBagConstraints();
                constraintsLblUsage.gridx = 1;
                constraintsLblUsage.gridy = 1;
                constraintsLblUsage.ipadx = 101;
                constraintsLblUsage.insets = new Insets(11, 6, 15, 5);
                this.getPnlUsage().add((Component)this.getLblUsage(), constraintsLblUsage);
                GridBagConstraints constraintsCbxUsage = new GridBagConstraints();
                constraintsCbxUsage.gridx = 2;
                constraintsCbxUsage.gridy = 1;
                constraintsCbxUsage.fill = 2;
                constraintsCbxUsage.weightx = 1.0;
                constraintsCbxUsage.ipadx = 89;
                constraintsCbxUsage.insets = new Insets(7, 5, 10, 7);
                this.getPnlUsage().add((Component)this.getCbxUsage(), constraintsCbxUsage);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlUsage;
    }

    public NlsString getSyntax() {
        String syntax;
        if (this.getCbxUsage().hasElementChanged()) {
            this.getCbxUsage().save0or1Dependency(UmlUsage.class);
        }
        if ((syntax = this.getPnlEditor().getText()) != null && syntax.length() > 0) {
            if (this.iliSyntax == null || this.iliSyntax.getSyntax() == null) {
                return new NlsString(syntax);
            }
            return new NlsString(this.iliSyntax.getSyntax(), syntax);
        }
        return null;
    }

    @Override
    protected void handleException(Throwable exception) {
        BaseDialog.showError(this, this.getResourceString("CESyntax"), exception.toString(), exception);
    }

    private void initialize() {
        try {
            this.setName("PnlInterlisSyntax");
            this.setBorder(new EtchedBorder());
            this.setLayout(new BorderLayout());
            this.setSize(382, 165);
            this.add((Component)this.getPnlEditor(), "Center");
            this.add((Component)this.getPnlDataSelector(), "South");
            this.add((Component)this.getPnlUsage(), "North");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getPnlEditor().setToolTipText(this.getResourceString("PnlEditor_toolTipText"));
        this.setCurrentObject(null);
        this.getPnlDataSelector().setListener(this);
        this.getPnlUsage().setVisible(false);
    }

    @Override
    public void removeObject(Object object) {
    }

    @Override
    public Object saveChanges(Object object) {
        if (object instanceof ConstraintDef) {
            ConstraintDef constraintDef = (ConstraintDef)object;
            ((ConstraintExpression)constraintDef.getBody()).setSyntax(new NlsString(((ConstraintExpression)constraintDef.getBody()).getSyntax(), this.getPnlEditor().getText()));
            return constraintDef;
        }
        return new NlsString((NlsString)object, this.getPnlEditor().getText());
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
        this.getPnlDataSelector().setVisible(false);
        this.getPnlEditor().setEditable(true);
        if (((ConstraintExpression)constraint.getBody()).getSyntax() == null) {
            this.getPnlEditor().setText(new String());
        } else {
            this.getPnlEditor().setText(ElementUtils.mapNlsString(((ConstraintExpression)constraint.getBody()).getSyntax()));
        }
    }

    public void setConstraints(ModelElement modelElement) {
        this.modelElement = modelElement;
        Iterator iterator = modelElement.iteratorConstraint();
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        while (iterator != null && iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            list.add(constraint);
        }
        this.getPnlDataSelector().setObjects(list);
    }

    @Override
    public void setCurrentObject(Object syntax) {
        if (syntax == null) {
            this.getPnlEditor().setEditable(false);
            this.getPnlEditor().setText(null);
        } else {
            this.getPnlEditor().setEditable(true);
            if (syntax instanceof ConstraintDef) {
                ConstraintDef constraintDef = (ConstraintDef)syntax;
                this.getPnlEditor().setText(ElementUtils.mapNlsString(((ConstraintExpression)constraintDef.getBody()).getSyntax()));
            } else {
                this.getPnlEditor().setText(ElementUtils.mapNlsString((NlsString)syntax));
            }
        }
    }

    @Override
    public void setObject(Object object) {
        throw new UnsupportedOperationException();
    }

    public void setParameterDefs(ModelElement modelElement) {
        this.modelElement = modelElement;
        Iterator iterator = ((ClassDef)modelElement).iteratorParameterDef();
        ArrayList<NlsString> list = new ArrayList<NlsString>();
        while (iterator != null && iterator.hasNext()) {
            ParameterDef parameterDef = (ParameterDef)iterator.next();
            list.add(parameterDef.getSyntax());
        }
        this.getPnlDataSelector().setObjects(list);
    }

    public void setSyntax(IliSyntax iliSyntax) {
        this.iliSyntax = iliSyntax;
        if (iliSyntax instanceof UnitDef || iliSyntax instanceof FunctionDef || iliSyntax instanceof LineFormTypeDef || iliSyntax instanceof GraphicParameterDef || iliSyntax instanceof ViewDef || iliSyntax instanceof GraphicDef) {
            this.setUsage((ModelElement)((Object)iliSyntax));
        }
        this.getPnlDataSelector().setVisible(false);
        this.getPnlEditor().setEditable(true);
        if (iliSyntax == null || iliSyntax.getSyntax() == null) {
            this.getPnlEditor().setText(new String());
        } else {
            this.getPnlEditor().setText(ElementUtils.mapNlsString(iliSyntax.getSyntax()));
        }
    }

    public void setUsage(ModelElement modelElement) {
        this.getPnlUsage().setVisible(true);
        this.getCbxUsage().setEnabled(this.getCbxUsage().setUsage(modelElement));
    }
}

