/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.interlis.tools;

import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.graphicdescriptions.GraphicParameterDef;
import ch.ehi.interlis.metaobjects.MetaDataUseDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.ContextDef;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.IliImport;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.units.UnitDef;
import ch.ehi.interlis.views.ViewDef;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.implementation.UmlModel;
import ch.ehi.uml1_4.implementation.UmlPackage;
import ch.ehi.uml1_4.tools.NamespaceUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModelElementUtility {
    private static ArrayList ordering = null;

    public static Set getReferencableElements(ModelElement athis, Class aclass) {
        Namespace root = athis.getNamespace();
        while (!(root instanceof ModelDef) && root.containsNamespace()) {
            root = root.getNamespace();
        }
        HashSet referencables = new HashSet();
        ArrayList<Namespace> todo = new ArrayList<Namespace>();
        if (root instanceof ModelDef) {
            todo.add(root);
            Iterator impRelIt = root.iteratorClientDependency();
            while (impRelIt.hasNext()) {
                Object obj = impRelIt.next();
                if (!(obj instanceof IliImport)) continue;
                IliImport impRel = (IliImport)obj;
                Iterator supplierIt = impRel.iteratorSupplier();
                while (supplierIt.hasNext()) {
                    ModelDef supplier = (ModelDef)supplierIt.next();
                    todo.add(supplier);
                }
            }
            Namespace umlmodel = athis.getNamespace();
            while (umlmodel.containsNamespace()) {
                umlmodel = umlmodel.getNamespace();
            }
            if (NamespaceUtility.deepContainsOwnedElement(umlmodel, ModelDef.class, "INTERLIS")) {
                ModelDef interlisModel = (ModelDef)NamespaceUtility.deepGetOwnedElement(umlmodel, ModelDef.class, "INTERLIS");
                todo.add(interlisModel);
            }
        } else {
            root = athis.getNamespace();
            while (root.containsNamespace()) {
                root = root.getNamespace();
            }
            todo.add(root);
        }
        while (!todo.isEmpty()) {
            Namespace current = (Namespace)todo.get(0);
            Iterator iterator = current.iteratorOwnedElement();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj != athis && aclass.isAssignableFrom(obj.getClass())) {
                    referencables.add(obj);
                }
                if (!(obj instanceof Namespace)) continue;
                todo.add((Namespace)obj);
            }
            todo.remove(0);
        }
        return referencables;
    }

    private ModelElementUtility() {
    }

    public static Set getPeerElements(ModelElement athis, Class aclass) {
        Namespace root = athis.getNamespace();
        while (!(root instanceof UmlModel) && !(root instanceof ModelDef) && !(root instanceof TopicDef) && root.containsNamespace()) {
            root = root.getNamespace();
        }
        Set peers = ModelElementUtility.getChildElements(root, aclass);
        peers.remove(athis);
        return peers;
    }

    public static Set getChildElements(Namespace container, Class aclass) {
        HashSet children = new HashSet();
        ArrayList<Namespace> todo = new ArrayList<Namespace>();
        if (container == null) {
            return children;
        }
        todo.add(container);
        while (!todo.isEmpty()) {
            Namespace current = (Namespace)todo.get(0);
            Iterator iterator = current.iteratorOwnedElement();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if ((aclass == null || aclass.isAssignableFrom(obj.getClass())) && !(obj instanceof UmlPackage)) {
                    children.add(obj);
                }
                if (!(obj instanceof UmlPackage)) continue;
                todo.add((Namespace)obj);
            }
            todo.remove(0);
        }
        return children;
    }

    public static String getIliQualifiedName(ModelElement source, ModelElement ref, String language) {
        StringBuffer ret = new StringBuffer();
        Namespace parent = null;
        Namespace sourceScope = null;
        if (language == null) {
            language = NlsString.getDefaultLanguage();
        }
        if (ref instanceof ModelDef) {
            ret.append(ref.getName().getValue(language));
            return ret.toString();
        }
        if (source != null && source.containsNamespace()) {
            parent = source.getNamespace();
            while (parent.containsNamespace() && !(parent instanceof TopicDef) && !(parent instanceof ModelDef)) {
                parent = parent.getNamespace();
            }
            sourceScope = parent;
        }
        if (ref.containsNamespace()) {
            parent = ref.getNamespace();
            while (parent.containsNamespace() && !(parent instanceof TopicDef) && !(parent instanceof ModelDef)) {
                parent = parent.getNamespace();
            }
        }
        if (parent == null || !(parent instanceof TopicDef) && !(parent instanceof ModelDef)) {
            if (parent != null) {
                parent = ref.getNamespace();
                while (parent.containsNamespace()) {
                    ret.insert(0, parent.getName().getValue(language) + ".");
                    parent = parent.getNamespace();
                }
            }
            ret.append(ref.getName().getValue(language));
            throw new IllegalStateException(ret.toString() + " not inside a ModelDef/TopicDef");
        }
        TopicDef topic = null;
        if (parent instanceof TopicDef) {
            topic = (TopicDef)parent;
            if (topic == sourceScope) {
                ret.append(ref.getName().getValue(language));
                return ret.toString();
            }
            while (!(parent instanceof ModelDef)) {
                parent = parent.getNamespace();
            }
        } else if (parent == sourceScope) {
            ret.append(ref.getName().getValue(language));
            return ret.toString();
        }
        ret.append(parent.getName().getValue(language));
        ret.append(".");
        if (topic != null) {
            ret.append(topic.getName().getValue(language));
            ret.append(".");
        }
        ret.append(ref.getName().getValue(language));
        return ret.toString();
    }

    public static int compareDefinition(Class c1, Class c2) {
        int i2;
        int i1;
        if (ordering == null) {
            ordering = new ArrayList();
            ordering.add(MetaDataUseDef.class);
            ordering.add(UnitDef.class);
            ordering.add(FunctionDef.class);
            ordering.add(LineFormTypeDef.class);
            ordering.add(DomainDef.class);
            ordering.add(ContextDef.class);
            ordering.add(GraphicParameterDef.class);
            ordering.add(ClassDef.class);
            ordering.add(AssociationDef.class);
            ordering.add(ViewDef.class);
            ordering.add(UmlPackage.class);
            ordering.add(TopicDef.class);
            ordering.add(ModelDef.class);
            ordering.add(INTERLIS2Def.class);
        }
        if ((i1 = ordering.indexOf(c1)) < (i2 = ordering.indexOf(c2))) {
            return -1;
        }
        if (i2 < i1) {
            return 1;
        }
        return 0;
    }

    public static ModelDef getModel(ModelElement source) {
        ModelElement parent = source;
        if (source instanceof AttributeDef) {
            parent = ((AttributeDef)source).getOwner();
        }
        while (!(parent instanceof ModelDef)) {
            parent = parent.getNamespace();
        }
        return (ModelDef)parent;
    }

    public static RoleDef getOppEnd(RoleDef athis) {
        AssociationDef assoc = (AssociationDef)athis.getAssociation();
        Iterator rolei = assoc.iteratorConnection();
        while (rolei.hasNext()) {
            RoleDef obj = (RoleDef)rolei.next();
            if (obj == athis) continue;
            return obj;
        }
        return null;
    }
}

