/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.interlis.constraints;

import ch.ehi.basics.tools.AbstractVisitor;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.IliSyntax;
import ch.ehi.interlis.constraints.PlausibilityConstraint;
import ch.ehi.interlis.constraints.UniquenessConstraint;
import ch.ehi.uml1_4.changepropagation.MetaModel;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.foundation.datatypes.BooleanExpression;
import ch.ehi.uml1_4.implementation.AbstractEditorElement;
import java.io.Serializable;

public class ConstraintExpression
extends AbstractEditorElement
implements BooleanExpression,
IliSyntax,
Serializable {
    private PlausibilityConstraint plausibility;
    private UniquenessConstraint uniqueness;
    private NlsString syntax = null;
    private String language;
    private NlsString body = null;

    @Override
    public void unlinkAll() {
        this.detachPlausibility();
        this.detachUniqueness();
        this.setSyntax(null);
        this.setBody(null);
        super.unlinkAll();
    }

    @Override
    public void enumerateChildren(AbstractVisitor visitor) {
        Object it = null;
        if (this.containsPlausibility()) {
            visitor.visit((Object)this.getPlausibility());
        }
        if (this.containsUniqueness()) {
            visitor.visit((Object)this.getUniqueness());
        }
        visitor.visit((Object)this.getSyntax());
        visitor.visit((Object)this.getBody());
        super.enumerateChildren(visitor);
    }

    public void attachPlausibility(PlausibilityConstraint plausibility1) {
        if (this.plausibility != null) {
            throw new IllegalStateException("already a plausibility attached");
        }
        if (plausibility1 == null) {
            throw new IllegalArgumentException("null may not be attached as plausibility");
        }
        this.plausibility = plausibility1;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "attachPlausibility"));
    }

    public PlausibilityConstraint detachPlausibility() {
        PlausibilityConstraint ret = null;
        ret = this.plausibility;
        this.plausibility = null;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "detachPlausibility"));
        return ret;
    }

    public PlausibilityConstraint getPlausibility() {
        if (this.plausibility == null) {
            throw new IllegalStateException("no plausibility attached");
        }
        return this.plausibility;
    }

    public boolean containsPlausibility() {
        return this.plausibility != null;
    }

    public void attachUniqueness(UniquenessConstraint uniqueness1) {
        if (this.uniqueness != null) {
            throw new IllegalStateException("already a uniqueness attached");
        }
        if (uniqueness1 == null) {
            throw new IllegalArgumentException("null may not be attached as uniqueness");
        }
        this.uniqueness = uniqueness1;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "attachUniqueness"));
    }

    public UniquenessConstraint detachUniqueness() {
        UniquenessConstraint ret = null;
        ret = this.uniqueness;
        this.uniqueness = null;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "detachUniqueness"));
        return ret;
    }

    public UniquenessConstraint getUniqueness() {
        if (this.uniqueness == null) {
            throw new IllegalStateException("no uniqueness attached");
        }
        return this.uniqueness;
    }

    public boolean containsUniqueness() {
        return this.uniqueness != null;
    }

    @Override
    public NlsString getSyntax() {
        return this.syntax;
    }

    @Override
    public void setSyntax(NlsString value1) {
        if (!(this.syntax == value1 || this.syntax != null && this.syntax.equals((Object)value1))) {
            this.syntax = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setSyntax"));
        }
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String value1) {
        if (this.language != value1) {
            this.language = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setLanguage"));
        }
    }

    @Override
    public NlsString getBody() {
        return this.body;
    }

    @Override
    public void setBody(NlsString value1) {
        if (!(this.body == value1 || this.body != null && this.body.equals((Object)value1))) {
            this.body = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setBody"));
        }
    }
}

