/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.wkb;

import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.List;

public class RingCollector {
    private CompoundCurve shell = null;
    private List<CompoundCurve> rings = new ArrayList<CompoundCurve>();
    private List<CurveSegment> segs = new ArrayList<CurveSegment>();
    private List<Integer> starts = new ArrayList<Integer>();

    private void addSegment(CurveSegment seg) {
        int startSegOfRing = this.getSegIndexInLastPolyline(seg.getEndPoint());
        this.segs.add(seg);
        if (startSegOfRing >= 0) {
            CompoundCurve ring = new CompoundCurve(this.segs.subList(startSegOfRing, this.segs.size()), new JtsextGeometryFactory());
            this.rings.add(ring);
            this.segs = this.segs.subList(0, startSegOfRing);
            if (startSegOfRing == this.starts.get(this.starts.size() - 1)) {
                this.starts.remove(this.starts.size() - 1);
            }
        }
    }

    private int getSegIndexInLastPolyline(Coordinate endPoint) {
        for (int idx = this.starts.get(this.starts.size() - 1).intValue(); idx < this.segs.size(); ++idx) {
            if (!this.segs.get(idx).getStartPoint().equals((Object)endPoint)) continue;
            return idx;
        }
        return -1;
    }

    private void buildRings() {
        if (this.shell == null) {
            if (this.starts.size() == 1 && this.segs.size() > 1) {
                CompoundCurve ring = new CompoundCurve(this.segs, new JtsextGeometryFactory());
                this.rings.add(ring);
            } else if (this.starts.size() != 0 || this.segs.size() != 0) {
                throw new IllegalStateException("starts.size() " + this.starts.size() + ", segs.size() " + this.segs.size());
            }
            for (CompoundCurve ring : this.rings) {
                if (this.shell == null) {
                    this.shell = ring;
                    continue;
                }
                if (!ring.getEnvelopeInternal().contains(this.shell.getEnvelopeInternal())) continue;
                this.shell = ring;
            }
            this.rings.remove((Object)this.shell);
            this.rings.add(0, this.shell);
        }
    }

    public List<CompoundCurve> getRings() {
        this.buildRings();
        return this.rings;
    }

    public void addLine(CompoundCurve poly) {
        if (this.segs.size() == 0 || !this.segs.get(this.segs.size() - 1).getEndPoint().equals((Object)poly.getSegments().get(0).getStartPoint())) {
            this.starts.add(this.segs.size());
        }
        for (int idx = 0; idx < poly.getSegments().size(); ++idx) {
            CurveSegment seg = poly.getSegments().get(idx);
            this.addSegment(seg);
            if (this.starts.size() != 0 || idx + 1 >= poly.getSegments().size()) continue;
            this.starts.add(0);
        }
    }
}

