/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.noding;

import ch.ehi.iox.objpool.impl.CompoundCurveComparator;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class CompoundCurveDissolver {
    private Set<CompoundCurve> ocaMap = new TreeSet<CompoundCurve>(new CompoundCurveComparator());

    public void dissolve(Collection<? extends CompoundCurve> segStrings) {
        Iterator<? extends CompoundCurve> i = segStrings.iterator();
        while (i.hasNext()) {
            this.dissolve(i.next());
        }
    }

    public void dissolve(CompoundCurve segString) {
        if (segString.getStartPoint().getCoordinate().equals2D(segString.getEndPoint().getCoordinate())) {
            ArrayList<CurveSegment> segv = new ArrayList<CurveSegment>();
            for (CurveSegment seg : segString.getSegments()) {
                segv.add(seg);
            }
            ArrayList<CurveSegment> newsegv = CompoundCurveRing.normalizeRing(true, segv);
            segString = ((JtsextGeometryFactory)segString.getFactory()).createCompoundCurve(newsegv);
        } else if (segString.getStartPoint().compareTo((Object)segString.getEndPoint()) > 0) {
            segString = (CompoundCurve)segString.reverse();
        }
        if (!this.ocaMap.contains((Object)segString)) {
            this.ocaMap.add(segString);
        }
    }

    public Collection<CompoundCurve> getDissolved() {
        return this.ocaMap;
    }
}

