/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import java.beans.PropertyVetoException;
import java.util.List;

public class Function
extends AbstractLeafElement {
    private static final FormalArgument[] NO_ARGS = new FormalArgument[0];
    protected String name = null;
    protected Type domain = null;
    protected FormalArgument[] arguments = NO_ARGS;
    protected String explanation = null;

    @Override
    protected void linkTranslationOf(Element baseElement) {
        super.linkTranslationOf(baseElement);
        FormalArgument[] args = this.getArguments();
        FormalArgument[] baseArgs = ((Function)baseElement).getArguments();
        if (args.length == baseArgs.length) {
            for (int i = 0; i < args.length; ++i) {
                FormalArgument arg = args[i];
                FormalArgument baseArg = baseArgs[i];
                arg.linkTranslationOf(baseArg);
                Type type = arg.getType();
                Type baseType = baseArg.getType();
                if (!type.getClass().equals(baseType.getClass())) continue;
                type.linkTranslationOf(baseType);
            }
        }
        Type type = this.getDomain();
        Type baseType = ((Function)baseElement).getDomain();
        if (type.getClass().equals(baseType.getClass())) {
            type.linkTranslationOf(baseType);
        }
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        FormalArgument[] baseArgs;
        FormalArgument[] args;
        super.checkTranslationOf(errs, name, baseName);
        Function baseElement = (Function)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (!(this.getExplanation() == null && baseElement.getExplanation() == null || this.getExplanation() != null && baseElement.getExplanation() != null)) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_explanationMismatch", this.getName(), baseElement.getName())));
        }
        if ((args = this.getArguments()).length != (baseArgs = baseElement.getArguments()).length) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_functionArgumentCountMismatch", this.getName(), baseElement.getName())));
        }
        for (int i = 0; i < args.length; ++i) {
            FormalArgument arg = args[i];
            FormalArgument baseArg = baseArgs[i];
            Type type = arg.getType();
            Type baseType = baseArg.getType();
            if (type.getClass() != baseType.getClass()) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_functionArgumentTypeMismatch", this.getScopedName(), baseElement.getScopedName())));
                return;
            }
            if (type instanceof TypeAlias && ((TypeAlias)type).getAliasing().getTranslationOfOrSame() != ((TypeAlias)baseType).getAliasing().getTranslationOfOrSame()) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_functionArgumentTypeMismatch", this.getScopedName(), baseElement.getScopedName())));
                return;
            }
            try {
                type.checkTranslationOf(errs, this.getScopedName(), baseElement.getScopedName());
                continue;
            }
            catch (Ili2cSemanticException ex) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_functionArgumentTypeMismatch", this.getScopedName(), baseElement.getScopedName())));
            }
        }
        Type type = this.getDomain();
        Type baseType = baseElement.getDomain();
        if (type.getClass() != baseType.getClass()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_functionType", this.getScopedName(), baseElement.getScopedName())));
            return;
        }
        if (type instanceof TypeAlias && ((TypeAlias)type).getAliasing().getTranslationOfOrSame() != ((TypeAlias)baseType).getAliasing().getTranslationOfOrSame()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_functionType", this.getScopedName(), baseElement.getScopedName())));
            return;
        }
        try {
            type.checkTranslationOf(errs, this.getScopedName(), baseElement.getScopedName());
        }
        catch (Ili2cSemanticException ex) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Function.formatMessage("err_diff_functionType", this.getScopedName(), baseElement.getScopedName())));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Function.checkNameSanity(name, false);
        this.checkNameUniqueness(name, Function.class, null, "err_duplicateFunctionName");
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String toString() {
        return "FUNCTION " + this.getScopedName(null);
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) throws PropertyVetoException {
        String oldValue = this.explanation;
        String newValue = explanation;
        this.fireVetoableChange("explanation", oldValue, newValue);
        this.explanation = newValue;
        this.firePropertyChange("explanation", oldValue, newValue);
    }

    public FormalArgument[] getArguments() {
        return this.arguments;
    }

    public FormalArgument getArgument(String name) {
        for (int argi = 0; argi < this.arguments.length; ++argi) {
            if (!this.arguments[argi].getName().equals(name)) continue;
            return this.arguments[argi];
        }
        return null;
    }

    public void setArguments(FormalArgument[] arguments) throws PropertyVetoException {
        int i;
        FormalArgument[] oldValue = this.arguments;
        FormalArgument[] newValue = arguments;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("arguments", oldValue, newValue);
        this.arguments = newValue;
        if (newValue != null) {
            for (i = 0; i < newValue.length; ++i) {
                newValue[i].setFunction(this);
            }
        }
        if (oldValue != null) {
            for (i = 0; i < oldValue.length; ++i) {
                oldValue[i].setFunction(this);
            }
        }
        this.firePropertyChange("arguments", oldValue, newValue);
    }

    public Type getDomain() {
        return this.domain;
    }

    public void setDomain(Type domain) throws PropertyVetoException {
        Type oldValue = this.domain;
        Type newValue = domain;
        if (newValue == null) {
            throw new IllegalArgumentException("null is not acceptable as domain of a FUNCTION");
        }
        this.fireVetoableChange("domain", oldValue, newValue);
        this.domain = newValue;
        this.firePropertyChange("domain", oldValue, newValue);
    }
}

