/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.ms_mdb;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.generator.TextFileUtility;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbConstraint;
import ch.ehi.sqlgen.repository.DbEnumEle;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeneratorMdb
implements Generator {
    private BufferedWriter out = null;
    private TextFileUtility fmt = null;
    private boolean createSegments = false;
    private List segment;
    private int tablec;
    private String segName;
    private DbTable relTable = null;
    private DbTable enumTable = null;

    @Override
    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        this.fmt = new TextFileUtility();
        File sqlRoot = null;
        sqlRoot = new File(config.getValue("ch.ehi.sqlgen.sqlPath"));
        sqlRoot.mkdirs();
        File genSqlFile = new File(sqlRoot, schema.getName() + ".bas");
        this.out = new BufferedWriter(new FileWriter(genSqlFile));
        String header = config.getValue(config.getValue("ch.ehi.sqlgen.sqlHeader"));
        if (header != null) {
            FileInputStream template = new FileInputStream(header);
            GeneratorMdb.copyStream(this.out, template);
            ((InputStream)template).close();
        }
        this.out.write(this.fmt.newline());
        this.out.write(this.fmt.getIndent() + this.linecmt() + "requires Microsoft DAO 3.6 Object Library" + this.fmt.newline());
        this.out.write(this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "Option Explicit" + this.fmt.newline());
        this.out.write(this.fmt.newline());
        this.createSegments = schema.sizeTable() > 30;
    }

    @Override
    public void visitSchemaEnd(DbSchema schema) throws IOException {
        InputStream template = this.getClass().getResourceAsStream(ResourceBundle.class2packagePath(GeneratorMdb.class) + "/UtilsMSAccess.bas");
        GeneratorMdb.copyStream(this.out, template);
        template.close();
        this.out.close();
        this.out = null;
    }

    private static void copyStream(BufferedWriter out, InputStream in) throws IOException {
        int i;
        byte[] bt = new byte[1024];
        while ((i = in.read(bt)) != -1) {
            out.write(new String(bt, 0, i));
        }
    }

    private void startSegment() {
        this.segment = new ArrayList();
        this.tablec = 0;
        this.segName = null;
    }

    @Override
    public void visit1Begin() throws IOException {
        this.startSegment();
    }

    @Override
    public void visit1End() throws IOException {
        if (this.segment.size() > 0) {
            this.fmt.dec_ind();
            this.out.write(this.fmt.getIndent() + "End Sub" + this.fmt.newline());
        }
        this.out.write(this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "Sub dbCreateP1(database As database)" + this.fmt.newline());
        this.fmt.inc_ind();
        for (String line : this.segment) {
            this.out.write(this.fmt.getIndent() + line + this.fmt.newline());
        }
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "End Sub" + this.fmt.newline());
    }

    @Override
    public void visit2Begin() throws IOException {
        this.startSegment();
    }

    @Override
    public void visit2End() throws IOException {
        if (this.segment.size() > 0) {
            this.fmt.dec_ind();
            this.out.write(this.fmt.getIndent() + "End Sub" + this.fmt.newline());
        }
        this.out.write(this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "Sub dbCreateP2(database As database)" + this.fmt.newline());
        this.fmt.inc_ind();
        for (String line : this.segment) {
            this.out.write(this.fmt.getIndent() + line + this.fmt.newline());
        }
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "End Sub" + this.fmt.newline());
    }

    @Override
    public void visit1TableBegin(DbTable table) throws IOException {
        if (this.tablec == 0) {
            if (this.segment.size() > 0) {
                this.fmt.dec_ind();
                this.out.write(this.fmt.getIndent() + "End Sub" + this.fmt.newline());
            }
            this.segName = Integer.toString(this.segment.size());
            this.out.write(this.fmt.getIndent() + "Sub dbCreateP1_" + this.segName + "(database As database)" + this.fmt.newline());
            this.fmt.inc_ind();
            this.out.write(this.fmt.getIndent() + "Dim tableDef As TableDef" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim index As Index" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim field As Field" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim rskey As Recordset" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim createTable As Boolean" + this.fmt.newline());
            this.out.write(this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Set rskey = database.OpenRecordset(\"T_Key_Object\", dbOpenTable)" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "rskey.index = \"PrimaryKey\"" + this.fmt.newline());
            this.out.write(this.fmt.newline());
            String line = "dbCreateP1_" + this.segName + " database";
            this.segment.add(line);
        }
        this.out.write(this.fmt.newline());
        this.out.write(this.fmt.getIndent() + this.linecmt() + table.getIliName() + this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "createTable = not existsTable(database,\"" + table.getName() + "\")" + this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "if createTable then" + this.fmt.newline());
        this.fmt.inc_ind();
        this.out.write(this.fmt.getIndent() + "Set tableDef = database.CreateTableDef(\"" + table.getName() + "\")" + this.fmt.newline());
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "else" + this.fmt.newline());
        this.fmt.inc_ind();
        this.out.write(this.fmt.getIndent() + "Set tableDef = database.TableDefs(\"" + table.getName() + "\")" + this.fmt.newline());
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "end if" + this.fmt.newline());
        this.fmt.inc_ind();
    }

    @Override
    public void visit1TableEnd(DbTable table) throws IOException {
        if (table.isRequiresSequence()) {
            this.out.write(this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "addSequence rskey, tableDef.Name" + this.fmt.newline());
        }
        this.fmt.dec_ind();
        this.out.write(this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "if createTable then" + this.fmt.newline());
        this.fmt.inc_ind();
        this.out.write(this.fmt.getIndent() + "database.TableDefs.Append tableDef" + this.fmt.newline());
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "end if" + this.fmt.newline());
        ++this.tablec;
        if (this.tablec == 30) {
            this.tablec = 0;
        }
    }

    @Override
    public void visit2TableBegin(DbTable table) throws IOException {
        if (this.tablec == 0) {
            if (this.segment.size() > 0) {
                this.fmt.dec_ind();
                this.out.write(this.fmt.getIndent() + "End Sub" + this.fmt.newline());
            }
            this.segName = Integer.toString(this.segment.size());
            this.out.write(this.fmt.getIndent() + "Sub dbCreateP2_" + this.segName + "(database As database)" + this.fmt.newline());
            this.fmt.inc_ind();
            this.out.write(this.fmt.getIndent() + "Dim tableDef As TableDef" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim index As Index" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim field As Field" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim relation As Relation" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim rsnls As Recordset" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim rsTrsl As Recordset" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim rsenum As Recordset" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Dim rskey As Recordset" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Set rskey = database.OpenRecordset(\"T_Key_Object\")" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "rskey.index = \"PrimaryKey\"" + this.fmt.newline());
            this.out.write(this.fmt.newline());
            String line = "dbCreateP2_" + this.segName + " database";
            this.segment.add(line);
        }
        this.out.write(this.fmt.newline());
        this.out.write(this.fmt.getIndent() + this.linecmt() + table.getIliName() + this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "Set tableDef = database.TableDefs(\"" + table.getName() + "\")" + this.fmt.newline());
        this.fmt.inc_ind();
    }

    @Override
    public void visit2TableEnd(DbTable table) throws IOException {
        this.fmt.dec_ind();
        ++this.tablec;
        if (this.tablec == 30) {
            this.tablec = 0;
        }
    }

    @Override
    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String type = "";
        String size = "";
        String notSupported = null;
        if (column instanceof DbColBoolean) {
            type = "dbBoolean";
            size = "";
        } else if (column instanceof DbColDateTime) {
            type = "dbDate";
            size = "";
        } else if (column instanceof DbColDecimal) {
            type = "dbDouble";
            size = "";
        } else if (column instanceof DbColGeometry) {
            type = "dbBinary";
            size = "";
        } else if (column instanceof DbColId) {
            type = "dbLong";
            size = "";
        } else if (column instanceof DbColUuid) {
            type = "dbText";
            size = ", 36";
        } else if (column instanceof DbColNumber) {
            type = "dbLong";
            size = "";
        } else if (column instanceof DbColVarchar) {
            int colsize = ((DbColVarchar)column).getSize();
            type = colsize > 254 ? "dbMemo" : "dbText";
            size = ", " + Integer.toString(colsize);
        } else {
            type = "dbText";
            size = ", 20";
            notSupported = "NOTSUPPORTED: " + column.getClass().getName();
        }
        this.out.write(this.fmt.newline());
        String scriptCmt = column.getScriptComment();
        if (scriptCmt != null) {
            this.out.write(this.fmt.getIndent() + this.linecmt() + scriptCmt + this.fmt.newline());
        }
        this.out.write(this.fmt.getIndent() + "if not existsField(tableDef,\"" + column.getName() + "\") then" + this.fmt.newline());
        this.fmt.inc_ind();
        if (notSupported != null) {
            this.out.write(this.fmt.getIndent() + this.linecmt() + notSupported + this.fmt.newline());
        }
        this.out.write(this.fmt.getIndent() + "Set field = tableDef.CreateField(\"" + column.getName() + "\", " + type + size + ")" + this.fmt.newline());
        if (column.isNotNull()) {
            this.out.write(this.fmt.getIndent() + "field.Required = True" + this.fmt.newline());
        }
        this.out.write(this.fmt.getIndent() + "tableDef.Fields.Append field" + this.fmt.newline());
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "end if" + this.fmt.newline());
        if (column instanceof DbColId && ((DbColId)column).isPrimaryKey()) {
            this.out.write(this.fmt.getIndent() + "if not existsindex(tableDef,\"PrimaryKey\") then" + this.fmt.newline());
            this.fmt.inc_ind();
            this.out.write(this.fmt.getIndent() + "Set index = tableDef.CreateIndex(\"PrimaryKey\")" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Set field = index.CreateField(\"" + column.getName() + "\")" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "index.Fields.Append field" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "index.Primary = True" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "tableDef.Indexes.Append index" + this.fmt.newline());
            this.fmt.dec_ind();
            this.out.write(this.fmt.getIndent() + "end if" + this.fmt.newline());
        }
    }

    @Override
    public void visitTableBeginColumn(DbTable table) throws IOException {
    }

    @Override
    public void visitTableEndColumn(DbTable table) throws IOException {
    }

    @Override
    public void visitIndex(DbIndex idx) throws IOException {
        this.out.write(this.fmt.getIndent() + "if not existsindex(tableDef,\"" + idx.getName() + "\") then" + this.fmt.newline());
        this.fmt.inc_ind();
        this.out.write(this.fmt.getIndent() + "Set index = tableDef.CreateIndex(\"" + idx.getName() + "\")" + this.fmt.newline());
        Iterator attri = idx.iteratorAttr();
        while (attri.hasNext()) {
            DbColumn attr = (DbColumn)attri.next();
            this.out.write(this.fmt.getIndent() + "Set field = index.CreateField(\"" + attr.getName() + "\")" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "index.Fields.Append field" + this.fmt.newline());
        }
        if (idx.isPrimary()) {
            this.out.write(this.fmt.getIndent() + "index.Primary = True" + this.fmt.newline());
        } else if (idx.isUnique()) {
            this.out.write(this.fmt.getIndent() + "index.Unique = True" + this.fmt.newline());
        }
        this.out.write(this.fmt.getIndent() + "tableDef.Indexes.Append index" + this.fmt.newline());
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "end if" + this.fmt.newline());
    }

    @Override
    public void visitTableBeginIndex(DbTable table) throws IOException {
    }

    @Override
    public void visitTableEndIndex(DbTable table) throws IOException {
    }

    @Override
    public void visitConstraint(DbConstraint cnstr) throws IOException {
        this.out.write(this.fmt.getIndent() + "if not existsrelation(database,\"" + cnstr.getName() + "\") then" + this.fmt.newline());
        this.fmt.inc_ind();
        this.out.write(this.fmt.getIndent() + "Set relation = database.CreateRelation(\"" + cnstr.getName() + "\", \"" + this.relTable.getName() + "\", \"" + cnstr.getFkTable() + "\")" + this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "Set field = relation.CreateField(\"" + cnstr.getPkAttr() + "\")" + this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "field.ForeignName = \"" + cnstr.getFkAttr() + "\"" + this.fmt.newline());
        this.out.write(this.fmt.getIndent() + "relation.Fields.Append field" + this.fmt.newline());
        if (cnstr.getAction() == DbConstraint.DELETE_CASCADE) {
            this.out.write(this.fmt.getIndent() + "relation.Attributes = dbRelationDontEnforce" + this.fmt.newline());
        } else if (cnstr.getAction() == DbConstraint.DELETE_PREVENT) {
            this.out.write(this.fmt.getIndent() + "relation.Attributes = dbRelationDontEnforce" + this.fmt.newline());
        } else if (cnstr.getAction() == DbConstraint.DELETE_SET_NULL) {
            this.out.write(this.fmt.getIndent() + "relation.Attributes = dbRelationDontEnforce" + this.fmt.newline());
        } else if (cnstr.getAction() == DbConstraint.DONT_ENFORCE) {
            this.out.write(this.fmt.getIndent() + "relation.Attributes = dbRelationDontEnforce" + this.fmt.newline());
        }
        this.out.write(this.fmt.getIndent() + "database.Relations.Append relation" + this.fmt.newline());
        this.fmt.dec_ind();
        this.out.write(this.fmt.getIndent() + "end if" + this.fmt.newline());
    }

    @Override
    public void visitTableBeginConstraint(DbTable table) throws IOException {
        this.relTable = table;
    }

    @Override
    public void visitTableEndConstraint(DbTable table) throws IOException {
        this.relTable = null;
    }

    @Override
    public void visitEnumEle(DbEnumEle ele) throws IOException {
        String eleName = ele.getIliCode();
        this.out.write(this.fmt.getIndent() + "dbAddEnumEle rskey, rsenum, rsnls, rstrsl, \"de\", \"" + eleName + "\", \"" + eleName + "\", " + ele.getSequence() + this.fmt.newline());
    }

    @Override
    public void visitTableBeginEnumEle(DbTable table) throws IOException {
        if (table.sizeEnumEle() > 0) {
            this.enumTable = table;
            this.out.write(this.fmt.getIndent() + "Set rsnls = database.OpenRecordset(\"T_NLS\", dbOpenTable)" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Set rsTrsl = database.OpenRecordset(\"T_Translation\", dbOpenTable)" + this.fmt.newline());
            this.out.write(this.fmt.getIndent() + "Set rsenum = database.OpenRecordset(\"" + table.getName() + "\", dbOpenTable)" + this.fmt.newline());
        }
    }

    @Override
    public void visitTableEndEnumEle(DbTable table) throws IOException {
        this.enumTable = null;
    }

    private String linecmt() {
        return "' ";
    }
}

