/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.iox.ilisite.ILIREPOSITORY09;
import ch.interlis.ili2c.Ili2cSettings;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.models.ILIREPOSITORY20;
import ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

@Deprecated
public class MakeIliModelsXml2 {
    public static final String DEFAULT_ILIDIRS = "http://models.interlis.ch/;%JAR_DIR";
    public static final String APP_NAME = "mkilimodelsxml";
    private String version = null;
    private String ilidirs = "http://models.interlis.ch/;%JAR_DIR";
    private long newtid = 0L;

    public static void main(String[] args) {
        new MakeIliModelsXml2().mymain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mymain(String[] args) {
        String httpProxyHost = null;
        String httpProxyPort = null;
        try {
            int argi;
            String outFile = null;
            for (argi = 0; argi < args.length; ++argi) {
                String arg = args[argi];
                if (args[argi].equals("--proxy")) {
                    httpProxyHost = args[++argi];
                    continue;
                }
                if (args[argi].equals("--proxyPort")) {
                    httpProxyPort = args[++argi];
                    continue;
                }
                if (args[argi].equals("--ilidirs")) {
                    this.ilidirs = args[++argi];
                    continue;
                }
                if (arg.equals("--trace")) {
                    EhiLogger.getInstance().setTraceFilter(false);
                    continue;
                }
                if (arg.equals("--quiet")) {
                    StdListener.getInstance().skipInfo(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    this.printVersion();
                    return;
                }
                if (arg.equals("--o")) {
                    outFile = args[++argi];
                    continue;
                }
                if (arg.equals("--help")) {
                    this.printHelp();
                    return;
                }
                if (!arg.startsWith("-")) break;
                EhiLogger.logAdaption((String)(arg + ": unknown option; ignored"));
            }
            if (argi == args.length) {
                this.printHelp();
                return;
            }
            if (argi + 1 != args.length) {
                this.printHelp();
                return;
            }
            String repositoryRoot = args[argi];
            if (outFile == null) {
                outFile = repositoryRoot + File.separator + "ilimodels.xml";
            }
            HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>> oldfiles = null;
            File out = new File(outFile);
            if (out.exists()) {
                oldfiles = this.readIliModelsXml(out);
            }
            if (oldfiles == null) {
                oldfiles = new HashMap();
            }
            ArrayList<ch.interlis.ilirepository.impl.ModelMetadata> models = new ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>(MakeIliModelsXml2.scanIliFileDir(new File(repositoryRoot)));
            HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>> newfiles = this.createFilelist(models);
            HashSet<ch.interlis.ilirepository.impl.ModelMetadata> newModels = new HashSet<ch.interlis.ilirepository.impl.ModelMetadata>();
            ArrayList<ch.interlis.ilirepository.impl.ModelMetadata> updatedModels = new ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>();
            for (ch.interlis.ilirepository.impl.ModelMetadata model : models) {
                ch.interlis.ilirepository.impl.ModelMetadata theOldModel = null;
                if (oldfiles.containsKey(model.getFile())) {
                    ArrayList<ch.interlis.ilirepository.impl.ModelMetadata> oldmodels = oldfiles.get(model.getFile());
                    for (ch.interlis.ilirepository.impl.ModelMetadata modelMetadata : oldmodels) {
                        if (!modelMetadata.getName().equals(model.getName())) continue;
                        theOldModel = modelMetadata;
                        break;
                    }
                    if (theOldModel != null) {
                        String[] deps;
                        theOldModel.setMd5(model.getMd5());
                        theOldModel.setDependsOnModel(null);
                        for (String dep : deps = model.getDependsOnModel()) {
                            theOldModel.addDependsOnModel(dep);
                        }
                        model = theOldModel;
                    } else {
                        newModels.add(model);
                        model.setOid(Long.toString(this.newtid));
                        ++this.newtid;
                    }
                } else {
                    newModels.add(model);
                    model.setOid(Long.toString(this.newtid));
                    ++this.newtid;
                }
                updatedModels.add(model);
            }
            models = updatedModels;
            HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>> files = this.createFilelist(newModels);
            for (String theNewFile : files.keySet()) {
                IliFiles tempIliFiles = RepositoryAccess.createIliFiles2(repositoryRoot, newModels);
                Ili2cSettings settings = new Ili2cSettings();
                settings.setHttpProxyHost(httpProxyHost);
                settings.setHttpProxyPort(httpProxyPort);
                settings.setIlidirs(repositoryRoot + ";" + this.ilidirs);
                settings.setTransientObject("ch.interlis.ili2c.tempReposIliFiles", (Object)tempIliFiles);
                settings.setTransientObject("ch.interlis.ili2c.tempReposUri", (Object)repositoryRoot);
                Configuration config = new Configuration();
                FileEntry fileEntry = new FileEntry(new File(repositoryRoot, theNewFile).getAbsolutePath(), 1);
                config.addFileEntry(fileEntry);
                config.setAutoCompleteModelList(true);
                config.setGenerateWarnings(false);
                config.setOutputKind(1);
                TransferDescription td = Main.runCompiler(config, (Settings)settings);
                if (td == null) continue;
                ArrayList<ch.interlis.ilirepository.impl.ModelMetadata> modelv = files.get(theNewFile);
                for (ch.interlis.ilirepository.impl.ModelMetadata model : modelv) {
                    String lang;
                    String original;
                    String furtherMetadata;
                    String furtherInfo;
                    String precursorVersion;
                    String technicalContact;
                    Model modelDef = (Model)td.getElement(Model.class, model.getName());
                    if (modelDef == null) continue;
                    String title = modelDef.getDocumentation();
                    if (title != null) {
                        int titleEnd = title.indexOf(46);
                        if (titleEnd > 0) {
                            String doc = StringUtility.purge((String)title.substring(titleEnd + 1));
                            title = StringUtility.purge((String)title.substring(0, titleEnd + 1));
                            if (doc != null) {
                                model.setShortDescription(doc);
                            }
                            if (title != null) {
                                model.setTitle(title);
                            }
                        } else {
                            model.setTitle(title);
                        }
                    }
                    if ((technicalContact = modelDef.getMetaValue("technicalContact")) != null) {
                        model.setTechnicalContact(technicalContact);
                    }
                    if ((precursorVersion = modelDef.getMetaValue("precursorVersion")) != null) {
                        model.setPrecursorVersion(precursorVersion);
                    }
                    if ((furtherInfo = modelDef.getMetaValue("furtherInformation")) != null) {
                        model.setFurtherInformation(furtherInfo);
                    }
                    if ((furtherMetadata = modelDef.getMetaValue("furtherMetadata")) != null) {
                        model.setFurtherMetadata(furtherMetadata);
                    }
                    String idGeoIV = modelDef.getMetaValue("IDGeoIV");
                    String tags = modelDef.getMetaValue("tags");
                    if (tags == null) {
                        tags = idGeoIV;
                    } else if (idGeoIV != null) {
                        tags = tags + "," + idGeoIV;
                    }
                    if (tags != null) {
                        model.setTags(tags);
                    }
                    if ((original = modelDef.getMetaValue("Original")) != null) {
                        model.setOriginal(original);
                    }
                    if (model.getSchemaLanguage().equals("ili2_3") || model.getSchemaLanguage().equals("ili2_4")) {
                        String issuer = modelDef.getIssuer();
                        model.setIssuer(issuer);
                        String version = modelDef.getModelVersion();
                        model.setVersion(version);
                        String versionExpl = modelDef.getModelVersionExpl();
                        if (versionExpl != null) {
                            model.setVersionComment(versionExpl);
                        }
                    }
                    if ((lang = modelDef.getLanguage()) == null) continue;
                    model.setNameLanguage(lang);
                }
            }
            FileOutputStream outStream = null;
            XtfWriterBase ioxWriter = null;
            try {
                outStream = new FileOutputStream(outFile);
                ioxWriter = new XtfWriterBase((OutputStream)outStream, ILIREPOSITORY20.getIoxMapping(), "2.3");
                ioxWriter.setModels(new XtfModel[]{ILIREPOSITORY20.getXtfModel()});
                StartTransferEvent startTransferEvent = new StartTransferEvent();
                startTransferEvent.setSender("mkilimodelsxml-" + this.getVersion());
                ioxWriter.write((IoxEvent)startTransferEvent);
                StartBasketEvent startBasketEvent = new StartBasketEvent("IliRepository20.RepositoryIndex", "b1");
                ioxWriter.write((IoxEvent)startBasketEvent);
                for (ch.interlis.ilirepository.impl.ModelMetadata model : models) {
                    ioxWriter.write((IoxEvent)new ch.interlis.iox_j.ObjectEvent((IomObject)RepositoryAccess.mapToIom20(model)));
                }
                ioxWriter.write((IoxEvent)new EndBasketEvent());
                ioxWriter.write((IoxEvent)new ch.interlis.iox_j.EndTransferEvent());
                ioxWriter.flush();
            }
            catch (FileNotFoundException ex) {
                EhiLogger.logError((Throwable)ex);
                System.exit(1);
            }
            finally {
                if (ioxWriter != null) {
                    ioxWriter.close();
                    ioxWriter = null;
                }
                if (outStream != null) {
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (IOException ex) {
                        EhiLogger.logError((Throwable)ex);
                    }
                    outStream = null;
                }
            }
        }
        catch (Exception ex) {
            EhiLogger.logError((String)"mkilimodelsxml: failed", (Throwable)ex);
            System.exit(1);
        }
    }

    public static HashSet<ch.interlis.ilirepository.impl.ModelMetadata> scanIliFileDir(File startdir) throws IOException {
        int oid = 1;
        if (!startdir.isDirectory()) {
            throw new IllegalArgumentException(startdir + " is not a folder/directory");
        }
        URI starturi = startdir.toURI();
        HashSet<ch.interlis.ilirepository.impl.ModelMetadata> ret = new HashSet<ch.interlis.ilirepository.impl.ModelMetadata>();
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(startdir);
        GenericFileFilter filter = new GenericFileFilter("INTERLIS models (*.ili)", "ili");
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.remove(0);
            File[] filev = dir.listFiles();
            for (int i = 0; i < filev.length; ++i) {
                IliFile iliFile;
                if (filev[i].isDirectory()) {
                    dirs.add(filev[i]);
                    continue;
                }
                if (!filter.accept(filev[i]) || (iliFile = ModelScan.scanIliFile(filev[i])) == null) continue;
                URI relPath = starturi.relativize(filev[i].toURI());
                String md5 = RepositoryAccess.calcMD5(filev[i]);
                String fileVersion = MakeIliModelsXml2.getFileVersion(filev[i]);
                Iterator modeli = iliFile.iteratorModel();
                while (modeli.hasNext()) {
                    IliModel iliModel = (IliModel)modeli.next();
                    ch.interlis.ilirepository.impl.ModelMetadata model = new ch.interlis.ilirepository.impl.ModelMetadata();
                    model.setOid(Integer.toString(oid++));
                    model.setFile(relPath.toString());
                    model.setName(iliModel.getName());
                    double cslVersion = iliModel.getIliVersion();
                    if (cslVersion == 1.0) {
                        model.setSchemaLanguage("ili1");
                    } else if (cslVersion == 2.2) {
                        model.setSchemaLanguage("ili2_2");
                    } else if (cslVersion == 2.3) {
                        model.setSchemaLanguage("ili2_3");
                    } else if (cslVersion == 2.4) {
                        model.setSchemaLanguage("ili2_4");
                    } else {
                        throw new IllegalStateException("unexpected ili version");
                    }
                    model.setPublishingDate(fileVersion);
                    model.setVersion(fileVersion);
                    model.setMd5(md5);
                    for (String depModelName : iliModel.getDependencies()) {
                        model.addDependsOnModel(depModelName);
                    }
                    ret.add(model);
                }
            }
        }
        return ret;
    }

    private static String getFileVersion(File file) {
        String fileVersion = new SimpleDateFormat("yyyy-MM-dd").format(new Date(file.lastModified()));
        String fileName = GenericFileFilter.stripFileExtension((String)file.getName());
        if (fileName.length() >= 10) {
            String dateString = fileName.substring(fileName.length() - 10);
            Date date = null;
            date = new SimpleDateFormat("yyyy-MM-dd").parse(dateString, new ParsePosition(0));
            if (date == null) {
                date = new SimpleDateFormat("yyyyMMdd").parse(dateString, new ParsePosition(2));
            }
            if (date != null) {
                fileVersion = new SimpleDateFormat("yyyy-MM-dd").format(date);
            }
        }
        return fileVersion;
    }

    private void printHelp() {
        this.printVersion();
        System.err.println();
        this.printDescription();
        System.err.println();
        this.printUsage();
        System.err.println();
        System.err.println("OPTIONS");
        System.err.println();
        System.err.println("--o filename           name of outputfile.");
        System.err.println("--trace                enable trace messages.");
        System.err.println("--quiet               Suppress info messages.");
        System.err.println("--ilidirs " + this.ilidirs + " list of directories with ili-files.");
        System.err.println("--proxy host          proxy server to access model repositories.");
        System.err.println("--proxyPort port      proxy port to access model repositories.");
        System.err.println("--help                 Display this help text.");
        System.err.println("--version              Display the version of mkilimodelsxml");
        System.err.println();
    }

    protected void printVersion() {
        System.err.println("mkilimodelsxml, Version " + this.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3401 Burgdorf");
    }

    protected void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Reads INTERLIS models and generates a suitable ilimodels.xml file (according to IliRepository09.");
    }

    protected void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -cp ili2c.jar " + MakeIliModelsXml2.class.getName() + " [Options] folder-with-ili-files");
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = TransferDescription.getVersion();
        }
        return this.version;
    }

    private HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>> readIliModelsXml(File file) {
        if (file == null) {
            return null;
        }
        ArrayList<ch.interlis.ilirepository.impl.ModelMetadata> models = new ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>();
        XtfReader reader = null;
        try {
            reader = new XtfReader(file);
            reader.getFactory().registerFactory(ILIREPOSITORY09.getIoxFactory());
            reader.getFactory().registerFactory(ILIREPOSITORY20.getIoxFactory());
            IoxEvent event = null;
            do {
                if (!((event = reader.read()) instanceof ObjectEvent)) continue;
                IomObject iomObj = ((ObjectEvent)event).getIomObject();
                ch.interlis.ilirepository.impl.ModelMetadata model = null;
                if (iomObj instanceof ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata) {
                    model = RepositoryAccess.mapFromIom09((ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata)iomObj);
                } else if (iomObj instanceof ModelMetadata) {
                    model = RepositoryAccess.mapFromIom20((ModelMetadata)iomObj);
                }
                if (model == null) continue;
                models.add(model);
                try {
                    long tidInt = Long.parseLong(model.getOid());
                    if (tidInt <= this.newtid) continue;
                    this.newtid = tidInt;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            } while (!(event instanceof EndTransferEvent));
        }
        catch (IoxException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.newtid = (this.newtid / 10L + 1L) * 10L;
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    throw new IllegalStateException(e);
                }
                reader = null;
            }
        }
        HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>> files = this.createFilelist(models);
        return files;
    }

    private HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>> createFilelist(Collection<ch.interlis.ilirepository.impl.ModelMetadata> models) {
        HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>> files = new HashMap<String, ArrayList<ch.interlis.ilirepository.impl.ModelMetadata>>();
        for (ch.interlis.ilirepository.impl.ModelMetadata model : models) {
            String filename = model.getFile();
            ArrayList<Object> modelv = null;
            if (!files.containsKey(filename)) {
                modelv = new ArrayList();
                files.put(filename, modelv);
            } else {
                modelv = files.get(filename);
            }
            modelv.add(model);
        }
        return files;
    }
}

