/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.iom2java;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;

public class Iom2JavaTool {
    private static final String INDENTATION = "    ";
    private String bid = null;
    private HashMap<String, Integer> assuranceOfUniqueObjNames = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xtf2java(File xtfFile) throws IoxException {
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(xtfFile);
        }
        catch (FileNotFoundException e) {
            throw new IoxException("file: '" + xtfFile.getAbsolutePath() + "' not found", (Throwable)e);
        }
        XtfReader reader = null;
        try {
            reader = new XtfReader(inputFile);
        }
        catch (IoxException e) {
            throw new IoxException("failed to create XtfReader", (Throwable)e);
        }
        System.out.println("@Test");
        String[] fileParts = xtfFile.getName().split(".xtf");
        System.out.println("public void " + fileParts[0] + "() {");
        try {
            IoxEvent event = null;
            do {
                event = reader.read();
                this.writeEventAsJava(event);
            } while (!(event instanceof EndTransferEvent));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    EhiLogger.logError((Throwable)e);
                }
                reader = null;
            }
        }
        System.out.println("}");
    }

    private void writeEventAsJava(IoxEvent event) throws IoxException {
        if (event instanceof StartTransferEvent) {
            System.out.println("    ArrayList<IoxEvent> events=new ArrayList<IoxEvent>();");
            System.out.println("    StartTransferEvent startTransferEvent=new StartTransferEvent();");
            System.out.println("    events.add(startTransferEvent);");
        } else if (event instanceof StartBasketEvent) {
            StartBasketEvent startBasketEvent = (StartBasketEvent)event;
            this.bid = startBasketEvent.getBid();
            String bidNoSpecialChar = this.bid.replace(".", "_");
            System.out.println("    {");
            System.out.println("        // basket_" + this.bid);
            System.out.println("        StartBasketEvent startBasketEvent_" + bidNoSpecialChar + "=new StartBasketEvent(\"" + startBasketEvent.getType() + "\",\"" + this.bid + "\");");
            System.out.println("        events.add(startBasketEvent_" + bidNoSpecialChar + ");");
        } else if (event instanceof ObjectEvent) {
            IomObject iomObj = ((ObjectEvent)event).getIomObject();
            String oid = iomObj.getobjectoid();
            String oidNoSpecialChar = null;
            if (oid != null) {
                oidNoSpecialChar = oid.replace(".", "_");
            }
            System.out.println("        {");
            System.out.println("            // object_" + oid);
            System.out.println("            Iom_jObject object_" + oidNoSpecialChar + "=new Iom_jObject(\"" + iomObj.getobjecttag() + "\",\"" + oid + "\");");
            this.writeData(iomObj, "object_" + oidNoSpecialChar);
            System.out.println("            ObjectEvent objEvent_" + oidNoSpecialChar + "=new ObjectEvent(object_" + oidNoSpecialChar + ");");
            System.out.println("            events.add(objEvent_" + oidNoSpecialChar + ");");
            System.out.println("        }");
            this.assuranceOfUniqueObjNames.clear();
        } else if (event instanceof EndBasketEvent) {
            String bidNoSpecialChar = this.bid.replace(".", "_");
            System.out.println("        EndBasketEvent endBasketEvent_" + bidNoSpecialChar + "=new EndBasketEvent();");
            System.out.println("        events.add(endBasketEvent_" + bidNoSpecialChar + ");");
            System.out.println("    }");
        } else if (event instanceof EndTransferEvent) {
            System.out.println("    EndTransferEvent endTransferEvent=new EndTransferEvent();");
            System.out.println("    events.add(endTransferEvent);");
        }
    }

    private void writeData(IomObject obj, String objName) {
        int attrc = obj.getattrcount();
        Object[] propNames = new String[attrc];
        for (int j = 0; j < attrc; ++j) {
            propNames[j] = obj.getattrname(j);
        }
        Arrays.sort(propNames);
        for (int i = 0; i < attrc; ++i) {
            Object propName = propNames[i];
            int propc = obj.getattrvaluecount((String)propName);
            if (propc <= 0) continue;
            for (int propi = 0; propi < propc; ++propi) {
                String value = obj.getattrprim((String)propName, propi);
                if (value != null) {
                    System.out.println("            " + objName + ".setattrvalue(\"" + (String)propName + "\", \"" + value + "\");");
                    continue;
                }
                IomObject structvalue = obj.getattrobj((String)propName, propi);
                String subObjName = "object_" + (String)propName;
                if (this.assuranceOfUniqueObjNames.containsKey(subObjName)) {
                    int oldCount = this.assuranceOfUniqueObjNames.get(subObjName);
                    int newCount = ++oldCount;
                    this.assuranceOfUniqueObjNames.put(subObjName, newCount);
                    subObjName = subObjName + newCount;
                } else {
                    this.assuranceOfUniqueObjNames.put(subObjName, 1);
                }
                System.out.println("            IomObject " + subObjName + "=" + objName + ".addattrobj(\"" + (String)propName + "\", \"" + structvalue.getobjecttag() + "\");");
                this.writeData(structvalue, subObjName);
            }
        }
    }
}

