/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public final class XSDGenerator {
    IndentPrintWriter ipw;
    TransferDescription td;
    int numErrors = 0;
    private Settings settings = null;
    public static final String SETTING_FULL_XTF_CAPABILITIES = "ch.interlis.ili2c.generator.XSDGenerator.fullCapabilities";
    static ResourceBundle rsrc = ResourceBundle.getBundle(Interlis1Generator.class.getName(), Locale.getDefault());
    private boolean refConsistencyType = false;
    private boolean refIncrementalTypes = false;
    private boolean refCoordValue = false;
    private boolean refArcPoint = false;
    private boolean refOidSpaces = false;
    private HashSet referencedTypes = new HashSet();

    private XSDGenerator(Writer out, TransferDescription td, Settings settings) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
        this.settings = settings;
    }

    private void finish() {
        this.ipw.close();
    }

    public static int generate(Writer out, TransferDescription td) {
        XSDGenerator d = new XSDGenerator(out, td, new Settings());
        d.printXSD(td);
        d.finish();
        return d.numErrors;
    }

    public static int generate(Writer out, TransferDescription td, Settings settings) {
        XSDGenerator d = new XSDGenerator(out, td, settings);
        d.printXSD(td);
        d.finish();
        return d.numErrors;
    }

    public static String getTransferName(Element elt) {
        if (elt instanceof Model) {
            return elt.getName();
        }
        if (elt instanceof Topic) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Viewable) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Domain) {
            return elt.getScopedName(null);
        }
        if (elt instanceof AttributeDef) {
            return elt.getName();
        }
        if (elt instanceof RoleDef) {
            return elt.getName();
        }
        throw new IllegalArgumentException();
    }

    private void printXSD(TransferDescription td) {
        Topic topic;
        Object tObj;
        Iterator topici;
        Model model;
        boolean addAllInterlisTypes = false;
        boolean addAliasTable = false;
        Model lastModel = td.getLastModel();
        if (lastModel != null) {
            addAllInterlisTypes = this.getMetaValueBoolean(lastModel, "ili2c.ili23xsd.addAllInterlisTypesDefault", false);
            addAliasTable = this.getMetaValueBoolean(lastModel, "ili2c.ili23xsd.addAliasTableDefault", false);
        }
        this.ipw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.ipw.println("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://www.interlis.ch/INTERLIS2.3\" xmlns:ili2c=\"http://www.interlis.ch/ili2c\" targetNamespace=\"http://www.interlis.ch/INTERLIS2.3\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">");
        this.ipw.indent();
        this.ipw.println("<xsd:annotation>");
        this.ipw.indent();
        this.ipw.print("<xsd:appinfo source=\"http://www.interlis.ch/ili2c/ili2cversion\">");
        this.ipw.print(TransferDescription.getVersion());
        this.ipw.println("</xsd:appinfo>");
        for (Object modelo : this.sortMetamodelElements(td.iterator())) {
            if (!(modelo instanceof Model) || (model = (Model)modelo) == td.INTERLIS) continue;
            this.ipw.println("<xsd:appinfo source=\"http://www.interlis.ch/ili2c\">");
            this.ipw.indent();
            this.ipw.println("<ili2c:model>" + model.getName() + "</ili2c:model>");
            this.ipw.println("<ili2c:modelVersion>" + model.getModelVersion() + "</ili2c:modelVersion>");
            if (model.getModelVersionExpl() != null) {
                this.ipw.println("<ili2c:modelVersionExplanation>" + model.getModelVersionExpl() + "</ili2c:modelVersionExplanation>");
            }
            this.ipw.println("<ili2c:modelAt>" + model.getIssuer() + "</ili2c:modelAt>");
            String textMinimalCharset = model.getMetaValue("ili2c.textMinimalCharset");
            if (textMinimalCharset != null) {
                this.ipw.println("<ili2c:textMinimalCharset>" + textMinimalCharset + "</ili2c:textMinimalCharset>");
            } else {
                this.ipw.println("<ili2c:textMinimalCharset>ili23AnnexB</ili2c:textMinimalCharset>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:appinfo>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:annotation>");
        this.ipw.println("<xsd:element name=\"TRANSFER\" type=\"Transfer\"/>");
        this.ipw.println("<xsd:simpleType name=\"IliID\">");
        this.ipw.indent();
        this.ipw.println("<xsd:restriction base=\"xsd:string\">");
        this.ipw.indent();
        this.ipw.println("<xsd:pattern value=\"([a-zA-Z_][0-9a-zA-Z_\\-\\.]*:)?[0-9a-zA-Z_][0-9a-zA-Z_\\-\\.]*\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:restriction>");
        this.ipw.unindent();
        this.ipw.println("</xsd:simpleType>");
        this.ipw.println("<xsd:complexType name=\"Transfer\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"HEADERSECTION\" type=\"HeaderSection\"/>");
        this.ipw.println("<xsd:element name=\"DATASECTION\" type=\"DataSection\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        if (addAliasTable) {
            this.generateAliasTable();
        }
        this.ipw.println("<xsd:complexType name=\"Models\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"MODEL\" type=\"Model\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"Model\">");
        this.ipw.indent();
        this.ipw.println("<xsd:attribute name=\"NAME\" type=\"INTERLIS.NAME\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"VERSION\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"URI\" type=\"xsd:anyURI\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        if (addAliasTable) {
            this.ipw.println("<xsd:complexType name=\"Alias\">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"ENTRIES\" type=\"Entries\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.println("<xsd:complexType name=\"Entries\">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:choice maxOccurs=\"unbounded\">");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"TAGENTRY\" type=\"Tagentry\"/>");
            this.ipw.println("<xsd:element name=\"VALENTRY\" type=\"Valentry\"/>");
            this.ipw.println("<xsd:element name=\"DELENTRY\" type=\"Delentry\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:choice>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.println("<xsd:attribute name=\"FOR\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.println("<xsd:complexType name=\"Tagentry\">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"FROM\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"TO\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.println("<xsd:complexType name=\"Valentry\">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"TAG\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"ATTR\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"FROM\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"TO\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.println("<xsd:complexType name=\"Delentry\">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"TAG\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"ATTR\" type=\"xsd:string\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        }
        this.ipw.println("<xsd:complexType name=\"RoleType\">");
        this.ipw.indent();
        this.ipw.println("<xsd:simpleContent>");
        this.ipw.indent();
        this.ipw.println("<xsd:extension base=\"xsd:string\">");
        this.ipw.indent();
        this.ipw.println("<xsd:attribute name=\"REF\" type=\"IliID\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
        this.ipw.println("<xsd:attribute name=\"ORDER_POS\" type=\"xsd:positiveInteger\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:simpleContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"DataSection\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        this.ipw.indent();
        for (Object mObj : this.sortMetamodelElements(td.iterator())) {
            if (!(mObj instanceof Model) || this.suppressModel((Model)mObj)) continue;
            model = (Model)mObj;
            topici = model.iterator();
            while (topici.hasNext()) {
                tObj = topici.next();
                if (!(tObj instanceof Topic) || this.suppressTopic((Topic)tObj)) continue;
                topic = (Topic)tObj;
                this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(topic) + "\" type=\"" + XSDGenerator.getTransferName(topic) + "\"/>");
            }
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        for (Object mObj : this.sortMetamodelElements(td.iterator())) {
            if (!(mObj instanceof Model) || mObj instanceof PredefinedModel) continue;
            model = (Model)mObj;
            topici = model.iterator();
            while (topici.hasNext()) {
                tObj = topici.next();
                if (tObj instanceof Topic) {
                    topic = (Topic)tObj;
                    this.declareTopic(topic);
                }
                if (tObj instanceof Domain) {
                    this.declareDomainDef((Domain)tObj);
                }
                if (!(tObj instanceof AbstractClassDef)) continue;
                this.declareAbstractClassDef((AbstractClassDef)tObj);
            }
        }
        if (addAllInterlisTypes || this.refCoordValue) {
            this.ipw.println("<xsd:complexType name=\"CoordValue\">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"C1\" type=\"xsd:double\"/>");
            this.ipw.println("<xsd:element name=\"C2\" type=\"xsd:double\" minOccurs=\"0\"/>");
            this.ipw.println("<xsd:element name=\"C3\" type=\"xsd:double\" minOccurs=\"0\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        }
        if (addAllInterlisTypes || this.refArcPoint) {
            this.ipw.println("<xsd:complexType name=\"ArcPoint\">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"C1\" type=\"xsd:double\"/>");
            this.ipw.println("<xsd:element name=\"C2\" type=\"xsd:double\"/>");
            this.ipw.println("<xsd:element name=\"C3\" type=\"xsd:double\" minOccurs=\"0\"/>");
            this.ipw.println("<xsd:element name=\"A1\" type=\"xsd:double\"/>");
            this.ipw.println("<xsd:element name=\"A2\" type=\"xsd:double\"/>");
            this.ipw.println("<xsd:element name=\"R\" type=\"xsd:double\" minOccurs=\"0\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        }
        this.declareDomainDef(td.INTERLIS.NAME);
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.METAOBJECT)) {
            this.declareAbstractClassDef(td.INTERLIS.METAOBJECT);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.METAOBJECT_TRANSLATION)) {
            this.declareAbstractClassDef(td.INTERLIS.METAOBJECT_TRANSLATION);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.AXIS)) {
            this.declareAbstractClassDef(td.INTERLIS.AXIS);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.REFSYSTEM)) {
            this.declareAbstractClassDef(td.INTERLIS.REFSYSTEM);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.COORDSYSTEM)) {
            this.declareAbstractClassDef(td.INTERLIS.COORDSYSTEM);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.SCALSYSTEM)) {
            this.declareAbstractClassDef(td.INTERLIS.SCALSYSTEM);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.SIGN)) {
            this.declareAbstractClassDef(td.INTERLIS.SIGN);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.TIMESYSTEMS.CALENDAR)) {
            this.declareAbstractClassDef(td.INTERLIS.TIMESYSTEMS.CALENDAR);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.TIMESYSTEMS.TIMEOFDAYSYS)) {
            this.declareAbstractClassDef(td.INTERLIS.TIMESYSTEMS.TIMEOFDAYSYS);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.TimeOfDay)) {
            this.declareAbstractClassDef(td.INTERLIS.TimeOfDay);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.UTC)) {
            this.declareAbstractClassDef(td.INTERLIS.UTC);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.GregorianDate)) {
            this.declareAbstractClassDef(td.INTERLIS.GregorianDate);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.GregorianDateTime)) {
            this.declareAbstractClassDef(td.INTERLIS.GregorianDateTime);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.HALIGNMENT)) {
            this.declareDomainDef(td.INTERLIS.HALIGNMENT);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.VALIGNMENT)) {
            this.declareDomainDef(td.INTERLIS.VALIGNMENT);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.URI)) {
            this.declareDomainDef(td.INTERLIS.URI);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.INTERLIS_1_DATE)) {
            this.declareDomainDef(td.INTERLIS.INTERLIS_1_DATE);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.STANDARDOID)) {
            this.declareDomainDef(td.INTERLIS.STANDARDOID);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.I32OID)) {
            this.declareDomainDef(td.INTERLIS.I32OID);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.UUIDOID)) {
            this.declareDomainDef(td.INTERLIS.UUIDOID);
        }
        if (addAllInterlisTypes || this.referencedTypes.contains(td.INTERLIS.GregorianYear)) {
            this.declareDomainDef(td.INTERLIS.GregorianYear);
        }
        this.ipw.println("<xsd:complexType name=\"HeaderSection\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"MODELS\" type=\"Models\"/>");
        if (addAliasTable) {
            this.ipw.println("<xsd:element name=\"ALIAS\" type=\"Alias\" minOccurs=\"0\"/>");
        }
        if (this.refOidSpaces) {
            this.ipw.println("<xsd:element name=\"OIDSPACES\" type=\"OidSpaces\" minOccurs=\"0\"/>");
        }
        this.ipw.println("<xsd:element name=\"COMMENT\" type=\"xsd:string\" minOccurs=\"0\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.println("<xsd:attribute name=\"VERSION\" type=\"xsd:decimal\" use=\"required\" fixed=\"2.3\"/>");
        this.ipw.println("<xsd:attribute name=\"SENDER\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        if (this.refOidSpaces) {
            this.ipw.println("<xsd:complexType name=\"OidSpaces\">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"OIDSPACE\" type=\"OidSpace\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.println("<xsd:complexType name=\"OidSpace\">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"NAME\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"OIDDOMAIN\" type=\"xsd:string\" use=\"required\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        }
        if (addAllInterlisTypes || this.refIncrementalTypes) {
            this.ipw.println("<xsd:simpleType name=\"OperationType\">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            this.ipw.indent();
            this.ipw.println("<xsd:enumeration value=\"INSERT\"/>");
            this.ipw.println("<xsd:enumeration value=\"UPDATE\"/>");
            this.ipw.println("<xsd:enumeration value=\"DELETE\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
            this.ipw.println("<xsd:simpleType name=\"TransferKindType\">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            this.ipw.indent();
            this.ipw.println("<xsd:enumeration value=\"FULL\"/>");
            this.ipw.println("<xsd:enumeration value=\"INITIAL\"/>");
            this.ipw.println("<xsd:enumeration value=\"UPDATE\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        }
        if (addAllInterlisTypes || this.refConsistencyType) {
            this.ipw.println("<xsd:simpleType name=\"ConsistencyType\">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            this.ipw.indent();
            this.ipw.println("<xsd:enumeration value=\"COMPLETE\"/>");
            this.ipw.println("<xsd:enumeration value=\"INCOMPLETE\"/>");
            this.ipw.println("<xsd:enumeration value=\"INCONSISTENT\"/>");
            this.ipw.println("<xsd:enumeration value=\"ADAPTED\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:schema>");
        this.ipw.flush();
    }

    private void generateAliasTable() {
        this.ipw.println("<!-- ALIAS TABLE ");
        this.ipw.indent();
        Iterator modeli = this.td.iterator();
        while (modeli.hasNext()) {
            Object tObj;
            Object mObj = modeli.next();
            if (!(mObj instanceof Model) || this.suppressModel((Model)mObj)) continue;
            Model model = (Model)mObj;
            this.ipw.println("<ENTRIES FOR=\"" + XSDGenerator.getTransferName(model) + "\">");
            this.ipw.indent();
            Iterator topici = model.iterator();
            HashSet<Viewable> modelelev = new HashSet<Viewable>();
            while (topici.hasNext()) {
                tObj = topici.next();
                if (!(tObj instanceof Viewable) || this.suppressViewableInAliasTable((Viewable)tObj)) continue;
                Viewable v = (Viewable)tObj;
                modelelev.add(v);
                this.ipw.println("<TAGENTRY FROM=\"" + XSDGenerator.getTransferName(v) + "\" TO=\"" + XSDGenerator.getTransferName(v) + "\"/>");
                for (Viewable xv : this.sortMetamodelElements(v.getExtensions())) {
                    if (xv == v) continue;
                    if (!this.suppressViewableInAliasTable(xv)) {
                        modelelev.add(xv);
                        this.ipw.println("<TAGENTRY FROM=\"" + XSDGenerator.getTransferName(xv) + "\" TO=\"" + XSDGenerator.getTransferName(v) + "\"/>");
                    }
                    Iterator attri = xv.iterator();
                    while (attri.hasNext()) {
                        AttributeDef attr;
                        Object attro = attri.next();
                        if (!(attro instanceof AttributeDef) || (attr = (AttributeDef)attro).getExtending() != null) continue;
                        this.ipw.println("<DELENTRY TAG=\"" + XSDGenerator.getTransferName(xv) + "\" ATTR=\"" + XSDGenerator.getTransferName(attr) + "\"/>");
                    }
                }
            }
            topici = model.iterator();
            while (topici.hasNext()) {
                tObj = topici.next();
                if (!(tObj instanceof Topic) || this.suppressTopicInAliasTable((Topic)tObj)) continue;
                Topic topic = (Topic)tObj;
                this.ipw.println("<TAGENTRY FROM=\"" + XSDGenerator.getTransferName(topic) + "\" TO=\"" + XSDGenerator.getTransferName(topic) + "\"/>");
                for (Topic xtopic : this.sortMetamodelElements(topic.getExtensions())) {
                    if (xtopic == topic || this.suppressTopicInAliasTable(xtopic)) continue;
                    this.ipw.println("<TAGENTRY FROM=\"" + XSDGenerator.getTransferName(xtopic) + "\" TO=\"" + XSDGenerator.getTransferName(topic) + "\"/>");
                }
                HashSet<Viewable> elev = new HashSet<Viewable>();
                Iterator elei = topic.iterator();
                while (elei.hasNext()) {
                    Object ele = elei.next();
                    if (!(ele instanceof Viewable) || this.suppressViewableInAliasTable((Viewable)ele)) continue;
                    Viewable v = (Viewable)ele;
                    elev.add(v);
                    this.ipw.println("<TAGENTRY FROM=\"" + XSDGenerator.getTransferName(v) + "\" TO=\"" + XSDGenerator.getTransferName(v) + "\"/>");
                    for (Viewable xv : this.sortMetamodelElements(v.getExtensions())) {
                        if (xv == v) continue;
                        if (!this.suppressViewableInAliasTable(xv)) {
                            elev.add(xv);
                            this.ipw.println("<TAGENTRY FROM=\"" + XSDGenerator.getTransferName(xv) + "\" TO=\"" + XSDGenerator.getTransferName(v) + "\"/>");
                        }
                        Iterator attri = xv.iterator();
                        while (attri.hasNext()) {
                            AttributeDef attr;
                            Object attro = attri.next();
                            if (!(attro instanceof AttributeDef) || (attr = (AttributeDef)attro).getExtending() != null) continue;
                            this.ipw.println("<DELENTRY TAG=\"" + XSDGenerator.getTransferName(xv) + "\" ATTR=\"" + XSDGenerator.getTransferName(attr) + "\"/>");
                        }
                    }
                }
                for (Topic xtopic : this.sortMetamodelElements(topic.getExtensions())) {
                    if (xtopic == topic || this.suppressTopicInAliasTable(xtopic)) continue;
                    elei = xtopic.iterator();
                    while (elei.hasNext()) {
                        Viewable v;
                        Object ele = elei.next();
                        if (!(ele instanceof Viewable) || this.suppressViewableInAliasTable((Viewable)ele) || elev.contains(v = (Viewable)ele) || modelelev.contains(v)) continue;
                        this.ipw.println("<DELENTRY TAG=\"" + XSDGenerator.getTransferName(v) + "\"/>");
                    }
                }
            }
            this.ipw.unindent();
            this.ipw.println("</ENTRIES>");
        }
        this.ipw.unindent();
        this.ipw.println("    ALIAS TABLE -->");
    }

    private ArrayList sortMetamodelElements(Iterator it) {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object o = null;
        while (it.hasNext()) {
            o = it.next();
            ret.add(o);
        }
        return this.sortMetamodelElements(ret);
    }

    private ArrayList sortMetamodelElements(Collection c) {
        ArrayList ret = new ArrayList(c);
        Collections.sort(ret, new Comparator(){

            public int compare(Object o1, Object o2) {
                Element e1 = (Element)o1;
                Element e2 = (Element)o2;
                return e1.getScopedName(null).compareTo(e2.getScopedName(null));
            }
        });
        return ret;
    }

    protected boolean suppressModel(Model model) {
        if (model == null) {
            return true;
        }
        if (model == this.td.INTERLIS) {
            return true;
        }
        return model instanceof TypeModel || model instanceof PredefinedModel;
    }

    protected boolean suppressTopic(Topic topic) {
        if (topic == null) {
            return true;
        }
        return topic.isAbstract();
    }

    protected boolean suppressTopicInAliasTable(Topic topic) {
        return this.suppressTopic(topic);
    }

    protected boolean suppressViewableInAliasTable(Viewable v) {
        Topic topic;
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        return v instanceof View && (topic = (Topic)v.getContainer(Topic.class)) != null && !topic.isViewTopic();
    }

    private void reportError(String msg) {
        EhiLogger.logError((String)msg);
        ++this.numErrors;
    }

    private boolean getMetaValueBoolean(Element topic, String metaAttrName, boolean defVal) {
        String val = topic.getMetaValue(metaAttrName);
        if (val != null) {
            if (val.equals("true")) {
                return true;
            }
            if (val.equals("false")) {
                return false;
            }
            this.reportError(topic.getScopedName(null) + ": unexpected value <" + val + "> for " + metaAttrName);
        }
        return defVal;
    }

    private boolean getInheritedMetaValueBoolean(Topic topic, String metaAttrName, boolean defVal) {
        String val = topic.getMetaValue(metaAttrName);
        if (val == null) {
            val = topic.getContainer().getMetaValue(metaAttrName);
        }
        if (val != null) {
            if (val.equals("true")) {
                return true;
            }
            if (val.equals("false")) {
                return false;
            }
            this.reportError(topic.getScopedName(null) + ": unexpected value <" + val + "> for " + metaAttrName);
        }
        return defVal;
    }

    protected void declareTopic(Topic topic) {
        Domain objectOid;
        Domain basketOid;
        boolean supportSourceBasketId = this.getInheritedMetaValueBoolean(topic, "ili2c.ili23xml.supportSourceBasketId", false);
        boolean supportIncrementalTransfer = this.getInheritedMetaValueBoolean(topic, "ili2c.ili23xml.supportIncrementalTransfer", false);
        boolean supportInconsistentTransfer = this.getInheritedMetaValueBoolean(topic, "ili2c.ili23xml.supportInconsistentTransfer", false);
        boolean supportPolymorphicRead = this.getInheritedMetaValueBoolean(topic, "ili2c.ili23xml.supportPolymorphicRead", false);
        if (supportIncrementalTransfer) {
            this.refIncrementalTypes = true;
        }
        if (supportInconsistentTransfer) {
            this.refConsistencyType = true;
        }
        if ((basketOid = topic.getBasketOid()) != null) {
            this.refOidSpaces = true;
        }
        if ((objectOid = topic.getOid()) != null) {
            this.refOidSpaces = true;
        }
        Iterator<Object> iter = topic.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (e instanceof Domain) {
                this.declareDomainDef((Domain)e);
            }
            if (e instanceof AbstractClassDef) {
                if (e instanceof AssociationDef) {
                    AssociationDef assoc = (AssociationDef)e;
                    if (assoc.isLightweight() && !assoc.getAttributes().hasNext() && !assoc.getLightweightAssociations().iterator().hasNext()) continue;
                    this.declareAbstractClassDef(assoc);
                    continue;
                }
                this.declareAbstractClassDef((AbstractClassDef)e);
                continue;
            }
            if (!topic.isViewTopic() || !(e instanceof View)) continue;
            this.declareViewDef((View)e);
        }
        this.ipw.println("<xsd:complexType name=\"" + XSDGenerator.getTransferName(topic) + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        this.ipw.indent();
        for (Object object : topic.getViewables()) {
            if (!(object instanceof Viewable) || AbstractPatternDef.suppressViewableInTransfer((Viewable)object)) continue;
            Viewable v = (Viewable)object;
            if (supportSourceBasketId || supportIncrementalTransfer || supportInconsistentTransfer) {
                this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(v) + "\">");
                this.ipw.indent();
                this.ipw.println("<xsd:complexType>");
                this.ipw.indent();
                this.ipw.println("<xsd:complexContent>");
                this.ipw.indent();
                this.ipw.println("<xsd:extension base=\"" + XSDGenerator.getTransferName(v) + "\">");
                this.ipw.indent();
                if (supportSourceBasketId) {
                    this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
                }
                if (supportIncrementalTransfer) {
                    this.ipw.println("<xsd:attribute name=\"OPERATION\" type=\"OperationType\"/>");
                }
                if (supportInconsistentTransfer) {
                    this.ipw.println("<xsd:attribute name=\"CONSISTENCY\" type=\"ConsistencyType\"/>");
                }
                this.ipw.unindent();
                this.ipw.println("</xsd:extension>");
                this.ipw.unindent();
                this.ipw.println("</xsd:complexContent>");
                this.ipw.unindent();
                this.ipw.println("</xsd:complexType>");
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
                continue;
            }
            this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(v) + "\" type=\"" + XSDGenerator.getTransferName(v) + "\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\" use=\"required\"/>");
        if (supportPolymorphicRead) {
            this.ipw.println("<xsd:attribute name=\"TOPICS\" type=\"xsd:string\"/>");
        }
        if (supportIncrementalTransfer) {
            this.ipw.println("<xsd:attribute name=\"KIND\" type=\"TransferKindType\"/>");
            this.ipw.println("<xsd:attribute name=\"STARTSTATE\" type=\"xsd:string\"/>");
            this.ipw.println("<xsd:attribute name=\"ENDSTATE\" type=\"xsd:string\"/>");
        }
        if (supportInconsistentTransfer) {
            this.ipw.println("<xsd:attribute name=\"CONSISTENCY\" type=\"ConsistencyType\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    private void declareViewDef(View v) {
        this.ipw.println("<xsd:complexType  name=\"" + XSDGenerator.getTransferName(v) + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        Iterator<ViewableTransferElement> iter = v.getAttributesAndRoles2();
        while (iter.hasNext()) {
            AssociationDef roleOwner;
            Type proxyType;
            AttributeDef attr;
            ViewableTransferElement obj = iter.next();
            if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                this.declareAttribute(attr);
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            if (!obj.embedded || (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() != null) continue;
            Cardinality card = role.getCardinality();
            String minOccurs = "";
            if (card.getMinimum() == 0L) {
                minOccurs = " minOccurs=\"0\"";
            }
            this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(role) + "\"" + minOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            if (roleOwner.getAttributes().hasNext() || roleOwner.getLightweightAssociations().iterator().hasNext()) {
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(roleOwner) + "\" type=\"" + XSDGenerator.getTransferName(roleOwner) + "\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
            }
            this.ipw.println("<xsd:attribute name=\"REF\" type=\"IliID\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"ORDER_POS\" type=\"xsd:positiveInteger\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.println("<xsd:attribute name=\"TID\" type=\"IliID\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    protected void declareAbstractClassDef(Viewable v) {
        this.ipw.println("<xsd:complexType  name=\"" + XSDGenerator.getTransferName(v) + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        Iterator<ViewableTransferElement> iter = v.getAttributesAndRoles2();
        while (iter.hasNext()) {
            AssociationDef roleOwner;
            AttributeDef attr;
            ViewableTransferElement obj = iter.next();
            if (obj.obj instanceof AttributeDef && !(attr = (AttributeDef)obj.obj).isTransient()) {
                this.declareAttribute(attr);
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            if (!obj.embedded && !((AssociationDef)v).isLightweight()) {
                this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(role) + "\" type=\"RoleType\"/>");
            }
            if (!obj.embedded || (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() != null) continue;
            Cardinality card = role.getCardinality();
            String minOccurs = "";
            if (card.getMinimum() == 0L) {
                minOccurs = " minOccurs=\"0\"";
            }
            this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(role) + "\"" + minOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            if (roleOwner.getAttributes().hasNext() || roleOwner.getLightweightAssociations().iterator().hasNext()) {
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(roleOwner) + "\" type=\"" + XSDGenerator.getTransferName(roleOwner) + "\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
            }
            this.ipw.println("<xsd:attribute name=\"REF\" type=\"IliID\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"ORDER_POS\" type=\"xsd:positiveInteger\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        if (!(v instanceof AssociationDef && ((AssociationDef)v).isLightweight() || v instanceof Table && !((Table)v).isIdentifiable())) {
            if (v instanceof AssociationDef) {
                AssociationDef assoc = (AssociationDef)v;
                if (assoc.isIdentifiable()) {
                    this.ipw.println("<xsd:attribute name=\"TID\" type=\"IliID\" use=\"required\"/>");
                } else {
                    Domain oid = assoc.getDefinedOid();
                    if (oid != null && !(oid instanceof NoOid)) {
                        this.ipw.println("<xsd:attribute name=\"TID\" type=\"IliID\" use=\"required\"/>");
                        this.refOidSpaces = true;
                    }
                }
            } else {
                this.ipw.println("<xsd:attribute name=\"TID\" type=\"IliID\" use=\"required\"/>");
                Domain oid = ((AbstractClassDef)v).getDefinedOid();
                if (oid != null && !(oid instanceof NoOid)) {
                    this.refOidSpaces = true;
                }
            }
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    protected void declareDomainDef(Domain domain) {
        this.declareType(domain.getType(), domain);
    }

    protected void declareAttribute(AttributeDef attribute) {
        try {
            String minOccurs = "";
            Type type = attribute.getDomain();
            if (type == null) {
                Evaluable[] ev = ((LocalAttribute)attribute).getBasePaths();
                type = ((ObjectPath)ev[0]).getType();
            }
            if (!type.isMandatoryConsideringAliases()) {
                minOccurs = " minOccurs=\"0\"";
            }
            if (type instanceof TypeAlias) {
                if (((TypeAlias)type).getAliasing() == this.td.INTERLIS.BOOLEAN) {
                    this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(attribute) + "\" type=\"xsd:boolean\"" + minOccurs + "/>");
                } else if (((TypeAlias)type).getAliasing() == this.td.INTERLIS.XmlDate) {
                    this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(attribute) + "\" type=\"xsd:date\"" + minOccurs + "/>");
                } else if (((TypeAlias)type).getAliasing() == this.td.INTERLIS.XmlDateTime) {
                    this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(attribute) + "\" type=\"xsd:dateTime\"" + minOccurs + "/>");
                } else if (((TypeAlias)type).getAliasing() == this.td.INTERLIS.XmlTime) {
                    this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(attribute) + "\" type=\"xsd:time\"" + minOccurs + "/>");
                } else {
                    this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(attribute) + "\" type=\"" + this.getDomainRef(((TypeAlias)type).getAliasing()) + "\"" + minOccurs + "/>");
                }
            } else {
                this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(attribute) + "\"" + minOccurs + ">");
                this.ipw.indent();
                this.declareType(type, null);
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
            }
        }
        catch (Exception ex) {
            System.err.println(attribute.toString());
            ex.printStackTrace(System.err);
        }
    }

    protected void declareType(Type type, Domain domain) {
        String typeName = "";
        if (domain != null) {
            typeName = " name=\"" + XSDGenerator.getTransferName(domain) + "\"";
        }
        if (type instanceof PolylineType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"POLYLINE\">");
            this.ipw.indent();
            this.declarePolylineValue((PolylineType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"SURFACE\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"BOUNDARY\" maxOccurs=\"unbounded\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"POLYLINE\" maxOccurs=\"unbounded\">");
            this.ipw.indent();
            this.declarePolylineValue((SurfaceOrAreaType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof CoordType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"COORD\" type=\"CoordValue\"/>");
            this.refCoordValue = true;
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof CompositionType) {
            Set extv;
            CompositionType composition = (CompositionType)type;
            Table part = composition.getComponentType();
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            Cardinality card = composition.getCardinality();
            String minOccurs = "";
            if (card.getMinimum() > 1L) {
                minOccurs = " minOccurs=\"" + Long.toString(card.getMinimum()) + "\"";
            }
            String maxOccurs = "";
            if (card.getMaximum() != 1L) {
                maxOccurs = card.getMaximum() == Long.MAX_VALUE ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + Long.toString(card.getMaximum()) + "\"";
            }
            if ((extv = part.getExtensions()).size() > 1) {
                this.ipw.println("<xsd:choice" + minOccurs + maxOccurs + ">");
                this.ipw.indent();
                for (Table ext : this.sortMetamodelElements(extv)) {
                    this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(ext) + "\" type=\"" + this.getStructureRef(ext) + "\"/>");
                }
                this.ipw.unindent();
                this.ipw.println("</xsd:choice>");
            } else {
                this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(part) + "\" type=\"" + this.getStructureRef(part) + "\"" + minOccurs + maxOccurs + "/>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof ReferenceType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"REF\" type=\"IliID\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof OIDType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"OID\" type=\"IliID\" use=\"required\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.refOidSpaces = true;
        } else if (type instanceof EnumerationType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            this.ipw.indent();
            ArrayList ev = new ArrayList();
            XSDGenerator.buildEnumList(ev, "", ((EnumerationType)type).getConsolidatedEnumeration());
            for (String value : ev) {
                this.ipw.println("<xsd:enumeration value=\"" + value + "\"/>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof NumericType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            if (type.isAbstract()) {
                this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                this.ipw.println("</xsd:restriction>");
            } else {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                if (min.getAccuracy() > 0) {
                    this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                    this.ipw.indent();
                    this.ipw.println("<xsd:minInclusive value=\"" + ((NumericType)type).getMinimum() + "\"/>");
                    this.ipw.println("<xsd:maxInclusive value=\"" + ((NumericType)type).getMaximum() + "\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:restriction>");
                } else {
                    this.ipw.println("<xsd:restriction base=\"xsd:integer\">");
                    this.ipw.indent();
                    this.ipw.println("<xsd:minInclusive value=\"" + (int)((NumericType)type).getMinimum().doubleValue() + "\"/>");
                    this.ipw.println("<xsd:maxInclusive value=\"" + (int)((NumericType)type).getMaximum().doubleValue() + "\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:restriction>");
                }
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof TextType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            if (((TextType)type).isNormalized()) {
                this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
            } else {
                this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            }
            if (((TextType)type).getMaxLength() > 0) {
                this.ipw.indent();
                this.ipw.println("<xsd:maxLength value=\"" + ((TextType)type).getMaxLength() + "\"/>");
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof FormattedType) {
            FormattedType ftype = (FormattedType)type;
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            Domain baseDomain = ((FormattedType)type).getDefinedBaseDomain();
            if (baseDomain == this.td.INTERLIS.XmlDate) {
                this.ipw.println("<xsd:restriction base=\"xsd:date\">");
                this.ipw.indent();
                PrecisionDecimal[] minv = ftype.valueOf(ftype.getMinimum());
                PrecisionDecimal[] maxv = ftype.valueOf(ftype.getMaximum());
                String min = this.getDateValue(minv);
                String max = this.getDateValue(maxv);
                this.ipw.println("<xsd:minInclusive value=\"" + min + "\"/>");
                this.ipw.println("<xsd:maxInclusive value=\"" + max + "\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
            } else if (baseDomain == this.td.INTERLIS.XmlDateTime) {
                this.ipw.println("<xsd:restriction base=\"xsd:dateTime\">");
                this.ipw.indent();
                PrecisionDecimal[] minv = ftype.valueOf(ftype.getMinimum());
                PrecisionDecimal[] maxv = ftype.valueOf(ftype.getMaximum());
                String min = this.getDateValue(minv) + "T" + this.getTimeValue(minv, 3);
                String max = this.getDateValue(maxv) + "T" + this.getTimeValue(maxv, 3);
                this.ipw.println("<xsd:minInclusive value=\"" + min + "\"/>");
                this.ipw.println("<xsd:maxInclusive value=\"" + max + "\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
            } else if (baseDomain == this.td.INTERLIS.XmlTime) {
                this.ipw.println("<xsd:restriction base=\"xsd:time\">");
                this.ipw.indent();
                PrecisionDecimal[] minv = ftype.valueOf(ftype.getMinimum());
                PrecisionDecimal[] maxv = ftype.valueOf(ftype.getMaximum());
                String min = this.getTimeValue(minv, 0);
                String max = this.getTimeValue(maxv, 0);
                this.ipw.println("<xsd:minInclusive value=\"" + min + "\"/>");
                this.ipw.println("<xsd:maxInclusive value=\"" + max + "\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
            } else {
                this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
                this.ipw.indent();
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof BlackboxType) {
            BlackboxType ftype = (BlackboxType)type;
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            if (ftype.getKind() == 2) {
                this.ipw.println("<xsd:element name=\"BINBLBOX\">");
            } else {
                this.ipw.println("<xsd:element name=\"XMLBLBOX\">");
            }
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            if (ftype.getKind() == 2) {
                this.ipw.indent();
                this.ipw.println("<xsd:simpleContent>");
                this.ipw.indent();
                this.ipw.println("<xsd:extension base=\"xsd:base64Binary\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:simpleContent>");
                this.ipw.unindent();
            } else {
                this.ipw.indent();
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:any minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"skip\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:simpleContent>");
            this.ipw.indent();
            this.ipw.println("<xsd:extension base=\"xsd:string\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleContent>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        }
    }

    private String getDateValue(PrecisionDecimal[] minv) {
        DecimalFormat nnnn = new DecimalFormat("0000");
        DecimalFormat nn = new DecimalFormat("00");
        String min = nnnn.format(new BigDecimal(minv[0].toString())) + "-" + nn.format(new BigDecimal(minv[1].toString())) + "-" + nn.format(new BigDecimal(minv[2].toString()));
        return min;
    }

    private String getTimeValue(PrecisionDecimal[] minv, int offset) {
        DecimalFormat ss = new DecimalFormat("00.000");
        DecimalFormat nn = new DecimalFormat("00");
        String min = nn.format(new BigDecimal(minv[0 + offset].toString())) + ":" + nn.format(new BigDecimal(minv[1 + offset].toString())) + ":" + ss.format(new BigDecimal(minv[2 + offset].toString()));
        return min;
    }

    private void declarePolylineValue(LineType domain) {
        Table part;
        this.ipw.println("<xsd:complexType>");
        this.ipw.indent();
        boolean hasLineAttr = false;
        if (domain instanceof SurfaceOrAreaType && (part = ((SurfaceOrAreaType)domain).getLineAttributeStructure()) != null) {
            hasLineAttr = true;
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"LINEATTR\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(part) + "\" type=\"" + this.getStructureRef(part) + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.println("<xsd:choice minOccurs=\"2\" maxOccurs=\"unbounded\">");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"COORD\" type=\"CoordValue\"/>");
        this.refCoordValue = true;
        HashSet<LineForm> lfv = new HashSet<LineForm>(Arrays.asList(domain.getLineForms()));
        if (lfv.contains(this.td.INTERLIS.ARCS)) {
            this.ipw.println("<xsd:element name=\"ARC\" type=\"ArcPoint\"/>");
            this.refArcPoint = true;
        }
        for (LineForm lf : lfv) {
            if (lf == this.td.INTERLIS.ARCS || lf == this.td.INTERLIS.STRAIGHTS) continue;
            Table segmentStruct = lf.getSegmentStructure();
            this.ipw.println("<xsd:element name=\"" + XSDGenerator.getTransferName(segmentStruct) + "\" type=\"" + this.getStructureRef(segmentStruct) + "\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        if (hasLineAttr) {
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    public static void buildEnumList(List accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                XSDGenerator.buildEnumList(accu, prefix + ee.getName(), subEnum);
                continue;
            }
            accu.add(prefix + ee.getName());
        }
    }

    public static HashMap getTagMap(TransferDescription td) {
        HashMap<String, Viewable> ret = new HashMap<String, Viewable>();
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object mObj = modeli.next();
            if (!(mObj instanceof Model)) continue;
            Model model = (Model)mObj;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Object tObj = topici.next();
                if (tObj instanceof Topic) {
                    Topic topic = (Topic)tObj;
                    for (Viewable<?> obj : topic.getViewables()) {
                        if (!(obj instanceof Viewable)) continue;
                        Viewable<?> v = obj;
                        ret.put(v.getScopedName((Container)null), v);
                    }
                    continue;
                }
                if (!(tObj instanceof Viewable)) continue;
                Viewable v = (Viewable)tObj;
                ret.put(v.getScopedName((Container)null), v);
            }
        }
        return ret;
    }

    private String getDomainRef(Domain ele) {
        this.referencedTypes.add(ele);
        return XSDGenerator.getTransferName(ele);
    }

    private String getStructureRef(Viewable ele) {
        this.referencedTypes.add(ele);
        return XSDGenerator.getTransferName(ele);
    }
}

