/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2gpkg;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.wkb.ByteArrayOutputStream;
import ch.interlis.iox_j.wkb.Iox2wkb;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.nio.ByteOrder;

public class Iox2gpkg {
    private int outputDimension = 2;
    private ByteArrayOutputStream os = null;

    private Iox2gpkg() {
    }

    public Iox2gpkg(int outputDimension) {
        this(outputDimension, ByteOrder.BIG_ENDIAN);
    }

    public Iox2gpkg(int outputDimension, ByteOrder byteOrder) {
        this.outputDimension = outputDimension;
        this.os = new ByteArrayOutputStream(byteOrder);
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public byte[] coord2wkb(IomObject obj, int srsId) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.os.reset();
            Coordinate coord = Iox2jtsext.coord2JTS((IomObject)obj);
            Envelope env = new Envelope();
            env.expandToInclude(coord);
            this.writeGeoPackageBinaryHeader(srsId, env);
            Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order());
            this.os.write(helper.coord2wkb(obj));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        catch (IoxException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public Object multicoord2wkb(IomObject obj, int srsId) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.os.reset();
            Envelope env = new Envelope();
            int coordc = obj.getattrvaluecount("coord");
            for (int coordi = 0; coordi < coordc; ++coordi) {
                IomObject coord = obj.getattrobj("coord", coordi);
                env.expandToInclude(Iox2jtsext.coord2JTS((IomObject)coord));
            }
            this.writeGeoPackageBinaryHeader(srsId, env);
            Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order());
            this.os.write(helper.multicoord2wkb(obj));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        catch (IoxException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] polyline2wkb(IomObject obj, boolean isSurfaceOrArea, boolean asCompoundCurve, double p, int srsId) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.os.reset();
            CompoundCurve surface = Iox2jtsext.polyline2JTS((IomObject)obj, (boolean)false, (double)p);
            this.writeGeoPackageBinaryHeader(srsId, surface.getEnvelopeInternal());
            Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order());
            this.os.write(helper.polyline2wkb(obj, isSurfaceOrArea, asCompoundCurve, p));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        catch (IoxException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multiline2wkb(IomObject obj, boolean asCompoundCurve, double p, int srsId) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.os.reset();
            int polylinec = obj.getattrvaluecount("polyline");
            Envelope env = new Envelope();
            for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                IomObject polyline = obj.getattrobj("polyline", polylinei);
                CompoundCurve curve = Iox2jtsext.polyline2JTS((IomObject)polyline, (boolean)false, (double)p);
                env.expandToInclude(curve.getEnvelopeInternal());
            }
            this.writeGeoPackageBinaryHeader(srsId, env);
            Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order());
            this.os.write(helper.multiline2wkb(obj, asCompoundCurve, p));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        catch (IoxException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] surface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP, boolean repairTouchingLines, int srsId) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.os.reset();
            Polygon surface = Iox2jtsext.surface2JTS((IomObject)obj, (double)strokeP);
            this.writeGeoPackageBinaryHeader(srsId, surface.getEnvelopeInternal());
            Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order());
            this.os.write(helper.surface2wkb(obj, asCurvePolygon, strokeP, repairTouchingLines));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        catch (IoxException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multisurface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP, boolean repairTouchingLines, int srsId) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.os.reset();
            int surfacec = obj.getattrvaluecount("surface");
            Envelope env = new Envelope();
            for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                IomObject surface = obj.getattrobj("surface", surfacei);
                Iom_jObject iomSurfaceClone = new Iom_jObject("MULTISURFACE", (String)null);
                iomSurfaceClone.addattrobj("surface", surface);
                env.expandToInclude(Iox2jtsext.surface2JTS((IomObject)iomSurfaceClone, (double)strokeP).getEnvelopeInternal());
            }
            this.writeGeoPackageBinaryHeader(srsId, env);
            Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order());
            this.os.write(helper.multisurface2wkb(obj, asCurvePolygon, strokeP, repairTouchingLines));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        catch (IoxException e) {
            throw new RuntimeException("Unexpected exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private void writeGeoPackageBinaryHeader(int srsId, Envelope envelope) {
        this.os.write(71);
        this.os.write(80);
        this.os.write(0);
        int flags = 0;
        flags = this.os.order().equals(ByteOrder.LITTLE_ENDIAN) ? (int)((byte)(flags | 1)) : (int)((byte)(flags & 0xFFFFFFFE));
        if (envelope != null) {
            flags = (byte)(flags | 2);
        }
        this.os.write(flags);
        this.os.writeInt(srsId);
        if (envelope != null) {
            this.os.writeDouble(envelope.getMinX());
            this.os.writeDouble(envelope.getMaxX());
            this.os.writeDouble(envelope.getMinY());
            this.os.writeDouble(envelope.getMaxY());
        }
    }
}

