/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;

public class FunctionCall
extends Evaluable {
    protected Function function;
    protected Evaluable[] arguments;

    public FunctionCall(Function function, Evaluable[] arguments) {
        this.function = function;
        this.arguments = arguments;
        if (function == null || arguments == null) {
            return;
        }
        FormalArgument[] declaredParams = function.getArguments();
        if (declaredParams == null) {
            return;
        }
        if (declaredParams.length != arguments.length) {
            throw new IllegalArgumentException(Element.formatMessage("err_functionCall_wrongNumberArgs", function.toString(), Integer.toString(declaredParams.length)));
        }
    }

    @Override
    public boolean isLogical() {
        return this.function.getDomain().isBoolean();
    }

    @Override
    public Type getType() {
        return this.function.getDomain();
    }

    public Function getFunction() {
        return this.function;
    }

    public Evaluable[] getArguments() {
        return this.arguments;
    }

    @Override
    public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
        Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
        if (ret != null) {
            return ret;
        }
        FunctionCall other = (FunctionCall)otherEv;
        if (!Element.equalElementRef(this.function, other.function)) {
            return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_functionRefMismatch", this.function.getScopedName(), other.function.getScopedName()));
        }
        if (this.arguments.length != other.arguments.length) {
            return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_functionArgumentMismatch"));
        }
        for (int pathi = 0; pathi < this.arguments.length; ++pathi) {
            if (this.arguments[pathi].getClass() != other.arguments[pathi].getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_functionArgumentMismatch"));
            }
            ret = this.arguments[pathi].checkTranslation(other.arguments[pathi], sourceLine);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

