/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.base;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.converter.AbstractRecordConverter;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class TableBasedIdGen
implements DbIdGen {
    public static final String SQL_T_KEY_OBJECT = "T_KEY_OBJECT";
    public static final String SQL_T_KEY = "T_Key";
    public static final String SQL_T_LASTUNIQUEID = "T_LastUniqueId";
    Connection conn = null;
    String dbusr = null;
    String schema = null;
    long idBlockStart = 0L;
    long lastLocalId = 0L;

    @Override
    public void init(String schema, Config config) {
        this.schema = schema;
    }

    @Override
    public void initDb(Connection conn, String dbusr) {
        this.conn = conn;
        this.dbusr = dbusr;
    }

    @Override
    public void addMappingTable(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), SQL_T_KEY_OBJECT));
        DbColVarchar t_key = new DbColVarchar();
        t_key.setName(SQL_T_KEY);
        t_key.setNotNull(true);
        t_key.setPrimaryKey(true);
        t_key.setSize(30);
        tab.addColumn((DbColumn)t_key);
        DbColNumber t_lastuniqueid = new DbColNumber();
        t_lastuniqueid.setName(SQL_T_LASTUNIQUEID);
        t_lastuniqueid.setNotNull(true);
        tab.addColumn((DbColumn)t_lastuniqueid);
        AbstractRecordConverter.addStdCol(tab);
        schema.addTable(tab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount(String key) {
        String sqlName = SQL_T_KEY_OBJECT;
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        Statement getstmt = null;
        ResultSet res = null;
        try {
            String stmt = "SELECT T_LastUniqueId FROM " + sqlName + " WHERE " + SQL_T_KEY + "= ?";
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = this.conn.prepareStatement(stmt);
            getstmt.setString(1, key);
            res = getstmt.executeQuery();
            long ret = 0L;
            if (res.next()) {
                long l = ret = res.getLong(1);
                return l;
            }
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to query " + sqlName), (Throwable)ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {
                    EhiLogger.logError((Throwable)e);
                }
                res = null;
            }
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                getstmt = null;
            }
        }
        long ret = 0L;
        Timestamp today = new Timestamp(System.currentTimeMillis());
        String stmt = "INSERT INTO " + sqlName + " (" + SQL_T_KEY + "," + SQL_T_LASTUNIQUEID + ",T_LastChange,T_CreateDate,T_User) VALUES (?,?,?,?,?)";
        EhiLogger.traceBackendCmd((String)stmt);
        PreparedStatement updstmt = null;
        try {
            updstmt = this.conn.prepareStatement(stmt);
            updstmt.setString(1, key);
            updstmt.setLong(2, ret);
            updstmt.setTimestamp(3, today);
            updstmt.setTimestamp(4, today);
            updstmt.setString(5, this.dbusr);
            updstmt.executeUpdate();
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to insert " + sqlName), (Throwable)ex);
        }
        finally {
            if (updstmt != null) {
                try {
                    updstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCount(long newId, String key) {
        String sqlName = SQL_T_KEY_OBJECT;
        if (this.schema != null) {
            sqlName = this.schema + "." + sqlName;
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        String stmt = "UPDATE " + sqlName + " SET " + SQL_T_LASTUNIQUEID + "=?,T_LastChange=?,T_User=? WHERE " + SQL_T_KEY + "=?";
        EhiLogger.traceBackendCmd((String)stmt);
        PreparedStatement updstmt = null;
        try {
            updstmt = this.conn.prepareStatement(stmt);
            updstmt.setLong(1, newId);
            updstmt.setTimestamp(2, today);
            updstmt.setString(3, this.dbusr);
            updstmt.setString(4, key);
            updstmt.executeUpdate();
        }
        catch (SQLException ex) {
            EhiLogger.logError((String)("failed to update " + sqlName), (Throwable)ex);
        }
        finally {
            if (updstmt != null) {
                try {
                    updstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void initDbDefs(Generator gen) {
    }

    @Override
    public long newObjSqlId() {
        long ret;
        long BLOCK_SIZE = 20L;
        if (this.lastLocalId != 0L && this.lastLocalId < 20L) {
            ++this.lastLocalId;
            ret = this.idBlockStart + this.lastLocalId;
        } else {
            this.lastLocalId = 1L;
            ret = this.idBlockStart = this.getCount("T_Id") + this.lastLocalId;
            this.setCount(this.idBlockStart + 20L, "T_Id");
        }
        return ret;
    }

    @Override
    public long getLastSqlId() {
        return this.idBlockStart + this.lastLocalId;
    }

    @Override
    public String getDefaultValueSql() {
        return null;
    }
}

