/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.inifile;

import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.nio.charset.Charset;

public class IniFileReader {
    public static ValidationConfig readFile(File file) throws IOException {
        ValidationConfig config = null;
        config = new ValidationConfig();
        IniFileReader.mergeIniFile(config, file);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeIniFile(ValidationConfig config, File file) throws IOException {
        BufferedReader br = null;
        PushbackReader pushbackReader = null;
        StringReader stringReader = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
            String line = null;
            String key = null;
            String value = null;
            String header = null;
            while ((line = br.readLine()) != null) {
                stringReader = new StringReader(line);
                pushbackReader = new PushbackReader(stringReader);
                IniFileReader.skipSpaces(pushbackReader);
                int c = pushbackReader.read();
                if (c == -1) continue;
                if (c == 91) {
                    pushbackReader.unread(c);
                    header = IniFileReader.parseSectionHeader(pushbackReader);
                    continue;
                }
                if (c == 35) {
                    pushbackReader.unread(c);
                    IniFileReader.parseComment(pushbackReader);
                    continue;
                }
                pushbackReader.unread(c);
                String[] keyAndValue = IniFileReader.parseKeyValueLine(pushbackReader);
                key = keyAndValue[0];
                value = keyAndValue[1];
                config.setConfigValue(header, key, value);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pushbackReader != null) {
                pushbackReader.close();
            }
            if (stringReader != null) {
                stringReader.close();
            }
        }
    }

    private static String parseSectionHeader(PushbackReader line) throws IOException {
        IniFileReader.skipSpaces(line);
        int c = line.read();
        if (c == -1) {
            return null;
        }
        if (c != 91) {
            throw new IOException("unexpected character " + IniFileReader.quoteChar(c) + " in section header");
        }
        IniFileReader.skipSpaces(line);
        String headerName = IniFileReader.parseName(line);
        IniFileReader.skipSpaces(line);
        c = line.read();
        if (c != 93) {
            throw new IOException("unexpected character " + IniFileReader.quoteChar(c) + " in section header");
        }
        IniFileReader.parseComment(line);
        return headerName;
    }

    private static String quoteChar(int c) {
        if (c == -1) {
            return "EOL";
        }
        if (Character.isISOControl(c) || !Character.isDefined(c) || Character.isWhitespace(c)) {
            return "'\\u" + Integer.toHexString(c) + "'";
        }
        return "'" + Character.toString((char)c) + "'";
    }

    private static void parseComment(PushbackReader line) {
    }

    private static String parseName(PushbackReader line) throws IOException {
        return IniFileReader.parseValue(line, true);
    }

    private static String parseValue(PushbackReader line) throws IOException {
        return IniFileReader.parseValue(line, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseValue(PushbackReader line, boolean parseName) throws IOException {
        String ret = null;
        int c = line.read();
        if (c == 34) {
            StringBuilder value = new StringBuilder();
            c = line.read();
            while (c != -1 && c != 34) {
                if (c == 92) {
                    c = line.read();
                    if (c == -1) {
                        throw new IOException("unexpected end of " + (parseName ? "name" : "value"));
                    }
                    if (c != 92 && c != 34) throw new IOException("unexpected character " + IniFileReader.quoteChar(c) + " after escape");
                    value.append((char)c);
                } else {
                    value.append((char)c);
                }
                c = line.read();
            }
            ret = value.toString();
        } else {
            StringBuilder value = new StringBuilder();
            while (c != -1 && !(parseName ? c == 32 || c == 9 || !Character.isDigit(c) && !Character.isLetter(c) && c != 95 && c != 46 && c != 45 && c != 63 && c != 58 && c != 125 && c != 123 : c == 35)) {
                value.append((char)c);
                c = line.read();
            }
            if (c != -1) {
                line.unread(c);
            }
            ret = value.toString().trim();
        }
        if (!parseName || ret.length() != 0) return ret;
        throw new IOException("unexpected end of name");
    }

    private static void skipSpaces(PushbackReader line) throws IOException {
        int c = line.read();
        while (c == 32 || c == 9) {
            c = line.read();
        }
        if (c != -1) {
            line.unread(c);
        }
    }

    private static String[] parseKeyValueLine(PushbackReader line) throws IOException {
        IniFileReader.skipSpaces(line);
        String[] keyAndValue = new String[2];
        String key = IniFileReader.parseName(line);
        IniFileReader.skipSpaces(line);
        int c = line.read();
        if (c != 61) {
            throw new IOException("unexpected character " + IniFileReader.quoteChar(c) + " in key value line");
        }
        IniFileReader.skipSpaces(line);
        String value = IniFileReader.parseValue(line);
        IniFileReader.skipSpaces(line);
        IniFileReader.parseComment(line);
        keyAndValue[0] = key;
        keyAndValue[1] = value;
        return keyAndValue;
    }
}

