/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.iligml;

import ch.interlis.ili2c.generator.Iligml20Generator;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.iligml.LinkPool;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.IoxSyntaxException;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Iligml20Reader
implements IoxReader,
IoxIliReader {
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private LinkPool linkPool = new LinkPool();
    private InputStream inputFile = null;
    private XMLEventReader reader = null;
    private HashMap<QName, Topic> iliTopics = null;
    private HashMap<QName, Viewable> iliClasses = null;
    private HashMap<Viewable, HashMap<QName, Element>> iliProperties = null;
    private Iterator<IomObject> linkIterator;
    private String topicName = null;
    private int state = 0;
    private TransferDescription td;
    private static final int START = 0;
    private static final int START_DOCUMENT = 1;
    private static final int INSIDE_TRANSFER = 2;
    private static final int INSIDE_BASKETS = 3;
    private static final int INSIDE_BASKET = 4;
    private static final int INSIDE_MEMBER = 5;
    private static final int END_OBJECT = 6;
    private static final int END_MEMBER = 7;
    private static final int END_BASKET = 8;
    private static final int PRE_ENDBASKET = 9;
    private static final int END_BASKETS = 10;
    private static final int END_TRANSFER = 11;
    private static final int END_DOCUMENT = 12;
    private static final String METAATTR_NAMESPACE = "ili2.iligml20.namespaceName";
    private static final String NAMESPACE_ILIGMLBASE = "http://www.interlis.ch/ILIGML-2.0/";
    private static final String NAMESPACE_ILIGMLBASE_INTERLIS = "http://www.interlis.ch/ILIGML-2.0/INTERLIS";
    public static final String XMLNS_ILIGML = "http://www.interlis.ch/ILIGML-2.0/INTERLIS";
    private static final String NAMESPACE_GML = "http://www.opengis.net/gml/3.2";
    private static final String NAMESPACE_XLINK = "http://www.w3.org/1999/xlink";
    private static final String NAMESPACE_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final QName QNAME_ID = new QName("http://www.opengis.net/gml/3.2", "id");
    private static final QName QNAME_ILI_TRANSFER = new QName("http://www.interlis.ch/ILIGML-2.0/INTERLIS", "TRANSFER");
    private static final QName QNAME_POLYGON = new QName("http://www.opengis.net/gml/3.2", "Polygon");
    private static final QName QNAME_EXTERIOR = new QName("http://www.opengis.net/gml/3.2", "exterior");
    private static final QName QNAME_INTERIOR = new QName("http://www.opengis.net/gml/3.2", "interior");
    private static final QName QNAME_RING = new QName("http://www.opengis.net/gml/3.2", "Ring");
    private static final QName QNAME_CURVEMEMBER = new QName("http://www.opengis.net/gml/3.2", "curveMember");
    private static final QName QNAME_POINT = new QName("http://www.opengis.net/gml/3.2", "Point");
    private static final QName QNAME_SEGMENTS = new QName("http://www.opengis.net/gml/3.2", "segments");
    private static final QName QNAME_POS = new QName("http://www.opengis.net/gml/3.2", "posList");
    private static final QName QNAME_ILI_BASKETS = new QName("http://www.interlis.ch/ILIGML-2.0/INTERLIS", "baskets");
    private static final QName QNAME_MEMBER = new QName("http://www.opengis.net/gml/3.2", "member");
    private static final QName QNAME_ARC = new QName("http://www.opengis.net/gml/3.2", "Arc");
    private static final QName QNAME_LINESTRINGSEGMENT = new QName("http://www.opengis.net/gml/3.2", "LineStringSegment");
    private static final QName QNAME_CURVE = new QName("http://www.opengis.net/gml/3.2", "Curve");
    private static final QName QNAME_LINESTRING = new QName("http://www.opengis.net/gml/3.2", "LineString");
    private static final QName QNAME_ORIENTABLECURVE = new QName("http://www.opengis.net/gml/3.2", "OrientableCurve");
    private static final QName QNAME_COMPOSITECURVE = new QName("http://www.opengis.net/gml/3.2", "CompositeCurve");
    private static final String INTERPOLATIION_LINEAR = "linear";
    private static final String INTERPOLATIION_CIRCULARARC3POINTS = "circularArc3Points";
    private static final String XLINK_HREF = "href";
    private static final QName QNAME_HREF = new QName("http://www.w3.org/1999/xlink", "href");

    public Iligml20Reader(InputStream in) throws IoxException {
        this.init(in);
    }

    public Iligml20Reader(InputStreamReader in) throws IoxException {
    }

    public Iligml20Reader(File xtffile) throws IoxException {
        try {
            this.inputFile = new FileInputStream(xtffile);
            this.init(this.inputFile);
        }
        catch (IOException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void init(InputStream in) throws IoxException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            this.reader = inputFactory.createXMLEventReader(in);
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public void close() throws IoxException {
        this.reader = null;
        if (this.inputFile != null) {
            try {
                this.inputFile.close();
            }
            catch (IOException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.inputFile = null;
        }
    }

    public IoxEvent read() throws IoxException {
        IomObject iomObj = null;
        if (this.state == 9 && this.linkIterator != null) {
            if (this.linkIterator.hasNext()) {
                IomObject assocObj = this.linkIterator.next();
                return new ObjectEvent(assocObj);
            }
            this.linkIterator = null;
            this.state = 8;
            return new EndBasketEvent();
        }
        while (this.reader.hasNext()) {
            Characters characters;
            StartElement element;
            XMLEvent event = null;
            try {
                event = this.reader.nextEvent();
            }
            catch (XMLStreamException ex) {
                throw new IoxException((Throwable)ex);
            }
            if (this.state == 0) {
                if (event.isStartDocument()) {
                    this.state = 1;
                    continue;
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 1) {
                if (event.isEndDocument()) {
                    this.state = 12;
                    continue;
                }
                if (event.isStartElement()) {
                    element = (StartElement)event;
                    if (element.getName().equals(QNAME_ILI_TRANSFER)) {
                        this.state = 2;
                        return new StartTransferEvent();
                    }
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                if (!event.isCharacters() || (characters = (Characters)event).isWhiteSpace()) continue;
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 2) {
                if (event.isEndElement()) {
                    this.state = 11;
                    return new EndTransferEvent();
                }
                if (event.isStartElement()) {
                    this.state = 3;
                    continue;
                }
                if (!event.isCharacters() || (characters = (Characters)event).isWhiteSpace()) continue;
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 3) {
                if (event.isEndElement()) {
                    this.state = 10;
                    continue;
                }
                if (event.isStartElement()) {
                    element = (StartElement)event;
                    this.topicName = element.getName().getLocalPart();
                    String topicScopedName = this.getIliTopic(element.getName());
                    if (topicScopedName == null) {
                        throw new IoxException(this.event2msgtext(event));
                    }
                    QName gmlId = QNAME_ID;
                    Attribute bid = event.asStartElement().getAttributeByName(gmlId);
                    if (bid == null) continue;
                    this.state = 4;
                    return new StartBasketEvent(topicScopedName, bid.getValue());
                }
                if (event.isCharacters()) {
                    characters = (Characters)event;
                    if (characters.isWhiteSpace()) continue;
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 4) {
                if (event.isEndElement()) {
                    this.state = 8;
                    return new EndBasketEvent();
                }
                if (event.isStartElement()) {
                    this.state = 5;
                    continue;
                }
                if (event.isCharacters()) {
                    characters = (Characters)event;
                    if (characters.isWhiteSpace()) continue;
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 5) {
                if (event.isEndElement()) {
                    if (iomObj == null) {
                        this.state = 6;
                        continue;
                    }
                    this.state = 6;
                    return new ObjectEvent(iomObj);
                }
                if (event.isStartElement()) {
                    Viewable viewable = null;
                    StartElement element2 = (StartElement)event;
                    String className = element2.getName().getLocalPart();
                    QName extendedQName = new QName(element2.getName().getNamespaceURI(), this.topicName + "." + className);
                    viewable = this.getIliClass(extendedQName);
                    if (viewable == null) {
                        viewable = this.getIliClass(element2.getName());
                    }
                    if (viewable == null) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    Integer srsDimension = null;
                    QName qName = QNAME_ID;
                    Attribute oid = event.asStartElement().getAttributeByName(qName);
                    srsDimension = this.srsDimensionValidation(srsDimension, event);
                    if (oid == null) continue;
                    iomObj = this.createIomObject(viewable.getScopedName(), oid.getValue());
                    try {
                        iomObj = this.readObject(event, viewable, iomObj, srsDimension);
                        continue;
                    }
                    catch (XMLStreamException ex) {
                        throw new IoxException((Throwable)ex);
                    }
                }
                if (event.isCharacters()) {
                    characters = (Characters)event;
                    if (characters.isWhiteSpace()) continue;
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 6) {
                if (event.isCharacters()) {
                    characters = (Characters)event;
                    if (characters.isWhiteSpace()) continue;
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                if (event.isEndElement()) {
                    this.state = 7;
                    continue;
                }
                if (event.isStartElement()) {
                    this.state = 5;
                    continue;
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 7) {
                if (event.isStartElement()) {
                    this.state = 5;
                    continue;
                }
                if (event.isCharacters()) {
                    characters = (Characters)event;
                    if (characters.isWhiteSpace()) continue;
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                if (event.isEndElement()) {
                    this.state = 9;
                    ArrayList<IomObject> objList = this.associationBuilder();
                    if (objList != null) {
                        this.linkIterator = objList.iterator();
                        if (this.linkIterator != null && this.linkIterator.hasNext()) {
                            IomObject assocObj = this.linkIterator.next();
                            return new ObjectEvent(assocObj);
                        }
                    }
                    this.linkIterator = null;
                    this.state = 8;
                    return new EndBasketEvent();
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state == 9) {
                throw new IllegalStateException("state=PRE_ENDBASKET");
            }
            if (this.state == 8) {
                if (event.isStartElement()) {
                    this.state = 3;
                    continue;
                }
                if (event.isCharacters()) {
                    characters = (Characters)event;
                    if (characters.isWhiteSpace()) continue;
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                if (event.isEndElement()) {
                    this.state = 11;
                    continue;
                }
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (this.state != 11) continue;
            if (event.isCharacters()) {
                characters = (Characters)event;
                if (characters.isWhiteSpace()) continue;
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            if (event.isEndElement()) {
                this.state = 12;
                return new EndTransferEvent();
            }
            if (event.isEndDocument()) {
                this.state = 12;
                return new EndTransferEvent();
            }
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        return null;
    }

    private ArrayList<IomObject> associationBuilder() throws IoxException {
        ArrayList<IomObject> assocIomObjects = new ArrayList<IomObject>();
        Iterator<IomObject> linkIterator = this.linkPool.getLinkObjects();
        if (linkIterator == null) {
            return null;
        }
        if (linkIterator.hasNext()) {
            IomObject assocLink = linkIterator.next();
            assocIomObjects.add(assocLink);
        }
        return assocIomObjects;
    }

    private Integer srsDimensionValidation(Integer srsDimension, XMLEvent event) {
        QName srsName = new QName("srsDimension");
        if (srsDimension == null) {
            StartElement element = (StartElement)event;
            if (element.getAttributeByName(srsName) != null) {
                Integer dimensionValue = Integer.parseInt(event.asStartElement().getAttributeByName(srsName).getValue());
                return dimensionValue;
            }
            return srsDimension;
        }
        return srsDimension;
    }

    private IomObject readObject(XMLEvent event, Viewable aClass, IomObject iomObj, Integer srsDimension) throws IoxException, XMLStreamException {
        String attrName = null;
        while (this.reader.hasNext()) {
            try {
                event = this.reader.nextEvent();
                event = this.skipSpaces(event);
            }
            catch (XMLStreamException ex) {
                throw new IoxException((Throwable)ex);
            }
            if (attrName != null) {
                throw new IllegalStateException("attrName != null");
            }
            if (event.isStartElement()) {
                XMLEvent peekEvent;
                StartElement element = (StartElement)event;
                QName qName = element.getName();
                Element prop = this.getIliProperty(aClass, qName);
                if (prop == null) {
                    throw new IoxSyntaxException("unexpected element: " + qName.getLocalPart());
                }
                attrName = prop.getName();
                srsDimension = this.srsDimensionValidation(srsDimension, event);
                XMLEvent peekEvent2 = this.reader.peek();
                if (!peekEvent2.isEndElement()) {
                    event = this.reader.nextEvent();
                }
                if (!(peekEvent = this.reader.peek()).isEndElement()) {
                    event = this.skipSpaces(event);
                }
                if (event.isCharacters() && prop instanceof AttributeDef) {
                    Characters character = (Characters)event;
                    String characterValue = character.getData();
                    iomObj.setattrvalue(attrName, characterValue);
                    event = this.reader.nextEvent();
                    if (event.isEndElement()) {
                        attrName = null;
                        continue;
                    }
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                if (event.isEndElement()) {
                    attrName = null;
                    continue;
                }
                if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_POINT)) {
                    srsDimension = this.srsDimensionValidation(srsDimension, event);
                    event = this.reader.nextEvent();
                    if (!(event = this.skipSpaces(event)).isStartElement()) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    iomObj.addattrobj(attrName, this.prepareSegments(event, srsDimension));
                    event = this.reader.nextEvent();
                    event = this.skipSpaces(event);
                    if (event.isEndElement()) {
                        attrName = null;
                        return iomObj;
                    }
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_CURVE)) {
                    srsDimension = this.srsDimensionValidation(srsDimension, event);
                    IomObject polyline = this.readCurve(event, srsDimension);
                    iomObj.addattrobj(attrName, polyline);
                    event = this.reader.nextEvent();
                    event = this.skipSpaces(event);
                    if (event.isEndElement()) {
                        attrName = null;
                        return iomObj;
                    }
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_LINESTRING) || event.isStartElement() && event.asStartElement().getName().equals(QNAME_ORIENTABLECURVE) || event.isStartElement() && event.asStartElement().getName().equals(QNAME_COMPOSITECURVE)) {
                    throw new IoxSyntaxException("unsupported geometry " + event.asStartElement().getName().getLocalPart());
                }
                if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_POLYGON)) {
                    srsDimension = this.srsDimensionValidation(srsDimension, event);
                    IomObject subIomObj = this.createIomObject("MULTISURFACE", null);
                    iomObj.addattrobj(attrName, this.readPolygon(event, subIomObj, srsDimension));
                    if (!event.isStartElement()) {
                        throw new IoxSyntaxException(this.event2msgtext(event));
                    }
                    event = this.reader.nextEvent();
                    event = this.skipSpaces(event);
                    return iomObj;
                }
                Element attrElement = this.getIliProperty(aClass, qName);
                if (attrElement instanceof RoleDef) {
                    AssociationDef association;
                    Container elementContainer;
                    RoleDef role = (RoleDef)attrElement;
                    if (role.getContainer() == null || !((elementContainer = role.getContainer()) instanceof AssociationDef) || !((association = (AssociationDef)elementContainer) instanceof Viewable)) continue;
                    AssociationDef viewable = association;
                    iomObj = this.readReference(aClass, iomObj, element, role, association);
                    event = this.reader.nextEvent();
                    event = this.reader.nextEvent();
                    attrName = null;
                    continue;
                }
                QName subQName = ((StartElement)event).getName();
                Viewable iliStruct = this.getIliClass(subQName);
                if (iliStruct == null) {
                    String xmlCollection = Iligml20Reader.collectXMLElement(this.reader, event);
                    iomObj.setattrvalue(attrName, xmlCollection);
                    attrName = null;
                    continue;
                }
                IomObject structObj = this.createIomObject(iliStruct.getName(), null);
                iomObj.addattrobj(attrName, this.readObject(event, iliStruct, structObj, srsDimension));
                if (!event.isStartElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                if (!(event = this.skipSpaces(event)).isEndElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                if (!(event = this.skipSpaces(event)).isEndElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                return iomObj;
            }
            if (event.isEndElement() && attrName == null) {
                return iomObj;
            }
            if (event.isEndElement() && attrName != null) {
                if (!(event = this.skipSpaces(event)).isEndElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                attrName = null;
                continue;
            }
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        return null;
    }

    private IomObject readReference(Viewable aclass, IomObject iomObj, StartElement element, RoleDef role, AssociationDef association) throws IoxSyntaxException {
        String refOid = element.getAttributeByName(QNAME_HREF).getValue();
        if (refOid.length() <= 1 || !refOid.startsWith("#")) {
            throw new IoxSyntaxException("unexpected reference format " + refOid);
        }
        refOid = refOid.substring(1);
        if (aclass.isExtending((Element)association)) {
            iomObj.addattrobj(role.getName(), "REF").setobjectrefoid(refOid);
        } else if (association.isLightweight()) {
            if (this.isEmbeddedRole(role)) {
                iomObj.addattrobj(role.getName(), "REF").setobjectrefoid(refOid);
            }
        } else {
            this.linkPool.addAssocLink(association, role, iomObj.getobjectoid(), refOid);
        }
        return iomObj;
    }

    private boolean isEmbeddedRole(RoleDef role) {
        return role.getOppEnd().isAssociationEmbedded();
    }

    private static String collectXMLElement(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
        XMLOutputFactory xmloutputf = XMLOutputFactory.newInstance();
        xmloutputf.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        XMLEventFactory xmlef = XMLEventFactory.newInstance();
        StringWriter strw = new StringWriter();
        XMLEventWriter xmlw = xmloutputf.createXMLEventWriter(strw);
        xmlw.add(xmlef.createStartDocument());
        xmlw.add(event);
        int inHeader = 1;
        while (reader.hasNext()) {
            event = reader.nextEvent();
            xmlw.add(event);
            switch (event.getEventType()) {
                case 1: {
                    ++inHeader;
                    break;
                }
                case 2: {
                    --inHeader;
                }
            }
            if (inHeader == 0 && event.getEventType() == 2) break;
            if (inHeader >= 0) continue;
            throw new IllegalStateException("inHeader < 0");
        }
        xmlw.add(xmlef.createEndDocument());
        xmlw.flush();
        xmlw.close();
        return strw.toString();
    }

    private XMLEvent skipSpaces(XMLEvent event) throws XMLStreamException, IoxSyntaxException {
        while (event.isCharacters()) {
            Characters characters = (Characters)event;
            if (!characters.isWhiteSpace()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.reader.nextEvent();
        }
        return event;
    }

    private IomObject readCurve(XMLEvent event, Integer srsDimension) throws IoxException, XMLStreamException {
        srsDimension = this.srsDimensionValidation(srsDimension, event);
        if (!event.asStartElement().getName().equals(QNAME_CURVE)) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.reader.nextEvent();
        if (!(event = this.skipSpaces(event)).asStartElement().getName().equals(QNAME_SEGMENTS)) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        IomObject polylineObj = this.createIomObject("POLYLINE", null);
        if (!event.isStartElement()) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpaces(event);
        QName interpolationType = new QName("interpolation");
        String interpolationValue = "";
        while (event.isStartElement()) {
            StartElement element = (StartElement)event;
            if (element.getAttributeByName(interpolationType) != null) {
                interpolationValue = element.getAttributeByName(interpolationType).getValue();
            }
            if (interpolationValue != null && interpolationValue.equals(INTERPOLATIION_LINEAR)) {
                srsDimension = this.srsDimensionValidation(srsDimension, event);
                if (!event.isStartElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                event = this.skipSpaces(event);
                polylineObj.addattrobj("sequence", this.prepareSegments(event, srsDimension));
                if (!event.isStartElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                event = this.skipSpaces(event);
            } else if (interpolationValue != null && interpolationValue.equals(INTERPOLATIION_CIRCULARARC3POINTS)) {
                srsDimension = this.srsDimensionValidation(srsDimension, event);
                polylineObj.addattrobj("sequence", this.readArcSegment(event, srsDimension));
                if (!event.isStartElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                event = this.skipSpaces(event);
            } else {
                throw new IoxSyntaxException("unsupported interpolation " + interpolationValue);
            }
            if (!event.isEndElement()) continue;
            event = this.reader.nextEvent();
            event = this.skipSpaces(event);
        }
        return polylineObj;
    }

    private IomObject prepareSegments(XMLEvent event, Integer srsDimension) throws IoxException, XMLStreamException {
        IomObject segments = this.createIomObject("SEGMENTS", null);
        if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_POS)) {
            srsDimension = this.srsDimensionValidation(srsDimension, event);
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.reader.nextEvent();
            if (event.isCharacters()) {
                if (srsDimension == null) {
                    throw new IoxSyntaxException("syntax error no srsDimension defined");
                }
                Characters posData = (Characters)event;
                String[] linearSegments = posData.getData().split(" ");
                for (int i = 0; i < linearSegments.length; ++i) {
                    IomObject linearSegment;
                    ArrayList<String> segmentList = new ArrayList<String>();
                    if (srsDimension.equals(1)) {
                        if (i + 2 > linearSegments.length) {
                            throw new IoxSyntaxException("missing coord values for 1d Coord");
                        }
                        segmentList.add(linearSegments[i]);
                        linearSegment = this.readLineSegment(segmentList);
                        segments.addattrobj("segment", linearSegment);
                        continue;
                    }
                    if (srsDimension.equals(2)) {
                        if (i + 2 > linearSegments.length) {
                            throw new IoxSyntaxException("missing coord values for 2d Coord");
                        }
                        segmentList.add(linearSegments[i]);
                        segmentList.add(linearSegments[++i]);
                        linearSegment = this.readLineSegment(segmentList);
                        segments.addattrobj("segment", linearSegment);
                        continue;
                    }
                    if (srsDimension.equals(3)) {
                        if (i + 3 > linearSegments.length) {
                            throw new IoxSyntaxException("missing coord values for 3d Coord");
                        }
                        segmentList.add(linearSegments[i]);
                        segmentList.add(linearSegments[++i]);
                        segmentList.add(linearSegments[++i]);
                        linearSegment = this.readLineSegment(segmentList);
                        segments.addattrobj("segment", linearSegment);
                        continue;
                    }
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                if (!event.isEndElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                event = this.skipSpaces(event);
                return segments;
            }
        }
        return null;
    }

    private IomObject readArcSegment(XMLEvent event, Integer srsDimension) throws IoxException, XMLStreamException {
        srsDimension = this.srsDimensionValidation(srsDimension, event);
        if (!event.isStartElement()) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.reader.nextEvent();
        if ((event = this.skipSpaces(event)).isStartElement() && event.asStartElement().getName().equals(QNAME_POS)) {
            srsDimension = this.srsDimensionValidation(srsDimension, event);
            IomObject arcObj = this.createIomObject("ARC", null);
            event = this.reader.nextEvent();
            if (event.isCharacters()) {
                if (srsDimension == null) {
                    throw new IoxSyntaxException("no srsDimension defined");
                }
                Characters posData = (Characters)event;
                String[] arcPositions = posData.getData().split(" ");
                if (arcPositions.length < 4) {
                    throw new IoxSyntaxException("missing arc pos values");
                }
                if (arcPositions.length > 0) {
                    arcObj.setattrvalue("A1", arcPositions[0]);
                }
                if (arcPositions.length > 1) {
                    arcObj.setattrvalue("A2", arcPositions[1]);
                }
                if (arcPositions.length > 2) {
                    arcObj.setattrvalue("C1", arcPositions[2]);
                }
                if (arcPositions.length > 3) {
                    arcObj.setattrvalue("C2", arcPositions[3]);
                }
                if (arcPositions.length > 4) {
                    arcObj.setattrvalue("C3", arcPositions[4]);
                }
                if (arcPositions.length > 5) {
                    throw new IoxSyntaxException("too many arc pos values");
                }
                event = this.reader.nextEvent();
                if (!event.isEndElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                event = this.reader.nextEvent();
                if (!(event = this.skipSpaces(event)).isEndElement()) {
                    throw new IoxSyntaxException(this.event2msgtext(event));
                }
                return arcObj;
            }
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        if (event.isEndElement()) {
            throw new IoxSyntaxException("missing arc pos element");
        }
        throw new IoxSyntaxException(this.event2msgtext(event));
    }

    private IomObject readLineSegment(ArrayList<String> coords) throws IoxException {
        IomObject coordObj = this.createIomObject("COORD", null);
        for (String coord : coords) {
            coord = coord.trim();
        }
        if (coords.size() < 1) {
            throw new IoxSyntaxException("missing coord pos values");
        }
        if (coords.size() > 0) {
            coordObj.setattrvalue("C1", coords.get(0));
        }
        if (coords.size() > 1) {
            coordObj.setattrvalue("C2", coords.get(1));
        }
        if (coords.size() > 2) {
            coordObj.setattrvalue("C3", coords.get(2));
        }
        if (coords.size() > 5) {
            throw new IoxSyntaxException("too many coord pos values");
        }
        return coordObj;
    }

    private IomObject readPolygon(XMLEvent event, IomObject iomObj, Integer srsDimension) throws IoxException, XMLStreamException {
        IomObject boundaryObj = this.createIomObject("BOUNDARY", null);
        IomObject surfaceObj = this.createIomObject("SURFACE", null);
        IomObject polygonObj = this.createIomObject("MULTISURFACE", null);
        if (!event.isStartElement()) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.reader.nextEvent();
        if (!(event = this.skipSpaces(event)).isStartElement()) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        int exteriorExist = 0;
        while (event.isStartElement() && (event.asStartElement().getName().equals(QNAME_EXTERIOR) || event.asStartElement().getName().equals(QNAME_INTERIOR))) {
            if (event.asStartElement().getName().equals(QNAME_EXTERIOR)) {
                ++exteriorExist;
            } else if (event.asStartElement().getName().equals(QNAME_INTERIOR) && exteriorExist == 0) {
                throw new IoxSyntaxException("no exterior ring found");
            }
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpaces(event);
            boundaryObj = this.readBoundary(event, surfaceObj, srsDimension);
            surfaceObj.addattrobj("boundary", boundaryObj);
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpaces(event);
        }
        if (exteriorExist == 0) {
            throw new IoxSyntaxException("no lines found in polygon of " + iomObj.getobjecttag());
        }
        polygonObj.addattrobj("surface", surfaceObj);
        return polygonObj;
    }

    private String event2msgtext(XMLEvent event) {
        String output = "";
        if (event instanceof StartElement) {
            output = "unexpected start element " + event.asStartElement().getName().getLocalPart();
        } else if (event instanceof EndElement) {
            output = "unexpected end element " + event.asEndElement().getName().getLocalPart();
        } else if (event instanceof Characters) {
            output = "unexpected characters " + ((Characters)event).getData();
        }
        return output;
    }

    private IomObject readBoundary(XMLEvent event, IomObject surfaceObj, Integer srsDimension) throws IoxException, XMLStreamException {
        IomObject boundaryObj = this.createIomObject("BOUNDARY", null);
        if (!event.asStartElement().getName().equals(QNAME_RING)) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpaces(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_CURVEMEMBER)) {
            srsDimension = this.srsDimensionValidation(srsDimension, event);
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpaces(event);
            boundaryObj.addattrobj("polyline", this.readCurve(event, srsDimension));
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.event2msgtext(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpaces(event);
        }
        if (!event.isEndElement()) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.reader.nextEvent();
        if (!(event = this.skipSpaces(event)).isEndElement()) {
            throw new IoxSyntaxException(this.event2msgtext(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpaces(event);
        return boundaryObj;
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    private void ObjectComposition(StartElement element) {
    }

    @Override
    public void setModel(TransferDescription td) {
        this.td = td;
    }

    private void fillIliMaps() {
        this.iliTopics = new HashMap();
        this.iliClasses = new HashMap();
        this.iliProperties = new HashMap();
        if (this.td == null) {
            return;
        }
        for (Object modelObj : this.td) {
            if (!(modelObj instanceof DataModel)) continue;
            DataModel model = (DataModel)modelObj;
            for (Object topicObj : model) {
                if (!(topicObj instanceof Topic)) continue;
                Topic topic = (Topic)topicObj;
                String localTopicPart = topic.getName();
                String modelNameSpace = model.getMetaValue(METAATTR_NAMESPACE);
                if (modelNameSpace == null) {
                    modelNameSpace = NAMESPACE_ILIGMLBASE + model.getName();
                }
                QName topicQName = new QName(modelNameSpace, localTopicPart);
                this.iliTopics.put(topicQName, topic);
                for (Object classObj : topic) {
                    if (!(classObj instanceof Viewable)) continue;
                    Viewable viewable = (Viewable)classObj;
                    String localClassPart = viewable.getName();
                    String nameSpace = model.getMetaValue(METAATTR_NAMESPACE);
                    if (nameSpace == null) {
                        nameSpace = NAMESPACE_ILIGMLBASE + model.getName();
                    }
                    QName classQName = new QName(nameSpace, localClassPart);
                    HashMap<QName, Element> transferElements = null;
                    if (this.iliTopics.containsKey(classQName) || this.iliClasses.containsKey(classQName)) {
                        localClassPart = topic.getName() + "." + viewable.getName();
                        QName extendedClassQName = new QName(nameSpace, localClassPart);
                        this.iliClasses.put(extendedClassQName, viewable);
                    } else {
                        this.iliClasses.put(classQName, viewable);
                    }
                    Iterator elementIter = Iligml20Generator.getAttributesAndRoles2((Viewable)viewable);
                    transferElements = new HashMap<QName, Element>();
                    Element element = null;
                    while (elementIter.hasNext()) {
                        ViewableTransferElement obj = (ViewableTransferElement)elementIter.next();
                        if (!(obj.obj instanceof Element)) continue;
                        element = (Element)obj.obj;
                        String elementName = element.getName();
                        QName eleQName = new QName(nameSpace, elementName);
                        transferElements.put(eleQName, element);
                    }
                    this.iliProperties.put(viewable, transferElements);
                }
            }
        }
    }

    private String getIliTopic(QName qName) {
        Topic topic;
        if (this.iliTopics == null) {
            this.fillIliMaps();
        }
        if ((topic = this.iliTopics.get(qName)) != null) {
            return topic.getScopedName();
        }
        String topicName = qName.getLocalPart();
        String xmlNs = qName.getNamespaceURI();
        if (xmlNs.startsWith(NAMESPACE_ILIGMLBASE)) {
            String modelName = xmlNs.substring(NAMESPACE_ILIGMLBASE.length());
            return modelName + "." + topicName;
        }
        return null;
    }

    private Viewable getIliClass(QName qName) {
        if (this.iliClasses == null) {
            this.fillIliMaps();
        }
        return this.iliClasses.get(qName);
    }

    private Element getIliProperty(Viewable aClass, QName qName) throws IoxException {
        if (this.iliProperties == null) {
            this.fillIliMaps();
        }
        HashMap<QName, Element> iliPropIter = this.iliProperties.get(aClass);
        return iliPropIter.get(qName);
    }

    @Override
    public void setTopicFilter(String[] topicNames) {
    }

    @Override
    public String getMimeType() {
        return "application/gml+xml;version=3.2";
    }
}

