/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool.impl.btree;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.iox.objpool.impl.LongSerializer;
import ch.ehi.iox.objpool.impl.Serializer;
import ch.ehi.iox.objpool.impl.btree.Entry;
import ch.ehi.iox.objpool.impl.btree.Node;
import ch.ehi.iox.objpool.impl.btree.NodeId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class BTree<Key, Value> {
    static final int M = 16;
    private NodeId root;
    private int height;
    private int n;
    private Serializer<Key> keySerializer;
    private Serializer<Value> valueSerializer;
    Comparator<Key> keyComparator;
    private RandomAccessFile file;
    private File fileName = null;
    public static final int BLOCK_SIZE = 8192;
    private int pageCount = 0;
    private static int MAX_CACHE = 32;
    private String poolName = null;
    private final LinkedHashMap<NodeId, Node> cache = new LinkedHashMap<NodeId, Node>(MAX_CACHE, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<NodeId, Node> eldest) {
            Node node = eldest.getValue();
            if (this.size() < MAX_CACHE) {
                return false;
            }
            if (node.isDirty()) {
                BTree.this.writeNode(node);
            }
            return true;
        }
    };
    private long maxKeySize = 0L;
    private long minKeySize = 0L;
    private long maxValueSize = 0L;
    private long minValueSize = 0L;

    protected void touchNode(NodeId nodeId) {
        this.cache.get(nodeId);
    }

    private void writeNode(Node node) {
        try {
            ArrayList<Long> pages = node.getOverflowPages();
            byte[] bytes = node.getBytes();
            int blockSize = 8184;
            int pagec = (bytes.length - 1) / 8184 + 1;
            if (pagec > pages.size() + 1) {
                for (int i = pages.size() + 1; i < pagec; ++i) {
                    pages.add(this.allocPage().getPageId());
                }
            }
            long blockId = node.getNodeId().getPageId();
            for (int i = 0; i < pagec; ++i) {
                long nextPage = -1L;
                if (i < pages.size()) {
                    nextPage = pages.get(i);
                }
                if (i > 0) {
                    blockId = pages.get(i - 1);
                }
                this.file.seek(blockId * 8192L);
                this.file.writeLong(nextPage);
                if (bytes.length < (i + 1) * 8184) {
                    this.file.write(bytes, i * 8184, bytes.length - i * 8184);
                    continue;
                }
                this.file.write(bytes, i * 8184, 8184);
            }
            node.setOverflowPages(pages);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Node<Key, Value> getNode(NodeId nodeId) {
        Node ret = this.cache.get(nodeId);
        if (ret != null) {
            return ret;
        }
        try {
            ArrayList<Long> pages = new ArrayList<Long>();
            long blockId = nodeId.getPageId();
            this.file.seek(blockId * 8192L);
            long nextBlock = this.file.readLong();
            byte[] buffer = new byte[8184];
            this.file.read(buffer);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write(buffer);
            while (nextBlock != -1L) {
                pages.add(nextBlock);
                blockId = nextBlock;
                this.file.seek(blockId * 8192L);
                nextBlock = this.file.readLong();
                this.file.read(buffer);
                bytes.write(buffer);
            }
            Node node = Node.read(this, nodeId, bytes.toByteArray());
            node.setOverflowPages(pages);
            return node;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public BTree(File path, Comparator<Key> keyComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        this(null, path, keyComparator, keySerializer, valueSerializer);
    }

    public BTree(String poolName, File path, Comparator<Key> keyComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        this.poolName = poolName;
        this.keyComparator = keyComparator;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.fileName = path;
        this.file = new RandomAccessFile(path, "rw");
        this.height = 0;
        this.n = 0;
        this.root = new Node(this, this.allocPage(), 0).getNodeId();
    }

    private NodeId allocPage() {
        NodeId ret = new NodeId(this.pageCount);
        ++this.pageCount;
        return ret;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.n;
    }

    public int height() {
        return this.height;
    }

    public Value get(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("argument to get() is null");
        }
        return this.search(this.getNode(this.root), key, this.height);
    }

    private Value search(Node<Key, Value> currentNode, Key key, int ht) {
        if (ht == 0) {
            for (int j = 0; j < currentNode.getEntryCount(); ++j) {
                if (!this.eq(key, currentNode.getEntry(j).getKey())) continue;
                return currentNode.getEntry(j).getVal();
            }
        } else {
            for (int j = 0; j < currentNode.getEntryCount(); ++j) {
                if (j + 1 != currentNode.getEntryCount() && !this.less(key, currentNode.getEntry(j + 1).getKey())) continue;
                return this.search(this.getNode(currentNode.getEntry(j).getChildNode()), key, ht - 1);
            }
        }
        return null;
    }

    public void put(Key key, Value val) {
        if (key == null) {
            throw new IllegalArgumentException("argument key to put() is null");
        }
        Node u = this.insert(this.getNode(this.root), key, val, this.height);
        ++this.n;
        if (u == null) {
            return;
        }
        Node t = new Node(this, this.allocPage(), 2);
        t.setEntry(0, new Entry<Key, Object>(this.getNode(this.root).getEntry(0).getKey(), null, this.root));
        t.setEntry(1, new Entry(u.getEntry(0).getKey(), null, u.getNodeId()));
        this.root = t.getNodeId();
        ++this.height;
    }

    private Node insert(Node<Key, Value> h, Key key, Value val, int ht) {
        int j;
        Entry<Key, Object> t = new Entry<Key, Value>(key, val, null);
        if (ht == 0) {
            for (j = 0; j < h.getEntryCount(); ++j) {
                if (this.eq(key, h.getEntry(j).getKey())) {
                    h.setEntry(j, t);
                    return null;
                }
                if (!this.less(key, h.getEntry(j).getKey())) {
                    continue;
                }
                break;
            }
        } else {
            for (j = 0; j < h.getEntryCount(); ++j) {
                if (j + 1 != h.getEntryCount() && !this.less(key, h.getEntry(j + 1).getKey())) continue;
                NodeId childNode = h.getEntry(j).getChildNode();
                Node u = this.insert(this.getNode(childNode), key, val, ht - 1);
                ++j;
                if (u == null) {
                    return null;
                }
                t = new Entry(u.getEntry(0).getKey(), null, u.getNodeId());
                break;
            }
        }
        h = this.getNode(h.getNodeId());
        for (int i = h.getEntryCount(); i > j; --i) {
            h.setEntry(i, h.getEntry(i - 1));
        }
        h.setEntry(j, t);
        h.setEntryCount(h.getEntryCount() + 1);
        if (h.getEntryCount() < 16) {
            return null;
        }
        return this.split(h);
    }

    private Node split(Node fullNode) {
        Node newNode = new Node(this, this.allocPage(), 8);
        fullNode.setEntryCount(8);
        for (int j = 0; j < 8; ++j) {
            newNode.setEntry(j, fullNode.getEntry(8 + j));
        }
        return newNode;
    }

    public String toString() {
        return this.toString(this.getNode(this.root), this.height, "") + "\n";
    }

    private String toString(Node h, int ht, String indent) {
        StringBuilder s = new StringBuilder();
        if (ht == 0) {
            for (int j = 0; j < h.getEntryCount(); ++j) {
                s.append(indent + h.getEntry(j).getKey() + " " + h.getEntry(j).getVal() + "\n");
            }
        } else {
            for (int j = 0; j < h.getEntryCount(); ++j) {
                if (j > 0) {
                    s.append(indent + h.getNodeId() + ": (" + h.getEntry(j).getKey() + ")\n");
                }
                s.append(this.toString(this.getNode(h.getEntry(j).getChildNode()), ht - 1, indent + "     "));
            }
        }
        return s.toString();
    }

    private boolean less(Key k1, Key k2) {
        return this.keyComparator.compare(k1, k2) < 0;
    }

    private boolean eq(Key k1, Key k2) {
        return this.keyComparator.compare(k1, k2) == 0;
    }

    public void writeInt(ByteArrayOutputStream outFile, int val) throws IOException {
        byte[] intBuf = new byte[4];
        LongSerializer.integerToBytes(val, intBuf, 0);
        outFile.write(intBuf);
    }

    private int readInt(ByteArrayInputStream outFile) throws IOException {
        byte[] bytes = new byte[4];
        outFile.read(bytes);
        return LongSerializer.bytesToInteger(bytes, 0);
    }

    public void serialzeKey(ByteArrayOutputStream outFile, Key key) throws IOException {
        byte[] bytes = this.keySerializer.getBytes(key);
        this.writeInt(outFile, bytes.length);
        outFile.write(bytes);
        this.maxKeySize = Math.max(this.maxKeySize, (long)bytes.length);
        this.minKeySize = Math.min(this.minKeySize, (long)bytes.length);
    }

    public void serialzeValue(ByteArrayOutputStream outFile, Value val) throws IOException {
        byte[] bytes = this.valueSerializer.getBytes(val);
        this.writeInt(outFile, bytes.length);
        outFile.write(bytes);
        this.maxValueSize = Math.max(this.maxValueSize, (long)bytes.length);
        this.minValueSize = Math.min(this.minValueSize, (long)bytes.length);
    }

    public Key deserialzeKey(ByteArrayInputStream outFile) throws IOException {
        int size = this.readInt(outFile);
        byte[] bytes = new byte[size];
        outFile.read(bytes);
        try {
            return this.keySerializer.getObject(bytes);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object deserialzeValue(ByteArrayInputStream outFile) throws IOException {
        int size = this.readInt(outFile);
        byte[] bytes = new byte[size];
        outFile.read(bytes);
        try {
            return this.valueSerializer.getObject(bytes);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void cachePut(NodeId nodeId, Node node) {
        this.cache.put(nodeId, node);
    }

    public void close() throws IOException {
        if (this.file != null) {
            String tag = this.poolName != null ? this.poolName : this.getClass().getSimpleName();
            EhiLogger.traceState((String)(tag + ": size " + this.size() + ", filesize " + this.file.length() + " <" + this.fileName.getPath() + ">"));
            EhiLogger.traceState((String)(tag + ": keySize min " + this.minKeySize + ", max " + this.maxKeySize));
            EhiLogger.traceState((String)(tag + ": valueSize min " + this.minValueSize + ", max " + this.maxValueSize));
            this.file.close();
            this.file = null;
        }
        if (this.fileName != null) {
            this.fileName.delete();
            this.fileName = null;
        }
    }

    public NodeId getRoot() {
        return this.root;
    }
}

