/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class RuntimeParameters {
    public static final String MINIMAL_RUNTIME_SYSTEM01_CURRENT_TRANSFERFILE = "MinimalRuntimeSystem01.CurrentTransferfile";
    public static final String MINIMAL_RUNTIME_SYSTEM01_CURRENT_DATE_TIME = "MinimalRuntimeSystem01.CurrentDateTime";
    public static final String MINIMAL_RUNTIME_SYSTEM01_CURRENT_USER_NAME = "MinimalRuntimeSystem01.CurrentUserName";
    public static final String MINIMAL_RUNTIME_SYSTEM01_HOST_NAME = "MinimalRuntimeSystem01.HostName";
    public static final String MINIMAL_RUNTIME_SYSTEM01_OPERATING_SYSTEM_NAME = "MinimalRuntimeSystem01.OperatingSystemName";
    public static final String MINIMAL_RUNTIME_SYSTEM01_RUNTIME_SYSTEM_VERSION = "MinimalRuntimeSystem01.RuntimeSystemVersion";
    public static final String MINIMAL_RUNTIME_SYSTEM01_RUNTIME_SYSTEM_NAME = "MinimalRuntimeSystem01.RuntimeSystemName";
    private HashMap<String, Object> values = new HashMap();
    private ArrayList<String> orderedKeys = null;

    public RuntimeParameters() {
        this(false);
    }

    public RuntimeParameters(boolean keepOrderOfDefs) {
        if (keepOrderOfDefs) {
            this.orderedKeys = new ArrayList();
        }
    }

    public RuntimeParameters(RuntimeParameters src) {
        if (src != null) {
            Iterator<String> it = src.getNamesIterator();
            while (it.hasNext()) {
                String name = it.next();
                Object obj = src.values.get(name);
                this.setValue(name, obj);
            }
        }
    }

    public static void initDefaultValues(RuntimeParameters src) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date today = new Date();
        String dateOut = dateFormatter.format(today);
        src.setValue(MINIMAL_RUNTIME_SYSTEM01_CURRENT_DATE_TIME, dateOut);
        src.setValue(MINIMAL_RUNTIME_SYSTEM01_CURRENT_USER_NAME, System.getProperty("user.name"));
        src.setValue(MINIMAL_RUNTIME_SYSTEM01_OPERATING_SYSTEM_NAME, System.getProperty("os.name"));
    }

    public Object getValue(String name) {
        Object value = this.values.get(name);
        return value;
    }

    public void setValue(String name, Object value) {
        if (value == null) {
            if (this.orderedKeys != null && this.orderedKeys.contains(name)) {
                this.orderedKeys.remove(name);
            }
            this.values.remove(name);
        } else {
            if (this.orderedKeys != null && !this.orderedKeys.contains(name)) {
                this.orderedKeys.add(name);
            }
            this.values.put(name, value);
        }
    }

    public Set<String> getNames() {
        return this.values.keySet();
    }

    public Iterator<String> getNamesIterator() {
        if (this.orderedKeys != null) {
            return this.orderedKeys.iterator();
        }
        return this.values.keySet().iterator();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Iterator<String> it = this.getNamesIterator();
        if (it.hasNext()) {
            String sep = "";
            ret.append("RuntimeParameters{");
            while (it.hasNext()) {
                String name = it.next();
                Object obj = this.values.get(name);
                ret.append(sep + name + "=" + obj.toString());
                sep = ";";
            }
            ret.append("}");
        }
        return ret.toString();
    }
}

