/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import java.util.List;

public class GraphicParameterDef
extends AbstractLeafElement {
    private String name = null;
    private Type domain = null;

    @Override
    protected void linkTranslationOf(Element baseElement) {
        super.linkTranslationOf(baseElement);
        Type type = this.getDomain();
        Type baseType = ((GraphicParameterDef)baseElement).getDomain();
        if (type.getClass().equals(baseType.getClass())) {
            type.linkTranslationOf(baseType);
        }
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        Type type = this.getDomain();
        GraphicParameterDef baseElement = (GraphicParameterDef)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        Type baseType = baseElement.getDomain();
        if (type.getClass() != baseType.getClass()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), GraphicParameterDef.formatMessage("err_diff_graphicparamType", this.getScopedName(), baseElement.getScopedName())));
            return;
        }
        if (type instanceof TypeAlias && ((TypeAlias)type).getAliasing().getTranslationOfOrSame() != ((TypeAlias)baseType).getAliasing().getTranslationOfOrSame()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), GraphicParameterDef.formatMessage("err_diff_graphicparamType", this.getScopedName(), baseElement.getScopedName())));
            return;
        }
        try {
            type.checkTranslationOf(errs, this.getScopedName(), baseElement.getScopedName());
            if (type instanceof AbstractCoordType) {
                String crs = ((AbstractCoordType)type).getCrs(this);
                String originCrs = ((AbstractCoordType)baseType).getCrs(baseElement);
                if (crs != null || originCrs != null) {
                    if (crs == null || originCrs == null) {
                        throw new Ili2cSemanticException();
                    }
                    if (!crs.equals(originCrs)) {
                        throw new Ili2cSemanticException();
                    }
                }
            }
        }
        catch (Ili2cSemanticException ex) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), GraphicParameterDef.formatMessage("err_diff_graphicparamType", this.getScopedName(), baseElement.getScopedName())));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Type getDomain() {
        return this.domain;
    }

    public void setDomain(Type domain) {
        this.domain = domain;
    }
}

