/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.tools;

import ch.ehi.basics.tools.Visitable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractVisitor {
    public void visit(Object object) {
        if (object == null) {
            return;
        }
        Method method = this.getMethod(object.getClass());
        try {
            method.invoke((Object)this, object);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(ex.getTargetException().getLocalizedMessage());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex.getLocalizedMessage());
        }
        if (object instanceof Visitable) {
            this.callEnumerate((Visitable)object);
        }
    }

    public void defaultVisit(Object o) {
    }

    protected Method getMethod(Class c) {
        Class newc = c;
        Method m = null;
        while (m == null && newc != Object.class) {
            String method = newc.getName();
            method = "visit" + method.substring(method.lastIndexOf(46) + 1);
            try {
                m = this.getClass().getMethod(method, newc);
            }
            catch (NoSuchMethodException e) {
                newc = newc.getSuperclass();
            }
        }
        if (newc == Object.class) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String method = interfaces[i].getName();
                method = "visit" + method.substring(method.lastIndexOf(46) + 1);
                try {
                    m = this.getClass().getMethod(method, interfaces[i]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        if (m == null) {
            try {
                m = this.getClass().getMethod("defaultVisit", Object.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m;
    }

    public void callEnumerate(Visitable visitable) {
        visitable.enumerateChildren(this);
    }
}

