/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.logging;

import ch.ehi.basics.logging.AbstractFilteringListener;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.StdLogEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FileListener
extends AbstractFilteringListener {
    private PrintWriter out = null;
    private File file = null;
    private boolean doTimeStamp = false;

    @Override
    public void outputMsgLine(int arg0, int arg1, String msg) {
        if (this.out == null) {
            try {
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
            }
            catch (IOException ex) {
                EhiLogger.getInstance().logInternalEventFromListener(this, new StdLogEvent(7, null, ex, null));
            }
        }
        if (this.out != null) {
            if (msg.endsWith("\n")) {
                this.out.print(msg);
            } else {
                this.out.println(msg);
            }
            this.out.flush();
        }
    }

    @Override
    public String getTimestamp() {
        if (!this.doTimeStamp) {
            return null;
        }
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
        dfm.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        String stmp = dfm.format(new Date()) + "Z";
        return stmp;
    }

    public FileListener(File file1) {
        this.file = file1;
    }

    public FileListener(File file1, boolean doTimeStamp1) {
        this.file = file1;
        this.doTimeStamp = doTimeStamp1;
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

