/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.ViewableProperty;
import ch.interlis.iom_j.xtf.OidSpace;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iom_j.xtf.impl.AbstractXtfWriterAlt;
import ch.interlis.iom_j.xtf.impl.XMLStreamWriterAdapter;
import ch.interlis.iox.IoxException;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.StringBufferInputStream;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class XtfWriterAlt
extends AbstractXtfWriterAlt {
    private ViewableProperties mapping = null;
    public static final String ili22Ns = "http://www.interlis.ch/INTERLIS2.2";
    public static final String ili23Ns = "http://www.interlis.ch/INTERLIS2.3";
    private static String iliNs = "http://www.interlis.ch/INTERLIS2.3";
    private boolean isIli22 = false;
    private XMLInputFactory inputFactory = null;

    public XtfWriterAlt(OutputStreamWriter buffer, ViewableProperties mapping1, String version) throws IoxException {
        this.mapping = mapping1;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            this.xout = outputFactory.createXMLStreamWriter(new BufferedWriter(buffer));
            String encoding = Charset.forName(buffer.getEncoding()).name();
            this.xout.writeStartDocument(encoding, "1.0");
            if (version != null && version.equals("2.2")) {
                iliNs = ili22Ns;
                this.isIli22 = true;
            } else {
                iliNs = ili23Ns;
                this.isIli22 = false;
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeStartTransfer(String sender, String comment, XtfModel[] models) throws IoxException {
        this.writeStartTransfer(sender, comment, models, null);
    }

    @Override
    public void writeStartTransfer(String sender, String comment, XtfModel[] models, XtfStartTransferEvent e) throws IoxException {
        try {
            this.xout.setDefaultNamespace(iliNs);
            this.xout.writeStartElement(iliNs, "TRANSFER");
            this.xout.writeDefaultNamespace(iliNs);
            this.newline();
            this.xout.writeStartElement(iliNs, "HEADERSECTION");
            if (sender == null || sender.length() == 0) {
                sender = "IOX";
            }
            this.xout.writeAttribute("SENDER", sender);
            this.xout.writeAttribute("VERSION", this.isIli22 ? "2.2" : "2.3");
            if (this.isIli22) {
                this.xout.writeStartElement(iliNs, "ALIAS");
                this.xout.writeEndElement();
            } else {
                this.xout.writeStartElement(iliNs, "MODELS");
                if (models == null || models.length == 0) {
                    throw new IoxException("no models given");
                }
                for (int i = 0; i < models.length; ++i) {
                    XtfModel model = models[i];
                    this.xout.writeStartElement(iliNs, "MODEL");
                    this.xout.writeAttribute("NAME", model.getName());
                    this.xout.writeAttribute("VERSION", model.getVersion());
                    this.xout.writeAttribute("URI", model.getUri());
                    this.xout.writeEndElement();
                }
                this.xout.writeEndElement();
                if (e != null && e.getOidSpaces().size() > 0) {
                    this.xout.writeStartElement(iliNs, "OIDSPACES");
                    for (OidSpace oidspace : e.getOidSpaces()) {
                        this.xout.writeStartElement(iliNs, "OIDSPACE");
                        this.xout.writeAttribute("NAME", oidspace.getName());
                        this.xout.writeAttribute("OIDDOMAIN", oidspace.getOiddomain());
                        this.xout.writeEndElement();
                    }
                    this.xout.writeEndElement();
                }
            }
            this.writeElementStringOptional("COMMENT", comment);
            this.xout.writeEndElement();
            this.newline();
            this.xout.writeStartElement(iliNs, "DATASECTION");
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeEndTransfer() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.newline();
            this.xout.writeEndElement();
            this.xout.writeEndDocument();
            this.xout.flush();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
        this.xout = null;
    }

    @Override
    public void writeStartBasket(String type, String bid) throws IoxException {
        this.writeStartBasket(type, bid, 0, 0, null, null, null, null);
    }

    @Override
    public void writeStartBasket(String type, String bid, int consistency, int kind, String startstate, String endstate, String[] topicv, String domains) throws IoxException {
        try {
            this.xout.writeStartElement(iliNs, type);
            this.xout.writeAttribute("BID", this.makeOid(bid));
            this.writeAttributeStringOptional("KIND", XtfWriterAlt.encodeBasketKind(kind));
            if (kind != 0) {
                if (kind == 1) {
                    this.xout.writeAttribute("STARTSTATE", startstate);
                }
                this.xout.writeAttribute("ENDSTATE", endstate);
            }
            this.writeAttributeStringOptional("CONSISTENCY", XtfWriterAlt.encodeConsistency(consistency));
            if (topicv != null && topicv.length > 0) {
                StringBuffer tb = new StringBuffer();
                String sep = "";
                for (int i = 0; i < topicv.length; ++i) {
                    String t = topicv[i];
                    if (t == null || (t = t.trim()).length() <= 0) continue;
                    tb.append(t);
                    tb.append(sep);
                    sep = ",";
                }
                this.writeAttributeStringOptional("TOPICS", tb.toString());
            }
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeEndBasket() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    @Override
    public void writeObject(IomObject obj) throws IoxException {
        try {
            this.xout.writeStartElement(iliNs, obj.getobjecttag());
            this.writeAttributeStringOptional("TID", this.makeOid(obj.getobjectoid()));
            this.writeAttributeStringOptional("OPERATION", XtfWriterAlt.encodeOperation(obj.getobjectoperation()));
            this.writeAttributeStringOptional("CONSISTENCY", XtfWriterAlt.encodeConsistency(obj.getobjectconsistency()));
            this.writeObjAttrs(obj);
            this.xout.writeEndElement();
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeObjAttrs(IomObject obj) throws IoxException {
        String tag = obj.getobjecttag();
        if (this.mapping != null && this.mapping.existsClass(tag)) {
            ViewableProperty[] attrv = this.mapping.getClassVProperties(tag);
            for (int i = 0; i < attrv.length; ++i) {
                this.writeObjAttr(obj, attrv[i]);
            }
        } else {
            if (!this.unkClsv.contains(tag)) {
                EhiLogger.logError("unknown class " + tag);
                this.unkClsv.add(tag);
            }
            for (int i = 0; i < obj.getattrcount(); ++i) {
                this.writeObjAttr(obj, new ViewableProperty(obj.getattrname(i)));
            }
        }
    }

    private void writeObjAttr(IomObject obj, ViewableProperty attr) throws IoxException {
        String attrName = attr.getName();
        try {
            int valueCount = obj.getattrvaluecount(attrName);
            if (valueCount > 0) {
                String val = obj.getattrprim(attrName, 0);
                if (val == null) {
                    IomObject child = obj.getattrobj(attrName, 0);
                    if (child != null) {
                        if (child.getobjecttag().equals("COORD")) {
                            this.xout.writeStartElement(iliNs, attrName);
                            this.writeCoord(child);
                            this.xout.writeEndElement();
                            if (valueCount > 1) {
                                throw new IoxException("max one COORD value allowed (" + attrName + ")");
                            }
                        } else if (child.getobjecttag().equals("POLYLINE")) {
                            this.xout.writeStartElement(iliNs, attrName);
                            this.writePolyline(child, false);
                            this.xout.writeEndElement();
                            if (valueCount > 1) {
                                throw new IoxException("max one POLYLINE value allowed (" + attrName + ")");
                            }
                        } else if (child.getobjecttag().equals("MULTISURFACE")) {
                            this.xout.writeStartElement(iliNs, attrName);
                            this.writeSurface(child);
                            this.xout.writeEndElement();
                            if (valueCount > 1) {
                                throw new IoxException("max one MULTISURFACE value allowed (" + attrName + ")");
                            }
                        } else {
                            boolean isRef;
                            String aref = child.getobjectrefoid();
                            boolean bl = isRef = aref != null;
                            if (isRef) {
                                String orderpos = null;
                                if (child.getobjectreforderpos() > 0L) {
                                    orderpos = Long.toString(child.getobjectreforderpos());
                                }
                                String extref = null;
                                String bid = child.getobjectrefbid();
                                if (bid != null) {
                                    extref = aref;
                                    aref = null;
                                }
                                this.xout.writeStartElement(iliNs, attrName);
                                if (aref != null) {
                                    this.xout.writeAttribute("REF", this.makeOid(aref));
                                } else {
                                    this.xout.writeAttribute("EXTREF", this.makeOid(extref));
                                    this.xout.writeAttribute("BID", this.makeOid(bid));
                                }
                                this.writeAttributeStringOptional("ORDER_POS", orderpos);
                                if (child.getattrcount() > 0) {
                                    this.xout.writeStartElement(iliNs, child.getobjecttag());
                                    this.writeObjAttrs(child);
                                    this.xout.writeEndElement();
                                }
                                this.xout.writeEndElement();
                                if (valueCount > 1) {
                                    throw new IoxException("max one reference value allowed (" + attrName + ")");
                                }
                            } else {
                                this.xout.writeStartElement(iliNs, attrName);
                                int valuei = 0;
                                while (true) {
                                    this.xout.writeStartElement(iliNs, child.getobjecttag());
                                    this.writeObjAttrs(child);
                                    this.xout.writeEndElement();
                                    if (++valuei >= valueCount) break;
                                    child = obj.getattrobj(attrName, valuei);
                                }
                                this.xout.writeEndElement();
                            }
                        }
                    }
                } else {
                    if (attr.isTypeOid()) {
                        if ((val = val.trim()).length() > 0) {
                            this.xout.writeStartElement(iliNs, attrName);
                            this.xout.writeAttribute("OID", this.makeOid(val));
                            this.xout.writeEndElement();
                        }
                    } else if (attr.isTypeBlackboxBin()) {
                        if ((val = val.trim()).length() > 0) {
                            this.xout.writeStartElement(iliNs, attrName);
                            this.xout.writeStartElement(iliNs, "BINBLBOX");
                            this.xout.writeCharacters(val);
                            int rest = val.length() % 2;
                            if (rest == 2) {
                                this.xout.writeCharacters("==");
                            } else if (rest == 1) {
                                this.xout.writeCharacters("=");
                            }
                            this.xout.writeEndElement();
                            this.xout.writeEndElement();
                        }
                    } else if (attr.isTypeBlackboxXml()) {
                        if ((val = val.trim()).length() > 0) {
                            this.xout.writeStartElement(iliNs, attrName);
                            this.xout.writeStartElement(iliNs, "XMLBLBOX");
                            if (this.inputFactory == null) {
                                this.inputFactory = XMLInputFactory.newInstance();
                            }
                            XMLEventReader xmlReader = this.inputFactory.createXMLEventReader(new StringBufferInputStream(val));
                            while (xmlReader.hasNext()) {
                                XMLEvent event = xmlReader.nextEvent();
                                if (event.getEventType() == 7 || event.getEventType() == 8) continue;
                                XMLStreamWriterAdapter.add(this.xout, event);
                            }
                            this.xout.writeEndElement();
                            this.xout.writeEndElement();
                        }
                    } else {
                        this.writeElementStringOptional(attrName, val);
                    }
                    if (valueCount > 1) {
                        throw new IoxException("max one primitive-type value allowed (" + attrName + ")");
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeCoord(IomObject obj) throws IoxException {
        try {
            this.xout.writeStartElement(iliNs, "COORD");
            String c1 = obj.getattrprim("C1", 0);
            this.writeElementStringOptional("C1", c1);
            String c2 = obj.getattrprim("C2", 0);
            if (c2 != null) {
                this.writeElementStringOptional("C2", c2);
                String c3 = obj.getattrprim("C3", 0);
                if (c3 != null) {
                    this.writeElementStringOptional("C3", c3);
                }
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeArc(IomObject obj) throws IoxException {
        try {
            this.xout.writeStartElement(iliNs, "ARC");
            String c1 = obj.getattrprim("C1", 0);
            this.writeElementStringOptional("C1", c1);
            String c2 = obj.getattrprim("C2", 0);
            this.writeElementStringOptional("C2", c2);
            String c3 = obj.getattrprim("C3", 0);
            if (c3 != null) {
                this.writeElementStringOptional("C3", c3);
            }
            String a1 = obj.getattrprim("A1", 0);
            this.writeElementStringOptional("A1", a1);
            String a2 = obj.getattrprim("A2", 0);
            this.writeElementStringOptional("A2", a2);
            String r = obj.getattrprim("R", 0);
            if (r != null) {
                this.writeElementStringOptional("R", r);
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writePolyline(IomObject obj, boolean hasLineAttr) throws IoxException {
        try {
            IomObject lineattr;
            this.xout.writeStartElement(iliNs, "POLYLINE");
            if (hasLineAttr && (lineattr = obj.getattrobj("lineattr", 0)) != null) {
                this.xout.writeStartElement(iliNs, "LINEATTR");
                this.xout.writeStartElement(iliNs, lineattr.getobjecttag());
                this.writeObjAttrs(lineattr);
                this.xout.writeEndElement();
                this.xout.writeEndElement();
            }
            boolean clipped = obj.getobjectconsistency() == 1;
            for (int sequencei = 0; sequencei < obj.getattrvaluecount("sequence"); ++sequencei) {
                if (clipped) {
                    this.xout.writeStartElement(iliNs, "CLIPPED");
                } else if (sequencei > 0) {
                    throw new IllegalArgumentException("unclipped polyline with multi 'sequence' elements");
                }
                IomObject sequence = obj.getattrobj("sequence", sequencei);
                for (int segmenti = 0; segmenti < sequence.getattrvaluecount("segment"); ++segmenti) {
                    IomObject segment = sequence.getattrobj("segment", segmenti);
                    if (segment.getobjecttag().equals("COORD")) {
                        this.writeCoord(segment);
                        continue;
                    }
                    if (segment.getobjecttag().equals("ARC")) {
                        this.writeArc(segment);
                        continue;
                    }
                    this.xout.writeStartElement(iliNs, segment.getobjecttag());
                    this.writeObjAttrs(segment);
                    this.xout.writeEndElement();
                }
                if (!clipped) continue;
                this.xout.writeEndElement();
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeSurface(IomObject obj) throws IoxException {
        try {
            this.xout.writeStartElement(iliNs, "SURFACE");
            boolean clipped = obj.getobjectconsistency() == 1;
            for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
                if (clipped) {
                    this.xout.writeStartElement(iliNs, "CLIPPED");
                } else if (surfacei > 0) {
                    throw new IllegalArgumentException("unclipped surface with multi 'surface' elements");
                }
                IomObject surface = obj.getattrobj("surface", surfacei);
                for (int boundaryi = 0; boundaryi < surface.getattrvaluecount("boundary"); ++boundaryi) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    this.xout.writeStartElement(iliNs, "BOUNDARY");
                    for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        this.writePolyline(polyline, true);
                    }
                    this.xout.writeEndElement();
                }
                if (!clipped) continue;
                this.xout.writeEndElement();
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeElementStringOptional(String name, String value) throws IoxException {
        try {
            if (value != null && value.length() > 0) {
                this.xout.writeStartElement(iliNs, name);
                this.xout.writeCharacters(value);
                this.xout.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeAttributeStringOptional(String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeAttribute(name, v);
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private static String encodeConsistency(int consistency) {
        String ret = null;
        switch (consistency) {
            case 1: {
                ret = "INCOMPLETE";
                break;
            }
            case 2: {
                ret = "INCONSISTENT";
                break;
            }
            case 3: {
                ret = "ADAPTED";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private static String encodeBasketKind(int kind) {
        String ret = null;
        switch (kind) {
            case 1: {
                ret = "UPDATE";
                break;
            }
            case 2: {
                ret = "INITIAL";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private static String encodeOperation(int ops) {
        String ret = null;
        switch (ops) {
            case 1: {
                ret = "UPDATE";
                break;
            }
            case 2: {
                ret = "DELETE";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private String makeOid(String value) {
        String v;
        if (value != null && (v = value.trim()).length() > 0) {
            if (this.isIli22) {
                return "x" + v;
            }
            return v;
        }
        return null;
    }
}

