/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf;

import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelUtilities {
    public static final String HELPER_TABLE_MAIN_TABLE_REF_PREFIX = "_itf_ref_";
    public static final String HELPER_TABLE_MAIN_TABLE_REF2_PREFIX = "_itf_ref2_";
    public static final String HELPER_TABLE_GEOM_ATTR_PREFIX = "_itf_geom_";

    private ModelUtilities() {
    }

    public static HashMap getTagMap(TransferDescription td) {
        HashMap<String, Element> ret = new HashMap<String, Element>();
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Model model;
            Object mObj = modeli.next();
            if (!(mObj instanceof Model) || (model = (Model)mObj) instanceof TypeModel) continue;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Object tObj = topici.next();
                if (tObj instanceof Topic) {
                    Topic topic = (Topic)tObj;
                    for (Viewable<?> obj : topic.getViewables()) {
                        if (!(obj instanceof Viewable)) continue;
                        Viewable<?> v = obj;
                        String className = v.getScopedName((Container)null);
                        ret.put(className, v);
                        Iterator<Extendable> attri = v.getAttributes();
                        while (attri.hasNext()) {
                            AttributeDef attr;
                            Type type;
                            Extendable attrObj = attri.next();
                            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceOrAreaType)) continue;
                            String name = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + attr.getName();
                            ret.put(name, attr);
                        }
                    }
                    continue;
                }
                if (!(tObj instanceof Viewable)) continue;
                Viewable v = (Viewable)tObj;
                ret.put(v.getScopedName((Container)null), v);
                Iterator<Extendable> attri = v.getAttributes();
                while (attri.hasNext()) {
                    AttributeDef attr;
                    Type type;
                    Extendable attrObj = attri.next();
                    if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceOrAreaType)) continue;
                    String name = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + attr.getName();
                    ret.put(name, attr);
                }
            }
        }
        return ret;
    }

    public static HashMap getTagMap2(TransferDescription td) {
        HashMap<String, Viewable> ret = new HashMap<String, Viewable>();
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Model model;
            Object mObj = modeli.next();
            if (!(mObj instanceof Model) || (model = (Model)mObj) instanceof TypeModel) continue;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Object tObj = topici.next();
                if (tObj instanceof Topic) {
                    Topic topic = (Topic)tObj;
                    for (Viewable<?> obj : topic.getViewables()) {
                        if (!(obj instanceof Viewable)) continue;
                        Viewable<?> v = obj;
                        String className = v.getScopedName((Container)null);
                        ret.put(className, v);
                    }
                    continue;
                }
                if (!(tObj instanceof Viewable)) continue;
                Viewable v = (Viewable)tObj;
                ret.put(v.getScopedName((Container)null), v);
            }
        }
        return ret;
    }

    public static ArrayList getItfTables(TransferDescription td, Topic topic) {
        ArrayList<Element> ret = new ArrayList<Element>();
        for (Viewable<?> obj : topic.getViewables()) {
            AttributeDef attr;
            Type type;
            Extendable attrObj;
            Viewable<?> v;
            if (!(obj instanceof Viewable) || (v = obj) instanceof Table && !((Table)v).isIdentifiable() || ModelUtilities.isPureRefAssoc(v)) continue;
            Iterator<Extendable> attri = null;
            attri = v.getAttributes();
            while (attri.hasNext()) {
                attrObj = attri.next();
                if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof AreaType)) continue;
                ret.add(attr);
            }
            ret.add(v);
            attri = v.getAttributes();
            while (attri.hasNext()) {
                attrObj = attri.next();
                if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceType)) continue;
                ret.add(attr);
            }
        }
        return ret;
    }

    public static ArrayList getItfTables(TransferDescription td, String modelName, String topicName) {
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Model model;
            Object mObj = modeli.next();
            if (!(mObj instanceof Model) || !(model = (Model)mObj).getName().equals(modelName)) continue;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Topic topic;
                Object tObj = topici.next();
                if (!(tObj instanceof Topic) || !(topic = (Topic)tObj).getName().equals(topicName)) continue;
                return ModelUtilities.getItfTables(td, topic);
            }
        }
        return null;
    }

    public static ArrayList getPolylineAttrs(AbstractClassDef table) {
        ArrayList<AttributeDef> ret = new ArrayList<AttributeDef>();
        Iterator<Extendable> iter = table.getAttributes();
        while (iter.hasNext()) {
            AttributeDef attr = (AttributeDef)iter.next();
            Type type = Type.findReal(attr.getDomain());
            if (!(type instanceof PolylineType)) continue;
            ret.add(attr);
        }
        return ret;
    }

    public static ArrayList getIli1AttrList(AbstractClassDef table) {
        ArrayList<ViewableTransferElement> attrlist = new ArrayList<ViewableTransferElement>();
        Iterator<Element> iter = table.getAttributesAndRoles();
        while (iter.hasNext()) {
            Element obj = iter.next();
            if (obj instanceof AttributeDef) {
                attrlist.add(new ViewableTransferElement(obj));
                continue;
            }
            if (!(obj instanceof RoleDef) || ((AssociationDef)table).isLightweight()) continue;
            attrlist.add(new ViewableTransferElement(obj, false));
        }
        ArrayList<RoleDef> rolesSorted = new ArrayList<RoleDef>(table.getLightweightAssociations());
        Collections.sort(rolesSorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                int idx2;
                int idx1 = ((RoleDef)o1).getIli1AttrIdx();
                if (idx1 == (idx2 = ((RoleDef)o2).getIli1AttrIdx())) {
                    return 0;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                if (idx1 < idx2) {
                    return -1;
                }
                return 1;
            }
        });
        for (RoleDef role : rolesSorted) {
            RoleDef oppend = role.getOppEnd();
            if (role.getIli1AttrIdx() == -1) {
                attrlist.add(new ViewableTransferElement(oppend, true));
                continue;
            }
            attrlist.add(role.getIli1AttrIdx(), new ViewableTransferElement(oppend, true));
        }
        return attrlist;
    }

    public static HashSet getEnumTypes(TransferDescription td) {
        HashSet<Element> ret = new HashSet<Element>();
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object mObj = modeli.next();
            if (!(mObj instanceof Model)) continue;
            Model model = (Model)mObj;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Type type;
                Object tObj = topici.next();
                if (tObj instanceof Domain) {
                    Domain domain = (Domain)tObj;
                    Type type2 = domain.getType();
                    if (!(type2 instanceof EnumerationType)) continue;
                    ret.add(domain);
                    continue;
                }
                if (tObj instanceof Topic) {
                    Topic topic = (Topic)tObj;
                    for (Viewable<?> obj : topic.getViewables()) {
                        if (obj instanceof Domain) {
                            Domain domain = (Domain)((Object)obj);
                            type = domain.getType();
                            if (!(type instanceof EnumerationType)) continue;
                            ret.add(domain);
                            continue;
                        }
                        if (!(obj instanceof Viewable)) continue;
                        Viewable<?> v = obj;
                        Iterator<Extendable> attri = v.getAttributes();
                        while (attri.hasNext()) {
                            AttributeDef attr;
                            Type type3;
                            Extendable attrObj = attri.next();
                            if (!(attrObj instanceof AttributeDef) || !((type3 = (attr = (AttributeDef)attrObj).getDomain()) instanceof EnumerationType)) continue;
                            ret.add(attr);
                        }
                    }
                    continue;
                }
                if (!(tObj instanceof Viewable)) continue;
                Viewable v = (Viewable)tObj;
                Iterator<Extendable> attri = v.getAttributes();
                while (attri.hasNext()) {
                    AttributeDef attr;
                    Extendable attrObj = attri.next();
                    if (!(attrObj instanceof AttributeDef) || !((type = (attr = (AttributeDef)attrObj).getDomain()) instanceof EnumerationType)) continue;
                    ret.add(attr);
                }
            }
        }
        return ret;
    }

    public static String code2string(int code) throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{(byte)code};
        return new String(bytes, "ISO-8859-1");
    }

    public static void buildEnumList(List accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                ModelUtilities.buildEnumList(accu, prefix + ee.getName(), subEnum);
                continue;
            }
            accu.add(prefix + ee.getName());
        }
    }

    public static void buildEnumListAll(List accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            accu.add(prefix + ee.getName());
            if (subEnum == null) continue;
            ModelUtilities.buildEnumListAll(accu, prefix + ee.getName(), subEnum);
        }
    }

    public static void buildEnumElementList(List<Map.Entry<String, Enumeration.Element>> accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                ModelUtilities.buildEnumElementList(accu, prefix + ee.getName(), subEnum);
                continue;
            }
            accu.add(new AbstractMap.SimpleEntry<String, Enumeration.Element>(prefix + ee.getName(), ee));
        }
    }

    public static void buildEnumElementListAll(List<Map.Entry<String, Enumeration.Element>> accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            accu.add(new AbstractMap.SimpleEntry<String, Enumeration.Element>(prefix + ee.getName(), ee));
            if (subEnum == null) continue;
            ModelUtilities.buildEnumElementListAll(accu, prefix + ee.getName(), subEnum);
        }
    }

    public static String getHelperTableMainTableRef(AttributeDef attr) {
        return HELPER_TABLE_MAIN_TABLE_REF_PREFIX + attr.getContainer().getName();
    }

    public static String getHelperTableMainTableRef2(AttributeDef attr) {
        return HELPER_TABLE_MAIN_TABLE_REF2_PREFIX + attr.getContainer().getName();
    }

    public static String getHelperTableGeomAttrName(AttributeDef attr) {
        return HELPER_TABLE_GEOM_ATTR_PREFIX + attr.getContainer().getName();
    }

    public static boolean isPureRefAssoc(Viewable v) {
        if (!(v instanceof AssociationDef)) {
            return false;
        }
        AssociationDef assoc = (AssociationDef)v;
        return assoc.isLightweight() && !assoc.getAttributes().hasNext() && !assoc.getLightweightAssociations().iterator().hasNext();
    }
}

