/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.TopoSort;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.metamodel.Ili2cMetaAttrs;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.Dataset;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliResolver;
import ch.interlis.ilirepository.ReposManager;
import ch.interlis.ilirepository.impl.DataFinder;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.ilirepository.impl.RepositoryCrawler;
import ch.interlis.ilirepository.impl.RepositoryVisitor;
import ch.interlis.models.DatasetIdx16.DataFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class IliManager
implements ReposManager {
    public static final String ILISITE_XML = "ilisite.xml";
    public static final String ILIMODELS_XML = "ilimodels.xml";
    public static final String ILIDATA_XML = "ilidata.xml";
    public static final String ILIDATA_URI_PREFIX = "ilidata:";
    public static final String FILE_URI_PREFIX = "file:";
    public static final String HTTP_URI_PREFIX = "http:";
    public static final String HTTPS_URI_PREFIX = "https:";
    private long iliMaxTTL = 604800000L;
    private long dataMaxTTL = 43200000L;
    private RepositoryAccess rep = new RepositoryAccess();
    private RepositoryCrawler iliCrawler = new RepositoryCrawler(this.rep);
    private DataFinder dataFinder = new DataFinder();
    private RepositoryVisitor dataCrawler = new RepositoryVisitor(this.rep, this.dataFinder);

    public void setRepositories(String[] uriv) {
        for (String uri : uriv) {
            EhiLogger.traceState("uri <" + uri + ">");
        }
        this.iliCrawler.setRepositories(uriv);
        this.dataCrawler.setRepositories(uriv);
    }

    public void setIliFiles(String uri, IliFiles iliFiles) {
        if (uri != null && iliFiles != null) {
            EhiLogger.traceState("uri <" + uri + ">");
            this.rep.setIliFiles(uri, iliFiles);
        }
    }

    public IliFiles getIliFiles(String uri) {
        if (uri != null) {
            EhiLogger.traceState("uri <" + uri + ">");
            return this.rep.getIliFiles(uri);
        }
        return null;
    }

    public IliResolver getResolver() {
        return this.rep.getResolver();
    }

    public void setResolver(IliResolver resolver) {
        this.rep.setResolver(resolver);
    }

    public void setCache(File localdir) {
        this.rep.setCache(localdir);
    }

    public Configuration getConfigWithFiles(ArrayList<String> requiredIliFileNames) throws Ili2cException {
        return this.getConfigWithFiles(requiredIliFileNames, null);
    }

    public Configuration getConfigWithFiles(ArrayList<String> requiredIliFileNames, Ili2cMetaAttrs metaAttrs) throws Ili2cException {
        return this.getConfigWithFiles(requiredIliFileNames, metaAttrs, 0.0);
    }

    public Configuration getConfigWithFiles(ArrayList<String> requiredIliFileNames, Ili2cMetaAttrs metaAttrs, double version) throws Ili2cException {
        if (requiredIliFileNames.isEmpty()) {
            throw new Ili2cException("no ili files given");
        }
        HashSet<IliFile> ilifiles = new HashSet<IliFile>();
        HashSet<IliFile> toVisitFiles = new HashSet<IliFile>();
        Iterator<String> reqFileIt = requiredIliFileNames.iterator();
        HashSet<String> availablemodels = new HashSet<String>();
        while (reqFileIt.hasNext()) {
            IliModel modelEle;
            Iterator modeli2;
            IliModel model1;
            IliModel model;
            String translationOf;
            Iterator modeli;
            String fname = reqFileIt.next();
            if (GenericFileFilter.getFileExtension(fname) != null) {
                IliModel model2;
                File file = new File(fname);
                if (!file.exists()) {
                    throw new Ili2cException(fname + ": There is no such file.");
                }
                IliFile iliFile = ModelScan.scanIliFile(file);
                if (iliFile == null) {
                    throw new Ili2cException(fname + ": Failed to scan ili-file.");
                }
                if (iliFile == null) continue;
                boolean skipThisFile = false;
                modeli = iliFile.iteratorModel();
                while (modeli.hasNext()) {
                    model2 = (IliModel)modeli.next();
                    if (version == 0.0) {
                        version = model2.getIliVersion();
                    } else if (version != model2.getIliVersion()) {
                        skipThisFile = true;
                        EhiLogger.logAdaption("different ili version; file ignored " + iliFile.getFilename());
                        break;
                    }
                    if (availablemodels.contains(model2.getName())) {
                        skipThisFile = true;
                        EhiLogger.logAdaption("duplicate model; file ignored " + iliFile.getFilename());
                        break;
                    }
                    if (metaAttrs == null || (translationOf = metaAttrs.getMetaAttrValue(model2.getName(), "ili2c.translationOf")) == null) continue;
                    model2.addDepenedency(translationOf);
                }
                if (skipThisFile) continue;
                ilifiles.add(iliFile);
                toVisitFiles.add(iliFile);
                modeli = iliFile.iteratorModel();
                while (modeli.hasNext()) {
                    model2 = (IliModel)modeli.next();
                    availablemodels.add(model2.getName());
                }
                continue;
            }
            if (version == 0.0) {
                String firstModel = fname;
                model = null;
                IliFile ilifile = this.iliCrawler.getIliFileMetadataDeep(firstModel, 0.0, true);
                if (ilifile != null) {
                    modeli = ilifile.iteratorModel();
                    while (modeli.hasNext()) {
                        model1 = (IliModel)modeli.next();
                        if (!model1.getName().equals(firstModel)) continue;
                        version = model1.getIliVersion();
                        model = model1;
                        ilifiles.add(ilifile);
                        toVisitFiles.add(ilifile);
                        modeli2 = ilifile.iteratorModel();
                        while (modeli2.hasNext()) {
                            modelEle = (IliModel)modeli2.next();
                            availablemodels.add(modelEle.getName());
                        }
                        if (metaAttrs == null || (translationOf = metaAttrs.getMetaAttrValue(model.getName(), "ili2c.translationOf")) == null) break;
                        model.addDepenedency(translationOf);
                        break;
                    }
                }
                if (model != null) continue;
                throw new Ili2cException(firstModel + ": model not found");
            }
            String modelname = fname;
            if (availablemodels.contains(modelname)) continue;
            model = null;
            IliFile ilifile = this.iliCrawler.getIliFileMetadataDeep(modelname, version, true);
            if (ilifile != null) {
                modeli = ilifile.iteratorModel();
                while (modeli.hasNext()) {
                    model1 = (IliModel)modeli.next();
                    if (!model1.getName().equals(modelname)) continue;
                    if (version != model1.getIliVersion()) {
                        throw new Ili2cException(modelname + ": unexpected version " + model1.getIliVersion() + " found");
                    }
                    model = model1;
                    ilifiles.add(ilifile);
                    toVisitFiles.add(ilifile);
                    modeli2 = ilifile.iteratorModel();
                    while (modeli2.hasNext()) {
                        modelEle = (IliModel)modeli2.next();
                        availablemodels.add(modelEle.getName());
                    }
                    if (metaAttrs == null || (translationOf = metaAttrs.getMetaAttrValue(model.getName(), "ili2c.translationOf")) == null) break;
                    model.addDepenedency(translationOf);
                    break;
                }
            }
            if (model != null) continue;
            throw new Ili2cException(modelname + ": model not found");
        }
        return this.createConfig(toVisitFiles, version);
    }

    public Configuration getConfig(ArrayList<String> requiredModels, double iliVersion) throws Ili2cException {
        return this.getConfig(requiredModels, iliVersion, null);
    }

    public Configuration getConfig(ArrayList<String> requiredModels, double iliVersion, Ili2cMetaAttrs externalMetaAttrs) throws Ili2cException {
        HashSet<IliFile> toVisitFiles = new HashSet<IliFile>();
        if (requiredModels == null || requiredModels.size() == 0) {
            throw new Ili2cException("no models given to look for");
        }
        if (iliVersion == 0.0) {
            String firstModel = requiredModels.get(0);
            IliModel model = null;
            IliFile ilifile = this.iliCrawler.getIliFileMetadataDeep(firstModel, 0.0, true);
            if (ilifile != null) {
                Iterator modeli = ilifile.iteratorModel();
                while (modeli.hasNext()) {
                    IliModel model1 = (IliModel)modeli.next();
                    if (!model1.getName().equals(firstModel)) continue;
                    iliVersion = model1.getIliVersion();
                    model = model1;
                    toVisitFiles.add(ilifile);
                    break;
                }
            }
            if (model == null) {
                throw new Ili2cException(firstModel + ": model not found");
            }
        }
        Iterator<String> it = requiredModels.iterator();
        HashSet<String> missingModels = new HashSet<String>();
        StringBuffer errmsg = new StringBuffer();
        String sep = "";
        while (it.hasNext()) {
            IliFile file;
            String model = it.next();
            if (model == null || model.equals("INTERLIS") || (file = this.getFromSet(toVisitFiles, model, iliVersion)) != null) continue;
            file = this.iliCrawler.getIliFileMetadataDeep(model, iliVersion, true);
            if (file == null) {
                if (missingModels.contains(model)) continue;
                missingModels.add(model);
                errmsg.append(sep);
                errmsg.append(model);
                sep = ", ";
                continue;
            }
            toVisitFiles.add(file);
        }
        if (!missingModels.isEmpty()) {
            errmsg.append(": model(s) not found");
            throw new Ili2cException(errmsg.toString());
        }
        if (externalMetaAttrs != null) {
            for (IliFile ilifile : toVisitFiles) {
                Iterator modeli = ilifile.iteratorModel();
                while (modeli.hasNext()) {
                    IliModel model = (IliModel)modeli.next();
                    String translationOfName = externalMetaAttrs.getMetaAttrValue(model.getName(), "ili2c.translationOf");
                    if (translationOfName == null) continue;
                    model.addDepenedency(translationOfName);
                }
            }
        }
        return this.createConfig(toVisitFiles, iliVersion);
    }

    private Configuration createConfig(HashSet<IliFile> toVisitFiles, double iliVersion) throws Ili2cException {
        IliFile res;
        if (toVisitFiles.isEmpty()) {
            return new Configuration();
        }
        HashSet<IliFile> visitedFiles = new HashSet<IliFile>();
        TopoSort reqFiles = new TopoSort();
        HashSet<String> missingModels = new HashSet<String>();
        StringBuffer errmsg = new StringBuffer();
        String sep = "";
        while (!toVisitFiles.isEmpty()) {
            IliFile ilifile = toVisitFiles.iterator().next();
            reqFiles.add(ilifile);
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                for (String dep : model.getDependencies()) {
                    if (dep.equals("INTERLIS")) continue;
                    IliFile supplier = this.getFromSet(visitedFiles, dep, iliVersion);
                    if (supplier == null) {
                        supplier = this.getFromSet(toVisitFiles, dep, iliVersion);
                    }
                    if (supplier == null) {
                        supplier = this.iliCrawler.getIliFileMetadataDeep(dep, iliVersion, true);
                    }
                    if (supplier == null) {
                        if (missingModels.contains(dep)) continue;
                        errmsg.append(sep);
                        errmsg.append(dep);
                        sep = ", ";
                        missingModels.add(dep);
                        continue;
                    }
                    if (!visitedFiles.contains(supplier)) {
                        toVisitFiles.add(supplier);
                    }
                    if (supplier == ilifile) continue;
                    reqFiles.addcond(supplier, ilifile);
                }
            }
            toVisitFiles.remove(ilifile);
            visitedFiles.add(ilifile);
        }
        if (!missingModels.isEmpty()) {
            errmsg.append(": model(s) not found");
            throw new Ili2cException(errmsg.toString());
        }
        if (!reqFiles.sort()) {
            StringBuffer loopele = new StringBuffer();
            Iterator resi = reqFiles.getResult().iterator();
            sep = "";
            while (resi.hasNext()) {
                res = (IliFile)resi.next();
                loopele.append(sep);
                loopele.append(res.getFilename().getName());
                sep = "->";
            }
            throw new Ili2cException("loop in ili-files: " + loopele.toString());
        }
        Iterator resi = reqFiles.getResult().iterator();
        Configuration config = new Configuration();
        while (resi.hasNext()) {
            res = (IliFile)resi.next();
            File iliFile = null;
            try {
                iliFile = this.rep.getLocalFileLocation(res.getRepositoryUri(), res.getPath(), this.iliMaxTTL, res.getMd5());
                if (iliFile == null) {
                    if (res.getRepositoryUri() == null) {
                        throw new Ili2cException("failed to get ili file " + res.getPath());
                    }
                    throw new Ili2cException("failed to get ili file " + res.getRepositoryUri() + "/" + res.getPath());
                }
            }
            catch (RepositoryAccessException e) {
                if (res.getRepositoryUri() == null) {
                    throw new Ili2cException("failed to get ili file " + res.getPath(), e);
                }
                throw new Ili2cException("failed to get ili file " + res.getRepositoryUri() + "/" + res.getPath(), e);
            }
            config.addFileEntry(new FileEntry(iliFile.getPath(), 1));
        }
        return config;
    }

    private IliFile getFromSet(HashSet<IliFile> ilifiles, String modelName, double iliVersion) {
        for (IliFile ilifile : ilifiles) {
            Iterator modeli = ilifile.iteratorModel();
            while (modeli.hasNext()) {
                IliModel model = (IliModel)modeli.next();
                if (!model.getName().equals(modelName) || model.getIliVersion() != iliVersion) continue;
                return ilifile;
            }
        }
        return null;
    }

    @Override
    public List<Dataset> getDatasetIndex(String bid, String[] topics) throws RepositoryAccessException {
        this.dataFinder.setCriteria(bid, topics);
        this.dataCrawler.visitRepositories();
        return this.dataFinder.getResult();
    }

    @Override
    public File[] getLocalFileOfRemoteDataset(Dataset dataset, String fileformat) throws Ili2cException {
        DataFile fileMetadata = null;
        for (DataFile file : dataset.getMetadata().getfiles()) {
            if (!fileformat.equals(file.getfileFormat())) continue;
            fileMetadata = file;
        }
        if (fileMetadata == null) {
            throw new Ili2cException("no format <" + fileformat + "> of dataset <" + dataset.getMetadata().getid() + ">");
        }
        ch.interlis.models.DatasetIdx16.File[] paths = fileMetadata.getfile();
        File[] iliFile = new File[paths.length];
        for (int fileidx = 0; fileidx < paths.length; ++fileidx) {
            String path = paths[fileidx].getpath();
            try {
                iliFile[fileidx] = this.rep.getLocalFileLocation(dataset.getUri(), path, this.dataMaxTTL, paths[fileidx].getmd5());
                if (iliFile[fileidx] != null) continue;
                if (dataset.getUri() == null) {
                    throw new Ili2cException("failed to get data file " + path);
                }
                throw new Ili2cException("failed to get data file " + dataset.getUri() + "/" + path);
            }
            catch (RepositoryAccessException e) {
                if (dataset.getUri() == null) {
                    throw new Ili2cException("failed to get data file " + path, e);
                }
                throw new Ili2cException("failed to get data file " + dataset.getUri() + "/" + path, e);
            }
        }
        return iliFile;
    }

    public static void main(String[] args) {
        EhiLogger.getInstance().setTraceFilter(false);
        IliManager m = new IliManager();
        m.setRepositories(new String[]{"C:/tmp/test23", "http://models.interlis.ch"});
        ArrayList<String> requiredModels = new ArrayList<String>();
        ArrayList requiredFiles = new ArrayList();
        requiredModels.add("CatalogueObjects_V1");
        try {
            Configuration config = m.getConfig(requiredModels, 0.0);
            if (config != null) {
                Ili2c.logIliFiles(config);
            }
        }
        catch (Ili2cException e) {
            EhiLogger.logError(e);
        }
    }

    public static File getLocalCopyOfReposFile(IliManager repoManager, String dataFile) throws Ili2cException {
        if (dataFile.startsWith(ILIDATA_URI_PREFIX)) {
            try {
                String bid = dataFile.substring(ILIDATA_URI_PREFIX.length());
                List<Dataset> datasets = repoManager.getDatasetIndex(bid, null);
                if (datasets.size() == 0) {
                    throw new Ili2cException("file " + dataFile + " not found");
                }
                if (datasets.size() > 1) {
                    throw new Ili2cException("file " + dataFile + " ambiguous");
                }
                File[] localFiles = repoManager.getLocalFileOfRemoteDataset(datasets.get(0), IliManager.getFormat(datasets.get(0)));
                return localFiles[0];
            }
            catch (RepositoryAccessException e) {
                throw new Ili2cException("failed to get file " + dataFile, e);
            }
        }
        if (dataFile.startsWith(HTTP_URI_PREFIX) || dataFile.startsWith(HTTPS_URI_PREFIX)) {
            try {
                return repoManager.rep.getLocalFileLocation(dataFile);
            }
            catch (RepositoryAccessException e) {
                throw new Ili2cException("failed to get file " + dataFile, e);
            }
        }
        if (dataFile.startsWith(FILE_URI_PREFIX)) {
            dataFile = dataFile.substring(FILE_URI_PREFIX.length());
        }
        return new File(dataFile);
    }

    private static String getFormat(Dataset dataset) {
        int n = 0;
        DataFile[] dataFileArray = dataset.getMetadata().getfiles();
        int n2 = dataFileArray.length;
        if (n < n2) {
            DataFile file = dataFileArray[n];
            return file.getfileFormat();
        }
        return null;
    }
}

