/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.AbstractEnumerationType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EnumerationType
extends AbstractEnumerationType {
    protected boolean ordered = false;
    protected boolean circular = false;
    protected Enumeration enumeration = null;
    private ArrayList<String> cachedValues = null;

    public EnumerationType() {
    }

    public EnumerationType(Enumeration enumeration, boolean ordered, boolean circular) {
        this.ordered = ordered;
        this.circular = circular;
        this.enumeration = enumeration;
    }

    @Override
    public void setSourceLine(int sourceLine) {
        super.setSourceLine(sourceLine);
        if (this.enumeration != null) {
            this.enumeration.setSourceLine(sourceLine);
        }
    }

    @Override
    public void setOrdered(boolean ordered) throws PropertyVetoException {
        boolean oldValue = this.ordered;
        boolean newValue = ordered;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("ordered", oldValue, newValue);
        if (!newValue && this.isCircular()) {
            this.fireVetoableChange("circular", true, false);
            this.circular = false;
            this.firePropertyChange("circular", true, false);
        }
        this.ordered = newValue;
        this.firePropertyChange("ordered", oldValue, newValue);
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean circular) throws PropertyVetoException {
        boolean oldValue = this.circular;
        boolean newValue = circular;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("circular", oldValue, newValue);
        if (newValue && !this.isOrdered()) {
            this.fireVetoableChange("ordered", false, true);
            this.ordered = true;
            this.firePropertyChange("ordered", false, true);
        }
        this.circular = newValue;
        this.firePropertyChange("circular", oldValue, newValue);
    }

    public Enumeration getEnumeration() {
        return this.enumeration;
    }

    @Override
    public Enumeration getConsolidatedEnumeration() {
        if (this.extending == null) {
            return new Enumeration(this.enumeration);
        }
        Enumeration ret = ((EnumerationType)this.extending.resolveAliases()).getConsolidatedEnumeration();
        if (this.enumeration.isFinal()) {
            ret.setFinal(true);
        }
        Iterator<Enumeration.Element> elei = this.enumeration.getElements();
        while (elei.hasNext()) {
            Enumeration.Element ele = elei.next();
            EnumerationType.mergeTree(ret, ele);
        }
        return ret;
    }

    static void mergeTree(Enumeration tree, Enumeration.Element newele) {
        Iterator<Enumeration.Element> desti = tree.getElements();
        while (desti.hasNext()) {
            Enumeration.Element dest = desti.next();
            if (!dest.getName().equals(newele.getName())) continue;
            if (newele.getSubEnumeration() != null) {
                if (dest.getSubEnumeration() != null) {
                    if (newele.getSubEnumeration().isFinal()) {
                        dest.getSubEnumeration().setFinal(true);
                    }
                    Iterator<Enumeration.Element> elei = newele.getSubEnumeration().getElements();
                    while (elei.hasNext()) {
                        Enumeration.Element ele = elei.next();
                        EnumerationType.mergeTree(dest.getSubEnumeration(), ele);
                    }
                } else {
                    dest.setSubEnumeration(new Enumeration(newele.getSubEnumeration()));
                }
            }
            return;
        }
        tree.addElement(new Enumeration.Element(newele));
    }

    public void setEnumeration(Enumeration enumeration) throws PropertyVetoException {
        Enumeration oldValue = this.enumeration;
        Enumeration newValue = enumeration;
        this.fireVetoableChange("enumeration", oldValue, newValue);
        this.enumeration = newValue;
        this.firePropertyChange("enumeration", oldValue, newValue);
        this.cachedValues = null;
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        this.checkTypeExtension(wantToExtend, true);
    }

    public void checkTypeExtension(Type wantToExtend, boolean allowDuplicateLeafs) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof EnumerationType)) {
            throw new IllegalArgumentException(rsrc.getString("err_enumerationType_ExtOther"));
        }
        if (wantToExtend == this) {
            return;
        }
        EnumerationType general = (EnumerationType)wantToExtend;
        Enumeration thisEnum = this.enumeration;
        Enumeration generalEnum = general.getConsolidatedEnumeration();
        Iterator<Enumeration.Element> elei = thisEnum.getElements();
        while (elei.hasNext()) {
            Enumeration.Element ele = elei.next();
            EnumerationType.checkTree(generalEnum, ele, allowDuplicateLeafs);
        }
        this.checkCardinalityExtension(wantToExtend);
    }

    public Set getDirectExtensions() {
        return this.extendedBy;
    }

    static void checkTree(Enumeration baseTree, Enumeration.Element extEle, boolean allowDuplicateLeafs) {
        Iterator<Enumeration.Element> baseElei = baseTree.getElements();
        while (baseElei.hasNext()) {
            Enumeration.Element baseEle = baseElei.next();
            if (!baseEle.getName().equals(extEle.getName())) continue;
            if (extEle.getSubEnumeration() != null && baseEle.getSubEnumeration() != null) {
                Iterator<Enumeration.Element> elei = extEle.getSubEnumeration().getElements();
                while (elei.hasNext()) {
                    Enumeration.Element ele = elei.next();
                    EnumerationType.checkTree(baseEle.getSubEnumeration(), ele, allowDuplicateLeafs);
                }
            } else if (extEle.getSubEnumeration() == null && !allowDuplicateLeafs) {
                throw new Ili2cSemanticException(extEle.getSourceLine(), EnumerationType.formatMessage("err_enumerationType_DupEle", extEle.getName()));
            }
            return;
        }
        if (baseTree.isFinal()) {
            throw new Ili2cSemanticException(extEle.getSourceLine(), EnumerationType.formatMessage("err_enumerationType_ExtFinal", extEle.getName()));
        }
    }

    @Override
    public boolean checkStructuralEquivalence(Element with) {
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        EnumerationType other = (EnumerationType)with;
        boolean fine = true;
        if (this.isCircular() != other.isCircular()) {
            EhiLogger.logError(EnumerationType.formatMessage("err_diff_enumType_mismatchInCircularity", this.toString(), with.toString()));
            fine = false;
        }
        if (this.isOrdered() != other.isOrdered()) {
            EhiLogger.logError(EnumerationType.formatMessage("err_diff_enumType_mismatchInOrderedness", this.toString(), with.toString()));
            fine = false;
        }
        if (!this.areEnumerationsStructurallyEquivalent(this.getEnumeration(), other.getEnumeration())) {
            fine = false;
        }
        return fine;
    }

    private boolean areEnumerationsStructurallyEquivalent(Enumeration a, Enumeration b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Iterator<Enumeration.Element> iter_a = a.getElements();
        Iterator<Enumeration.Element> iter_b = b.getElements();
        while (iter_a.hasNext() && iter_b.hasNext()) {
            Enumeration.Element elt_b;
            Enumeration.Element elt_a = iter_a.next();
            if (elt_a == null != ((elt_b = iter_b.next()) == null)) {
                return false;
            }
            if (elt_a == null || elt_b == null || this.areEnumerationsStructurallyEquivalent(elt_a.getSubEnumeration(), elt_b.getSubEnumeration())) continue;
            return false;
        }
        return iter_a.hasNext() == iter_b.hasNext();
    }

    @Override
    public EnumerationType clone() {
        EnumerationType cloned = (EnumerationType)super.clone();
        if (this.enumeration != null) {
            cloned.enumeration = this.enumeration.clone();
        }
        return cloned;
    }

    public List<String> getValues() {
        if (this.cachedValues == null) {
            this.cachedValues = new ArrayList();
            EnumerationType.buildEnumList(this.cachedValues, "", this.getConsolidatedEnumeration());
        }
        return this.cachedValues;
    }

    public static void buildEnumList(List<String> accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                EnumerationType.buildEnumList(accu, prefix + ee.getName(), subEnum);
                continue;
            }
            accu.add(prefix + ee.getName());
        }
    }

    @Override
    protected void linkTranslationOf(Element baseElement) {
        super.linkTranslationOf(baseElement);
        this.enumeration.linkTranslationOf(((EnumerationType)baseElement).enumeration);
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        EnumerationType baseElement = (EnumerationType)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isCircular() != baseElement.isCircular()) {
            throw new Ili2cSemanticException();
        }
        if (this.isOrdered() != baseElement.isOrdered()) {
            throw new Ili2cSemanticException();
        }
        if (this.enumeration.isFinal() != baseElement.enumeration.isFinal()) {
            throw new Ili2cSemanticException();
        }
    }
}

