/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2fme;

import COM.safe.fmeobjects.FMEException;
import COM.safe.fmeobjects.IFMEArea;
import COM.safe.fmeobjects.IFMECurve;
import COM.safe.fmeobjects.IFMEFactoryPipeline;
import COM.safe.fmeobjects.IFMEFeature;
import COM.safe.fmeobjects.IFMEGeometry;
import COM.safe.fmeobjects.IFMEMultiArea;
import COM.safe.fmeobjects.IFMEMultiCurve;
import COM.safe.fmeobjects.IFMEMultiPoint;
import COM.safe.fmeobjects.IFMENull;
import COM.safe.fmeobjects.IFMEPath;
import COM.safe.fmeobjects.IFMEPoint;
import COM.safe.fmeobjects.IFMESession;
import COM.safe.fmeobjects.IFMEText;
import ch.interlis.ili2fme.DataException;
import ch.interlis.ili2fme.Fme2iox;
import ch.interlis.ili2fme.Iox2fme;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;

public class GeometryConverter {
    private int mode = 0;
    private IFMESession session = null;
    private IFMEFeature f = null;
    private IFMEFactoryPipeline pipe = null;
    private final String DUMMY_TYPE = "Dummy";
    private final String DUMMY_ATTR = "attr";

    public GeometryConverter(IFMESession session, int converterMode) {
        this.session = session;
        this.f = session.createFeature();
        this.mode = converterMode;
    }

    private void initPipe() throws FMEException {
        if (this.pipe == null) {
            this.pipe = this.session.createFactoryPipeline("GeometryConverter", null);
            String func = null;
            func = this.mode == 4 ? "@Geometry(FROM_ATTRIBUTE_BINARY_HEX,attr)" : (this.mode == 3 ? "@Geometry(FROM_ATTRIBUTE_BINARY,attr)" : "@Geometry(FROM_ATTRIBUTE,attr)");
            String factory = "FACTORY_DEF * TeeFactory INPUT FEATURE_TYPE Dummy OUTPUT FEATURE_TYPE Dummy " + func;
            this.pipe.addFactory(factory, " ");
        }
    }

    public void dispose() {
        if (this.f != null) {
            this.f.dispose();
            this.f = null;
        }
        if (this.pipe != null) {
            this.pipe.dispose();
            this.pipe = null;
        }
    }

    private void setGeometry(IFMEFeature ret, String attrName, IFMEGeometry fmeLine) throws DataException {
        String ATTR = "attr";
        this.f.setGeometry(fmeLine);
        String func = null;
        func = this.mode == 4 ? "@Geometry(TO_ATTRIBUTE_BINARY_HEX,attr)" : (this.mode == 3 ? "@Geometry(TO_ATTRIBUTE_BINARY,attr)" : "@Geometry(TO_ATTRIBUTE,attr)");
        try {
            this.f.performFunction(func);
        }
        catch (FMEException ex) {
            throw new DataException(ex);
        }
        try {
            if (this.mode == 3) {
                ret.setByteArrayAttribute(attrName, this.f.getByteArrayAttribute("attr"));
            } else {
                ret.setStringAttribute(attrName, this.f.getStringAttribute("attr"));
            }
        }
        catch (FMEException ex) {
            throw new DataException(ex);
        }
    }

    private IFMEGeometry getGeometry(IFMEFeature src, String srcAttr) throws DataException {
        try {
            if (this.mode == 2) {
                String val = src.getStringAttribute(srcAttr);
                IFMEGeometry geom = this.session.getGeometryTools().createGeometryFromXML(val);
                return geom;
            }
            this.initPipe();
            this.f.setFeatureType("Dummy");
            if (this.mode == 3) {
                this.f.setByteArrayAttribute("attr", src.getByteArrayAttribute(srcAttr));
            } else {
                String val = src.getStringAttribute(srcAttr);
                this.f.setStringAttribute("attr", val);
            }
            this.pipe.processFeature(this.f);
            boolean gotOne = this.pipe.getOutputFeature(this.f);
            if (!gotOne) {
                throw new DataException("failed to get feature back from pipeline");
            }
        }
        catch (FMEException ex) {
            throw new DataException(ex);
        }
        return this.f.getGeometry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coord2FME(IFMEFeature ret, String attrName, IomObject value) throws DataException {
        IFMEPoint point = null;
        try {
            point = Iox2fme.coord2FME(this.session, value);
            this.setGeometry(ret, attrName, (IFMEGeometry)point);
        }
        finally {
            if (point != null) {
                point.dispose();
                point = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multicoord2FME(IFMEFeature ret, String attrName, IomObject value) throws DataException {
        IFMEMultiPoint multiPoint = null;
        try {
            multiPoint = Iox2fme.multicoord2FME(this.session, value);
            this.setGeometry(ret, attrName, (IFMEGeometry)multiPoint);
        }
        finally {
            if (multiPoint != null) {
                multiPoint.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void polyline2FME(IFMEFeature ret, String attrName, IomObject value) throws DataException {
        IFMEPath fmeLine = null;
        try {
            fmeLine = Iox2fme.polyline2FME(this.session, value, false);
            this.setGeometry(ret, attrName, (IFMEGeometry)fmeLine);
        }
        finally {
            if (fmeLine != null) {
                fmeLine.dispose();
                fmeLine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multipolyline2FME(IFMEFeature ret, String attrName, IomObject value) throws DataException {
        IFMEMultiCurve multiCurve = null;
        try {
            multiCurve = Iox2fme.multipolyline2FME(this.session, value);
            this.setGeometry(ret, attrName, (IFMEGeometry)multiCurve);
        }
        finally {
            if (multiCurve != null) {
                multiCurve.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surface2FME(IFMEFeature ret, String attrName, IomObject value) throws DataException {
        IFMEArea fmeSurface = null;
        try {
            fmeSurface = Iox2fme.surface2FME(this.session, value);
            this.setGeometry(ret, attrName, (IFMEGeometry)fmeSurface);
        }
        finally {
            if (fmeSurface != null) {
                fmeSurface.dispose();
                fmeSurface = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutlisurface2FME(IFMEFeature ret, String attrName, IomObject value) throws DataException {
        IFMEMultiArea fmeMultiArea = null;
        try {
            fmeMultiArea = Iox2fme.multisurface2FME(this.session, value);
            this.setGeometry(ret, attrName, (IFMEGeometry)fmeMultiArea);
        }
        finally {
            if (fmeMultiArea != null) {
                fmeMultiArea.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FME2polyline(IomObject target, String targetAttr, IFMEFeature src, String srcAttr) throws DataException {
        block6: {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = this.getGeometry(src, srcAttr);
                if (fmeGeom instanceof IFMECurve) {
                    IomObject polyline = Fme2iox.FME2polyline(this.session, (IFMECurve)fmeGeom);
                    target.addattrobj(targetAttr, polyline);
                    break block6;
                }
                if (fmeGeom instanceof IFMENull) {
                    break block6;
                }
                throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                    fmeGeom = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FME2multipolyline(IomObject target, String targetAttr, IFMEFeature src, String srcAttr) throws DataException {
        block7: {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = this.getGeometry(src, srcAttr);
                if (fmeGeom instanceof IFMEMultiCurve) {
                    IomObject multipolyline = Fme2iox.FME2multipolyline(this.session, (IFMEMultiCurve)fmeGeom);
                    target.addattrobj(targetAttr, multipolyline);
                    break block7;
                }
                if (fmeGeom instanceof IFMECurve) {
                    IomObject multipolyline = Fme2iox.FME2multipolyline(this.session, (IFMECurve)fmeGeom);
                    target.addattrobj(targetAttr, multipolyline);
                    break block7;
                }
                if (fmeGeom instanceof IFMENull) {
                    break block7;
                }
                throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FME2surface(IomObject target, String targetAttr, IFMEFeature src, String srcAttr) throws DataException {
        block6: {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = this.getGeometry(src, srcAttr);
                if (fmeGeom instanceof IFMEArea) {
                    IomObject surface = Fme2iox.FME2surface(this.session, (IFMEArea)fmeGeom);
                    target.addattrobj(targetAttr, surface);
                    break block6;
                }
                if (fmeGeom instanceof IFMENull) {
                    break block6;
                }
                throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                    fmeGeom = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FME2multisurface(IomObject target, String targetAttr, IFMEFeature src, String srcAttr) throws DataException {
        block7: {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = this.getGeometry(src, srcAttr);
                if (fmeGeom instanceof IFMEMultiArea) {
                    IomObject surface = Fme2iox.FME2multisurface(this.session, (IFMEMultiArea)fmeGeom);
                    target.addattrobj(targetAttr, surface);
                    break block7;
                }
                if (fmeGeom instanceof IFMEArea) {
                    IomObject surface = Fme2iox.FME2multisurface(this.session, (IFMEArea)fmeGeom);
                    target.addattrobj(targetAttr, surface);
                    break block7;
                }
                if (fmeGeom instanceof IFMENull) {
                    break block7;
                }
                throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FME2coord(IomObject target, String targetAttr, IFMEFeature src, String srcAttr) throws DataException {
        block7: {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = this.getGeometry(src, srcAttr);
                if (fmeGeom instanceof IFMEPoint) {
                    IomObject coord = Fme2iox.FME2coord((IFMEPoint)fmeGeom);
                    target.addattrobj(targetAttr, coord);
                    break block7;
                }
                if (fmeGeom instanceof IFMEText) {
                    IomObject coord = Fme2iox.FME2coord(((IFMEText)fmeGeom).getLocationAsPoint());
                    target.addattrobj(targetAttr, coord);
                    break block7;
                }
                if (fmeGeom instanceof IFMENull) {
                    break block7;
                }
                throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                    fmeGeom = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FME2multicoord(IomObject target, String targetAttr, IFMEFeature src, String srcAttr) throws DataException {
        block8: {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = this.getGeometry(src, srcAttr);
                if (fmeGeom instanceof IFMEMultiPoint) {
                    IomObject multicoord = Fme2iox.FME2multicoord((IFMEMultiPoint)fmeGeom);
                    target.addattrobj(targetAttr, multicoord);
                    break block8;
                }
                if (fmeGeom instanceof IFMEPoint) {
                    IomObject coord = Fme2iox.FME2coord((IFMEPoint)fmeGeom);
                    Iom_jObject multicoord = new Iom_jObject("MULTICOORD", null);
                    multicoord.addattrobj("coord", coord);
                    target.addattrobj(targetAttr, multicoord);
                    break block8;
                }
                if (fmeGeom instanceof IFMEText) {
                    IomObject coord = Fme2iox.FME2coord(((IFMEText)fmeGeom).getLocationAsPoint());
                    Iom_jObject multicoord = new Iom_jObject("MULTICOORD", null);
                    multicoord.addattrobj("coord", coord);
                    target.addattrobj(targetAttr, multicoord);
                    break block8;
                }
                if (fmeGeom instanceof IFMENull) {
                    break block8;
                }
                throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                }
            }
        }
    }
}

