/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.fme;

import COM.safe.fme.pluginbuilder.IFMEMappingFile;
import COM.safe.fme.pluginbuilder.IFMEReader;
import COM.safe.fme.pluginbuilder.IFMEReaderCreator;
import COM.safe.fme.pluginbuilder.IFMEWriter;
import COM.safe.fme.pluginbuilder.IFMEWriterCreator;
import COM.safe.fmeobjects.IFMECoordSysManager;
import COM.safe.fmeobjects.IFMELogFile;
import COM.safe.fmeobjects.IFMESession;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.FileListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.types.OutParam;
import ch.interlis.ili2fme.FmeLogListener;
import ch.interlis.ili2fme.Ili2Reader;
import ch.interlis.ili2fme.Ili2Writer;
import ch.interlis.iox_j.IoxUtility;
import ch.interlis.iox_j.inifile.IniFileReader;
import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class Main
implements IFMEReaderCreator,
IFMEWriterCreator {
    public static final String ILI2FME_FORMAT_NAME = "ch.ehi.fme.Main";
    public static final String MODELS = "MODELS";
    public static final String MODEL_DIR = "MODEL_DIR";
    public static final String CREATE_LINETABLES = "CREATE_LINETABLES";
    public static final String ILI1_LINETABLES = "ILI1_LINETABLES";
    public static final String META_CONFIG = "META_CONFIG";
    public static final String VALIDATE = "VALIDATE";
    public static final String VALIDATE_MULTIPLICITY = "VALIDATE_MULTIPLICITY";
    public static final String VALIDATE_CONFIG = "VALIDATE_CONFIG";
    public static final String USE_LINETABLES = "USE_LINETABLES";
    public static final String SKIP_POLYGONBUILDING = "SKIP_POLYGONBUILDING";
    public static final String INHERITANCE_MAPPING = "INHERITANCE_MAPPING";
    public static final String CREATEFEATURETYPE4ENUM = "CREATEFEATURETYPE4ENUM";
    public static final String TRACEMSGS = "TRACEMSGS";
    public static final String ILI1_ADDDEFVAL = "ILI1_ADDDEFVAL";
    public static final String ILI1_ENUMASITFCODE = "ILI1_ENUMASITFCODE";
    public static final Object ILI1_IGNOREPOLYGONBUILDINGERRORS = "ILI1_IGNOREPOLYGONBUILDINGERRORS";
    public static final String CHECK_UNIQUEOID = "CHECK_UNIQUEOID";
    public static final String TRIM_VALUES = "TRIM_VALUES";
    public static final String ILI1_RENUMBERTID = "ILI1_RENUMBERTID";
    public static final String XTFDIR_PLACEHOLDER = "%XTF_DIR";
    public static final String DATA_PLACEHOLDER = "%DATA";
    public static final String DEPRECATED_XTF_PLACEHOLDER = "XTF";
    public static final String FME_COORDINATE_SYSTEM = "COORDINATE_SYSTEM";
    public static final String GEOMETRY_ENCODING = "GEOMETRY_ENCODING";
    public static final String GEOM_ATTR_MAPPING = "GEOM_ATTR_MAPPING";
    public static final String HTTP_PROXYHOST = "HTTP_PROXYHOST";
    public static final String HTTP_PROXYPORT = "HTTP_PROXYPORT";
    public static final String TOPICS_FILTER = "TOPICS_FILTER";
    public static final String XTF_TRANSFER = "XTF_TRANSFER";
    public static final String XTF_BASKETS = "XTF_BASKETS";
    public static final String XTF_DELETEOBJECT = "XTF_DELETEOBJECT";
    public static final String XTF_ENUMS = "XTF_ENUMS";
    public static final String XTF_ERRORS = "XTF_ERRORS";
    public static final String XTF_ID = "xtf_id";
    public static final String XTF_BASKET = "xtf_basket";
    public static final String XTF_TOPIC = "xtf_topic";
    public static final String XTF_BASKETS_STARTSTATE = "xtf_startstate";
    public static final String XTF_BASKETS_ENDSTATE = "xtf_endstate";
    public static final String XTF_BASKETS_CONSISTENCY = "xtf_consistency";
    public static final String XTF_BASKETS_DOMAINS = "xtf_domains";
    public static final String XTF_BASKETS_DOMAINS_GENERIC = "generic";
    public static final String XTF_BASKETS_DOMAINS_CONCRETE = "concrete";
    public static final String XTF_BASKETS_SEQ = "xtf_seq";
    public static final String XTF_CLASS = "xtf_class";
    public static final String XTF_GEOMATTR = "xtf_geomattr";
    public static final String XTF_GEOMTYPE = "xtf_geomtype";
    public static final String XTF_OPERATION = "xtf_operation";
    public static final String ORDERPOS = "orderPos";
    public static final String XTF_ENUMTHIS = "thisEnum";
    public static final String XTF_ENUMBASE = "baseEnum";
    public static final String XTF_ENUMILICODE = "iliCode";
    public static final String XTF_ENUMITFCODE = "itfCode";
    public static final String XTF_ENUMSEQ = "seq";
    public static final String XTF_OIDSPACE = "oidspace";
    public static final String XTF_OIDNAME = "name";
    public static final String XTF_OIDDOMAIN = "oiddomain";
    public static final String XTF_COMMENT = "comment";
    public static final String XTF_ERRORS_ILINAME = "iliname";
    public static final String XTF_ERRORS_MESSAGE = "message";
    public static final String XTF_ERRORS_TID = "tid";
    public static final String ID_TYPE = "xtf_char(200)";
    public static final String ILINAME_TYPE = "xtf_char(255)";
    public static final String XTF_BASKETS_SEQ_TYPE = "xtf_int16";
    public static final String XTF_BASKETS_STATE_TYPE = "xtf_char(250)";
    public static final String XTF_BASKETS_CONSISTENCY_TYPE = "xtf_char(12)";
    public static final String XTF_BASKETS_DOMAINS_TYPE = "xtf_char(250)";
    public static final String OPERATION_TYPE = "xtf_char(6)";
    public static final String XTF_ENUMITFCODE_TYPE = "xtf_int16";
    public static final String XTF_ENUMSEQ_TYPE = "xtf_int16";
    public static final String DELETE_TAG = "DELETE";
    public static final int BASKET_SEQ_UNDEFINED = 0;
    public static final int BASKET_SEQ_START = 1;
    public static final String ILI2FME_JAR = "ili2fme.jar";
    public static final String SETTING_REFERENCE_DATA = "ch.ehi.ili2fme.refernceData";
    public static final String SETTING_VALIDATION_CONFIG = "ch.ehi.ili2fme.validationConfig";
    private static String version = null;
    private static final boolean doFMELog = true;
    private static final boolean doFileLog = false;
    private static HashMap fmeListeners = new HashMap();
    private static FileListener fileListener = null;
    private static int logFileCount = 0;

    public IFMEReader createReader(IFMEMappingFile mappingFile, IFMELogFile logFile, IFMECoordSysManager coordSysMan, IFMESession session, String readerTypeName, String readerKeyword) throws Exception {
        logFile.logMessageString("ili2fme-" + Main.getVersion(), 0);
        logFile.logMessageString("ili2c-" + ch.interlis.ili2c.Main.getVersion(), 0);
        logFile.logMessageString("iox-ili-" + IoxUtility.getVersion(), 0);
        logFile.logMessageString("java.version " + System.getProperty("java.version"), 0);
        logFile.logMessageString("maxMemory " + Runtime.getRuntime().maxMemory() / 1024L + " KB", 0);
        Ili2Reader ret = null;
        try {
            ret = new Ili2Reader(session, mappingFile, readerKeyword, logFile);
        }
        catch (Exception ex) {
            logFile.logMessageString("createReader() " + ex.getMessage(), 2);
            throw ex;
        }
        catch (Throwable ex) {
            logFile.logMessageString("createReader() " + ex.getMessage(), 2);
            throw new Exception(ex);
        }
        return ret;
    }

    public IFMEWriter createWriter(IFMEMappingFile mappingFile, IFMELogFile logFile, IFMECoordSysManager coordSysMan, IFMESession session, String readerTypeName, String readerKeyword) throws Exception {
        logFile.logMessageString("ili2fme-" + Main.getVersion(), 0);
        logFile.logMessageString("ili2c-" + ch.interlis.ili2c.Main.getVersion(), 0);
        logFile.logMessageString("iox-ili-" + IoxUtility.getVersion(), 0);
        logFile.logMessageString("java.version " + System.getProperty("java.version"), 0);
        logFile.logMessageString("maxMemory " + Runtime.getRuntime().maxMemory() / 1024L + " KB", 0);
        Ili2Writer ret = null;
        try {
            ret = new Ili2Writer(session, mappingFile, readerTypeName, readerKeyword, logFile);
        }
        catch (Exception ex) {
            logFile.logMessageString("createWriter()" + ex.getMessage(), 2);
            throw ex;
        }
        catch (Throwable ex) {
            logFile.logMessageString("createWriter() " + ex.getMessage(), 2);
            throw new Exception(ex);
        }
        return ret;
    }

    public static Settings readMetaConfig(File metaConfigFile, OutParam<String> baseConfig) throws IOException, ParseException {
        Settings settings = new Settings();
        ValidationConfig metaConfig = IniFileReader.readFile(metaConfigFile);
        baseConfig.value = metaConfig.getConfigValue("CONFIGURATION", "baseConfig");
        String referenceData = metaConfig.getConfigValue("CONFIGURATION", "ch.interlis.referenceData");
        settings.setValue(SETTING_REFERENCE_DATA, referenceData);
        String validConfig = metaConfig.getConfigValue("CONFIGURATION", "org.interlis2.validator.config");
        settings.setValue(SETTING_VALIDATION_CONFIG, validConfig);
        return settings;
    }

    public static Map<String, String> getPathMap(String xtffile, String appHome) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        if (xtffile != null) {
            pathMap.put(XTFDIR_PLACEHOLDER, new File(xtffile).getAbsoluteFile().getParent());
        } else {
            pathMap.put(XTFDIR_PLACEHOLDER, null);
        }
        return pathMap;
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch/interlis/ili2fme/Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }

    public static FmeLogListener setupLogging(IFMELogFile logFile) {
        FmeLogListener fmeListener = null;
        fmeListener = (FmeLogListener)fmeListeners.get(logFile);
        if (fmeListener == null) {
            fmeListener = new FmeLogListener(logFile);
            fmeListeners.put(logFile, fmeListener);
            EhiLogger.getInstance().addListener(fmeListener);
        }
        fmeListener.incrCount();
        if (logFileCount == 0) {
            EhiLogger.getInstance().removeListener(StdListener.getInstance());
        }
        ++logFileCount;
        return fmeListener;
    }

    public static void endLogging(FmeLogListener fmeListener) {
        if (--logFileCount == 0) {
            EhiLogger.getInstance().addListener(StdListener.getInstance());
        }
        if (fmeListener != null) {
            fmeListener.decrCount();
            if (fmeListener.getCount() == 0) {
                EhiLogger.getInstance().removeListener(fmeListener);
            }
            fmeListener = null;
        }
        if (logFileCount != 0 || fileListener != null) {
            // empty if block
        }
    }
}

