/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.fgdb;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.fgdb4j.jni.EnumRows;
import ch.ehi.fgdb4j.jni.FieldDef;
import ch.ehi.fgdb4j.jni.FieldDefs;
import ch.ehi.fgdb4j.jni.FieldType;
import ch.ehi.fgdb4j.jni.Geodatabase;
import ch.ehi.fgdb4j.jni.GeometryDef;
import ch.ehi.fgdb4j.jni.GeometryType;
import ch.ehi.fgdb4j.jni.SpatialReference;
import ch.ehi.fgdb4j.jni.SpatialReferenceInfo;
import ch.ehi.fgdb4j.jni.Table;
import ch.ehi.fgdb4j.jni.fgbd4j;
import ch.ehi.ili2fgdb.jdbc.FgdbConnection;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbConstraint;
import ch.ehi.sqlgen.repository.DbEnumEle;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.IOException;
import java.sql.Connection;

public class GeneratorFgdb
implements Generator {
    private static final String SRS_ID_LV95 = "2056";
    private static final String SRS_ID_LV03 = "21781";
    private static final String SRS_AUTH_EPSG = "EPSG";
    public static final String OBJECTOID = "OBJECTID";
    public static final String XY_RESOLUTION = "ch.ehi.ilifgdb.xyResolution";
    public static final String XY_TOLERANCE = "ch.ehi.ilifgdb.xyTolerance";
    private FgdbConnection conn;
    private Geodatabase db;
    private FieldDefs fieldv = null;
    private String geomFieldName = null;

    public void visit1Begin() throws IOException {
    }

    public void visit1End() throws IOException {
    }

    public void visit1TableBegin(DbTable tab) throws IOException {
        if (!GeneratorFgdb.tableExists(this.db, tab.getName().getName())) {
            if (this.fieldv != null) {
                this.fieldv.delete();
                this.fieldv = null;
            }
            this.fieldv = new FieldDefs();
        } else {
            this.fieldv = null;
        }
        this.geomFieldName = null;
    }

    public static boolean tableExists(Connection conn, DbTableName name) {
        return GeneratorFgdb.tableExists(((FgdbConnection)conn).getGeodatabase(), name.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Geodatabase db, String name) {
        Table table = null;
        try {
            table = new Table();
            int ret = db.OpenTable(name, table);
            if (ret == 0) {
                boolean bl = true;
                return bl;
            }
            if (ret != -2147220655) {
                throw new IllegalStateException("failed to test if table exists");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (table != null) {
                db.CloseTable(table);
                table.delete();
                table = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit1TableEnd(DbTable tab) throws IOException {
        if (this.fieldv != null) {
            Table table = null;
            try {
                table = new Table();
                FieldDef field = new FieldDef();
                field.SetName(OBJECTOID);
                field.SetType(FieldType.fieldTypeOID);
                field.SetIsNullable(false);
                this.fieldv.add(field);
                this.db.CreateTable(tab.getName().getName(), this.fieldv, "", table);
            }
            finally {
                if (this.fieldv != null) {
                    this.fieldv.delete();
                    this.fieldv = null;
                }
                if (table != null) {
                    this.db.CloseTable(table);
                    table.delete();
                    table = null;
                }
            }
        }
        if (tab.isDeleteDataIfTableExists()) {
            String delStmt = "DELETE FROM " + tab.getName().getName();
            EhiLogger.traceBackendCmd((String)delStmt);
            EnumRows rows = null;
            try {
                rows = new EnumRows();
                int err = this.db.ExecuteSQL(delStmt, false, rows);
                if (err != 0) {
                    throw new IllegalStateException("failed to delete data from " + tab.getName().getName());
                }
            }
            finally {
                if (rows != null) {
                    rows.Close();
                    rows.delete();
                    rows = null;
                }
            }
        }
    }

    public void visit2Begin() throws IOException {
    }

    public void visit2End() throws IOException {
    }

    public void visit2TableBegin(DbTable arg0) throws IOException {
    }

    public void visit2TableEnd(DbTable arg0) throws IOException {
    }

    public void visitColumn(DbTable tab, DbColumn column) throws IOException {
        if (this.fieldv == null) {
            return;
        }
        boolean isOid = false;
        FieldDef field = new FieldDef();
        if (column instanceof DbColBoolean) {
            field.SetType(FieldType.fieldTypeSmallInteger);
        } else if (column instanceof DbColDateTime) {
            field.SetType(FieldType.fieldTypeDate);
        } else if (column instanceof DbColDate) {
            field.SetType(FieldType.fieldTypeDate);
        } else if (column instanceof DbColTime) {
            field.SetType(FieldType.fieldTypeDate);
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            field.SetType(FieldType.fieldTypeDouble);
            field.SetLength(col.getSize());
        } else if (column instanceof DbColGeometry) {
            DbColGeometry col = (DbColGeometry)column;
            if (this.geomFieldName == null) {
                SpatialReferenceInfo srsInfo = new SpatialReferenceInfo();
                Integer srsId = GeneratorFgdb.getSrsId(col.getSrsAuth(), col.getSrsId(), srsInfo);
                if (srsId == null) {
                    throw new IllegalArgumentException("Unknown CRS " + col.getSrsAuth() + ":" + col.getSrsId());
                }
                SpatialReference spatialReference = new SpatialReference();
                String srsText = srsInfo.getSrtext();
                spatialReference.SetSpatialReferenceText(srsText);
                spatialReference.SetSpatialReferenceID(srsInfo.getAuth_srid());
                Double falseOriginX = null;
                Double falseOriginY = null;
                if (SRS_AUTH_EPSG.equals(col.getSrsAuth())) {
                    if (SRS_ID_LV03.equals(col.getSrsId())) {
                        falseOriginX = -2.93864E7;
                        falseOriginY = -3.30679E7;
                    } else if (SRS_ID_LV95.equals(col.getSrsId())) {
                        falseOriginX = -2.73864E7;
                        falseOriginY = -3.20679E7;
                    }
                }
                if (falseOriginX == null || falseOriginY == null) {
                    falseOriginX = this.extractWktParam(srsText, "\"False_Easting\"");
                    falseOriginY = this.extractWktParam(srsText, "\"False_Northing\"");
                }
                if (falseOriginX != null && falseOriginY != null) {
                    spatialReference.SetXYFalseOrigin(falseOriginX, falseOriginY);
                }
                Double xyResolution = null;
                String val = null;
                try {
                    val = col.getCustomValue(XY_RESOLUTION);
                    if (val != null) {
                        xyResolution = Double.valueOf(val);
                    }
                }
                catch (NumberFormatException e) {
                    EhiLogger.logAdaption((String)("ignore invalid xyResolution value <" + val + ">"));
                }
                if (xyResolution != null) {
                    spatialReference.SetXYResolution(xyResolution);
                }
                Double xyTolerance = null;
                val = null;
                try {
                    val = col.getCustomValue(XY_TOLERANCE);
                    if (val != null) {
                        xyTolerance = Double.valueOf(val);
                    }
                }
                catch (NumberFormatException e) {
                    EhiLogger.logAdaption((String)("ignore invalid xyTolerance value <" + val + ">"));
                }
                if (xyTolerance != null) {
                    spatialReference.SetXYTolerance(xyTolerance);
                }
                GeometryDef geomDef = new GeometryDef();
                if (col.getType() == 0) {
                    geomDef.SetGeometryType(GeometryType.geometryPoint);
                } else if (col.getType() == 9 || col.getType() == 8 || col.getType() == 2) {
                    geomDef.SetGeometryType(GeometryType.geometryPolyline);
                } else if (col.getType() == 10 || col.getType() == 3) {
                    geomDef.SetGeometryType(GeometryType.geometryPolygon);
                }
                geomDef.SetSpatialReference(spatialReference);
                geomDef.SetHasZ(col.getDimension() == 3);
                geomDef.SetHasM(false);
                field.SetType(FieldType.fieldTypeGeometry);
                field.SetGeometryDef(geomDef);
                srsInfo.delete();
                srsInfo = null;
                spatialReference.delete();
                spatialReference = null;
                this.geomFieldName = col.getName();
            }
        } else if (column instanceof DbColId) {
            DbColId col = (DbColId)column;
            if (col.isPrimaryKey()) {
                field.SetType(FieldType.fieldTypeInteger);
                isOid = true;
            } else {
                field.SetType(FieldType.fieldTypeInteger);
            }
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            field.SetType(FieldType.fieldTypeInteger);
            field.SetLength(col.getSize());
        } else if (column instanceof DbColVarchar) {
            int colsize = ((DbColVarchar)column).getSize();
            if (colsize == -1) {
                field.SetLength(0x7FFFFFFE);
            } else {
                field.SetLength(colsize);
            }
            field.SetType(FieldType.fieldTypeString);
        } else if (column instanceof DbColUuid) {
            field.SetType(FieldType.fieldTypeString);
            field.SetLength(36);
        } else if (column instanceof DbColBlob) {
            field.SetType(FieldType.fieldTypeBlob);
        } else if (column instanceof DbColXml) {
            field.SetType(FieldType.fieldTypeString);
            field.SetLength(0x7FFFFFFE);
        } else {
            field.SetLength(20);
            field.SetType(FieldType.fieldTypeString);
        }
        if (!isOid) {
            field.SetIsNullable(!column.isNotNull());
        }
        field.SetName(column.getName());
        this.fieldv.add(field);
    }

    private Double extractWktParam(String srsText, String paramName) {
        Double ret = null;
        int idx = srsText.indexOf(paramName);
        String val = null;
        if (idx > 0) {
            idx = srsText.indexOf(",", idx);
            int endIdx = srsText.indexOf("]", idx);
            if (idx > 0 && endIdx > 0) {
                try {
                    val = srsText.substring(idx + 1, endIdx);
                    if (val != null) {
                        ret = Double.valueOf(val);
                    }
                }
                catch (NumberFormatException e) {
                    EhiLogger.logAdaption((String)("failed to get " + paramName + " value <" + val + ">"));
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getSrsId(String srsAuth, String srsId) {
        SpatialReferenceInfo srsInfo = null;
        try {
            srsInfo = new SpatialReferenceInfo();
            Integer n = GeneratorFgdb.getSrsId(srsAuth, srsId, srsInfo);
            return n;
        }
        finally {
            if (srsInfo != null) {
                srsInfo.delete();
                srsInfo = null;
            }
        }
    }

    public static Integer getSrsId(String srsAuth, String srsId, SpatialReferenceInfo srsInfo) {
        Integer esriId = null;
        try {
            esriId = Integer.parseInt(srsId);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (!fgbd4j.FindSpatialReferenceBySRID(esriId, srsInfo)) {
            return null;
        }
        if (!srsInfo.getAuth_name().equals(srsAuth)) {
            return null;
        }
        return esriId;
    }

    public void visitConstraint(DbConstraint arg0) throws IOException {
    }

    public void visitEnumEle(DbEnumEle arg0) throws IOException {
    }

    public void visitIndex(DbIndex arg0) throws IOException {
    }

    public void visitSchemaBegin(Settings config, DbSchema arg1) throws IOException {
        this.conn = (FgdbConnection)config.getTransientObject("ch.ehi.sqlgen.jdbcConnection");
        if (this.conn == null) {
            throw new IllegalArgumentException("config.getConnection()==null");
        }
        this.db = this.conn.getGeodatabase();
    }

    public void visitSchemaEnd(DbSchema arg0) throws IOException {
    }

    public void visitTableBeginColumn(DbTable arg0) throws IOException {
    }

    public void visitTableBeginConstraint(DbTable arg0) throws IOException {
    }

    public void visitTableBeginEnumEle(DbTable arg0) throws IOException {
    }

    public void visitTableBeginIndex(DbTable arg0) throws IOException {
    }

    public void visitTableEndColumn(DbTable arg0) throws IOException {
    }

    public void visitTableEndConstraint(DbTable arg0) throws IOException {
    }

    public void visitTableEndEnumEle(DbTable arg0) throws IOException {
    }

    public void visitTableEndIndex(DbTable arg0) throws IOException {
    }
}

