/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.jdbc;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.generator.TextFileUtility;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbConstraint;
import ch.ehi.sqlgen.repository.DbEnumEle;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class GeneratorJdbc
implements Generator {
    public static int DEFAULT_NAME_LENGTH = 60;
    private int _maxSqlNameLength = DEFAULT_NAME_LENGTH;
    protected StringWriter out = null;
    protected Connection conn = null;
    private ArrayList dropLines = null;
    private ArrayList createLines = null;
    protected HashSet<DbTableName> createdTables = new HashSet();
    private static final String MAX_SQLNAME_LENGTH = "ch.ehi.ili2db.maxSqlNameLength";
    protected String colSep = null;
    private TextFileUtility txtOut = new TextFileUtility();

    public GeneratorJdbc() {
        this.dropLines = new ArrayList();
        this.createLines = new ArrayList();
    }

    @Override
    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        this.conn = (Connection)config.getTransientObject("ch.ehi.sqlgen.jdbcConnection");
        if (config.getValue(MAX_SQLNAME_LENGTH) != null) {
            this._maxSqlNameLength = Integer.parseInt(config.getValue(MAX_SQLNAME_LENGTH));
        }
    }

    @Override
    public void visitSchemaEnd(DbSchema schema) throws IOException {
    }

    @Override
    public void visit1Begin() throws IOException {
    }

    @Override
    public void visit1End() throws IOException {
    }

    @Override
    public void visit2Begin() throws IOException {
    }

    @Override
    public void visit2End() throws IOException {
    }

    @Override
    public void visit1TableBegin(DbTable tab) throws IOException {
        String iliname = tab.getIliName();
        if (iliname != null) {
            this.addCreateLine(new Cmt(tab.getIliName()));
        }
        this.out = new StringWriter();
        String tabName = tab.getName().getName();
        if (tab.getName().getSchema() != null) {
            tabName = tab.getName().getSchema() + "." + tabName;
        }
        this.out.write(this.getIndent() + "CREATE TABLE " + tabName + " (" + this.newline());
        this.inc_ind();
        if (iliname != null) {
            this.addDropLine(new Cmt(tab.getIliName()));
        }
        this.colSep = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit1TableEnd(DbTable tab) throws IOException {
        Iterator<DbIndex> idxi = tab.iteratorIndex();
        while (idxi.hasNext()) {
            DbIndex idx = idxi.next();
            if (!idx.isPrimary()) continue;
            this.out.write(this.getIndent() + this.colSep + "PRIMARY KEY (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                this.out.write(sep + attr.getName());
                sep = ",";
            }
            this.out.write(")" + this.newline());
            this.colSep = ",";
        }
        this.dec_ind();
        String cmt = this.getTableEndOptions(tab);
        if (cmt != null) {
            this.out.write(this.getIndent() + ") " + cmt + this.newline());
        } else {
            this.out.write(this.getIndent() + ")" + this.newline());
        }
        String stmt = this.out.toString();
        this.addCreateLine(new Stmt(stmt));
        this.addDropLine(new Stmt("DROP TABLE " + tab.getName()));
        this.out = null;
        if (this.conn != null) {
            IOException iox;
            Statement dbstmt;
            if (DbUtility.tableExists(this.conn, tab.getName())) {
                if (tab.isDeleteDataIfTableExists()) {
                    dbstmt = null;
                    try {
                        try {
                            dbstmt = this.conn.createStatement();
                            String delStmt = "DELETE FROM " + tab.getName();
                            EhiLogger.traceBackendCmd((String)delStmt);
                            dbstmt.executeUpdate(delStmt);
                        }
                        finally {
                            dbstmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        iox = new IOException("failed to delete data from table " + tab.getName());
                        iox.initCause(ex);
                        throw iox;
                    }
                }
            } else {
                dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)stmt);
                        dbstmt.executeUpdate(stmt);
                        this.createdTables.add(tab.getName());
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    iox = new IOException("failed to create table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
    }

    protected String getTableEndOptions(DbTable dbTab) {
        return null;
    }

    @Override
    public void visit2TableBegin(DbTable arg0) throws IOException {
    }

    @Override
    public void visit2TableEnd(DbTable arg0) throws IOException {
    }

    @Override
    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String type = "";
        String size = "";
        Object notSupported = null;
        if (column instanceof DbColBoolean) {
            type = "NUMBER(1)";
        } else if (column instanceof DbColDateTime) {
            type = "TIMESTAMP";
        } else if (column instanceof DbColDate) {
            type = "DATE";
        } else if (column instanceof DbColTime) {
            type = "TIME";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "DECIMAL(" + Integer.toString(col.getSize()) + "," + Integer.toString(col.getPrecision()) + ")";
        } else if (column instanceof DbColGeometry) {
            type = "BLOB";
        } else if (column instanceof DbColId) {
            type = "NUMBER(9)";
        } else if (column instanceof DbColUuid) {
            type = "VARCHAR2(36)";
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            type = "NUMBER(" + Integer.toString(col.getSize()) + ")";
        } else if (column instanceof DbColVarchar) {
            int colsize = ((DbColVarchar)column).getSize();
            type = "VARCHAR(" + Integer.toString(colsize) + ")";
        } else {
            type = "VARCHAR(20)";
        }
        String isNull = column.isNotNull() ? "NOT NULL" : "NULL";
        String name = column.getName();
        this.out.write(this.getIndent() + this.colSep + name + " " + type + " " + isNull + this.newline());
        this.colSep = ",";
    }

    @Override
    public void visitTableBeginColumn(DbTable arg0) throws IOException {
    }

    @Override
    public void visitTableEndColumn(DbTable arg0) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIndex(DbIndex idx) throws IOException {
        if (idx.isUnique()) {
            StringWriter out = new StringWriter();
            DbTable tab = idx.getTable();
            String tableName = tab.getName().getQName();
            String constraintName = idx.getName();
            if (constraintName == null) {
                String[] colNames = new String[idx.sizeAttr()];
                int i = 0;
                Iterator attri = idx.iteratorAttr();
                while (attri.hasNext()) {
                    DbColumn attr = (DbColumn)attri.next();
                    colNames[i++] = attr.getName();
                }
                constraintName = this.createConstraintName(tab, "key", colNames);
            }
            out.write(this.getIndent() + "ALTER TABLE " + tableName + " ADD CONSTRAINT " + constraintName + " UNIQUE (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                out.write(sep + attr.getName());
                sep = ",";
            }
            out.write(")" + this.newline());
            String stmt = out.toString();
            this.addCreateLine(new Stmt(stmt));
            out = null;
            if (this.conn != null && this.createdTables.contains(tab.getName())) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)stmt);
                        dbstmt.executeUpdate(stmt);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add UNIQUE to table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
    }

    @Override
    public void visitTableBeginIndex(DbTable arg0) throws IOException {
    }

    @Override
    public void visitTableEndIndex(DbTable arg0) throws IOException {
    }

    @Override
    public void visitConstraint(DbConstraint arg0) throws IOException {
    }

    @Override
    public void visitTableBeginConstraint(DbTable arg0) throws IOException {
    }

    @Override
    public void visitTableEndConstraint(DbTable arg0) throws IOException {
    }

    @Override
    public void visitEnumEle(DbEnumEle arg0) throws IOException {
    }

    @Override
    public void visitTableBeginEnumEle(DbTable arg0) throws IOException {
    }

    @Override
    public void visitTableEndEnumEle(DbTable arg0) throws IOException {
    }

    protected String getIndent() {
        return this.txtOut.getIndent();
    }

    protected void inc_ind() {
        this.txtOut.inc_ind();
    }

    protected void dec_ind() {
        this.txtOut.dec_ind();
    }

    protected String newline() {
        return this.txtOut.newline();
    }

    public void addDropLine(AbstractStmt dropstmt) {
        this.dropLines.add(dropstmt);
    }

    public Iterator iteratorDropLines() {
        return this.dropLines.iterator();
    }

    public void addCreateLine(AbstractStmt createstmt) {
        this.createLines.add(createstmt);
    }

    public Iterator iteratorCreateLines() {
        return this.createLines.iterator();
    }

    public boolean tableExists(DbTableName tableName) throws IOException {
        return this.conn != null && DbUtility.tableExists(this.conn, tableName);
    }

    public boolean tableCreated(DbTableName tableName) {
        return this.createdTables.contains(tableName);
    }

    public static void main(String[] args) {
        GeneratorJdbc tst = new GeneratorJdbc();
        String dburl = "jdbc:postgresql:ili2pg";
        String dbusr = "postgres";
        String dbpwd = "ola2011";
        try {
            tst.conn = DriverManager.getConnection(dburl, dbusr, dbpwd);
            DbTableName tab = new DbTableName("t_ili2db_imports");
            System.out.println(tab.toString() + " " + DbUtility.tableExists(tst.conn, tab));
            tab = new DbTableName("test1b");
            System.out.println(tab.toString() + " " + DbUtility.tableExists(tst.conn, tab));
            tab = new DbTableName("schema2", "test2");
            System.out.println(tab.toString() + " " + DbUtility.tableExists(tst.conn, tab));
            tab = new DbTableName("schema2", "test2b");
            System.out.println(tab.toString() + " " + DbUtility.tableExists(tst.conn, tab));
            tab = new DbTableName("schema3", "test3");
            System.out.println(tab.toString() + " " + DbUtility.tableExists(tst.conn, tab));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConstraint(DbTable dbTab, String constraintName, String createstmt, String dropstmt) throws IOException {
        this.addCreateLine(new Stmt(createstmt));
        this.addDropLine(new Stmt(dropstmt));
        if (this.conn != null && this.tableCreated(dbTab.getName())) {
            Statement dbstmt = null;
            try {
                try {
                    dbstmt = this.conn.createStatement();
                    EhiLogger.traceBackendCmd((String)createstmt);
                    dbstmt.execute(createstmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed to add constraint " + constraintName + " to table " + dbTab.getName());
                iox.initCause(ex);
                throw iox;
            }
        }
    }

    protected String createConstraintName(DbTable table, String suffix, String ... colNames) {
        String sqlname;
        int elec = colNames.length + 1;
        int suffixLen = 0;
        if (suffix != null) {
            suffixLen = suffix.length() + 1;
        }
        int maxLength = this.getMaxNameLength() - suffixLen - 1;
        int eleLength = maxLength / elec - 1;
        StringBuffer name = new StringBuffer();
        name.append(GeneratorJdbc.shortcutName(table.getName().getName(), eleLength));
        for (String colName : colNames) {
            name.append("_");
            name.append(GeneratorJdbc.shortcutName(colName, eleLength));
        }
        if (suffix != null) {
            name.append("_");
            name.append(suffix);
        }
        String base = sqlname = name.toString();
        int c = 1;
        while (table.getSchema().containsConstraintName(sqlname)) {
            sqlname = base + Integer.toString(c++);
        }
        table.getSchema().addConstraintName(sqlname);
        return sqlname;
    }

    public static String shortcutName(String aname, int maxlen) {
        StringBuffer name = new StringBuffer(aname);
        int stripc = name.length() - maxlen;
        if (stripc <= 0) {
            return aname;
        }
        for (int i = name.length() - 4; i >= 3; --i) {
            char c = name.charAt(i);
            if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u' && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U') continue;
            name.deleteCharAt(i);
            if (--stripc != 0) continue;
            return name.toString();
        }
        int start = (name.length() - stripc) / 2;
        name.delete(start, start + stripc);
        return name.toString();
    }

    private int getMaxNameLength() {
        return this._maxSqlNameLength;
    }

    public class Cmt
    extends AbstractStmt {
        public Cmt(String line1) {
            super(line1);
        }
    }

    public class Stmt
    extends AbstractStmt {
        public Stmt(String line1) {
            super(line1);
        }
    }

    public abstract class AbstractStmt {
        private String line = null;

        public AbstractStmt(String line1) {
            this.line = line1;
        }

        public String getLine() {
            return this.line;
        }
    }
}

