/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb.jdbc.sql;

import ch.ehi.ili2fgdb.jdbc.sql.SelectValue;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueField;
import ch.ehi.ili2fgdb.jdbc.sql.SqlStmt;
import ch.ehi.ili2fgdb.jdbc.sql.Value;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AbstractSelectStmt
extends SqlStmt {
    private String tableName = null;
    private String tableAlias = null;
    private List<SelectValue> fields = new ArrayList<SelectValue>();
    private List<Map.Entry<Value, Value>> conditions = new ArrayList<Map.Entry<Value, Value>>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<SelectValue> getFields() {
        return this.fields;
    }

    public void addField(SelectValue f) {
        this.fields.add(f);
    }

    public static void addField(AbstractSelectStmt stmt, SelectValue f) {
        String tabRef;
        String tabName = stmt.getTableAlias();
        if (tabName == null) {
            tabName = stmt.getTableName();
        }
        if (f instanceof SelectValueField && (tabRef = ((SelectValueField)f).getTableName()) != null && !tabRef.equals(tabName)) {
            return;
        }
        stmt.fields.add(f);
    }

    public void addCond(Value col, Value value) {
        this.conditions.add(new AbstractMap.SimpleEntry<Value, Value>(col, value));
    }

    public List<Map.Entry<Value, Value>> getConditions() {
        return this.conditions;
    }

    public void orderAsc() {
    }

    public void orderBy(String string) {
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public int findCol(String colName) {
        int idx = 1;
        for (SelectValue field : this.fields) {
            if (field.getColumnName().equals(colName)) {
                return idx;
            }
            ++idx;
        }
        return 0;
    }

    public String toString() {
        return "AbstractSelectStmt [tableName=" + this.tableName + ", tableAlias=" + this.tableAlias + ", fields=" + this.fields + ", conditions=" + this.conditions + "]";
    }
}

