/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.fgdb4j;

import java.util.Arrays;
import java.util.HashMap;
import java.util.WeakHashMap;

public class Tracker {
    private static Tracker instance = null;
    private WeakHashMap<Object, StackTraceElement[]> objs = new WeakHashMap();
    private HashMap<StackTraceElement[], String> allocations = new HashMap();

    private Tracker() {
    }

    public static Tracker getInstance() {
        if (instance == null) {
            instance = new Tracker();
        }
        return instance;
    }

    public static void startObject(Object obj) {
        Tracker.getInstance().start_Object(obj);
    }

    private void start_Object(Object obj) {
        String className = obj.getClass().getName();
        StackTraceElement[] origin = Tracker.getOrigin();
        this.objs.put(obj, origin);
        this.allocations.put(origin, className);
    }

    public static void endObject(Object obj) {
        Tracker.getInstance().end_Object(obj);
    }

    private void end_Object(Object obj) {
        StackTraceElement[] origin = this.objs.remove(obj);
        this.allocations.remove(origin);
    }

    private static StackTraceElement[] getOrigin() {
        Throwable tr = new Throwable();
        StackTraceElement[] stack = tr.getStackTrace();
        if (2 < stack.length) {
            StackTraceElement[] ret = Arrays.copyOfRange(stack, 3, stack.length - 3);
            return ret;
        }
        return null;
    }

    public HashMap<StackTraceElement[], String> getAllocations() {
        return this.allocations;
    }
}

