/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.jts;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iox_j.jts.Iox2jtsException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;

public class Jtsext2iox {
    private Jtsext2iox() {
    }

    public static IomObject hexwkb2coord(String value) throws Iox2jtsException {
        try {
            byte[] bv = WKBReader.hexToBytes((String)value);
            Geometry geom = new WKBReader().read(bv);
            return Jtsext2iox.JTS2coord(geom.getCoordinate());
        }
        catch (ParseException ex) {
            throw new Iox2jtsException(ex);
        }
    }

    public static IomObject hexwkb2polyline(String value) throws Iox2jtsException {
        try {
            byte[] bv = WKBReader.hexToBytes((String)value);
            Geometry geom = new WKBReader().read(bv);
            return Jtsext2iox.JTS2polyline((LineString)geom);
        }
        catch (ParseException ex) {
            throw new Iox2jtsException(ex);
        }
    }

    public static IomObject hexwkb2surface(String value) throws Iox2jtsException {
        try {
            byte[] bv = WKBReader.hexToBytes((String)value);
            Geometry geom = new WKBReader().read(bv);
            return Jtsext2iox.JTS2surface((Polygon)geom);
        }
        catch (ParseException ex) {
            throw new Iox2jtsException(ex);
        }
    }

    public static IomObject JTS2coord(Coordinate value) {
        Iom_jObject ret = new Iom_jObject("COORD", null);
        ret.setattrvalue("C1", Double.toString(value.x));
        ret.setattrvalue("C2", Double.toString(value.y));
        if (!Double.isNaN(value.z)) {
            ret.setattrvalue("C3", Double.toString(value.z));
        }
        return ret;
    }

    public static IomObject JTS2segment(CurveSegment value) throws Iox2jtsException {
        Iom_jObject ret = null;
        if (value instanceof ArcSegment) {
            ret = new Iom_jObject("ARC", null);
            Coordinate ep = value.getEndPoint();
            ret.setattrvalue("C1", Double.toString(ep.x));
            ret.setattrvalue("C2", Double.toString(ep.y));
            if (!Double.isNaN(ep.z)) {
                ret.setattrvalue("C3", Double.toString(ep.z));
            }
            Coordinate mp = ((ArcSegment)value).getMidPoint();
            ret.setattrvalue("A1", Double.toString(mp.x));
            ret.setattrvalue("A2", Double.toString(mp.y));
        } else if (value instanceof StraightSegment) {
            ret = new Iom_jObject("COORD", null);
            Coordinate ep = value.getEndPoint();
            ret.setattrvalue("C1", Double.toString(ep.x));
            ret.setattrvalue("C2", Double.toString(ep.y));
            if (!Double.isNaN(ep.z)) {
                ret.setattrvalue("C3", Double.toString(ep.z));
            }
        } else {
            throw new IllegalArgumentException(value.getClass().getName());
        }
        return ret;
    }

    public static IomObject JTS2polyline(LineString value) throws Iox2jtsException {
        Iom_jObject ret = new Iom_jObject("POLYLINE", null);
        Iom_jObject sequence = new Iom_jObject("SEGMENTS", null);
        ret.addattrobj("sequence", sequence);
        if (value instanceof CompoundCurve) {
            sequence.addattrobj("segment", Jtsext2iox.JTS2coord(value.getStartPoint().getCoordinate()));
            for (CurveSegment seg : ((CompoundCurve)value).getSegments()) {
                sequence.addattrobj("segment", Jtsext2iox.JTS2segment(seg));
            }
        } else if (value instanceof CompoundCurveRing) {
            sequence.addattrobj("segment", Jtsext2iox.JTS2coord(value.getStartPoint().getCoordinate()));
            for (CompoundCurve line : ((CompoundCurveRing)value).getLines()) {
                for (CurveSegment seg : line.getSegments()) {
                    sequence.addattrobj("segment", Jtsext2iox.JTS2segment(seg));
                }
            }
        } else {
            int coordc = value.getNumPoints();
            for (int coordi = 0; coordi < coordc; ++coordi) {
                sequence.addattrobj("segment", Jtsext2iox.JTS2coord(value.getCoordinateN(coordi)));
            }
        }
        return ret;
    }

    public static IomObject JTS2surface(Polygon value) throws Iox2jtsException {
        Iom_jObject ret = new Iom_jObject("MULTISURFACE", null);
        Iom_jObject surface = new Iom_jObject("SURFACE", null);
        ret.addattrobj("surface", surface);
        LineString shell = value.getExteriorRing();
        Iom_jObject boundary = new Iom_jObject("BOUNDARY", null);
        surface.addattrobj("boundary", boundary);
        boundary.addattrobj("polyline", Jtsext2iox.JTS2polyline(shell));
        int holec = value.getNumInteriorRing();
        for (int holei = 0; holei < holec; ++holei) {
            LineString hole = value.getInteriorRingN(holei);
            Iom_jObject boundary2 = new Iom_jObject("BOUNDARY", null);
            surface.addattrobj("boundary", boundary2);
            boundary2.addattrobj("polyline", Jtsext2iox.JTS2polyline(hole));
        }
        return ret;
    }
}

