/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.Viewable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

public class RoleDef
extends AbstractLeafElement
implements Extendable {
    private RoleDef extending;
    private Set<RoleDef> extendedBy = Collections.newSetFromMap(new WeakHashMap());
    private boolean _abstract;
    private boolean _final;
    private boolean hiding = false;
    private boolean extended;
    private boolean ordered;
    private int kind = 1;
    private Cardinality cardinality;
    private ArrayList<ReferenceType> endv = new ArrayList();
    private ObjectPath derivedFrom;
    private String name;
    private boolean isIli23;
    private int ili1AttrIdx = -1;

    public RoleDef() {
        this(true);
    }

    public RoleDef(boolean isIli23) {
        this.isIli23 = isIli23;
    }

    public void setExtended(boolean v) {
        this.extended = v;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setAbstract(boolean abst) {
        boolean oldValue = this._abstract;
        boolean newValue = abst;
        if (newValue && this.isFinal()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        this._abstract = newValue;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setFinal(boolean fin) {
        boolean oldValue = this._final;
        boolean newValue = fin;
        if (newValue && this.isAbstract()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        if (newValue && !this.extendedBy.isEmpty()) {
            throw new IllegalArgumentException(RoleDef.formatMessage("err_cantMakeExtendedFinal", this.toString(), this.extendedBy.iterator().next().toString()));
        }
        this._final = newValue;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setOrdered(boolean v) {
        this.ordered = v;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setKind(int v) {
        this.kind = v;
    }

    public int getKind() {
        return this.kind;
    }

    public void setCardinality(Cardinality v) {
        this.cardinality = v;
    }

    public boolean containsCardinality() {
        return this.cardinality != null;
    }

    public Cardinality getCardinality() {
        if (this.getExtending() != null && this.cardinality == null) {
            return ((RoleDef)this.getExtending()).getCardinality();
        }
        if (this.cardinality == null) {
            if (this.getKind() == 3) {
                if (this.isIli23) {
                    return new Cardinality(0L, 1L);
                }
                return new Cardinality(1L, 1L);
            }
            return new Cardinality(0L, Long.MAX_VALUE);
        }
        return this.cardinality;
    }

    public Cardinality getDefinedCardinality() {
        return this.cardinality;
    }

    public ReferenceType getReference() {
        if (this.endv.isEmpty()) {
            return null;
        }
        return this.endv.get(0);
    }

    public Iterator<ReferenceType> iteratorReference() {
        return this.endv.iterator();
    }

    public void setReference(ReferenceType ref) {
        this.endv.clear();
        this.endv.add(ref);
    }

    public void addReference(ReferenceType ref) {
        this.endv.add(ref);
    }

    public AbstractClassDef getDestination() {
        return this.endv.isEmpty() ? null : this.endv.get(0).getReferred();
    }

    public Iterator<AbstractClassDef> iteratorDestination() {
        ArrayList<AbstractClassDef> destv = new ArrayList<AbstractClassDef>(this.endv.size());
        for (int i = 0; i < this.endv.size(); ++i) {
            destv.add(this.endv.get(i).getReferred());
        }
        return destv.iterator();
    }

    public boolean isExternal() {
        return this.getReference().isExternal();
    }

    public void setDerivedFrom(ObjectPath v) {
        this.derivedFrom = v;
    }

    public ObjectPath getDerivedFrom() {
        return this.derivedFrom;
    }

    public void setName(String v) {
        this.name = v;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isExtending(Element ext) {
        RoleDef parent = this;
        while (parent != null) {
            if (parent == ext) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    @Override
    public void setExtending(Element ext) {
        RoleDef base = (RoleDef)ext;
        if (base.isFinal()) {
            throw new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_cantExtendFinal", base.toString()));
        }
        if (this.cardinality != null && !base.getCardinality().isGeneralizing(this.getCardinality())) {
            throw new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_role_cardExtMismatch", this.getCardinality().toString(), base.getCardinality().toString()));
        }
        Cardinality card = this.cardinality != null ? this.cardinality : base.getCardinality();
        if (card.getMaximum() > 1L && !this.isOrdered() && base.isOrdered()) {
            throw new Ili2cSemanticException(this.getSourceLine(), rsrc.getString("err_role_UnorderedExtOrdered"));
        }
        if (this.kind < base.kind) {
            throw new Ili2cSemanticException(this.getSourceLine(), rsrc.getString("err_role_WeakerExtStronger"));
        }
        if (!this.getDestination().isExtending(base.getDestination())) {
            throw new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_role_componentNotExt", this.getDestination().toString(), base.getDestination().toString()));
        }
        if (this.extending != null) {
            this.extending.extendedBy.remove(this);
        }
        this.extending = base;
        this.extending.extendedBy.add(this);
    }

    @Override
    public Element getExtending() {
        return this.extending;
    }

    public RoleDef getRootExtending() {
        RoleDef ret = (RoleDef)this.getExtending();
        if (ret != null) {
            Element ret1;
            while ((ret1 = ret.getExtending()) != null) {
                ret = (RoleDef)ret1;
            }
        }
        return ret;
    }

    @Override
    public Element getRealExtending() {
        Element ext = this.getExtending();
        return ext != null ? ext.getReal() : null;
    }

    @Override
    public Set<RoleDef> getExtensions() {
        HashSet<RoleDef> result = new HashSet<RoleDef>();
        this.getExtensions_recursiveHelper(result);
        return result;
    }

    private final void getExtensions_recursiveHelper(Set<RoleDef> s) {
        s.add(this);
        Iterator<RoleDef> iter = this.extendedBy.iterator();
        while (iter.hasNext()) {
            iter.next().getExtensions_recursiveHelper(s);
        }
    }

    public boolean isAssociationEmbedded() {
        AssociationDef container = (AssociationDef)this.getContainer();
        return container.getRoleWhereEmbedded() == this;
    }

    public void setIli1AttrIdx(int ili1AttrIdx) {
        this.ili1AttrIdx = ili1AttrIdx;
    }

    public int getIli1AttrIdx() {
        return this.ili1AttrIdx;
    }

    public RoleDef getOppEnd() {
        RoleDef[] role = new RoleDef[]{null, null};
        Iterator<Element> rolei = ((AssociationDef)this.getContainer()).getAttributesAndRoles();
        int i = 0;
        while (rolei.hasNext()) {
            Element obj = rolei.next();
            if (!(obj instanceof RoleDef)) continue;
            role[i++] = (RoleDef)obj;
        }
        return role[0] == this ? role[1] : role[0];
    }

    public boolean hasOneOppEnd() {
        Iterator<Element> rolei = ((AssociationDef)this.getContainer()).getAttributesAndRoles();
        int rolec = 0;
        while (rolei.hasNext()) {
            Element obj = rolei.next();
            if (!(obj instanceof RoleDef)) continue;
            ++rolec;
        }
        return rolec == 2;
    }

    public boolean isHiding() {
        return this.hiding;
    }

    public void setHiding(boolean hiding) {
        this.hiding = hiding;
    }

    public String toString() {
        Container<?> cont = this.getContainer(Viewable.class);
        if (cont == null) {
            return this.getName();
        }
        return cont.getScopedName(null) + ":" + this.getName();
    }

    @Override
    protected void linkTranslationOf(Element baseElement) {
        super.linkTranslationOf(baseElement);
        Iterator<ReferenceType> depIt = this.iteratorReference();
        Iterator<ReferenceType> baseDepIt = ((RoleDef)baseElement).iteratorReference();
        while (depIt.hasNext() && baseDepIt.hasNext()) {
            ReferenceType dep = depIt.next();
            ReferenceType baseDep = baseDepIt.next();
            dep.linkTranslationOf(baseDep);
        }
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        RoleDef baseElement = (RoleDef)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isAbstract() != baseElement.isAbstract()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_mismatchInAbstractness", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isFinal() != baseElement.isFinal()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_mismatchInFinality", this.getScopedName(), baseElement.getScopedName())));
        }
        Ili2cSemanticException err = null;
        err = RoleDef.checkElementRef(this.getExtending(), baseElement.getExtending(), this.getSourceLine(), "err_diff_baseRoleMismatch");
        if (err != null) {
            errs.add(err);
        }
        if (this.isHiding() != baseElement.isHiding()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_mismatchInHiding", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isOrdered() != baseElement.isOrdered()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_mismatchInOrdered", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.getKind() != baseElement.getKind()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_roleKindMismatch", this.getScopedName(), baseElement.getScopedName())));
        }
        Cardinality card = this.getDefinedCardinality();
        Cardinality baseCard = baseElement.getDefinedCardinality();
        if (card != null && baseCard != null) {
            if (!card.equals(baseCard)) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_cardinalityMismatch")));
            }
        } else if (card != null || baseCard != null) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_cardinalityMismatch")));
        }
        Iterator<ReferenceType> depIt = this.iteratorReference();
        Iterator<ReferenceType> baseDepIt = baseElement.iteratorReference();
        while (true) {
            if (!depIt.hasNext() || !baseDepIt.hasNext()) {
                if (depIt.hasNext() == baseDepIt.hasNext()) break;
                errs.add(new Ili2cSemanticException(this.getSourceLine(), RoleDef.formatMessage("err_diff_referencedClassMismatch")));
                break;
            }
            ReferenceType dep = depIt.next();
            ReferenceType baseDep = baseDepIt.next();
            dep.checkTranslationOf(errs, this.getScopedName(), baseElement.getScopedName());
        }
        if ((err = Evaluable.checkTranslation(this.getDerivedFrom(), baseElement.getDerivedFrom(), this.getSourceLine(), "err_diff_derviedFromMismatch")) != null) {
            errs.add(err);
        }
    }

    public class Kind {
        public static final int eASSOCIATE = 1;
        public static final int eAGGREGATE = 2;
        public static final int eCOMPOSITE = 3;

        private Kind() {
        }
    }
}

