/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.mapping;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.base.StatementExecutionHelper;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ColumnNameMapping;
import ch.ehi.ili2db.mapping.MssqlKw;
import ch.ehi.ili2db.mapping.MysqlKw;
import ch.ehi.ili2db.mapping.OracleKw;
import ch.ehi.ili2db.mapping.PostgresqlKw;
import ch.ehi.ili2db.mapping.Sql2003kw;
import ch.ehi.ili2db.mapping.SqliteKw;
import ch.ehi.ili2db.mapping.TranslationNameMapper;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NameMapping {
    public static int DEFAULT_NAME_LENGTH = 60;
    private int _maxSqlNameLength = DEFAULT_NAME_LENGTH;
    private HashMap<String, String> classNameIli2sql = new HashMap();
    private HashMap<String, String> classNameSql2ili = new HashMap();
    private ColumnNameMapping columnMapping = new ColumnNameMapping();
    private int nameing = 0;
    private static final int UNQUALIFIED_NAMES = 0;
    private static final int TOPIC_QUALIFIED_NAMES = 1;
    private static final int FULL_QUALIFIED_NAMES = 2;
    private boolean removeUnderscoreFromEnumDispName = false;
    private boolean useEpsg = false;
    private boolean isVer3_export = false;
    private Integer batchSize = null;
    private String[] languagePath = null;
    private TranslationNameMapper translationNameMapper = null;
    private static Set<String> kws = null;

    private NameMapping() {
    }

    public NameMapping(TransferDescription td, Config config) {
        this._maxSqlNameLength = Integer.parseInt(config.getMaxSqlNameLength());
        this.nameing = "disable".equals(config.getNameOptimization()) ? 2 : ("topic".equals(config.getNameOptimization()) ? 1 : 0);
        this.removeUnderscoreFromEnumDispName = "underscore".equals(config.getBeautifyEnumDispName());
        this.useEpsg = config.useEpsgInNames();
        this.isVer3_export = config.isVer3_export();
        this.batchSize = config.getBatchSize();
        String path = config.getNameLanguage();
        if (path != null) {
            this.languagePath = path.split(";");
            this.translationNameMapper = new TranslationNameMapper(td, config);
        }
    }

    private String makeSqlTableName(String modelName, String topicName, String className, String attrName, int maxSqlNameLength) {
        StringBuffer ret = new StringBuffer();
        String modelSqlName = modelName;
        String topicSqlName = topicName;
        String classSqlName = className;
        String attrSqlName = attrName;
        int maxClassNameLength = maxSqlNameLength;
        if (attrName != null) {
            maxClassNameLength -= 5;
        }
        if (this.nameing != 0) {
            if (this.nameing == 1) {
                if (topicSqlName != null) {
                    ret.append(NameMapping.shortcutName(topicSqlName, maxClassNameLength / 4 + 2));
                    ret.append("_");
                }
            } else if (this.nameing == 2) {
                if (topicSqlName == null) {
                    ret.append(NameMapping.shortcutName(modelSqlName, maxClassNameLength / 2 - 2));
                } else {
                    ret.append(NameMapping.shortcutName(modelSqlName, maxClassNameLength / 4 - 1));
                    ret.append(NameMapping.shortcutName(topicSqlName, maxClassNameLength / 4 + 2));
                }
                ret.append("_");
            } else {
                throw new IllegalStateException("nameing==" + this.nameing);
            }
        }
        ret.append(NameMapping.shortcutName(classSqlName, maxClassNameLength - ret.length()));
        if (attrSqlName != null) {
            ret.append("_");
            ret.append(NameMapping.shortcutName(attrSqlName, maxSqlNameLength - ret.length()));
        }
        String sqlTableName = this.makeValidSqlName(ret.toString());
        sqlTableName = this.normalizeSqlName(sqlTableName);
        if (this.nameing != 2 && this.existsSqlTableName(sqlTableName)) {
            ret.setLength(0);
            maxClassNameLength = maxSqlNameLength;
            if (attrName != null) {
                maxClassNameLength -= 5;
            }
            if (topicSqlName == null) {
                ret.append(NameMapping.shortcutName(modelSqlName, maxClassNameLength / 2 - 2));
            } else {
                ret.append(NameMapping.shortcutName(modelSqlName, maxClassNameLength / 4 - 1));
                ret.append(NameMapping.shortcutName(topicSqlName, maxClassNameLength / 4 + 2));
            }
            ret.append("_");
            ret.append(NameMapping.shortcutName(classSqlName, maxClassNameLength - ret.length()));
            if (attrSqlName != null) {
                ret.append("_");
                ret.append(NameMapping.shortcutName(attrSqlName, maxSqlNameLength - ret.length()));
            }
            sqlTableName = this.normalizeSqlName(ret.toString());
        }
        if (this.existsSqlTableName(sqlTableName)) {
            sqlTableName = this.makeSqlTableNameUnique(sqlTableName);
        }
        return sqlTableName;
    }

    public String mapSqlTableName(String sqlname) {
        sqlname = this.normalizeSqlName(sqlname);
        return this.classNameSql2ili.get(sqlname);
    }

    private void addTableNameMapping(String iliname, String sqlname) {
        this.classNameIli2sql.put(iliname, sqlname);
        this.classNameSql2ili.put(sqlname, iliname);
    }

    private boolean existsSqlTableName(String sqlname) {
        sqlname = this.normalizeSqlName(sqlname);
        return this.classNameSql2ili.containsKey(sqlname);
    }

    private String normalizeSqlName(String sqlname) {
        if (sqlname.length() > this.getMaxSqlNameLength()) {
            sqlname = sqlname.substring(0, this.getMaxSqlNameLength());
        }
        sqlname = sqlname.toLowerCase();
        return sqlname;
    }

    public String mapIliClassDef(Viewable def) {
        String iliname = def.getScopedName(null);
        String sqlname = this.classNameIli2sql.get(iliname);
        if (sqlname == null) {
            def = (Viewable)this.getTranslatedElement((Element)def);
            Topic topic = (Topic)def.getContainer(Topic.class);
            Model model = (Model)def.getContainer(Model.class);
            sqlname = this.makeSqlTableName(model.getName(), topic != null ? topic.getName() : null, def.getName(), null, this.getMaxSqlNameLength());
            this.addTableNameMapping(iliname, sqlname);
        }
        return sqlname;
    }

    public String mapIliDomainDef(Domain def) {
        String iliname = def.getScopedName(null);
        String sqlname = this.classNameIli2sql.get(iliname);
        if (sqlname == null) {
            def = (Domain)this.getTranslatedElement((Element)def);
            Topic topic = (Topic)def.getContainer(Topic.class);
            Model model = (Model)def.getContainer(Model.class);
            sqlname = this.makeSqlTableName(model.getName(), topic != null ? topic.getName() : null, def.getName(), null, this.getMaxSqlNameLength());
            this.addTableNameMapping(iliname, sqlname);
        }
        return sqlname;
    }

    public String beautifyEnumDispName(String value) {
        if (this.removeUnderscoreFromEnumDispName) {
            return value.replace('_', ' ');
        }
        return value;
    }

    public String mapIliEnumAttributeDefAsTable(AttributeDef def) {
        String iliname = def.getContainer().getScopedName(null) + "." + def.getName();
        String sqlname = this.classNameIli2sql.get(iliname);
        if (sqlname == null) {
            def = (AttributeDef)this.getTranslatedElement((Element)def);
            Topic topic = (Topic)def.getContainer(Topic.class);
            Model model = (Model)def.getContainer(Model.class);
            Viewable aclass = (Viewable)def.getContainer(Viewable.class);
            sqlname = this.makeSqlTableName(model.getName(), topic != null ? topic.getName() : null, aclass.getName(), def.getName(), this.getMaxSqlNameLength());
            this.addTableNameMapping(iliname, sqlname);
        }
        return sqlname;
    }

    public String mapItfGeometryAsTable(Viewable aclass, AttributeDef def, Integer epsgCode) {
        String iliqname = aclass.getScopedName(null) + "_" + def.getName();
        String sqlname = null;
        if (this.useEpsg && epsgCode != null) {
            String iliqname2 = iliqname + ":" + epsgCode;
            sqlname = this.classNameIli2sql.get(iliqname2);
            if (sqlname == null) {
                sqlname = this.classNameIli2sql.get(iliqname);
            }
            iliqname = iliqname2;
        } else {
            sqlname = this.classNameIli2sql.get(iliqname);
        }
        if (sqlname == null) {
            aclass = (Viewable)this.getTranslatedElement((Element)aclass);
            def = (AttributeDef)this.getTranslatedElement((Element)def);
            Topic topic = (Topic)aclass.getContainer(Topic.class);
            Model model = (Model)aclass.getContainer(Model.class);
            sqlname = this.useEpsg && epsgCode != null ? this.makeSqlTableName(model.getName(), topic != null ? topic.getName() : null, aclass.getName(), def.getName() + "_" + epsgCode, this.getMaxSqlNameLength()) : this.makeSqlTableName(model.getName(), topic != null ? topic.getName() : null, aclass.getName(), def.getName(), this.getMaxSqlNameLength());
            this.addTableNameMapping(iliqname, sqlname);
        }
        return sqlname;
    }

    public String mapAttributeAsTable(Viewable aclass, AttributeDef def, Integer epsgCode) {
        String iliqname = def.getContainer().getScopedName(null) + "." + def.getName();
        String sqlname = null;
        if (this.useEpsg && epsgCode != null) {
            iliqname = iliqname + ":" + epsgCode + "(" + aclass.getScopedName() + ")";
            sqlname = this.classNameIli2sql.get(iliqname);
        } else {
            iliqname = iliqname + "(" + aclass.getScopedName() + ")";
            sqlname = this.classNameIli2sql.get(iliqname);
        }
        if (sqlname == null) {
            aclass = (Viewable)this.getTranslatedElement((Element)aclass);
            def = (AttributeDef)this.getTranslatedElement((Element)def);
            Topic topic = (Topic)aclass.getContainer(Topic.class);
            Model model = (Model)aclass.getContainer(Model.class);
            sqlname = this.useEpsg && epsgCode != null ? this.makeSqlTableName(model.getName(), topic != null ? topic.getName() : null, aclass.getName(), def.getName() + "_" + epsgCode, this.getMaxSqlNameLength()) : this.makeSqlTableName(model.getName(), topic != null ? topic.getName() : null, aclass.getName(), def.getName(), this.getMaxSqlNameLength());
            this.addTableNameMapping(iliqname, sqlname);
        }
        return sqlname;
    }

    public String mapIliAttributeDefReverse(AttributeDef def, String ownerSqlTablename, String targetSqlTablename) {
        String iliname = def.getContainer().getScopedName(null) + "." + def.getName();
        String sqlname = this.columnMapping.getSqlName(iliname, ownerSqlTablename, targetSqlTablename);
        if (sqlname == null) {
            def = (AttributeDef)this.getTranslatedElement((Element)def);
            sqlname = NameMapping.shortcutName(targetSqlTablename, def.getName(), this.getMaxSqlNameLength() - 6);
            sqlname = this.makeValidSqlName(sqlname);
            sqlname = this.makeSqlColNameUnique(ownerSqlTablename, sqlname);
            this.columnMapping.addAttrNameMapping(iliname, sqlname, ownerSqlTablename, targetSqlTablename);
        }
        return sqlname;
    }

    public String mapIliRoleDef(RoleDef def, String ownerSqlTablename, String targetSqlTablename, boolean hasMultipleTargets) {
        String iliqname = def.getContainer().getScopedName(null) + "." + def.getName();
        String sqlname = this.columnMapping.getSqlName(iliqname, ownerSqlTablename, targetSqlTablename);
        if (sqlname == null) {
            def = (RoleDef)this.getTranslatedElement((Element)def);
            sqlname = hasMultipleTargets ? NameMapping.shortcutName(def.getName(), targetSqlTablename, this.getMaxSqlNameLength() - 6) : NameMapping.shortcutName(def.getName(), this.getMaxSqlNameLength() - 6);
            sqlname = this.makeValidSqlName(sqlname);
            sqlname = this.makeSqlColNameUnique(ownerSqlTablename, sqlname);
            this.columnMapping.addAttrNameMapping(iliqname, sqlname, ownerSqlTablename, targetSqlTablename);
        }
        return sqlname;
    }

    public String mapIliRoleDef(RoleDef def, String ownerSqlTablename, String targetSqlTablename) {
        String iliqname = def.getContainer().getScopedName(null) + "." + def.getName();
        String sqlname = this.columnMapping.getSqlName(iliqname, ownerSqlTablename, targetSqlTablename);
        if (sqlname == null) {
            def = (RoleDef)this.getTranslatedElement((Element)def);
            sqlname = NameMapping.shortcutName(def.getName(), this.getMaxSqlNameLength() - 6);
            sqlname = this.makeValidSqlName(sqlname);
            sqlname = this.makeSqlColNameUnique(ownerSqlTablename, sqlname);
            this.columnMapping.addAttrNameMapping(iliqname, sqlname, ownerSqlTablename, targetSqlTablename);
        }
        return sqlname;
    }

    public String mapIliAttributeDef(AttributeDef def, String ownerSqlTablename, String targetSqlTablename, boolean hasMultipleTargets) {
        String iliqname = def.getContainer().getScopedName(null) + "." + def.getName();
        String sqlname = this.columnMapping.getSqlName(iliqname, ownerSqlTablename, targetSqlTablename);
        if (sqlname == null) {
            def = (AttributeDef)this.getTranslatedElement((Element)def);
            sqlname = hasMultipleTargets ? NameMapping.shortcutName(def.getName(), targetSqlTablename, this.getMaxSqlNameLength() - 6) : NameMapping.shortcutName(def.getName(), this.getMaxSqlNameLength());
            sqlname = this.makeValidSqlName(sqlname);
            sqlname = this.makeSqlColNameUnique(ownerSqlTablename, sqlname);
            this.columnMapping.addAttrNameMapping(iliqname, sqlname, ownerSqlTablename, targetSqlTablename);
        }
        return sqlname;
    }

    public String mapIliAttributeDef(AttributeDef def, Integer epsgCode, String ownerSqlTablename, String targetSqlTablename) {
        String iliqname = def.getContainer().getScopedName(null) + "." + def.getName();
        String sqlname = null;
        if (this.useEpsg && epsgCode != null) {
            String iliqname2 = iliqname + ":" + epsgCode;
            sqlname = this.columnMapping.getSqlName(iliqname2, ownerSqlTablename, targetSqlTablename);
            if (sqlname == null) {
                sqlname = this.columnMapping.getSqlName(iliqname, ownerSqlTablename, targetSqlTablename);
            }
            iliqname = iliqname2;
        } else {
            sqlname = this.columnMapping.getSqlName(iliqname, ownerSqlTablename, targetSqlTablename);
        }
        if (sqlname == null) {
            def = (AttributeDef)this.getTranslatedElement((Element)def);
            sqlname = this.useEpsg && epsgCode != null ? NameMapping.shortcutName(def.getName() + "_" + epsgCode, this.getMaxSqlNameLength()) : NameMapping.shortcutName(def.getName(), this.getMaxSqlNameLength());
            sqlname = this.makeValidSqlName(sqlname);
            sqlname = this.makeSqlColNameUnique(ownerSqlTablename, sqlname);
            this.columnMapping.addAttrNameMapping(iliqname, sqlname, ownerSqlTablename, targetSqlTablename);
        }
        return sqlname;
    }

    private String mapIliAttrName(String ownerSqlTablename, AttributeDef def, String suffix) {
        String iliqname = def.getContainer().getScopedName(null) + "." + def.getName() + "." + suffix;
        String sqlname = this.columnMapping.getSqlName(iliqname, ownerSqlTablename, null);
        if (sqlname == null) {
            def = (AttributeDef)this.getTranslatedElement((Element)def);
            sqlname = NameMapping.shortcutName(suffix, this.getMaxSqlNameLength());
            sqlname = this.makeValidSqlName(sqlname);
            sqlname = this.makeSqlColNameUnique(ownerSqlTablename, sqlname);
            this.columnMapping.addAttrNameMapping(iliqname, sqlname, ownerSqlTablename, null);
        }
        return sqlname;
    }

    public Element getTranslatedElement(Element def) {
        if (this.translationNameMapper != null) {
            return this.translationNameMapper.translateElement(this.languagePath, def);
        }
        return def;
    }

    private String makeSqlColNameUnique(String ownerSqlTablename, String sqlname) {
        String base = sqlname = this.normalizeSqlName(sqlname);
        int c = 1;
        while (this.columnMapping.existsSqlName(ownerSqlTablename, sqlname)) {
            sqlname = base + Integer.toString(c++);
        }
        return sqlname;
    }

    private String makeSqlTableNameUnique(String sqlname) {
        String base = sqlname;
        int c = 1;
        while (this.existsSqlTableName(sqlname)) {
            sqlname = base + Integer.toString(c++);
        }
        return sqlname;
    }

    private String makeValidSqlName(String name) {
        NameMapping.initReservedWordList();
        String ucname = name.toUpperCase();
        while (kws.contains(ucname)) {
            name = "a" + name;
            ucname = name.toUpperCase();
        }
        return name;
    }

    public static boolean isValidSqlName(String name) {
        NameMapping.initReservedWordList();
        String ucname = name.toUpperCase();
        return !kws.contains(ucname);
    }

    private static void initReservedWordList() {
        if (kws == null) {
            kws = NameMapping.getSqlKeywords();
        }
    }

    public static Set<String> getSqlKeywords() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(Sql2003kw.getKeywords());
        ret.addAll(PostgresqlKw.getKeywords());
        ret.addAll(SqliteKw.getKeywords());
        ret.addAll(MssqlKw.getKeywords());
        ret.addAll(MysqlKw.getKeywords());
        ret.addAll(OracleKw.getKeywords());
        ret.add("TEXT");
        ret.add("OBJECTID");
        return ret;
    }

    private static String shortcutName(String aname, int maxlen) {
        StringBuffer name = new StringBuffer(aname);
        int stripc = name.length() - maxlen;
        if (stripc <= 0) {
            return aname;
        }
        for (int i = name.length() - 4; i >= 3; --i) {
            char c = name.charAt(i);
            if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u' && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U') continue;
            name.deleteCharAt(i);
            if (--stripc != 0) continue;
            return name.toString();
        }
        int start = (name.length() - stripc) / 2;
        name.delete(start, start + stripc);
        return name.toString();
    }

    private static String shortcutName(String modelName, String attrName, int maxSqlNameLength) {
        StringBuffer ret = new StringBuffer();
        String modelSqlName = modelName;
        String attrSqlName = attrName;
        int maxClassNameLength = maxSqlNameLength - 5;
        ret.append(NameMapping.shortcutName(modelSqlName, maxClassNameLength / 2 - 2));
        ret.append("_");
        ret.append(NameMapping.shortcutName(attrSqlName, maxSqlNameLength - ret.length()));
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<String> readTableMappingTableEntries(Connection conn, String schema) throws Ili2dbException {
        HashSet<String> ret = new HashSet<String>();
        String sqlName = "T_ILI2DB_CLASSNAME";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        try {
            String exstStmt = null;
            exstStmt = "SELECT IliName FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)exstStmt);
            PreparedStatement exstPrepStmt = null;
            ResultSet rs = null;
            try {
                exstPrepStmt = conn.prepareStatement(exstStmt);
                rs = exstPrepStmt.executeQuery();
                while (rs.next()) {
                    String iliCode = rs.getString(1);
                    ret.add(iliCode);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (exstPrepStmt != null) {
                    exstPrepStmt.close();
                    exstPrepStmt = null;
                }
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read class-mapping-table " + sqlName, ex);
        }
        return ret;
    }

    public void updateTableMappingTable(GeneratorJdbc gen, Connection conn, String schema) throws Ili2dbException {
        String mapTabName = "T_ILI2DB_CLASSNAME";
        if (schema != null) {
            mapTabName = schema + "." + mapTabName;
        }
        if (conn != null) {
            HashSet<String> exstEntries = NameMapping.readTableMappingTableEntries(conn, schema);
            try {
                String stmt = "INSERT INTO " + mapTabName + " (" + "IliName" + "," + "SqlName" + ") VALUES (?,?)";
                EhiLogger.traceBackendCmd((String)stmt);
                PreparedStatement ps = conn.prepareStatement(stmt);
                String iliname = null;
                String sqlname = null;
                StatementExecutionHelper seHelper = new StatementExecutionHelper(this.batchSize);
                try {
                    Iterator<String> entri = this.classNameIli2sql.keySet().iterator();
                    long start = System.currentTimeMillis();
                    while (entri.hasNext()) {
                        iliname = entri.next();
                        if (exstEntries.contains(iliname)) continue;
                        sqlname = this.classNameIli2sql.get(iliname);
                        ps.setString(1, iliname);
                        ps.setString(2, sqlname);
                        seHelper.write(ps);
                    }
                    seHelper.flush(ps);
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to insert classname-mapping " + iliname, ex);
                }
                finally {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update mapping-table " + mapTabName, ex);
            }
        }
        if (gen != null) {
            for (String iliname : this.classNameIli2sql.keySet()) {
                String sqlname = this.classNameIli2sql.get(iliname);
                String stmt = "INSERT INTO " + mapTabName + " (" + "IliName" + "," + "SqlName" + ") VALUES (" + Ili2db.quoteSqlStringValue(iliname) + "," + Ili2db.quoteSqlStringValue(sqlname) + ")";
                GeneratorJdbc generatorJdbc = gen;
                generatorJdbc.getClass();
                gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, stmt));
            }
        }
    }

    public void readTableMappingTable(Connection conn, String schema) throws Ili2dbException {
        String mapTableName = "T_ILI2DB_CLASSNAME";
        if (schema != null) {
            mapTableName = schema + "." + mapTableName;
        }
        String stmt = "SELECT IliName, SqlName FROM " + mapTableName;
        Statement dbstmt = null;
        ResultSet rs = null;
        try {
            dbstmt = conn.createStatement();
            rs = dbstmt.executeQuery(stmt);
            while (rs.next()) {
                String iliname = rs.getString("IliName");
                String sqlname = rs.getString("SqlName");
                if (this.classNameIli2sql.get(iliname) != null) continue;
                sqlname = this.normalizeSqlName(sqlname);
                this.addTableNameMapping(iliname, sqlname);
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query mapping-table " + mapTableName, ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to close query of " + mapTableName, ex);
                }
            }
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to close query of " + mapTableName, ex);
                }
                dbstmt = null;
            }
        }
    }

    public void updateAttrMappingTable(GeneratorJdbc gen, Connection conn, String schema) throws Ili2dbException {
        this.columnMapping.updateAttrMappingTable(gen, conn, schema);
    }

    public void readAttrMappingTable(Connection conn, String schema) throws Ili2dbException {
        this.columnMapping.readAttrMappingTable(conn, schema, this.isVer3_export);
    }

    public int getMaxSqlNameLength() {
        return this._maxSqlNameLength;
    }

    public String getSqlColNameItfLineTableRefAttr(AttributeDef attr, String ownerSqlTablename) {
        return this.mapIliAttrName(ownerSqlTablename, attr, "_ref");
    }

    public String getSqlColNameItfLineTableGeomAttr(AttributeDef attr, String ownerSqlTablename) {
        return this.mapIliAttrName(ownerSqlTablename, attr, "_geom");
    }
}

