/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.mapping;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.base.StatementExecutionHelper;
import ch.ehi.ili2db.mapping.AttrMappingKey;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;

public class ColumnNameMapping {
    private HashMap<AttrMappingKey, String> attrNameIli2sql = new HashMap();
    private HashMap<String, HashSet<String>> tables = new HashMap();
    private Integer batchSize = null;

    public ColumnNameMapping() {
    }

    public ColumnNameMapping(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void addAttrNameMapping(String iliname, String sqlname, String ownerSqlTablename, String targetSqlTablename) {
        if (ownerSqlTablename == null) {
            throw new IllegalArgumentException("ownerSqlTablename==null");
        }
        this.attrNameIli2sql.put(new AttrMappingKey(iliname, ownerSqlTablename, targetSqlTablename), sqlname);
        HashSet<Object> colNames = null;
        if (this.tables.containsKey(ownerSqlTablename)) {
            colNames = this.tables.get(ownerSqlTablename);
        } else {
            colNames = new HashSet();
            this.tables.put(ownerSqlTablename, colNames);
        }
        if (colNames.contains(sqlname)) {
            throw new IllegalArgumentException("duplicate column " + sqlname + " in table " + ownerSqlTablename);
        }
        colNames.add(sqlname);
    }

    public String getSqlName(String iliAttrqname, String ownerSqlTablename, String targetSqlTablename) {
        if (ownerSqlTablename == null) {
            throw new IllegalArgumentException("ownerSqlTablename==null");
        }
        return this.attrNameIli2sql.get(new AttrMappingKey(iliAttrqname, ownerSqlTablename, targetSqlTablename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<AttrMappingKey> readAttrMappingTableEntries(Connection conn, String schema, boolean isVer3_export) throws Ili2dbException {
        HashSet<AttrMappingKey> ret = new HashSet<AttrMappingKey>();
        String sqlName = "T_ILI2DB_ATTRNAME";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        try {
            String exstStmt = null;
            exstStmt = "SELECT IliName,ColOwner,Target FROM " + sqlName;
            if (isVer3_export) {
                exstStmt = "SELECT IliName,Owner,Target FROM " + sqlName;
            }
            EhiLogger.traceBackendCmd((String)exstStmt);
            PreparedStatement exstPrepStmt = conn.prepareStatement(exstStmt);
            ResultSet rs = null;
            try {
                rs = exstPrepStmt.executeQuery();
                while (rs.next()) {
                    String iliCode = rs.getString(1);
                    String owner = rs.getString(2);
                    String target = rs.getString(3);
                    ret.add(new AttrMappingKey(iliCode, owner, target));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (exstPrepStmt != null) {
                    exstPrepStmt.close();
                    exstPrepStmt = null;
                }
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read attr-mapping-table " + sqlName, ex);
        }
        return ret;
    }

    public void updateAttrMappingTable(GeneratorJdbc gen, Connection conn, String schema) throws Ili2dbException {
        String mapTabName = "T_ILI2DB_ATTRNAME";
        if (schema != null) {
            mapTabName = schema + "." + mapTabName;
        }
        if (conn != null) {
            HashSet<AttrMappingKey> exstEntries = ColumnNameMapping.readAttrMappingTableEntries(conn, schema, false);
            try {
                String stmt = "INSERT INTO " + mapTabName + " (" + "IliName" + "," + "SqlName" + "," + "ColOwner" + "," + "Target" + ") VALUES (?,?,?,?)";
                EhiLogger.traceBackendCmd((String)stmt);
                PreparedStatement ps = conn.prepareStatement(stmt);
                AttrMappingKey entry1 = null;
                StatementExecutionHelper seHelper = new StatementExecutionHelper(this.batchSize);
                try {
                    long start = System.currentTimeMillis();
                    for (AttrMappingKey entry : this.attrNameIli2sql.keySet()) {
                        if (exstEntries.contains(entry)) continue;
                        entry1 = entry;
                        String sqlname = this.attrNameIli2sql.get(entry);
                        ps.setString(1, entry.getIliname());
                        ps.setString(2, sqlname);
                        ps.setString(3, entry.getOwner());
                        ps.setString(4, entry.getTarget());
                        seHelper.write(ps);
                    }
                    seHelper.flush(ps);
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to insert attrname-mapping " + entry1, ex);
                }
                finally {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update mapping-table " + mapTabName, ex);
            }
        }
        if (gen != null) {
            for (AttrMappingKey entry : this.attrNameIli2sql.keySet()) {
                String sqlname = this.attrNameIli2sql.get(entry);
                String target = entry.getTarget();
                String stmt = "INSERT INTO " + mapTabName + " (" + "IliName" + "," + "SqlName" + "," + "ColOwner" + "," + "Target" + ") VALUES (" + Ili2db.quoteSqlStringValue(entry.getIliname()) + "," + Ili2db.quoteSqlStringValue(sqlname) + "," + Ili2db.quoteSqlStringValue(entry.getOwner()) + "," + Ili2db.quoteSqlStringValue(target) + ")";
                GeneratorJdbc generatorJdbc = gen;
                generatorJdbc.getClass();
                gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, stmt));
            }
        }
    }

    public void readAttrMappingTable(Connection conn, String schema, boolean isVer3_export) throws Ili2dbException {
        String mapTableName = "T_ILI2DB_ATTRNAME";
        if (schema != null) {
            mapTableName = schema + "." + mapTableName;
        }
        String ownerCol = "ColOwner";
        if (isVer3_export) {
            ownerCol = "Owner";
        }
        String stmt = "SELECT IliName, SqlName, " + ownerCol + ", " + "Target" + " FROM " + mapTableName;
        Statement dbstmt = null;
        ResultSet rs = null;
        try {
            dbstmt = conn.createStatement();
            rs = dbstmt.executeQuery(stmt);
            while (rs.next()) {
                String iliname = rs.getString("IliName");
                String sqlname = rs.getString("SqlName");
                String owner = rs.getString(ownerCol);
                String target = rs.getString("Target");
                this.addAttrNameMapping(iliname, sqlname, owner, target);
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query mapping-table " + mapTableName, ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to close query of " + mapTableName, ex);
                }
                rs = null;
            }
            if (dbstmt != null) {
                try {
                    dbstmt.close();
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to close query of " + mapTableName, ex);
                }
                dbstmt = null;
            }
        }
    }

    public boolean existsSqlName(String ownerSqlTablename, String sqlname) {
        HashSet<String> colNames;
        if (ownerSqlTablename == null) {
            throw new IllegalArgumentException("ownerSqlTablename==null");
        }
        return this.tables.containsKey(ownerSqlTablename) && (colNames = this.tables.get(ownerSqlTablename)).contains(sqlname);
    }
}

