/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.converter;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ArrayMappings;
import ch.ehi.ili2db.mapping.MultiLineMappings;
import ch.ehi.ili2db.mapping.MultiPointMappings;
import ch.ehi.ili2db.mapping.MultiSurfaceMappings;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom_j.itf.EnumCodeMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AbstractRecordConverter {
    protected EnumCodeMapper enumTypes = new EnumCodeMapper();
    protected TransferDescription td = null;
    protected NameMapping ili2sqlName = null;
    private String schemaName = null;
    protected String defaultCrsAuthority = null;
    protected String defaultCrsCode = null;
    protected String createEnumTable = null;
    protected boolean createStdCols = false;
    protected boolean createEnumTxtCol = false;
    protected boolean createEnumColAsItfCode = false;
    protected boolean createTypeDiscriminator = false;
    protected boolean sqlEnableNull = true;
    protected boolean strokeArcs = true;
    protected boolean createBasketCol = false;
    protected boolean createDatasetCol = false;
    protected boolean createItfLineTables = false;
    protected boolean createXtfLineTables = false;
    protected boolean createItfAreaRef = false;
    protected boolean createFk = false;
    protected boolean createFkIdx = false;
    protected boolean createExtRef = false;
    protected boolean isIli1Model = false;
    protected String colT_ID = null;
    private String uuid_default_value = null;
    private DbIdGen idGen = null;
    protected TrafoConfig trafoConfig = null;
    protected Viewable2TableMapping class2wrapper = null;
    protected MultiSurfaceMappings multiSurfaceAttrs = new MultiSurfaceMappings();
    protected MultiLineMappings multiLineAttrs = new MultiLineMappings();
    protected MultiPointMappings multiPointAttrs = new MultiPointMappings();
    protected ArrayMappings arrayAttrs = new ArrayMappings();
    protected boolean sqlColsAsText = false;
    private HashMap<Viewable, ArrayList<ViewableWrapper>> targetTablesPool = new HashMap();

    public AbstractRecordConverter(TransferDescription td1, NameMapping ili2sqlName, Config config, DbIdGen idGen1, TrafoConfig trafoConfig1, Viewable2TableMapping class2wrapper1) {
        this.td = td1;
        this.defaultCrsAuthority = config.getDefaultSrsAuthority();
        this.defaultCrsCode = config.getDefaultSrsCode();
        this.ili2sqlName = ili2sqlName;
        this.trafoConfig = trafoConfig1;
        this.createEnumTable = config.getCreateEnumDefs();
        this.class2wrapper = class2wrapper1;
        this.createEnumColAsItfCode = "yes".equals(config.getValue("ch.ehi.ili2db.createEnumColAsItfCode"));
        this.createStdCols = "all".equals(config.getCreateStdCols());
        this.createEnumTxtCol = "addTxtCol".equals(config.getCreateEnumCols());
        this.createFk = "yes".equals(config.getCreateFk());
        this.createFkIdx = "yes".equals(config.getCreateFkIdx());
        this.createExtRef = "enable".equals(config.getSqlExtRefCols());
        this.colT_ID = config.getColT_ID();
        if (this.colT_ID == null) {
            this.colT_ID = "T_Id";
        }
        this.uuid_default_value = config.getUuidDefaultValue();
        this.idGen = idGen1;
        this.schemaName = config.getDbschema();
        this.createTypeDiscriminator = "always".equals(config.getCreateTypeDiscriminator());
        this.sqlEnableNull = "enable".equals(config.getSqlNull());
        this.strokeArcs = "enable".equals(Config.getStrokeArcs(config));
        this.createBasketCol = "readWrite".equals(config.getBasketHandling());
        this.createDatasetCol = "addDatasetCol".equals(config.getCreateDatasetCols());
        this.isIli1Model = td1.getIli1Format() != null;
        this.createItfLineTables = this.isIli1Model && config.getDoItfLineTables();
        this.createItfAreaRef = this.isIli1Model && "keep".equals(config.getAreaRef());
        this.createXtfLineTables = !this.isIli1Model && config.getDoXtfLineTables();
        this.sqlColsAsText = "enable".equals(config.getSqlColsAsText());
    }

    public DbColGeometry generatePolylineType(Model model, LineType type, String attrName, Integer epsgCode) {
        DbColGeometry ret = new DbColGeometry();
        boolean compoundCurve = false;
        if (!this.strokeArcs) {
            compoundCurve = true;
        }
        ret.setType(compoundCurve ? 9 : 2);
        Domain coordDomain = type.getControlPointDomain();
        if (coordDomain != null) {
            CoordType coord = (CoordType)coordDomain.getType();
            if (coord.isGeneric()) {
                coord = (CoordType)Ili2cUtility.resolveGenericCoordDomain(model, coordDomain, epsgCode).getType();
            }
            ret.setDimension(coord.getDimensions().length);
            this.setBB(ret, (AbstractCoordType)coord, attrName);
        }
        return ret;
    }

    public DbColGeometry generateMultiPolylineType(Model model, LineType type, String attrName, Integer epsgCode) {
        DbColGeometry ret = new DbColGeometry();
        boolean curvePolyline = false;
        if (!this.strokeArcs) {
            curvePolyline = true;
        }
        ret.setType(curvePolyline ? 11 : 5);
        Domain coordDomain = type.getControlPointDomain();
        if (coordDomain != null) {
            CoordType coord = (CoordType)coordDomain.getType();
            if (coord.isGeneric()) {
                coord = (CoordType)Ili2cUtility.resolveGenericCoordDomain(model, coordDomain, epsgCode).getType();
            }
            ret.setDimension(coord.getDimensions().length);
            this.setBB(ret, (AbstractCoordType)coord, attrName);
        }
        return ret;
    }

    public void setCrs(DbColGeometry ret, int epsgCode) {
        ret.setSrsAuth("EPSG");
        ret.setSrsId(Integer.toString(epsgCode));
    }

    public DbColId addKeyCol(DbTable table) {
        DbColId dbColId = new DbColId();
        dbColId.setName(this.colT_ID);
        dbColId.setNotNull(true);
        dbColId.setPrimaryKey(true);
        if (table.isRequiresSequence()) {
            dbColId.setDefaultValue(this.idGen.getDefaultValueSql());
        }
        table.addColumn((DbColumn)dbColId);
        return dbColId;
    }

    public void addIliTidCol(DbTable dbTable, Domain oidDomain) {
        if (AbstractRecordConverter.isUuidOid(this.td, oidDomain)) {
            DbColUuid dbColIliTid = new DbColUuid();
            dbColIliTid.setName("T_Ili_Tid");
            dbColIliTid.setDefaultValue(this.uuid_default_value);
            dbTable.addColumn((DbColumn)dbColIliTid);
        } else {
            DbColVarchar dbColIliTid = new DbColVarchar();
            dbColIliTid.setName("T_Ili_Tid");
            dbColIliTid.setSize(200);
            dbTable.addColumn((DbColumn)dbColIliTid);
        }
    }

    public ArrayList<ViewableWrapper> getTargetTables(Viewable destination) {
        if (this.targetTablesPool.containsKey(destination)) {
            return this.targetTablesPool.get(destination);
        }
        ArrayList<ViewableWrapper> ret = new ArrayList<ViewableWrapper>();
        ArrayList<Viewable> candids = new ArrayList<Viewable>();
        candids.add(destination);
        while (!candids.isEmpty()) {
            ViewableWrapper wrapper;
            Viewable candid = (Viewable)candids.remove(0);
            String inheritanceStrategy = this.trafoConfig.getViewableConfig(candid, "ch.ehi.ili2db.inheritance");
            if ("superClass".equals(inheritanceStrategy)) {
                ret.add(this.class2wrapper.get(candid));
                continue;
            }
            if ("subClass".equals(inheritanceStrategy)) {
                candids.addAll(candid.getDirectExtensions());
                continue;
            }
            if ("newClass".equals(inheritanceStrategy)) {
                wrapper = this.class2wrapper.get(candid);
                if (wrapper == null) continue;
                ret.add(wrapper);
                continue;
            }
            if (!"newAndSubClass".equals(inheritanceStrategy)) continue;
            wrapper = this.class2wrapper.get(candid);
            if (wrapper != null) {
                ret.add(wrapper);
            }
            candids.addAll(candid.getDirectExtensions());
        }
        this.targetTablesPool.put(destination, ret);
        return ret;
    }

    protected static AbstractClassDef getCatalogueRefTarget(Type type) {
        return ((ReferenceType)((AttributeDef)((CompositionType)type).getComponentType().getAttributes().next()).getDomain()).getReferred();
    }

    protected String getSqlAttrName(AttributeDef def, Integer epsgCode, String ownerSqlTableName, String targetSqlTableName) {
        return this.ili2sqlName.mapIliAttributeDef(def, epsgCode, ownerSqlTableName, targetSqlTableName);
    }

    public DbTableName getSqlType(Viewable def) {
        String sqlname = this.ili2sqlName.mapIliClassDef(def);
        return new DbTableName(this.schemaName, sqlname);
    }

    public static boolean isUuidOid(TransferDescription td, Domain oid) {
        return oid != null && oid == td.INTERLIS.UUIDOID;
    }

    public static boolean isUuidOid(TransferDescription td, Viewable aclass) {
        throw new IllegalArgumentException("to be removed");
    }

    public static void addStdCol(DbTable table) {
        DbColDateTime dbCol = new DbColDateTime();
        dbCol.setName("T_LastChange");
        dbCol.setNotNull(true);
        table.addColumn((DbColumn)dbCol);
        dbCol = new DbColDateTime();
        dbCol.setName("T_CreateDate");
        dbCol.setNotNull(true);
        table.addColumn((DbColumn)dbCol);
        DbColVarchar dbColUsr = new DbColVarchar();
        dbColUsr.setName("T_User");
        dbColUsr.setNotNull(true);
        dbColUsr.setSize(40);
        table.addColumn((DbColumn)dbColUsr);
    }

    protected void setBB(DbColGeometry ret, AbstractCoordType coord, String scopedAttrName) {
        NumericalType[] dimv = coord.getDimensions();
        if (!(dimv[0] instanceof NumericType) || !(dimv[1] instanceof NumericType)) {
            EhiLogger.logError((String)("Attribute " + scopedAttrName + ": COORD type not supported (" + dimv[0].getClass().getName() + ")"));
            return;
        }
        if (((NumericType)dimv[0]).getMinimum() != null) {
            ret.setMin1(((NumericType)dimv[0]).getMinimum().toString());
            ret.setMax1(((NumericType)dimv[0]).getMaximum().toString());
            ret.setMin2(((NumericType)dimv[1]).getMinimum().toString());
            ret.setMax2(((NumericType)dimv[1]).getMaximum().toString());
            if (dimv.length == 3) {
                ret.setMin3(((NumericType)dimv[2]).getMinimum().toString());
                ret.setMax3(((NumericType)dimv[2]).getMaximum().toString());
            }
        }
    }

    protected int mapXtfCode2ItfCode(EnumerationType type, String xtfCode) {
        return Integer.parseInt(this.enumTypes.mapXtfCode2ItfCode(type, xtfCode));
    }

    protected String mapItfCode2XtfCode(EnumerationType type, int itfCode) {
        return this.enumTypes.mapItfCode2XtfCode(type, Integer.toString(itfCode));
    }

    public ArrayList<ViewableWrapper> getStructWrappers(Viewable structClass) {
        ArrayList<ViewableWrapper> ret = new ArrayList<ViewableWrapper>();
        ViewableWrapper structWrapper = this.class2wrapper.get(structClass);
        if (structWrapper != null) {
            while (structWrapper.getExtending() != null) {
                structWrapper = structWrapper.getExtending();
            }
            ret.add(structWrapper);
        }
        ArrayList exts = new ArrayList();
        exts.addAll(structClass.getDirectExtensions());
        while (exts.size() > 0) {
            structClass = (Viewable)exts.remove(0);
            structWrapper = this.class2wrapper.get(structClass);
            if (structWrapper != null) {
                while (structWrapper.getExtending() != null) {
                    structWrapper = structWrapper.getExtending();
                }
                if (ret.contains(structWrapper)) continue;
                ret.add(structWrapper);
                continue;
            }
            exts.addAll(structClass.getDirectExtensions());
        }
        return ret;
    }

    public boolean createTypeDiscriminator() {
        return this.createTypeDiscriminator;
    }

    protected DbTableName getEnumTargetTableName(AttributeDef attr, OutParam<String> iliname, String schema) {
        Type type = attr.getDomain();
        if (type instanceof TypeAlias) {
            Domain domain = ((TypeAlias)type).getAliasing();
            if (iliname != null) {
                iliname.value = domain.getScopedName();
            }
            domain = Ili2cUtility.getRootBaseDomain(domain);
            String sqlname = this.ili2sqlName.mapIliDomainDef(domain);
            return new DbTableName(schema, sqlname);
        }
        if (iliname != null) {
            iliname.value = attr.getScopedName();
        }
        attr = Ili2cUtility.getRootBaseAttr(attr);
        String sqlname = this.ili2sqlName.mapIliEnumAttributeDefAsTable(attr);
        return new DbTableName(schema, sqlname);
    }

    public Map<? extends Element, ? extends Element> getIomObjectAttrs(Viewable aclass) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Iterator iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            AttributeDef root;
            Type proxyType;
            AttributeDef attr;
            ViewableTransferElement obj = (ViewableTransferElement)iter.next();
            if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                root = Ili2cUtility.getRootBaseAttr(attr);
                ret.put(root, attr);
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            if (obj.embedded) {
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null) continue;
                root = Ili2cUtility.getRootBaseRole(role);
                ret.put(root, role);
                continue;
            }
            RoleDef root2 = Ili2cUtility.getRootBaseRole(role);
            ret.put(root2, role);
        }
        return ret;
    }

    protected boolean mapAsTextCol(AttributeDef attributeDef) {
        if (!this.sqlColsAsText) {
            return false;
        }
        return Ili2cUtility.isIomObjectPrimType(this.td, attributeDef);
    }
}

