/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.UnextendableView;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import java.beans.PropertyVetoException;
import java.util.List;

public class DecompositionView
extends UnextendableView {
    private ViewableAlias renamedViewable = null;
    protected ObjectPath decomposedAttribute = null;
    boolean areaDecomposition = false;

    public ObjectPath getDecomposedAttribute() {
        return this.decomposedAttribute;
    }

    public void setDecomposedAttribute(ObjectPath decomposedAttribute) throws PropertyVetoException {
        ObjectPath oldValue = this.decomposedAttribute;
        ObjectPath newValue = decomposedAttribute;
        if (oldValue == newValue) {
            return;
        }
        this.checkStateConsistency(newValue, this.areaDecomposition);
        this.fireVetoableChange("decomposedAttribute", oldValue, newValue);
        this.decomposedAttribute = newValue;
        this.firePropertyChange("decomposedAttribute", oldValue, newValue);
    }

    public boolean isAreaDecomposition() {
        return this.areaDecomposition;
    }

    public void setAreaDecomposition(boolean areaDecomposition) throws PropertyVetoException {
        boolean oldValue = this.areaDecomposition;
        boolean newValue = areaDecomposition;
        if (oldValue == newValue) {
            return;
        }
        this.checkStateConsistency(this.decomposedAttribute, newValue);
        this.fireVetoableChange("areaDecomposition", oldValue, newValue);
        this.areaDecomposition = newValue;
        this.firePropertyChange("areaDecomposition", oldValue, newValue);
    }

    private void checkStateConsistency(ObjectPath decomposedAttribute, boolean areaDecomposition) {
        Type decomposedType = null;
        if (decomposedAttribute != null) {
            decomposedType = Type.findReal(decomposedAttribute.getType());
        }
        if (decomposedType == null) {
            return;
        }
        if (!(decomposedType instanceof SurfaceOrAreaType || decomposedType instanceof CompositionType || decomposedType instanceof PolylineType)) {
            throw new IllegalArgumentException(DecompositionView.formatMessage("err_decompositionView_notDecomposable", decomposedAttribute.toString()));
        }
        if (areaDecomposition && !(decomposedType instanceof AreaType)) {
            throw new IllegalArgumentException(DecompositionView.formatMessage("err_decompositionView_areaDecompNotOnArea", this.toString(), decomposedAttribute.toString()));
        }
    }

    public ViewableAlias getRenamedViewable() {
        return this.renamedViewable;
    }

    public void setRenamedViewable(ViewableAlias renamedViewable) {
        this.renamedViewable = renamedViewable;
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        DecompositionView baseElement = (DecompositionView)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        Ili2cSemanticException err = null;
        err = DecompositionView.checkElementRef(this.getRenamedViewable().getAliasing(), baseElement.getRenamedViewable().getAliasing(), this.getSourceLine(), "err_diff_baseViewMismatch");
        if (err != null) {
            errs.add(err);
        }
        if ((err = Evaluable.checkTranslation(this.getDecomposedAttribute(), baseElement.getDecomposedAttribute(), this.getSourceLine(), "err_diff_objectPathMismatch")) == null && this.isAreaDecomposition() != baseElement.isAreaDecomposition()) {
            err = new Ili2cSemanticException(this.getSourceLine(), Element.formatMessage("err_diff_objectPathMismatch"));
        }
        if (err != null) {
            errs.add(err);
        }
    }
}

