/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.NumericOIDType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextOIDType;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class XSD24Generator {
    public static final String XTF24_XMLNSBASE = "http://www.interlis.ch/xtf/2.4";
    public static final String GEOM_XMLNS = "http://www.interlis.ch/geometry/1.0";
    public static final String INTERLIS_XMLNS = "http://www.interlis.ch/xtf/2.4/INTERLIS";
    public static final String BID_ATTR = "bid";
    public static final String CONSISTENCY_ATTR = "consistency";
    public static final String CONSISTENCY_ATTR_COMPLETE = "COMPLETE";
    public static final String CONSISTENCY_ATTR_INCOMPLETE = "INCOMPLETE";
    public static final String DOMAINS_ATTR = "domains";
    public static final String KIND_ATTR = "kind";
    public static final String KIND_ATTR_FULL = "FULL";
    public static final String KIND_ATTR_UPDATE = "UPDATE";
    public static final String KIND_ATTR_INITIAL = "INITIAL";
    public static final String STARTSTATE_ATTR = "startstate";
    public static final String ENDSTATE_ATTR = "endstate";
    public static final String TID_ATTR = "tid";
    public static final String OPERATION_ATTR = "operation";
    public static final String OPERATION_ATTR_INSERT = "INSERT";
    public static final String OPERATION_ATTR_UPDATE = "UPDATE";
    public static final String OPERATION_ATTR_DELETE = "DELETE";
    public static final String ORDER_POS_ATTR = "order_pos";
    public static final String ORDER_POS_TYPE = "orderposType";
    public static final String REF_ATTR = "ref";
    public static final String REF_TYPE = "refType";
    IndentPrintWriter ipw;
    TransferDescription td;
    File outdir;
    private Model currentModel = null;
    HashMap def2name = null;

    public static void generate(TransferDescription td, File outfolder) {
        XSD24Generator gen = new XSD24Generator();
        gen.outdir = outfolder;
        gen.td = td;
        gen.setupNameMapping();
        gen.printXSD(td);
    }

    private static String getTransferName(Element elt) {
        if (elt instanceof Model) {
            return elt.getName();
        }
        if (elt instanceof Topic) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Viewable) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Domain) {
            return elt.getScopedName(null);
        }
        if (elt instanceof AttributeDef) {
            return elt.getName();
        }
        if (elt instanceof RoleDef) {
            return elt.getName();
        }
        throw new IllegalArgumentException();
    }

    private void printXSD(TransferDescription td) {
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object mObj = modeli.next();
            if (!(mObj instanceof Model) || mObj instanceof PredefinedModel) continue;
            Model model = (Model)mObj;
            this.printModel(model);
        }
    }

    private void setupNameMapping() {
        this.def2name = XSD24Generator.createDef2NameMapping(this.td);
    }

    public static HashMap createName2NameMapping(TransferDescription td) {
        HashMap def2name = XSD24Generator.createDef2NameMapping(td);
        HashMap ret = new HashMap();
        for (Element def : def2name.keySet()) {
            if (def instanceof AttributeDef) {
                ret.put(def.getContainer().getScopedName(null) + "." + def.getName(), def2name.get(def));
                continue;
            }
            ret.put(def.getScopedName(null), def2name.get(def));
        }
        return ret;
    }

    public static HashMap createDef2NameMapping(TransferDescription td) {
        HashMap<Element, String> def2name = new HashMap<Element, String>();
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object modelo = modeli.next();
            if (!(modelo instanceof Model)) continue;
            Model model = (Model)modelo;
            HashMap<String, Element> name2def = new HashMap<String, Element>();
            HashSet<String> nameSet = new HashSet<String>();
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Element ele = (Element)topici.next();
                String eleName = ele.getName();
                nameSet.add(eleName);
                name2def.put(eleName, ele);
                def2name.put(ele, eleName);
            }
            topici = model.iterator();
            while (topici.hasNext()) {
                Object topico = topici.next();
                if (!(topico instanceof Topic)) continue;
                Topic topic = (Topic)topico;
                String topicName = topic.getName();
                Iterator classi = topic.iterator();
                while (classi.hasNext()) {
                    Element aclass = (Element)classi.next();
                    String className = aclass.getName();
                    if (nameSet.contains(className)) {
                        Element exstEle;
                        if (name2def.containsKey(className) && !((exstEle = (Element)name2def.get(className)).getContainer() instanceof Model)) {
                            String scopedName = exstEle.getContainer().getName() + "." + exstEle.getName();
                            name2def.remove(className);
                            name2def.put(scopedName, exstEle);
                            def2name.remove(exstEle);
                            def2name.put(exstEle, scopedName);
                        }
                        String scopedName = topicName + "." + className;
                        name2def.put(scopedName, aclass);
                        def2name.put(aclass, scopedName);
                        continue;
                    }
                    name2def.put(className, aclass);
                    def2name.put(aclass, className);
                    nameSet.add(className);
                }
            }
        }
        return def2name;
    }

    private String getScopedName(Element elt) {
        if (!this.def2name.containsKey(elt)) {
            throw new IllegalArgumentException("unexpected model element: " + elt.getScopedName(null));
        }
        Model eleModel = (Model)elt.getContainer(Model.class);
        String eleName = (String)this.def2name.get(elt);
        if (eleModel == this.currentModel) {
            return eleName;
        }
        return eleModel.getName() + ":" + eleName;
    }

    private String getName(Element elt) {
        if (!this.def2name.containsKey(elt)) {
            throw new IllegalArgumentException("unexpected model element: " + elt.getScopedName(null));
        }
        String eleName = (String)this.def2name.get(elt);
        return eleName;
    }

    private void printModel(Model model) {
        int modeli;
        File filename = new File(this.outdir, model.getName() + ".xsd");
        try {
            this.ipw = new IndentPrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8")));
        }
        catch (IOException ex) {
            EhiLogger.logError((Throwable)ex);
            return;
        }
        this.currentModel = model;
        this.ipw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.ipw.println("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        this.ipw.indent();
        this.ipw.println("xmlns=\"http://www.interlis.ch/xtf/2.4/" + model.getName() + "\"");
        this.ipw.println("targetNamespace=\"http://www.interlis.ch/xtf/2.4/" + model.getName() + "\"");
        this.ipw.println("xmlns:" + this.getGeomXmlnsNc() + "=\"" + GEOM_XMLNS + "\"");
        this.ipw.println("xmlns:" + this.getIliXmlnsNc() + "=\"" + INTERLIS_XMLNS + "\"");
        this.ipw.println("xmlns:ili2c=\"http://www.interlis.ch/ili2c\"");
        Model[] importedModels = model.getImporting();
        for (modeli = 0; modeli < importedModels.length; ++modeli) {
            if (importedModels[modeli] == this.td.INTERLIS) continue;
            this.ipw.println("xmlns:" + importedModels[modeli].getName() + "=\"" + XTF24_XMLNSBASE + "/" + importedModels[modeli].getName() + "\"");
        }
        this.ipw.println("elementFormDefault=\"qualified\" attributeFormDefault=\"qualified\">");
        this.ipw.unindent();
        this.ipw.println("<xsd:annotation>");
        this.ipw.indent();
        this.ipw.print("<xsd:appinfo source=\"http://www.interlis.ch/ili2c/ili2cversion\">");
        this.ipw.print(TransferDescription.getVersion());
        this.ipw.println("</xsd:appinfo>");
        this.ipw.println("<xsd:appinfo source=\"http://www.interlis.ch/ili2c\">");
        this.ipw.indent();
        this.ipw.println("<ili2c:model>" + model.getName() + "</ili2c:model>");
        if (!model.getIliVersion().equals("1")) {
            this.ipw.println("<ili2c:modelVersion>" + model.getModelVersion() + "</ili2c:modelVersion>");
            if (model.getModelVersionExpl() != null) {
                this.ipw.println("<ili2c:modelVersionExplanation>" + model.getModelVersionExpl() + "</ili2c:modelVersionExplanation>");
            }
            this.ipw.println("<ili2c:modelAt>" + model.getIssuer() + "</ili2c:modelAt>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:appinfo>");
        this.ipw.unindent();
        this.ipw.println("</xsd:annotation>");
        this.ipw.println("<xsd:import namespace=\"http://www.interlis.ch/geometry/1.0\"/>");
        this.ipw.println("<xsd:import namespace=\"http://www.interlis.ch/xtf/2.4/INTERLIS\"/>");
        for (modeli = 0; modeli < importedModels.length; ++modeli) {
            if (importedModels[modeli] == this.td.INTERLIS) continue;
            this.ipw.println("<xsd:import namespace=\"http://www.interlis.ch/xtf/2.4/" + importedModels[modeli].getName() + "\"/>");
        }
        Iterator topici = model.iterator();
        while (topici.hasNext()) {
            Object tObj = topici.next();
            if (tObj instanceof Domain) {
                this.declareDomainDef((Domain)tObj);
            }
            if (tObj instanceof AbstractClassDef) {
                this.declareAbstractClassDef((AbstractClassDef)tObj);
            }
            if (tObj instanceof LineForm) {
                this.declareLineForm((LineForm)tObj);
            }
            if (!(tObj instanceof Topic)) continue;
            Topic topic = (Topic)tObj;
            this.declareTopic(topic);
        }
        this.ipw.println("</xsd:schema>");
        this.ipw.close();
    }

    private void declareTopic(Topic topic) {
        Iterator<Object> iter = topic.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Domain) {
                this.declareDomainDef((Domain)obj);
            }
            if (!(obj instanceof AbstractClassDef)) continue;
            this.declareAbstractClassDef((AbstractClassDef)obj);
        }
        Topic extended = (Topic)topic.getExtending();
        this.ipw.println("<xsd:element name=\"" + this.getName(topic) + "\" type=\"" + this.getName(topic) + "Type\"/>");
        this.ipw.println("<xsd:complexType name=\"" + this.getName(topic) + "Type\">");
        this.ipw.indent();
        this.ipw.println("<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        this.ipw.indent();
        for (Object object : this.getTopicXsdElements(topic)) {
            if (!(object instanceof Viewable) || XSD24Generator.suppressViewableInTopicDef((Viewable)object)) continue;
            Viewable v = (Viewable)object;
            this.ipw.println("<xsd:element ref=\"" + this.getScopedName(v) + "\"/>");
        }
        boolean bl = this.getInheritedMetaValueBoolean(topic, "ili2c.ili23xml.supportIncrementalTransfer", false);
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + BID_ATTR + "\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + CONSISTENCY_ATTR + "\"/>");
        if (bl) {
            this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + KIND_ATTR + "\"/>");
            this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + STARTSTATE_ATTR + "\"/>");
            this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + ENDSTATE_ATTR + "\"/>");
        }
        if (topic.getDefferedGenerics().length > 0) {
            this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + DOMAINS_ATTR + "\" use=\"required\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    public static boolean suppressViewableInTopicDef(Viewable<?> v) {
        Topic topic;
        if (v == null) {
            return true;
        }
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.isLightweight()) {
                return true;
            }
            if (assoc.getDerivedFrom() != null) {
                return true;
            }
        }
        if (v instanceof View && (topic = (Topic)v.getContainer(Topic.class)) != null && !topic.isViewTopic()) {
            return true;
        }
        return v instanceof Table && !((Table)v).isIdentifiable();
    }

    private List<Viewable<?>> getTopicXsdElements(AbstractPatternDef topic) {
        ArrayList result = new ArrayList();
        ArrayList<AbstractPatternDef> topics = new ArrayList<AbstractPatternDef>();
        for (AbstractPatternDef t = topic; t != null; t = (AbstractPatternDef)t.getRealExtending()) {
            topics.add(0, t);
        }
        for (AbstractPatternDef t : topics) {
            Iterator iter = t.iterator();
            while (iter.hasNext()) {
                Element obj = (Element)iter.next();
                if (!(obj instanceof Viewable)) continue;
                if (obj instanceof Table && ((Table)obj).getExtending() == null) {
                    result.add((Table)obj);
                    continue;
                }
                if (!(obj instanceof AssociationDef) || ((AssociationDef)obj).getExtending() != null) continue;
                result.add((AssociationDef)obj);
            }
        }
        return result;
    }

    private void declareAbstractClassDef(Viewable v) {
        Viewable extended;
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.getDerivedFrom() != null) {
                return;
            }
            if (v.isFinal() && !v.getAttributes().hasNext() && assoc.isLightweight()) {
                return;
            }
        }
        if ((extended = (Viewable)v.getExtending()) != null) {
            this.ipw.println("<xsd:element name=\"" + this.getName(v) + "\" type=\"" + this.getName(v) + "Type\" substitutionGroup=\"" + this.getScopedName(extended) + "\"/>");
        } else {
            this.ipw.println("<xsd:element name=\"" + this.getName(v) + "\" type=\"" + this.getName(v) + "Type\"/>");
        }
        this.ipw.println("<xsd:complexType  name=\"" + this.getName(v) + "Type\">");
        if (extended != null) {
            this.ipw.indent();
            this.ipw.println("<xsd:complexContent>");
            this.ipw.indent();
            this.ipw.println("<xsd:extension base=\"" + this.getScopedName(extended) + "Type\">");
        }
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        Iterator<ViewableTransferElement> iter = null;
        iter = v.getAttributesAndRoles2();
        while (iter.hasNext()) {
            RoleDef oppend;
            AssociationDef roleOwner;
            AttributeDef attr;
            ViewableTransferElement obj = iter.next();
            if (obj.obj instanceof AttributeDef && (attr = (AttributeDef)obj.obj).getExtending() == null && attr.getContainer() == v && !attr.isTransient()) {
                this.declareAttribute(attr);
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            if (!obj.embedded && !((AssociationDef)v).isLightweight() && v.getExtending() == null && role.getExtending() == null) {
                this.ipw.println("<xsd:element name=\"" + XSD24Generator.getTransferName(role) + "\">");
                this.ipw.indent();
                this.ipw.println("<xsd:complexType>");
                this.ipw.indent();
                this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + REF_ATTR + "\" use=\"required\"/>");
                if (role.isOrdered()) {
                    this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + ORDER_POS_ATTR + "\" use=\"required\"/>");
                }
                this.ipw.unindent();
                this.ipw.println("</xsd:complexType>");
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
            }
            if (!obj.embedded || (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() != null || (oppend = role.getOppEnd()).getExtending() != null || oppend.getDestination() != v) continue;
            Cardinality card = role.getCardinality();
            String minOccurs = "";
            if (card.getMinimum() == 0L) {
                minOccurs = " minOccurs=\"0\"";
            }
            this.ipw.println("<xsd:element name=\"" + XSD24Generator.getTransferName(role) + "\"" + minOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            if (!roleOwner.isFinal() || roleOwner.getAttributes().hasNext()) {
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:element ref=\"" + this.getScopedName(roleOwner) + "\" minOccurs=\"0\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
            }
            this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + REF_ATTR + "\" use=\"required\"/>");
            if (oppend.isOrdered()) {
                this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + ORDER_POS_ATTR + "\" use=\"required\"/>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        if (extended == null && v instanceof Table && ((Table)v).isIdentifiable()) {
            boolean supportIncrementalTransfer;
            this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + TID_ATTR + "\" use=\"required\"/>");
            Container container = v.getContainer();
            if (container instanceof Topic && (supportIncrementalTransfer = this.getInheritedMetaValueBoolean((Topic)container, "ili2c.ili23xml.supportIncrementalTransfer", false))) {
                this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + OPERATION_ATTR + "/>");
            }
        }
        if (extended != null) {
            this.ipw.unindent();
            this.ipw.println("</xsd:extension>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexContent>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    private void declareDomainDef(Domain domain) {
        Type type = domain.getType();
        if (type instanceof TypeAlias) {
            Domain realDomain = ((TypeAlias)type).getAliasing();
            Type realType = realDomain.getType();
            String base = null;
            String facets = null;
            if (realDomain == this.td.INTERLIS.URI) {
                base = "xsd:anyURI";
                facets = "<xsd:maxLength value=\"1023\"/>";
            } else if (realDomain == this.td.INTERLIS.NAME) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"255\"/><xsd:pattern value=\"[a-zA-Z][a-zA-Z0-9_]*\"/>";
            } else if (realDomain == this.td.INTERLIS.INTERLIS_1_DATE) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"8\"/><xsd:pattern value=\"[0-9]*\"/>";
            } else if (realDomain == this.td.INTERLIS.BOOLEAN) {
                base = "xsd:boolean";
            } else if (realDomain == this.td.INTERLIS.HALIGNMENT) {
                base = this.getIliXmlns() + "HALIGNMENT";
            } else if (realDomain == this.td.INTERLIS.VALIGNMENT) {
                base = this.getIliXmlns() + "VALIGNMENT";
            } else if (realDomain == this.td.INTERLIS.XmlDate) {
                base = "xsd:date";
            } else if (realDomain == this.td.INTERLIS.XmlDateTime) {
                base = "xsd:dateTime";
            } else if (realDomain == this.td.INTERLIS.XmlTime) {
                base = "xsd:time";
            } else {
                throw new IllegalArgumentException(realDomain.getScopedName(null) + ": type " + type.getClass() + " not yet supported");
            }
            this.ipw.println("<xsd:simpleType name=\"" + this.getName(domain) + "\">");
            this.ipw.indent();
            if (facets == null) {
                this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            } else {
                this.ipw.println("<xsd:restriction base=\"" + base + "\">");
                this.ipw.indent();
                this.ipw.println(facets);
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else {
            this.declareType(type, domain, domain.isFinal());
        }
    }

    private void declareAttribute(AttributeDef attribute) {
        Type type;
        Cardinality card = attribute.getDomain().getCardinality();
        String minOccurs = "";
        if (card.getMinimum() != 1L) {
            minOccurs = " minOccurs=\"" + Long.toString(card.getMinimum()) + "\"";
        }
        String maxOccurs = "";
        if (card.getMaximum() != 1L) {
            maxOccurs = card.getMaximum() == Long.MAX_VALUE ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + Long.toString(card.getMaximum()) + "\"";
        }
        if ((type = attribute.getDomain()) instanceof TypeAlias) {
            Domain realDomain = ((TypeAlias)type).getAliasing();
            String base = null;
            String facets = null;
            if (realDomain == this.td.INTERLIS.URI) {
                base = "xsd:anyURI";
                facets = "<xsd:maxLength value=\"1023\"/>";
            } else if (realDomain == this.td.INTERLIS.NAME) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"255\"/><xsd:pattern value=\"[a-zA-Z][a-zA-Z0-9_]*\"/>";
            } else if (realDomain == this.td.INTERLIS.INTERLIS_1_DATE) {
                base = "xsd:token";
                facets = "<xsd:maxLength value=\"8\"/><xsd:pattern value=\"[0-9]*\"/>";
            } else {
                base = realDomain == this.td.INTERLIS.BOOLEAN ? "xsd:boolean" : (realDomain == this.td.INTERLIS.HALIGNMENT ? this.getIliXmlns() + "HALIGNMENT" : (realDomain == this.td.INTERLIS.VALIGNMENT ? this.getIliXmlns() + "VALIGNMENT" : (realDomain == this.td.INTERLIS.ANYOID ? "xsd:token" : (realDomain == this.td.INTERLIS.I32OID ? this.getIliXmlns() + "I32OID" : (realDomain == this.td.INTERLIS.STANDARDOID ? this.getIliXmlns() + "STANDARDOID" : (realDomain == this.td.INTERLIS.UUIDOID ? this.getIliXmlns() + "UUIDOID" : (realDomain == this.td.INTERLIS.GregorianYear ? "xsd:gYear" : (realDomain == this.td.INTERLIS.XmlTime ? "xsd:time" : (realDomain == this.td.INTERLIS.XmlDate ? "xsd:date" : (realDomain == this.td.INTERLIS.XmlDateTime ? "xsd:dateTime" : this.getScopedName(realDomain)))))))))));
            }
            if (facets == null) {
                this.ipw.println("<xsd:element name=\"" + XSD24Generator.getTransferName(attribute) + "\" type=\"" + base + "\"" + minOccurs + maxOccurs + "/>");
            } else {
                this.ipw.println("<xsd:element name=\"" + XSD24Generator.getTransferName(attribute) + "\"" + minOccurs + maxOccurs + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:simpleType>");
                this.ipw.indent();
                this.ipw.println("<xsd:restriction base=\"" + base + "\">");
                this.ipw.indent();
                this.ipw.println(facets);
                this.ipw.unindent();
                this.ipw.println("</xsd:restriction>");
                this.ipw.unindent();
                this.ipw.println("</xsd:simpleType>");
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
            }
        } else if (type instanceof CompositionType) {
            CompositionType composition = (CompositionType)type;
            Table part = composition.getComponentType();
            this.ipw.println("<xsd:element name=\"" + XSD24Generator.getTransferName(attribute) + "\"" + minOccurs + maxOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"" + this.getScopedName(part) + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof ReferenceType) {
            this.ipw.println("<xsd:element name=\"" + XSD24Generator.getTransferName(attribute) + "\"" + minOccurs + maxOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute ref=\"" + this.getIliXmlns() + REF_ATTR + "\" use=\"required\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else {
            this.ipw.println("<xsd:element name=\"" + XSD24Generator.getTransferName(attribute) + "\"" + minOccurs + maxOccurs + ">");
            this.ipw.indent();
            this.declareType(type, null, attribute.isFinal());
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
    }

    private void declareType(Type type, Domain domain, boolean isFinal) {
        String typeName = "";
        if (domain != null) {
            typeName = " name=\"" + this.getName(domain) + "\"";
        }
        if (type instanceof PolylineType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"geom:polyline\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof MultiPolylineType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"geom:multipolyline\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"geom:surface\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof MultiSurfaceOrAreaType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"geom:multisurface\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof CoordType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"geom:coord\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof MultiCoordType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"geom:multicoord\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof EnumerationType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
            if (isFinal) {
                this.ipw.indent();
                ArrayList ev = new ArrayList();
                this.buildEnumList(ev, "", ((EnumerationType)type).getConsolidatedEnumeration());
                for (String value : ev) {
                    this.ipw.println("<xsd:enumeration value=\"" + value + "\"/>");
                }
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof NumericType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            if (type.isAbstract()) {
                this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                this.ipw.println("</xsd:restriction>");
            } else {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                if (min.getAccuracy() > 0) {
                    if (min.getExponent() != 0) {
                        this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                        this.ipw.indent();
                        this.ipw.println("<xsd:minInclusive value=\"" + ((NumericType)type).getMinimum() + "\"/>");
                        this.ipw.println("<xsd:maxInclusive value=\"" + ((NumericType)type).getMaximum() + "\"/>");
                        this.ipw.unindent();
                    } else {
                        this.ipw.println("<xsd:restriction base=\"xsd:decimal\">");
                        this.ipw.indent();
                        this.ipw.println("<xsd:minInclusive value=\"" + ((NumericType)type).getMinimum().toString() + "\"/>");
                        this.ipw.println("<xsd:maxInclusive value=\"" + ((NumericType)type).getMaximum().toString() + "\"/>");
                        this.ipw.unindent();
                    }
                    this.ipw.println("</xsd:restriction>");
                } else {
                    this.ipw.println("<xsd:restriction base=\"xsd:integer\">");
                    this.ipw.indent();
                    this.ipw.println("<xsd:minInclusive value=\"" + (int)((NumericType)type).getMinimum().doubleValue() + "\"/>");
                    this.ipw.println("<xsd:maxInclusive value=\"" + (int)((NumericType)type).getMaximum().doubleValue() + "\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:restriction>");
                }
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof TextType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            if (((TextType)type).isNormalized()) {
                this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
            } else {
                this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            }
            if (((TextType)type).getMaxLength() > 0) {
                this.ipw.indent();
                this.ipw.println("<xsd:maxLength value=\"" + ((TextType)type).getMaxLength() + "\"/>");
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof FormattedType) {
            String base;
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            Domain baseDomain = ((FormattedType)type).getDefinedBaseDomain();
            if (baseDomain == this.td.INTERLIS.XmlDate) {
                base = "xsd:date";
            } else if (baseDomain == this.td.INTERLIS.XmlDateTime) {
                base = "xsd:dateTime";
            } else if (baseDomain == this.td.INTERLIS.XmlTime) {
                base = "xsd:time";
            } else {
                baseDomain = null;
                base = "xsd:normalizedString";
            }
            this.ipw.println("<xsd:restriction base=\"" + base + "\">");
            if (baseDomain == null) {
                this.ipw.println("<xsd:pattern value=\"" + ((FormattedType)type).getRegExp() + "\"/>");
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof BlackboxType) {
            if (((BlackboxType)type).getKind() == 1) {
                this.ipw.println("<xsd:complexType " + typeName + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:any namespace=\"##any\" minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"lax\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
                this.ipw.unindent();
                this.ipw.println("</xsd:complexType>");
            } else {
                this.ipw.println("<xsd:simpleType " + typeName + ">");
                this.ipw.indent();
                this.ipw.println("<xsd:restriction base=\"xsd:base64Binary\">");
                this.ipw.println("</xsd:restriction>");
                this.ipw.unindent();
                this.ipw.println("</xsd:simpleType>");
            }
        } else if (type instanceof ClassType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:normalizedString";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof AttributePathType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:normalizedString";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof NumericOIDType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:int";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof TextOIDType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:token";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof StructuredUnitType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            String base = "xsd:token";
            this.ipw.println("<xsd:restriction base=\"" + base + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else {
            throw new IllegalArgumentException("type " + type.getClass() + " not yet supported");
        }
    }

    private void declareLineForm(LineForm form) {
        EhiLogger.logAdaption((String)("User defined line form " + form.getScopedName(null) + " not yet supported"));
    }

    private void buildEnumList(List accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                this.buildEnumList(accu, prefix + ee.getName(), subEnum);
                continue;
            }
            accu.add(prefix + ee.getName());
        }
    }

    private String getIliXmlns() {
        return this.getIliXmlnsNc() + ":";
    }

    private String getGeomXmlns() {
        return this.getGeomXmlnsNc() + ":";
    }

    private String getIliXmlnsNc() {
        return "INTERLIS";
    }

    private String getGeomXmlnsNc() {
        return "geom";
    }

    private boolean getInheritedMetaValueBoolean(Topic topic, String metaAttrName, boolean defVal) {
        String val = topic.getMetaValue(metaAttrName);
        if (val == null) {
            val = topic.getContainer().getMetaValue(metaAttrName);
        }
        if (val != null) {
            if (val.equals("true")) {
                return true;
            }
            if (val.equals("false")) {
                return false;
            }
            EhiLogger.logError((String)(topic.getScopedName(null) + ": unexpected value <" + val + "> for " + metaAttrName));
        }
        return defVal;
    }
}

