/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.types.OutParam;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.OidSpace;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.IoxSyntaxException;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Xtf23Reader
implements IoxReader,
IoxIliReader {
    private XMLEventReader reader = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private InputStream inputFile = null;
    private int oidSpaceSize = 0;
    private List<XtfModel> models = new ArrayList<XtfModel>();
    private Set<String> filterTopics = null;
    private boolean isXtf23Reader0_compatible = true;
    private boolean ili22 = false;
    private int state = 0;
    private static final int START = 0;
    private static final int AFTER_STARTTRANSFER = 1;
    private static final int AFTER_STARTBASKET = 2;
    private static final int AFTER_OBJECT = 3;
    private static final int AFTER_ENDBASKET = 4;
    private static final int AFTER_ENDTRANSFER = 5;
    public static final String NAMESPACE_XTF23 = "http://www.interlis.ch/INTERLIS2.3";
    public static final String NAMESPACE_XTF22 = "http://www.interlis.ch/INTERLIS2.2";
    @Deprecated
    public static final String NAMESPACE_ILIXMLBASE = "http://www.interlis.ch/INTERLIS2.3";
    private String currentTopicName = null;
    private static final String INTERLIS_VERSION_23 = "2.3";
    private static final String INTERLIS_VERSION_22 = "2.2";
    private static final String NAME_XML_HEADERSECTION = "HEADERSECTION";
    private static final QName QNAME_XML_HEADERSECTION_SENDER = new QName("SENDER");
    private static final QName QNAME_XML_HEADERSECTION_VERSION = new QName("VERSION");
    private static final String NAME_XML_MODELS = "MODELS";
    private static final String NAME_XML_MODEL = "MODEL";
    private static final QName QNAME_XML_MODEL_NAME = new QName("NAME");
    private static final QName QNAME_XML_MODEL_VERSION = new QName("VERSION");
    private static final QName QNAME_XML_MODEL_URI = new QName("URI");
    private static final QName QNAME_XML_OIDSPACES = new QName("http://www.interlis.ch/INTERLIS2.3", "OIDSPACES");
    private static final QName QNAME_XML_OIDSPACE = new QName("http://www.interlis.ch/INTERLIS2.3", "OIDSPACE");
    private static final QName QNAME_XML_OIDSPACE_OIDDOMAIN = new QName("OIDDOMAIN");
    private static final QName QNAME_XML_OIDSPACE_NAME = new QName("NAME");
    private static final String QNAME_XML_ENTRIES = "ENTRIES";
    private static final String QNAME_XML_COMMENT = "COMMENT";
    private static final String NAME_XML_ALIAS = "ALIAS";
    private static final String QNAME_XML_ENTRIES_TAGENTRY = "TAGENTRY";
    private static final String QNAME_XML_ENTRIES_VALENTRY = "VALENTRY";
    private static final String QNAME_XML_ENTRIES_DELENTRY = "DELENTRY";
    private static final QName QNAME_XML_ENTRIES_VALUE_ATTR = new QName("ATTR");
    private static final QName QNAME_XML_ENTRIES_VALUE_FROM = new QName("FROM");
    private static final QName QNAME_XML_ENTRIES_VALUE_TO = new QName("TO");
    private static final QName QNAME_XML_ENTRIES_VALUE_TAG = new QName("TAG");
    private static final QName QNAME_XML_ENTRIES_VALUE_FOR = new QName("FOR");
    private static final QName QNAME_XML_TOPIC_BID = new QName("BID");
    private static final QName QNAME_XML_TOPIC_KIND = new QName("KIND");
    private static final String QNAME_XML_TOPIC_KIND_FULL = "FULL";
    private static final String QNAME_XML_TOPIC_KIND_UPDATE = "UPDATE";
    private static final String QNAME_XML_TOPIC_KIND_INITIAL = "INITIAL";
    private static final QName QNAME_XML_TOPIC_STARTSTATE = new QName("STARTSTATE");
    private static final QName QNAME_XML_TOPIC_ENDSTATE = new QName("ENDSTATE");
    private static final QName QNAME_XML_CONSISTENCY = new QName("CONSISTENCY");
    private static final String QNAME_XML_TOPIC_CONSISTENCY_COMPLETE = "COMPLETE";
    private static final String QNAME_XML_TOPIC_CONSISTENCY_INCOMPLETE = "INCOMPLETE";
    private static final String QNAME_XML_TOPIC_CONSISTENCY_INCONSISTENT = "INCONSISTENT";
    private static final String QNAME_XML_TOPIC_CONSISTENCY_ADAPTED = "ADAPTED";
    private static final String NAME_XML_DATASECTION = "DATASECTION";
    private static final QName QNAME_XML_OID = new QName("OID");
    private static final QName QNAME_XML_OBJECT_TID = new QName("TID");
    private static final QName QNAME_XML_OBJECT_OPERATION = new QName("OPERATION");
    private static final String XML_OPERATION_INSERT = "INSERT";
    private static final String XML_OPERATION_DELETE = "DELETE";
    private static final QName QNAME_XML_ORDERPOS = new QName("ORDER_POS");
    private static final String NAME_XML_TRANSFER = "TRANSFER";
    private static final QName QNAME_XML_REF = new QName("REF");
    private static final QName QNAME_XML_DOMAIN = new QName("DOMAINS");
    private static final String NAME_XML_DELETE = "DELETE";
    private static final String QNAME_XML_BINBLBOX = "BINBLBOX";
    private static final String QNAME_XML_XMLBLBOX = "XMLBLBOX";
    private static final String QNAME_XML_COORD = "COORD";
    private static final String QNAME_XML_ARC = "ARC";
    private static final String QNAME_XML_POLYLINE = "POLYLINE";
    private static final String QNAME_XML_BOUNDARY = "BOUNDARY";
    private static final String QNAME_XML_SURFACE = "SURFACE";
    private XMLEvent readAheadEvent = null;
    private int hsOid = 0;

    public Xtf23Reader(InputStream in) throws IoxException {
        this.init(in);
    }

    public Xtf23Reader(InputStreamReader in) throws IoxException {
    }

    public Xtf23Reader(File xtffile) throws IoxException {
        try {
            this.inputFile = new FileInputStream(xtffile);
            this.init(this.inputFile);
        }
        catch (IOException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void init(InputStream in) throws IoxException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            this.reader = inputFactory.createXMLEventReader(in);
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public void close() throws IoxException {
        this.reader = null;
        if (this.inputFile != null) {
            try {
                this.inputFile.close();
            }
            catch (IOException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.inputFile = null;
        }
    }

    public IoxEvent read() throws IoxException {
        try {
            if (this.state == 0) {
                this.readAheadEvent = this.reader.nextEvent();
                if (!this.readAheadEvent.isStartDocument()) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
                }
                this.readAheadEvent = this.nextEvent(this.readAheadEvent);
                if (!this.readAheadEvent.isStartElement() || !this.readAheadEvent.asStartElement().getName().equals(new QName("http://www.interlis.ch/INTERLIS2.3", NAME_XML_TRANSFER)) && !this.readAheadEvent.asStartElement().getName().equals(new QName(NAMESPACE_XTF22, NAME_XML_TRANSFER))) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
                }
                this.ili22 = this.readAheadEvent.asStartElement().getName().getNamespaceURI().equals(NAMESPACE_XTF22);
                this.readAheadEvent = this.nextEvent(this.readAheadEvent);
                XtfStartTransferEvent startTransferEvent = null;
                if (!this.readAheadEvent.isStartElement() || !this.readAheadEvent.asStartElement().getName().equals(this.getQName(NAME_XML_HEADERSECTION))) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
                }
                startTransferEvent = new XtfStartTransferEvent();
                this.readAheadEvent = this.readHeaderSection(this.readAheadEvent, startTransferEvent);
                HashMap<String, IomObject> modelx = new HashMap<String, IomObject>();
                for (XtfModel xtfModel : this.models) {
                    IomObject model = this.createIomObject("iom04.metamodel.ModelEntry", this.hsNextOid());
                    model.setattrvalue("model", xtfModel.getName());
                    if (xtfModel.getVersion() != null) {
                        model.setattrvalue("version", xtfModel.getVersion());
                    }
                    if (xtfModel.getUri() != null) {
                        model.setattrvalue("uri", xtfModel.getUri());
                    }
                    modelx.put(model.getobjectoid(), model);
                }
                startTransferEvent.setHeaderObjects(modelx);
                this.state = 1;
                return startTransferEvent;
            }
            if (this.state == 1) {
                if (!this.readAheadEvent.isStartElement() || !this.readAheadEvent.asStartElement().getName().equals(this.getQName(NAME_XML_DATASECTION))) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
                }
                this.readAheadEvent = this.nextEvent(this.readAheadEvent);
                if (this.readAheadEvent.isStartElement()) {
                    this.state = 2;
                    OutParam startBasketOut = new OutParam();
                    this.readAheadEvent = this.readStartBasket(this.readAheadEvent, (OutParam<IoxEvent>)startBasketOut);
                    return (IoxEvent)startBasketOut.value;
                }
                if (this.readAheadEvent.isEndElement()) {
                    this.state = 4;
                } else {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
                }
            }
            if (this.state == 2) {
                if (this.readAheadEvent.isStartElement()) {
                    StartElement startObjEle = this.readAheadEvent.asStartElement();
                    this.state = 3;
                    OutParam iomObjOut = new OutParam();
                    this.readAheadEvent = this.readObject(this.readAheadEvent, (OutParam<IomObject>)iomObjOut);
                    IomObject iomObj = (IomObject)iomObjOut.value;
                    this.setOperation(startObjEle, iomObj);
                    this.setConsistency(startObjEle, iomObj);
                    return new ObjectEvent(iomObj);
                }
                if (this.readAheadEvent.isEndElement()) {
                    assert (this.readAheadEvent.asEndElement().getName().equals(this.getQName(this.currentTopicName)));
                    this.readAheadEvent = this.nextEvent(this.readAheadEvent);
                    this.state = 4;
                    return new EndBasketEvent();
                }
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
            }
            if (this.state == 3) {
                if (this.readAheadEvent.isStartElement()) {
                    StartElement startObjEle = this.readAheadEvent.asStartElement();
                    OutParam iomObjOut = new OutParam();
                    this.readAheadEvent = this.readObject(this.readAheadEvent, (OutParam<IomObject>)iomObjOut);
                    IomObject iomObj = (IomObject)iomObjOut.value;
                    this.setOperation(startObjEle, iomObj);
                    this.setConsistency(startObjEle, iomObj);
                    return new ObjectEvent(iomObj);
                }
                if (this.readAheadEvent.isEndElement()) {
                    assert (this.readAheadEvent.asEndElement().getName().equals(this.getQName(this.currentTopicName)));
                    this.readAheadEvent = this.nextEvent(this.readAheadEvent);
                    this.state = 4;
                    return new EndBasketEvent();
                }
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
            }
            if (this.state == 4) {
                if (this.readAheadEvent.isStartElement()) {
                    this.state = 2;
                    OutParam startBasketOut = new OutParam();
                    this.readAheadEvent = this.readStartBasket(this.readAheadEvent, (OutParam<IoxEvent>)startBasketOut);
                    return (IoxEvent)startBasketOut.value;
                }
                if (this.readAheadEvent.isEndElement()) {
                    if (this.readAheadEvent.asEndElement().getName().equals(this.getQName(NAME_XML_DATASECTION))) {
                        this.readAheadEvent = this.nextEvent(this.readAheadEvent);
                    }
                    if (this.readAheadEvent.asEndElement().getName().equals(this.getQName(NAME_XML_TRANSFER))) {
                        this.readAheadEvent = this.nextEvent(this.readAheadEvent);
                        if (this.readAheadEvent.isEndDocument()) {
                            this.state = 5;
                            return new EndTransferEvent();
                        }
                        throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
                    }
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
                }
            }
            if (this.state == 5) {
                if (this.isXtf23Reader0_compatible) {
                    return null;
                }
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(this.readAheadEvent));
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
        return null;
    }

    private QName getQName(String localName) {
        return new QName(this.ili22 ? NAMESPACE_XTF22 : "http://www.interlis.ch/INTERLIS2.3", localName);
    }

    private XMLEvent readStartBasket(XMLEvent event, OutParam<IoxEvent> startBasketOut) throws IoxException, XMLStreamException {
        StartElement element = (StartElement)event;
        this.currentTopicName = this.getTopicFromQName(element.asStartElement().getName());
        if (this.currentTopicName == null) {
            throw new IoxException("missing topic name");
        }
        Attribute bid = element.getAttributeByName(QNAME_XML_TOPIC_BID);
        StartBasketEvent newObj = new StartBasketEvent(this.currentTopicName, this.stripX(bid.getValue()));
        newObj = this.setState(element, newObj);
        newObj = this.setConsistency(element, newObj);
        newObj = this.setDomain(element, newObj);
        newObj = this.setIncrementalKind(element, newObj);
        startBasketOut.value = newObj;
        event = this.nextEvent(event);
        return event;
    }

    private String getTopicFromQName(QName scopeName) {
        String iliQName = scopeName.getLocalPart();
        return iliQName;
    }

    private String getViewableFromQName(QName scopeName) {
        String iliQName = scopeName.getLocalPart();
        return iliQName;
    }

    private XMLEvent readHeaderSection(XMLEvent event, XtfStartTransferEvent xtfEvent) throws XMLStreamException, IoxException {
        Attribute version = event.asStartElement().getAttributeByName(QNAME_XML_HEADERSECTION_VERSION);
        if (version == null || !version.getValue().equals(INTERLIS_VERSION_23) && !version.getValue().equals(INTERLIS_VERSION_22)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        xtfEvent.setVersion(version.getValue());
        Attribute sender = event.asStartElement().getAttributeByName(QNAME_XML_HEADERSECTION_SENDER);
        if (sender == null) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        xtfEvent.setSender(sender.getValue());
        event = this.nextEvent(event);
        if (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(NAME_XML_MODELS))) {
            event = this.readHeaderSectionModels(xtfEvent, event);
        } else if (!this.isXtf23Reader0_compatible) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(NAME_XML_ALIAS))) {
            event = this.readHeaderSectionAlias(event);
        }
        if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_OIDSPACES)) {
            event = this.readHeaderSectionOidSpaces(event, xtfEvent);
        }
        if (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_COMMENT))) {
            event = this.readHeaderSectionComment(xtfEvent);
        }
        if (event.isEndElement()) {
            assert (event.asEndElement().getName().equals(this.getQName(NAME_XML_HEADERSECTION)));
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readHeaderSectionModels(XtfStartTransferEvent xtfEvent, XMLEvent startElementModels) throws IoxException, XMLStreamException {
        XMLEvent event = null;
        if (!startElementModels.isStartElement() || !startElementModels.asStartElement().getName().equals(this.getQName(NAME_XML_MODELS))) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        this.models = new ArrayList<XtfModel>();
        while (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(NAME_XML_MODEL))) {
            event = this.readHeaderSectionModel(event);
        }
        if (event.isEndElement() && event.asEndElement().getName().equals(this.getQName(NAME_XML_MODELS))) {
            if (this.models.size() == 0) {
                throw new IoxException("expected at least 1 model.");
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readHeaderSectionModel(XMLEvent startElementModel) throws IoxException, XMLStreamException {
        XMLEvent event = null;
        Attribute name = startElementModel.asStartElement().getAttributeByName(QNAME_XML_MODEL_NAME);
        Attribute version = startElementModel.asStartElement().getAttributeByName(QNAME_XML_MODEL_VERSION);
        Attribute uri = startElementModel.asStartElement().getAttributeByName(QNAME_XML_MODEL_URI);
        if (name != null && version != null && uri != null) {
            XtfModel xtfModel = new XtfModel(name.getValue(), version.getValue(), uri.getValue());
            this.models.add(xtfModel);
        } else if (name != null && this.isXtf23Reader0_compatible) {
            XtfModel xtfModel = new XtfModel(name.getValue(), version != null ? version.getValue() : null, uri != null ? uri.getValue() : null);
            this.models.add(xtfModel);
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementModel));
        }
        event = this.nextEvent(event);
        if (!event.isEndElement() || !event.asEndElement().getName().equals(this.getQName(NAME_XML_MODEL))) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readHeaderSectionAlias(XMLEvent event) throws IoxException, XMLStreamException {
        if (event.isStartElement()) {
            assert (event.asStartElement().getName().equals(this.getQName(NAME_XML_ALIAS)));
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES))) {
            event = this.readAliasEntries(event);
        }
        if (event.isStartElement() && !event.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES))) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (event.isEndElement()) {
            assert (event.asEndElement().getName().equals(this.getQName(NAME_XML_ALIAS)));
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readAliasEntries(XMLEvent event) throws IoxSyntaxException, XMLStreamException, IoxException {
        Attribute entryFor = event.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_FOR);
        if (entryFor == null) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        while (event.isStartElement() && (event.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_TAGENTRY)) || event.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_VALENTRY)) || event.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_DELENTRY)))) {
            event = this.readAliasEntry(event);
        }
        if (!event.isEndElement() || !event.asEndElement().getName().equals(this.getQName(QNAME_XML_ENTRIES))) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readAliasEntry(XMLEvent startElementAliasEntry) throws IoxSyntaxException, IoxException, XMLStreamException {
        XMLEvent event = null;
        if (startElementAliasEntry.isStartElement() && startElementAliasEntry.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_TAGENTRY))) {
            if (startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_FROM) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TO) == null) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.nextEvent(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_TAGENTRY))) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.nextEvent(event);
        } else if (startElementAliasEntry.isStartElement() && startElementAliasEntry.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_VALENTRY))) {
            if (startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TAG) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_ATTR) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_FROM) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TO) == null) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementAliasEntry));
            }
            event = this.nextEvent(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_VALENTRY))) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.nextEvent(event);
        } else if (startElementAliasEntry.isStartElement() && startElementAliasEntry.asStartElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_DELENTRY))) {
            if (startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TAG) == null) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementAliasEntry));
            }
            event = this.nextEvent(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(this.getQName(QNAME_XML_ENTRIES_DELENTRY))) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.nextEvent(event);
        }
        return event;
    }

    private XMLEvent readHeaderSectionOidSpaces(XMLEvent event, XtfStartTransferEvent xtfEvent) throws XMLStreamException, IoxException {
        ArrayList<OidSpace> oidSpaces;
        if ((event = this.nextEvent(event)).isStartElement() && event.asStartElement().getName().equals(QNAME_XML_OIDSPACE)) {
            oidSpaces = new ArrayList<OidSpace>();
            while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_OIDSPACE)) {
                event = this.readOidSpace(event, oidSpaces);
            }
            if (this.oidSpaceSize == 0) {
                throw new IoxException("expected at least 1 oid space");
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        xtfEvent.setOidSpaces(oidSpaces);
        if (event.isEndElement()) {
            assert (event.asEndElement().getName().equals(QNAME_XML_OIDSPACES));
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readOidSpace(XMLEvent startElementOidSpace, List<OidSpace> oidSpaces) throws IoxSyntaxException, IoxException, XMLStreamException {
        XMLEvent event = null;
        if (startElementOidSpace.asStartElement().getAttributeByName(QNAME_XML_OIDSPACE_NAME) != null || startElementOidSpace.asStartElement().getAttributeByName(QNAME_XML_OIDSPACE_OIDDOMAIN) != null) {
            Attribute oidSpace = startElementOidSpace.asStartElement().getAttributeByName(QNAME_XML_OIDSPACE_OIDDOMAIN);
            OidSpace oidSpaceObj = new OidSpace("oidSpace" + this.oidSpaceSize, oidSpace.getValue());
            oidSpaces.add(this.oidSpaceSize, oidSpaceObj);
            ++this.oidSpaceSize;
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementOidSpace));
        }
        event = this.nextEvent(event);
        if (event.isEndElement()) {
            assert (event.asEndElement().getName().equals(QNAME_XML_OIDSPACE));
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readHeaderSectionComment(XtfStartTransferEvent xtfEvent) throws IoxSyntaxException, XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        event = this.skipCommentary(event);
        StringBuffer value = new StringBuffer();
        event = this.readSimpleContent(event, value);
        xtfEvent.setComment(value.toString());
        if (event.isEndElement()) {
            assert (event.asEndElement().getName().equals(this.getQName(QNAME_XML_COMMENT)));
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent skipCommentary(XMLEvent event) throws XMLStreamException {
        while (event.getEventType() == 5) {
            event = this.reader.nextEvent();
        }
        return event;
    }

    private XMLEvent readObject(XMLEvent event, OutParam<IomObject> iomObjOut) throws IoxException {
        try {
            if (!event.isStartElement()) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            Attribute oid = event.asStartElement().getAttributeByName(QNAME_XML_OBJECT_TID);
            if (event.asStartElement().getAttributeByName(QNAME_XML_TOPIC_BID) != null) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            if (event.asStartElement().getName().equals(this.getQName("DELETE"))) {
                event = this.readDelete(event, iomObjOut);
                return event;
            }
            String currentViewableName = this.getViewableFromQName(event.asStartElement().getName());
            if (currentViewableName == null) {
                throw new IoxException("missing table name");
            }
            iomObjOut.value = oid != null ? this.createIomObject(currentViewableName, this.stripX(oid.getValue())) : this.createIomObject(currentViewableName, null);
            ((IomObject)iomObjOut.value).setobjectline(event.getLocation().getLineNumber());
            event = this.nextEvent(event);
            while (event.isStartElement()) {
                event = this.readAttribute(event, (IomObject)iomObjOut.value);
            }
            if ((event = this.nextEvent(event)).isEndElement() || event.isStartElement()) {
                return event;
            }
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMLEvent readDelete(XMLEvent event, OutParam<IomObject> iomObjOut) throws IoxException, XMLStreamException {
        Attribute attrTid = event.asStartElement().getAttributeByName(QNAME_XML_OBJECT_TID);
        if (attrTid == null) throw new IoxException("delete object needs tid");
        iomObjOut.value = this.createIomObject("DELETE", this.stripX(attrTid.getValue()));
        if (!(event = this.nextEvent(event)).isEndElement()) throw new IoxException("delete references are not yet implemented.");
        this.state = 2;
        if (event.asEndElement().getName().equals(this.getQName("DELETE"))) return this.nextEvent(event);
        throw new IoxException("expected rolename and role reference tid");
    }

    private IomObject setConsistency(StartElement element, IomObject iomObj) throws IoxException {
        Attribute consistency = element.getAttributeByName(QNAME_XML_CONSISTENCY);
        if (consistency != null) {
            String attrValue = consistency.getValue();
            if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_COMPLETE)) {
                iomObj.setobjectoperation(0);
            } else if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_INCOMPLETE)) {
                iomObj.setobjectoperation(1);
            } else if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_INCONSISTENT)) {
                iomObj.setobjectoperation(2);
            } else if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_ADAPTED)) {
                iomObj.setobjectoperation(3);
            } else {
                throw new IoxException("unexpected consistency <" + attrValue + ">");
            }
        }
        return iomObj;
    }

    private IomObject setOperation(StartElement element, IomObject iomObj) throws IoxException {
        Attribute operation = element.getAttributeByName(QNAME_XML_OBJECT_OPERATION);
        if (operation != null) {
            String attrValue = operation.getValue();
            if (attrValue.equals(XML_OPERATION_INSERT)) {
                iomObj.setobjectoperation(0);
            } else if (attrValue.equals(QNAME_XML_TOPIC_KIND_UPDATE)) {
                iomObj.setobjectoperation(1);
            } else if (attrValue.equals("DELETE")) {
                iomObj.setobjectoperation(2);
            } else {
                throw new IoxException("unexpected operation <" + attrValue + ">");
            }
        }
        return iomObj;
    }

    private StartBasketEvent setState(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (codingObj.getName().equals(QNAME_XML_TOPIC_STARTSTATE)) {
                startBasketEvent.setStartstate(codingObj.getValue());
                continue;
            }
            if (!codingObj.getName().equals(QNAME_XML_TOPIC_ENDSTATE)) continue;
            startBasketEvent.setEndstate(codingObj.getValue());
        }
        return startBasketEvent;
    }

    private StartBasketEvent setIncrementalKind(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_XML_TOPIC_KIND)) continue;
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_KIND_FULL)) {
                startBasketEvent.setKind(0);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_KIND_UPDATE)) {
                startBasketEvent.setKind(1);
                continue;
            }
            if (!codingObj.getValue().equals(QNAME_XML_TOPIC_KIND_INITIAL)) continue;
            startBasketEvent.setKind(2);
        }
        return startBasketEvent;
    }

    private StartBasketEvent setDomain(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        String[] genericAndConcreteDomains = null;
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_XML_DOMAIN)) continue;
            String domainValue = codingObj.getValue();
            for (String singleDomain : genericAndConcreteDomains = domainValue.split("\\,")) {
                startBasketEvent.addDomain(singleDomain, element.getName().getLocalPart());
            }
        }
        return startBasketEvent;
    }

    private StartBasketEvent setConsistency(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_XML_CONSISTENCY)) continue;
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_COMPLETE)) {
                startBasketEvent.setConsistency(0);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_INCOMPLETE)) {
                startBasketEvent.setConsistency(1);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_INCONSISTENT)) {
                startBasketEvent.setConsistency(2);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_ADAPTED)) {
                startBasketEvent.setConsistency(3);
                continue;
            }
            throw new IoxException("unexpected consistency <" + codingObj.getValue() + ">");
        }
        return startBasketEvent;
    }

    private XMLEvent collectXMLElement(XMLEvent event, StringWriter strw) throws XMLStreamException, IoxSyntaxException {
        XMLOutputFactory xmloutputf = XMLOutputFactory.newInstance();
        xmloutputf.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        XMLEventFactory.newInstance();
        XMLEventWriter xmlw = xmloutputf.createXMLEventWriter(strw);
        xmlw.add(event);
        int inHeader = 1;
        while (this.reader.hasNext()) {
            event = this.reader.nextEvent();
            xmlw.add(event);
            switch (event.getEventType()) {
                case 1: {
                    ++inHeader;
                    break;
                }
                case 2: {
                    --inHeader;
                }
            }
            if (inHeader == 0 && event.getEventType() == 2) break;
            if (inHeader >= 0) continue;
            throw new IllegalStateException("inHeader < 0");
        }
        xmlw.flush();
        xmlw.close();
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readSimpleContent(XMLEvent event, StringBuffer value) throws XMLStreamException, IoxSyntaxException {
        while (event.isCharacters()) {
            Characters characters = (Characters)event;
            value.append(characters.getData());
            event = this.reader.nextEvent();
        }
        return event;
    }

    private XMLEvent nextEvent(XMLEvent event) throws XMLStreamException, IoxSyntaxException {
        event = this.reader.nextEvent();
        while (event != null && (event.isCharacters() || event.getEventType() == 5)) {
            Characters characters;
            if (event.isCharacters() && !(characters = (Characters)event).isWhiteSpace()) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
        }
        return event;
    }

    private XMLEvent skipSpaces(XMLEvent event) throws XMLStreamException, IoxSyntaxException {
        while (event != null && (event.isCharacters() || event.getEventType() == 5)) {
            Characters characters;
            if (event.isCharacters() && !(characters = (Characters)event).isWhiteSpace()) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
        }
        return event;
    }

    private XMLEvent skipSpacesAndStopAtContent(XMLEvent event) throws XMLStreamException, IoxSyntaxException {
        while (event != null && (event.isCharacters() || event.getEventType() == 5)) {
            Characters characters;
            if (event.isCharacters() && !(characters = (Characters)event).isWhiteSpace()) {
                return event;
            }
            event = this.reader.nextEvent();
        }
        return event;
    }

    private String unexpectedXmlEvent2msg(XMLEvent actual) {
        StringBuilder output = new StringBuilder();
        output.append("Unexpected XML event ");
        if (actual instanceof StartElement) {
            output.append(actual.asStartElement().getName().getLocalPart());
        } else if (actual instanceof EndElement) {
            output.append(actual.asEndElement().getName().getLocalPart());
        } else if (actual instanceof Characters) {
            output.append(actual.asCharacters().getData());
        } else {
            output.append(actual.toString());
        }
        output.append(" found.");
        return output.toString();
    }

    private XMLEvent readAttribute(XMLEvent event, IomObject iomObj) throws IoxException {
        try {
            String attrName = null;
            StartElement startElement = event.asStartElement();
            if (startElement.getAttributeByName(QNAME_XML_REF) != null) {
                event = this.readReference(iomObj, startElement, startElement.getName().getLocalPart());
            } else if (startElement.getAttributeByName(QNAME_XML_OID) != null) {
                Attribute oidAttr = startElement.getAttributeByName(QNAME_XML_OID);
                attrName = startElement.getName().getLocalPart();
                iomObj.setattrvalue(attrName, oidAttr.getValue());
                event = this.nextEvent(event);
                event = this.nextEvent(event);
            } else {
                StringBuffer value;
                attrName = startElement.getName().getLocalPart();
                if (attrName == null) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                event = this.reader.nextEvent();
                if (event.isCharacters() && (event = this.readSimpleContent(event, value = new StringBuffer())).isEndElement()) {
                    iomObj.setattrvalue(attrName, value.toString());
                }
                if (!event.isStartElement() && !event.isEndElement()) {
                    event = this.nextEvent(event);
                }
                if (event.isStartElement()) {
                    if (event.isStartElement() && (event.asStartElement().getName().equals(this.getQName(QNAME_XML_COORD)) || event.asStartElement().getName().equals(this.getQName(QNAME_XML_ARC)))) {
                        String segmentType = null;
                        if (event.asStartElement().getName().equals(this.getQName(QNAME_XML_COORD))) {
                            segmentType = QNAME_XML_COORD;
                        } else if (event.asStartElement().getName().equals(this.getQName(QNAME_XML_ARC))) {
                            segmentType = QNAME_XML_ARC;
                        }
                        OutParam returnedSegment = new OutParam();
                        event = this.readSegment(event, segmentType, (OutParam<IomObject>)returnedSegment);
                        if (((IomObject)returnedSegment.value).getattrcount() == 0) {
                            throw new IoxException("expected coord. unexpected event: " + event.asStartElement().getName().getLocalPart());
                        }
                        iomObj.addattrobj(attrName, (IomObject)returnedSegment.value);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_POLYLINE))) {
                        OutParam polylineOut = new OutParam();
                        event = this.readPolyline(event, (OutParam<IomObject>)polylineOut);
                        IomObject polyline = (IomObject)polylineOut.value;
                        iomObj.addattrobj(attrName, polyline);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_SURFACE))) {
                        IomObject multiSurface = this.createIomObject("MULTISURFACE", null);
                        OutParam surfaceOut = new OutParam();
                        event = this.readSurface(event, (OutParam<IomObject>)surfaceOut);
                        IomObject surface = (IomObject)surfaceOut.value;
                        if (surface.getattrcount() == 0) {
                            throw new IoxException("expected surface");
                        }
                        multiSurface.addattrobj("surface", surface);
                        iomObj.addattrobj(attrName, multiSurface);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_XMLBLBOX))) {
                        event = this.nextEvent(event);
                        StringWriter strw = new StringWriter();
                        event = this.collectXMLElement(event, strw);
                        assert (event.isEndElement() && event.asEndElement().getName().equals(this.getQName(QNAME_XML_XMLBLBOX)));
                        iomObj.setattrvalue(attrName, strw.toString());
                        event = this.nextEvent(event);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_BINBLBOX))) {
                        event = this.reader.nextEvent();
                        value = new StringBuffer();
                        event = this.readSimpleContent(event, value);
                        assert (event.isEndElement() && event.asEndElement().getName().equals(this.getQName(QNAME_XML_BINBLBOX)));
                        iomObj.setattrvalue(attrName, value.toString());
                        event = this.nextEvent(event);
                    } else {
                        do {
                            OutParam iomObjOut = new OutParam();
                            event = this.readObject(event, (OutParam<IomObject>)iomObjOut);
                            IomObject structObj = (IomObject)iomObjOut.value;
                            iomObj.addattrobj(attrName, structObj);
                        } while (event.isStartElement());
                    }
                }
                if (!event.isEndElement()) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                event = this.nextEvent(event);
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
        return event;
    }

    private XMLEvent readReference(IomObject iomObj, StartElement element, String attrName) throws IoxException, XMLStreamException {
        String orderPosVal;
        String refOid = null;
        Attribute refAttr = element.getAttributeByName(QNAME_XML_REF);
        if (refAttr != null && (refOid = this.stripX(refAttr.getValue())).length() == 0) {
            throw new IoxException("unexpected reference value <" + refOid + ">");
        }
        Attribute attrRefBid = element.getAttributeByName(QNAME_XML_TOPIC_BID);
        String refBid = null;
        if (attrRefBid != null && (refBid = this.stripX(attrRefBid.getValue())).length() == 0) {
            throw new IoxException("unexpected reference BID value <" + refBid + ">");
        }
        Long orderPos = null;
        Attribute orderPosAttr = element.getAttributeByName(QNAME_XML_ORDERPOS);
        if (orderPosAttr != null && (orderPosVal = orderPosAttr.getValue()) != null) {
            try {
                orderPos = Long.parseLong(orderPosVal);
            }
            catch (NumberFormatException e) {
                throw new IoxException("unexpected orderPos <" + orderPosVal + ">", (Throwable)e);
            }
        }
        XMLEvent event = this.nextEvent(element);
        IomObject refObject = null;
        if (event.isStartElement()) {
            element = (StartElement)event;
            OutParam iomObjOut = new OutParam();
            event = this.readObject(event, (OutParam<IomObject>)iomObjOut);
            refObject = (IomObject)iomObjOut.value;
            iomObj.addattrobj(attrName, refObject);
        } else {
            refObject = iomObj.addattrobj(attrName, "REF");
        }
        event = this.nextEvent(event);
        if (!event.isStartElement() && !event.isEndElement()) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        refObject.setobjectrefoid(refOid);
        if (orderPos != null) {
            refObject.setobjectreforderpos(orderPos.longValue());
        }
        if (refBid != null) {
            refObject.setobjectrefbid(refBid);
        }
        return event;
    }

    private XMLEvent readSurface(XMLEvent event, OutParam<IomObject> surfaceOut) throws IoxException, XMLStreamException {
        assert (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_SURFACE)));
        IomObject surface = this.createIomObject(QNAME_XML_SURFACE, null);
        surfaceOut.value = surface;
        event = this.nextEvent(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_BOUNDARY))) {
            OutParam boundaryOut = new OutParam();
            event = this.readBoundary(event, (OutParam<IomObject>)boundaryOut);
            surface.addattrobj("boundary", (IomObject)boundaryOut.value);
        }
        assert (event.isEndElement() && event.asEndElement().getName().equals(this.getQName(QNAME_XML_SURFACE)));
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readBoundary(XMLEvent event, OutParam<IomObject> boundaryOut) throws IoxException, XMLStreamException {
        assert (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_BOUNDARY)));
        IomObject boundary = this.createIomObject(QNAME_XML_BOUNDARY, null);
        boundaryOut.value = boundary;
        event = this.nextEvent(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_POLYLINE))) {
            OutParam polylineOut = new OutParam();
            event = this.readPolyline(event, (OutParam<IomObject>)polylineOut);
            boundary.addattrobj("polyline", (IomObject)polylineOut.value);
        }
        if (boundary.getattrcount() == 0) {
            throw new IoxException("at least one POLYLINE expected");
        }
        assert (event.isEndElement() && event.asEndElement().getName().equals(this.getQName(QNAME_XML_BOUNDARY)));
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readPolyline(XMLEvent event, OutParam<IomObject> polylineOut) throws IoxException, XMLStreamException {
        assert (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_POLYLINE)));
        IomObject polyline = this.createIomObject(QNAME_XML_POLYLINE, null);
        if ((event = this.nextEvent(event)).isStartElement()) {
            OutParam seqOut = new OutParam();
            event = this.readSequence(event, (OutParam<IomObject>)seqOut);
            polyline.addattrobj("sequence", (IomObject)seqOut.value);
        }
        if (polyline.getattrcount() == 0) {
            throw new IoxException("at least one COORD expected");
        }
        polylineOut.value = polyline;
        assert (event.isEndElement() && event.asEndElement().getName().equals(this.getQName(QNAME_XML_POLYLINE)));
        event = this.nextEvent(event);
        return event;
    }

    private XMLEvent readSequence(XMLEvent event, OutParam<IomObject> seqOut) throws XMLStreamException, IoxException {
        assert (event.isStartElement() && event.asStartElement().getName().equals(this.getQName(QNAME_XML_COORD)));
        IomObject sequence = this.createIomObject("SEGMENTS", null);
        seqOut.value = sequence;
        while (event.isStartElement()) {
            String segmentType = null;
            if (event.asStartElement().getName().equals(this.getQName(QNAME_XML_COORD))) {
                segmentType = QNAME_XML_COORD;
            } else if (event.asStartElement().getName().equals(this.getQName(QNAME_XML_ARC))) {
                segmentType = QNAME_XML_ARC;
            }
            OutParam segment = new OutParam();
            event = this.readSegment(event, segmentType, (OutParam<IomObject>)segment);
            sequence.addattrobj("segment", (IomObject)segment.value);
        }
        assert (event.isEndElement() && event.asEndElement().getName().equals(this.getQName(QNAME_XML_POLYLINE)));
        return event;
    }

    private XMLEvent readSegment(XMLEvent event, String segmentType, OutParam<IomObject> segmentOut) throws IoxException, XMLStreamException {
        if (!event.isStartElement()) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (segmentType == null) {
            throw new IoxException("expected segment type");
        }
        IomObject segment = this.createIomObject(segmentType, null);
        segmentOut.value = segment;
        SegmentType segTypeName = null;
        event = this.nextEvent(event);
        while (event.isStartElement()) {
            String segmentTypeName = event.asStartElement().getName().getLocalPart();
            segTypeName = SegmentType.valueOf(segmentTypeName);
            event = this.reader.nextEvent();
            if (!event.isCharacters()) {
                throw new IoxSyntaxException("expected coord");
            }
            StringBuffer value = new StringBuffer();
            event = this.readSimpleContent(event, value);
            if (StringUtility.purge((String)value.toString()) == null) {
                throw new IoxSyntaxException("expected coord");
            }
            if (!event.isEndElement()) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            switch (segTypeName) {
                case C1: {
                    segment.setattrvalue("C1", value.toString());
                    break;
                }
                case C2: {
                    segment.setattrvalue("C2", value.toString());
                    break;
                }
                case C3: {
                    segment.setattrvalue("C3", value.toString());
                    break;
                }
                case A1: {
                    segment.setattrvalue("A1", value.toString());
                    break;
                }
                case A2: {
                    segment.setattrvalue("A2", value.toString());
                    break;
                }
                case R: {
                    segment.setattrvalue("R", value.toString());
                    break;
                }
                default: {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
            }
            event = this.nextEvent(event);
        }
        if (!event.isEndElement()) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.nextEvent(event);
        return event;
    }

    private String hsNextOid() {
        ++this.hsOid;
        return Integer.toString(this.hsOid);
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    @Override
    public void setModel(TransferDescription td) {
    }

    @Override
    public void setTopicFilter(String[] topicNames) {
        this.filterTopics = new HashSet<String>();
        for (String topicName : topicNames) {
            this.filterTopics.add(topicName);
        }
    }

    @Override
    public String getMimeType() {
        if (this.isIli22()) {
            return "application/interlis+xml;version=2.2";
        }
        return "application/interlis+xml;version=2.3";
    }

    public boolean isIli22() {
        return this.ili22;
    }

    private String stripX(String oid) {
        if (oid == null) {
            return null;
        }
        if (!this.ili22) {
            return oid;
        }
        if (!oid.startsWith("x")) {
            throw new IllegalArgumentException("OID requires a leading 'x'");
        }
        return oid.substring(1);
    }

    public void setStrict(boolean b) {
        this.isXtf23Reader0_compatible = false;
    }

    private static enum SegmentType {
        C1,
        C2,
        C3,
        A1,
        A2,
        R;

    }

    private class XtfModel {
        private String name;
        private String version;
        private String uri;

        public XtfModel(String name, String version, String uri) {
            this.name = name;
            this.version = version;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

