/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.geom;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iom_j.itf.impl.jtsext.io.WKTWriterJtsext;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CompoundCurveNoder;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.util.ArrayList;
import java.util.List;

public class CompoundCurveRing
extends LinearRing {
    private ArrayList<CompoundCurve> lines = null;

    public CompoundCurveRing(CompoundCurve line, GeometryFactory factory) {
        super(line.getCoordinateSequence(), factory);
        this.lines = new ArrayList(1);
        this.lines.add(line);
    }

    public CompoundCurveRing(ArrayList<CompoundCurve> lines, GeometryFactory factory) {
        super(CompoundCurveRing.derivePoints(lines, factory), factory);
        this.lines = new ArrayList<CompoundCurve>(lines);
    }

    private static CoordinateSequence derivePoints(ArrayList<CompoundCurve> lines, GeometryFactory factory) {
        CoordinateList ret = new CoordinateList();
        for (CompoundCurve line : lines) {
            ret.add(line.getCoordinates(), false);
        }
        return factory.getCoordinateSequenceFactory().create(ret.toCoordinateArray());
    }

    public ArrayList<CompoundCurve> getLines() {
        return this.lines;
    }

    public void setLines(CompoundCurve newline) {
        this.lines = new ArrayList(1);
        this.lines.add(newline);
        this.points = CompoundCurveRing.derivePoints(this.lines, this.factory);
    }

    public static ArrayList<CurveSegment> normalizeRing(boolean clockwise, ArrayList<CurveSegment> segv) {
        Coordinate minCoord;
        ArrayList<Coordinate> coordv = new ArrayList<Coordinate>();
        for (CurveSegment seg : segv) {
            Coordinate coord = null;
            coord = seg.getStartPoint();
            coordv.add(coord);
            if (!(seg instanceof ArcSegment)) continue;
            coord = ((ArcSegment)seg).getMidPoint();
            coordv.add(coord);
        }
        coordv.add(segv.get(0).getStartPoint());
        Coordinate[] coords = coordv.toArray(new Coordinate[coordv.size()]);
        ArrayList<CurveSegment> newsegv = new ArrayList<CurveSegment>();
        if (CGAlgorithms.isCCW((Coordinate[])coords) == clockwise) {
            int i;
            CurveSegment seg2;
            minCoord = null;
            int newStartSeg = 0;
            int li = 0;
            for (CurveSegment seg2 : segv) {
                Coordinate coord = null;
                coord = seg2.getEndPoint();
                if (minCoord == null || minCoord.compareTo((Object)coord) > 0) {
                    minCoord = new Coordinate(coord);
                    newStartSeg = li;
                }
                ++li;
            }
            for (i = newStartSeg; i >= 0; --i) {
                seg2 = segv.get(i);
                if (seg2 instanceof ArcSegment) {
                    newsegv.add(new ArcSegment(seg2.getEndPoint(), ((ArcSegment)seg2).getMidPoint(), seg2.getStartPoint()));
                    continue;
                }
                newsegv.add(new StraightSegment(seg2.getEndPoint(), seg2.getStartPoint()));
            }
            for (i = segv.size() - 1; i > newStartSeg; --i) {
                seg2 = segv.get(i);
                if (seg2 instanceof ArcSegment) {
                    newsegv.add(new ArcSegment(seg2.getEndPoint(), ((ArcSegment)seg2).getMidPoint(), seg2.getStartPoint()));
                    continue;
                }
                newsegv.add(new StraightSegment(seg2.getEndPoint(), seg2.getStartPoint()));
            }
        } else {
            int i;
            CurveSegment seg3;
            minCoord = null;
            int newStartSeg = 0;
            int li = 0;
            for (CurveSegment seg3 : segv) {
                Coordinate coord = null;
                coord = seg3.getStartPoint();
                if (minCoord == null || minCoord.compareTo((Object)coord) > 0) {
                    minCoord = new Coordinate(coord);
                    newStartSeg = li;
                }
                ++li;
            }
            for (i = newStartSeg; i <= segv.size() - 1; ++i) {
                seg3 = segv.get(i);
                newsegv.add(seg3);
            }
            for (i = 0; i < newStartSeg; ++i) {
                seg3 = segv.get(i);
                newsegv.add(seg3);
            }
        }
        return newsegv;
    }

    public boolean isValid() {
        for (Coordinate coord : this.getCoordinates()) {
            if (IsValidOp.isValid((Coordinate)coord)) continue;
            return false;
        }
        if (!this.isClosed()) {
            return false;
        }
        if (this.getCoordinates().length < 4) {
            return false;
        }
        CompoundCurveNoder validator = new CompoundCurveNoder(this.lines, true);
        boolean ret = validator.isValid();
        if (!ret) {
            List<Intersection> isv = validator.getIntersections();
            for (Intersection is : isv) {
                EhiLogger.traceState((String)("invalid CompoundCurveRing: " + is.toString()));
            }
        }
        return ret;
    }

    public String toText() {
        WKTWriterJtsext writer = new WKTWriterJtsext();
        return writer.write((Geometry)this);
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope ret = new Envelope();
        if (this.isEmpty()) {
            return ret;
        }
        for (CompoundCurve line : this.lines) {
            for (CurveSegment seg : line.getSegments()) {
                ret = seg.expandEnvelope(ret);
            }
        }
        return ret;
    }

    public static boolean isCCW(LinearRing ring) {
        if (ring instanceof CompoundCurveRing) {
            ArrayList<CurveSegment> segs = new ArrayList<CurveSegment>();
            for (CompoundCurve line : ((CompoundCurveRing)ring).getLines()) {
                segs.addAll(line.getSegments());
            }
            int topIdx = 0;
            Envelope topEnv = ((CurveSegment)segs.get(topIdx)).computeEnvelopeInternal();
            for (int i = 1; i < segs.size(); ++i) {
                CurveSegment seg = (CurveSegment)segs.get(i);
                Envelope segEnv = seg.computeEnvelopeInternal();
                if (!(segEnv.getMaxY() > topEnv.getMaxY())) continue;
                topIdx = i;
                topEnv = segEnv;
            }
            CurveSegment top = (CurveSegment)segs.get(topIdx);
            if (top instanceof ArcSegment && ((ArcSegment)top).getSign() != 0.0 && top.getStartPoint().y < topEnv.getMaxY() && top.getEndPoint().y < topEnv.getMaxY()) {
                Coordinate[] coords = new Coordinate[]{top.getStartPoint(), ((ArcSegment)top).getMidPoint(), top.getEndPoint(), top.getStartPoint()};
                return CGAlgorithms.isCCW((Coordinate[])coords);
            }
            CurveSegment seg0 = null;
            CurveSegment seg1 = null;
            if (top.getStartPoint().y == topEnv.getMaxY()) {
                int seg0Idx = topIdx - 1;
                do {
                    if (seg0Idx < 0) {
                        seg0Idx = segs.size() - 1;
                    }
                    seg0 = (CurveSegment)segs.get(seg0Idx);
                    --seg0Idx;
                } while (seg0.getStartPoint().y == topEnv.getMaxY() && seg0 instanceof StraightSegment);
                seg1 = top;
            } else {
                int seg1Idx = topIdx + 1;
                do {
                    if (seg1Idx >= segs.size()) {
                        seg1Idx = 0;
                    }
                    seg1 = (CurveSegment)segs.get(seg1Idx);
                    ++seg1Idx;
                } while (seg1.getEndPoint().y == topEnv.getMaxY() && seg1 instanceof StraightSegment);
                seg0 = top;
            }
            Coordinate[] coords = null;
            coords = seg0.getStartPoint().equals2D(seg1.getEndPoint()) ? new Coordinate[]{seg0.getStartPoint(), seg0 instanceof StraightSegment ? seg0.getEndPoint() : ((ArcSegment)seg0).getDirectionPt(false, 0.1), seg1 instanceof StraightSegment ? seg1.getStartPoint() : ((ArcSegment)seg1).getDirectionPt(true, 0.1), coords[0]} : new Coordinate[]{seg0 instanceof StraightSegment ? seg0.getStartPoint() : ((ArcSegment)seg0).getDirectionPt(false, 0.1), seg0.getEndPoint(), seg1.getStartPoint(), seg1 instanceof StraightSegment ? seg1.getEndPoint() : ((ArcSegment)seg1).getDirectionPt(true, 0.1), coords[0]};
            return CGAlgorithms.isCCW((Coordinate[])coords);
        }
        return CGAlgorithms.isCCW((Coordinate[])ring.getCoordinates());
    }
}

